/*
 * Decompiled with CFR 0.152.
 */
package com.google.api.ads.adwords.axis.utils.v201702.shopping;

import com.google.api.ads.adwords.axis.utils.v201702.shopping.ProductPartitionNode;
import com.google.api.ads.adwords.axis.v201702.cm.ProductDimension;
import java.util.Comparator;

class ProductPartitionNodeDiffer {
    private ProductPartitionNodeDiffer() {
    }

    static NodeDifference diff(ProductPartitionNode originalNode, ProductPartitionNode newNode, Comparator<ProductDimension> dimensionComparator) {
        NodeDifference nodeDifference;
        if (originalNode == null && newNode == null) {
            nodeDifference = NodeDifference.NONE;
        } else if (originalNode == null) {
            nodeDifference = NodeDifference.NEW_NODE;
        } else if (newNode == null) {
            nodeDifference = NodeDifference.REMOVED_NODE;
        } else {
            Long bid2;
            Long bid1;
            if (dimensionComparator.compare(originalNode.getDimension(), newNode.getDimension()) != 0) {
                throw new IllegalArgumentException("Original node and new node are not for the same product dimension");
            }
            nodeDifference = originalNode.isUnit() != newNode.isUnit() ? NodeDifference.PARTITION_TYPE_CHANGE : (originalNode.isExcludedUnit() != newNode.isExcludedUnit() ? NodeDifference.EXCLUDED_UNIT_CHANGE : (!originalNode.isExcludedUnit() && originalNode.isUnit() && newNode.isUnit() ? ((bid1 = originalNode.getBid()) == null != ((bid2 = newNode.getBid()) == null) ? NodeDifference.BID_CHANGE : (bid1 == null && bid2 == null ? NodeDifference.NONE : (bid1.compareTo(bid2) != 0 ? NodeDifference.BID_CHANGE : NodeDifference.NONE))) : NodeDifference.NONE));
        }
        return nodeDifference;
    }

    static enum NodeDifference {
        NONE,
        NEW_NODE,
        REMOVED_NODE,
        PARTITION_TYPE_CHANGE,
        EXCLUDED_UNIT_CHANGE,
        BID_CHANGE;

    }
}

