// Copyright 2017 Google Inc. All Rights Reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * LiveStreamEvent.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Mar 02, 2009 (07:08:06 PST) WSDL2Java emitter.
 */

package com.google.api.ads.dfp.axis.v201708;


/**
 * A {@code LiveStreamEvent} encapsulates all the information necessary
 * to enable DAI (Dynamic Ad Insertion) into a live video stream.
 *             
 *             <p>This includes information such as the start and expected
 * end time of
 *             the event, the URL of the actual content for DFP to pull
 * and insert ads into,
 *             as well as the metadata necessary to generate ad requests
 * during the event.
 */
public class LiveStreamEvent  implements java.io.Serializable {
    /* The unique ID of the {@code LiveStreamEvent}. This value is
     * read-only and
     *                 is assigned by Google. */
    private java.lang.Long id;

    /* The name of the {@code LiveStreamEvent}. This value is required
     * to create
     *                 a live stream event and has a maximum length of 255
     * characters. */
    private java.lang.String name;

    /* Additional notes to annotate the event with. This attribute
     * is optional and
     *                 has a maximum length of 65,535 characters. */
    private java.lang.String description;

    /* The status of this {@code LiveStreamEvent}. This attribute
     * is read-only
     *                 and is assigned by Google. Live stream events are
     * created in the
     *                 {@link LiveStreamEventStatus#PAUSED} state. */
    private com.google.api.ads.dfp.axis.v201708.LiveStreamEventStatus status;

    /* The date and time this {@code LiveStreamEvent} was created.
     * This attribute
     *                 is read-only. */
    private com.google.api.ads.dfp.axis.v201708.DateTime creationDateTime;

    /* The date and time this {@code LiveStreamEvent} was last modified.
     * This
     *                 attribute is read-only. */
    private com.google.api.ads.dfp.axis.v201708.DateTime lastModifiedDateTime;

    /* The start date and time of this {@code LiveStreamEvent}. This
     * attribute
     *                 is required if the {@link LiveStreamEvent#startDateTimeType}
     * is
     *                 {@link StartDateTimeType#USE_START_DATE_TIME} and
     * is ignored for all other values of
     *                 {@link StartDateTimeType}. */
    private com.google.api.ads.dfp.axis.v201708.DateTime startDateTime;

    /* The scheduled end date and time of this {@code LiveStreamEvent}.
     * This
     *                 attribute is required if {@code unlimitedEndDateTime}
     * is false and ignored if
     *                 {@code unlimitedEndDateTime} is true. */
    private com.google.api.ads.dfp.axis.v201708.DateTime endDateTime;

    /* The total number of concurrent users expected to watch this
     * event across
     *                 all regions. This attribute is optional and default
     * value is 0. */
    private java.lang.Long totalEstimatedConcurrentUsers;

    /* The list of URLs pointing to the live stream content in
     *                 Content Delivery Network. This attribute is required. */
    private java.lang.String[] contentUrls;

    /* The list of DFP ad tag URLs generated by DFP trafficking workflow
     * that are
     *                 associated with this live stream event. This attribute
     * is required. */
    private java.lang.String[] adTags;

    /* This code is used in constructing a live stream event master
     * playlist URL. This attribute is
     *                 read-only and is assigned by Google. */
    private java.lang.String liveStreamEventCode;

    /* This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used. */
    private com.google.api.ads.dfp.axis.v201708.AuthenticationService authenticationService;

    /* This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used. */
    private java.lang.String authenticationKey;

    /* This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used. */
    private java.lang.Boolean tokenAuthenticationUnsigned;

    /* This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used. */
    private com.google.api.ads.dfp.axis.v201708.OriginForwardingType originForwardingType;

    /* This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used. */
    private java.lang.String originPathPrefix;

    /* Length of the DVR window in seconds. This value is optional.
     * If unset
     *                 the default window as provided by the input encoder
     * will be used. */
    private java.lang.Integer dvrWindowSeconds;

    /* The type of content that should be used to fill an empty ad
     * break. This value is optional and
     *                 defaults to {@link AdBreakFillType#SLATE}. */
    private com.google.api.ads.dfp.axis.v201708.AdBreakFillType adBreakFillType;

    /* The duration (in seconds), starting from the time the user
     * enters the DAI stream, for which
     *                 mid-roll decisioning will be skipped. This field is
     * only applicable when an ad holiday
     *                 is requested in the stream create request. This value
     * is optional and defaults to 0. */
    private java.lang.Long adHolidayDuration;

    /* Whether there will be durationless ad breaks in this live stream.
     * If true,
     *                 {@code defaultAdBreakDuration} should be specified.
     * This field is optional and defaults to
     *                 false; */
    private java.lang.Boolean enableDurationlessAdBreaks;

    /* The default ad pod duration (in seconds) that will be requested
     * when an ad break cue-out
     *                 does not specify a duration. This field is optional
     * and defaults to 0; */
    private java.lang.Long defaultAdBreakDuration;

    public LiveStreamEvent() {
    }

    public LiveStreamEvent(
           java.lang.Long id,
           java.lang.String name,
           java.lang.String description,
           com.google.api.ads.dfp.axis.v201708.LiveStreamEventStatus status,
           com.google.api.ads.dfp.axis.v201708.DateTime creationDateTime,
           com.google.api.ads.dfp.axis.v201708.DateTime lastModifiedDateTime,
           com.google.api.ads.dfp.axis.v201708.DateTime startDateTime,
           com.google.api.ads.dfp.axis.v201708.DateTime endDateTime,
           java.lang.Long totalEstimatedConcurrentUsers,
           java.lang.String[] contentUrls,
           java.lang.String[] adTags,
           java.lang.String liveStreamEventCode,
           com.google.api.ads.dfp.axis.v201708.AuthenticationService authenticationService,
           java.lang.String authenticationKey,
           java.lang.Boolean tokenAuthenticationUnsigned,
           com.google.api.ads.dfp.axis.v201708.OriginForwardingType originForwardingType,
           java.lang.String originPathPrefix,
           java.lang.Integer dvrWindowSeconds,
           com.google.api.ads.dfp.axis.v201708.AdBreakFillType adBreakFillType,
           java.lang.Long adHolidayDuration,
           java.lang.Boolean enableDurationlessAdBreaks,
           java.lang.Long defaultAdBreakDuration) {
           this.id = id;
           this.name = name;
           this.description = description;
           this.status = status;
           this.creationDateTime = creationDateTime;
           this.lastModifiedDateTime = lastModifiedDateTime;
           this.startDateTime = startDateTime;
           this.endDateTime = endDateTime;
           this.totalEstimatedConcurrentUsers = totalEstimatedConcurrentUsers;
           this.contentUrls = contentUrls;
           this.adTags = adTags;
           this.liveStreamEventCode = liveStreamEventCode;
           this.authenticationService = authenticationService;
           this.authenticationKey = authenticationKey;
           this.tokenAuthenticationUnsigned = tokenAuthenticationUnsigned;
           this.originForwardingType = originForwardingType;
           this.originPathPrefix = originPathPrefix;
           this.dvrWindowSeconds = dvrWindowSeconds;
           this.adBreakFillType = adBreakFillType;
           this.adHolidayDuration = adHolidayDuration;
           this.enableDurationlessAdBreaks = enableDurationlessAdBreaks;
           this.defaultAdBreakDuration = defaultAdBreakDuration;
    }

    @Override
    public String toString() {
        return com.google.common.base.MoreObjects.toStringHelper(this.getClass())
            .omitNullValues()
            .add("adBreakFillType", getAdBreakFillType())
            .add("adHolidayDuration", getAdHolidayDuration())
            .add("adTags", getAdTags())
            .add("authenticationKey", getAuthenticationKey())
            .add("authenticationService", getAuthenticationService())
            .add("contentUrls", getContentUrls())
            .add("creationDateTime", getCreationDateTime())
            .add("defaultAdBreakDuration", getDefaultAdBreakDuration())
            .add("description", getDescription())
            .add("dvrWindowSeconds", getDvrWindowSeconds())
            .add("enableDurationlessAdBreaks", getEnableDurationlessAdBreaks())
            .add("endDateTime", getEndDateTime())
            .add("id", getId())
            .add("lastModifiedDateTime", getLastModifiedDateTime())
            .add("liveStreamEventCode", getLiveStreamEventCode())
            .add("name", getName())
            .add("originForwardingType", getOriginForwardingType())
            .add("originPathPrefix", getOriginPathPrefix())
            .add("startDateTime", getStartDateTime())
            .add("status", getStatus())
            .add("tokenAuthenticationUnsigned", getTokenAuthenticationUnsigned())
            .add("totalEstimatedConcurrentUsers", getTotalEstimatedConcurrentUsers())
            .toString();
    }

    /**
     * Gets the id value for this LiveStreamEvent.
     * 
     * @return id   * The unique ID of the {@code LiveStreamEvent}. This value is
     * read-only and
     *                 is assigned by Google.
     */
    public java.lang.Long getId() {
        return id;
    }


    /**
     * Sets the id value for this LiveStreamEvent.
     * 
     * @param id   * The unique ID of the {@code LiveStreamEvent}. This value is
     * read-only and
     *                 is assigned by Google.
     */
    public void setId(java.lang.Long id) {
        this.id = id;
    }


    /**
     * Gets the name value for this LiveStreamEvent.
     * 
     * @return name   * The name of the {@code LiveStreamEvent}. This value is required
     * to create
     *                 a live stream event and has a maximum length of 255
     * characters.
     */
    public java.lang.String getName() {
        return name;
    }


    /**
     * Sets the name value for this LiveStreamEvent.
     * 
     * @param name   * The name of the {@code LiveStreamEvent}. This value is required
     * to create
     *                 a live stream event and has a maximum length of 255
     * characters.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }


    /**
     * Gets the description value for this LiveStreamEvent.
     * 
     * @return description   * Additional notes to annotate the event with. This attribute
     * is optional and
     *                 has a maximum length of 65,535 characters.
     */
    public java.lang.String getDescription() {
        return description;
    }


    /**
     * Sets the description value for this LiveStreamEvent.
     * 
     * @param description   * Additional notes to annotate the event with. This attribute
     * is optional and
     *                 has a maximum length of 65,535 characters.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }


    /**
     * Gets the status value for this LiveStreamEvent.
     * 
     * @return status   * The status of this {@code LiveStreamEvent}. This attribute
     * is read-only
     *                 and is assigned by Google. Live stream events are
     * created in the
     *                 {@link LiveStreamEventStatus#PAUSED} state.
     */
    public com.google.api.ads.dfp.axis.v201708.LiveStreamEventStatus getStatus() {
        return status;
    }


    /**
     * Sets the status value for this LiveStreamEvent.
     * 
     * @param status   * The status of this {@code LiveStreamEvent}. This attribute
     * is read-only
     *                 and is assigned by Google. Live stream events are
     * created in the
     *                 {@link LiveStreamEventStatus#PAUSED} state.
     */
    public void setStatus(com.google.api.ads.dfp.axis.v201708.LiveStreamEventStatus status) {
        this.status = status;
    }


    /**
     * Gets the creationDateTime value for this LiveStreamEvent.
     * 
     * @return creationDateTime   * The date and time this {@code LiveStreamEvent} was created.
     * This attribute
     *                 is read-only.
     */
    public com.google.api.ads.dfp.axis.v201708.DateTime getCreationDateTime() {
        return creationDateTime;
    }


    /**
     * Sets the creationDateTime value for this LiveStreamEvent.
     * 
     * @param creationDateTime   * The date and time this {@code LiveStreamEvent} was created.
     * This attribute
     *                 is read-only.
     */
    public void setCreationDateTime(com.google.api.ads.dfp.axis.v201708.DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }


    /**
     * Gets the lastModifiedDateTime value for this LiveStreamEvent.
     * 
     * @return lastModifiedDateTime   * The date and time this {@code LiveStreamEvent} was last modified.
     * This
     *                 attribute is read-only.
     */
    public com.google.api.ads.dfp.axis.v201708.DateTime getLastModifiedDateTime() {
        return lastModifiedDateTime;
    }


    /**
     * Sets the lastModifiedDateTime value for this LiveStreamEvent.
     * 
     * @param lastModifiedDateTime   * The date and time this {@code LiveStreamEvent} was last modified.
     * This
     *                 attribute is read-only.
     */
    public void setLastModifiedDateTime(com.google.api.ads.dfp.axis.v201708.DateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }


    /**
     * Gets the startDateTime value for this LiveStreamEvent.
     * 
     * @return startDateTime   * The start date and time of this {@code LiveStreamEvent}. This
     * attribute
     *                 is required if the {@link LiveStreamEvent#startDateTimeType}
     * is
     *                 {@link StartDateTimeType#USE_START_DATE_TIME} and
     * is ignored for all other values of
     *                 {@link StartDateTimeType}.
     */
    public com.google.api.ads.dfp.axis.v201708.DateTime getStartDateTime() {
        return startDateTime;
    }


    /**
     * Sets the startDateTime value for this LiveStreamEvent.
     * 
     * @param startDateTime   * The start date and time of this {@code LiveStreamEvent}. This
     * attribute
     *                 is required if the {@link LiveStreamEvent#startDateTimeType}
     * is
     *                 {@link StartDateTimeType#USE_START_DATE_TIME} and
     * is ignored for all other values of
     *                 {@link StartDateTimeType}.
     */
    public void setStartDateTime(com.google.api.ads.dfp.axis.v201708.DateTime startDateTime) {
        this.startDateTime = startDateTime;
    }


    /**
     * Gets the endDateTime value for this LiveStreamEvent.
     * 
     * @return endDateTime   * The scheduled end date and time of this {@code LiveStreamEvent}.
     * This
     *                 attribute is required if {@code unlimitedEndDateTime}
     * is false and ignored if
     *                 {@code unlimitedEndDateTime} is true.
     */
    public com.google.api.ads.dfp.axis.v201708.DateTime getEndDateTime() {
        return endDateTime;
    }


    /**
     * Sets the endDateTime value for this LiveStreamEvent.
     * 
     * @param endDateTime   * The scheduled end date and time of this {@code LiveStreamEvent}.
     * This
     *                 attribute is required if {@code unlimitedEndDateTime}
     * is false and ignored if
     *                 {@code unlimitedEndDateTime} is true.
     */
    public void setEndDateTime(com.google.api.ads.dfp.axis.v201708.DateTime endDateTime) {
        this.endDateTime = endDateTime;
    }


    /**
     * Gets the totalEstimatedConcurrentUsers value for this LiveStreamEvent.
     * 
     * @return totalEstimatedConcurrentUsers   * The total number of concurrent users expected to watch this
     * event across
     *                 all regions. This attribute is optional and default
     * value is 0.
     */
    public java.lang.Long getTotalEstimatedConcurrentUsers() {
        return totalEstimatedConcurrentUsers;
    }


    /**
     * Sets the totalEstimatedConcurrentUsers value for this LiveStreamEvent.
     * 
     * @param totalEstimatedConcurrentUsers   * The total number of concurrent users expected to watch this
     * event across
     *                 all regions. This attribute is optional and default
     * value is 0.
     */
    public void setTotalEstimatedConcurrentUsers(java.lang.Long totalEstimatedConcurrentUsers) {
        this.totalEstimatedConcurrentUsers = totalEstimatedConcurrentUsers;
    }


    /**
     * Gets the contentUrls value for this LiveStreamEvent.
     * 
     * @return contentUrls   * The list of URLs pointing to the live stream content in
     *                 Content Delivery Network. This attribute is required.
     */
    public java.lang.String[] getContentUrls() {
        return contentUrls;
    }


    /**
     * Sets the contentUrls value for this LiveStreamEvent.
     * 
     * @param contentUrls   * The list of URLs pointing to the live stream content in
     *                 Content Delivery Network. This attribute is required.
     */
    public void setContentUrls(java.lang.String[] contentUrls) {
        this.contentUrls = contentUrls;
    }

    public java.lang.String getContentUrls(int i) {
        return this.contentUrls[i];
    }

    public void setContentUrls(int i, java.lang.String _value) {
        this.contentUrls[i] = _value;
    }


    /**
     * Gets the adTags value for this LiveStreamEvent.
     * 
     * @return adTags   * The list of DFP ad tag URLs generated by DFP trafficking workflow
     * that are
     *                 associated with this live stream event. This attribute
     * is required.
     */
    public java.lang.String[] getAdTags() {
        return adTags;
    }


    /**
     * Sets the adTags value for this LiveStreamEvent.
     * 
     * @param adTags   * The list of DFP ad tag URLs generated by DFP trafficking workflow
     * that are
     *                 associated with this live stream event. This attribute
     * is required.
     */
    public void setAdTags(java.lang.String[] adTags) {
        this.adTags = adTags;
    }

    public java.lang.String getAdTags(int i) {
        return this.adTags[i];
    }

    public void setAdTags(int i, java.lang.String _value) {
        this.adTags[i] = _value;
    }


    /**
     * Gets the liveStreamEventCode value for this LiveStreamEvent.
     * 
     * @return liveStreamEventCode   * This code is used in constructing a live stream event master
     * playlist URL. This attribute is
     *                 read-only and is assigned by Google.
     */
    public java.lang.String getLiveStreamEventCode() {
        return liveStreamEventCode;
    }


    /**
     * Sets the liveStreamEventCode value for this LiveStreamEvent.
     * 
     * @param liveStreamEventCode   * This code is used in constructing a live stream event master
     * playlist URL. This attribute is
     *                 read-only and is assigned by Google.
     */
    public void setLiveStreamEventCode(java.lang.String liveStreamEventCode) {
        this.liveStreamEventCode = liveStreamEventCode;
    }


    /**
     * Gets the authenticationService value for this LiveStreamEvent.
     * 
     * @return authenticationService   * This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used.
     */
    public com.google.api.ads.dfp.axis.v201708.AuthenticationService getAuthenticationService() {
        return authenticationService;
    }


    /**
     * Sets the authenticationService value for this LiveStreamEvent.
     * 
     * @param authenticationService   * This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used.
     */
    public void setAuthenticationService(com.google.api.ads.dfp.axis.v201708.AuthenticationService authenticationService) {
        this.authenticationService = authenticationService;
    }


    /**
     * Gets the authenticationKey value for this LiveStreamEvent.
     * 
     * @return authenticationKey   * This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used.
     */
    public java.lang.String getAuthenticationKey() {
        return authenticationKey;
    }


    /**
     * Sets the authenticationKey value for this LiveStreamEvent.
     * 
     * @param authenticationKey   * This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used.
     */
    public void setAuthenticationKey(java.lang.String authenticationKey) {
        this.authenticationKey = authenticationKey;
    }


    /**
     * Gets the tokenAuthenticationUnsigned value for this LiveStreamEvent.
     * 
     * @return tokenAuthenticationUnsigned   * This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used.
     */
    public java.lang.Boolean getTokenAuthenticationUnsigned() {
        return tokenAuthenticationUnsigned;
    }


    /**
     * Sets the tokenAuthenticationUnsigned value for this LiveStreamEvent.
     * 
     * @param tokenAuthenticationUnsigned   * This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used.
     */
    public void setTokenAuthenticationUnsigned(java.lang.Boolean tokenAuthenticationUnsigned) {
        this.tokenAuthenticationUnsigned = tokenAuthenticationUnsigned;
    }


    /**
     * Gets the originForwardingType value for this LiveStreamEvent.
     * 
     * @return originForwardingType   * This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used.
     */
    public com.google.api.ads.dfp.axis.v201708.OriginForwardingType getOriginForwardingType() {
        return originForwardingType;
    }


    /**
     * Sets the originForwardingType value for this LiveStreamEvent.
     * 
     * @param originForwardingType   * This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used.
     */
    public void setOriginForwardingType(com.google.api.ads.dfp.axis.v201708.OriginForwardingType originForwardingType) {
        this.originForwardingType = originForwardingType;
    }


    /**
     * Gets the originPathPrefix value for this LiveStreamEvent.
     * 
     * @return originPathPrefix   * This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used.
     */
    public java.lang.String getOriginPathPrefix() {
        return originPathPrefix;
    }


    /**
     * Sets the originPathPrefix value for this LiveStreamEvent.
     * 
     * @param originPathPrefix   * This field is deprecated and should not be set or read. Please
     * update the API version to
     *                 v201711 or later and use the {@link LiveStreamEvent#sourceContentConfigurations}
     * field to
     *                 specify security policies for {@link LiveStreamEvent#contentUrls}.
     * The value for this field
     *                 will be out-of-date once {@link LiveStreamEvent#sourceContentConfigurations}
     * is used.
     */
    public void setOriginPathPrefix(java.lang.String originPathPrefix) {
        this.originPathPrefix = originPathPrefix;
    }


    /**
     * Gets the dvrWindowSeconds value for this LiveStreamEvent.
     * 
     * @return dvrWindowSeconds   * Length of the DVR window in seconds. This value is optional.
     * If unset
     *                 the default window as provided by the input encoder
     * will be used.
     */
    public java.lang.Integer getDvrWindowSeconds() {
        return dvrWindowSeconds;
    }


    /**
     * Sets the dvrWindowSeconds value for this LiveStreamEvent.
     * 
     * @param dvrWindowSeconds   * Length of the DVR window in seconds. This value is optional.
     * If unset
     *                 the default window as provided by the input encoder
     * will be used.
     */
    public void setDvrWindowSeconds(java.lang.Integer dvrWindowSeconds) {
        this.dvrWindowSeconds = dvrWindowSeconds;
    }


    /**
     * Gets the adBreakFillType value for this LiveStreamEvent.
     * 
     * @return adBreakFillType   * The type of content that should be used to fill an empty ad
     * break. This value is optional and
     *                 defaults to {@link AdBreakFillType#SLATE}.
     */
    public com.google.api.ads.dfp.axis.v201708.AdBreakFillType getAdBreakFillType() {
        return adBreakFillType;
    }


    /**
     * Sets the adBreakFillType value for this LiveStreamEvent.
     * 
     * @param adBreakFillType   * The type of content that should be used to fill an empty ad
     * break. This value is optional and
     *                 defaults to {@link AdBreakFillType#SLATE}.
     */
    public void setAdBreakFillType(com.google.api.ads.dfp.axis.v201708.AdBreakFillType adBreakFillType) {
        this.adBreakFillType = adBreakFillType;
    }


    /**
     * Gets the adHolidayDuration value for this LiveStreamEvent.
     * 
     * @return adHolidayDuration   * The duration (in seconds), starting from the time the user
     * enters the DAI stream, for which
     *                 mid-roll decisioning will be skipped. This field is
     * only applicable when an ad holiday
     *                 is requested in the stream create request. This value
     * is optional and defaults to 0.
     */
    public java.lang.Long getAdHolidayDuration() {
        return adHolidayDuration;
    }


    /**
     * Sets the adHolidayDuration value for this LiveStreamEvent.
     * 
     * @param adHolidayDuration   * The duration (in seconds), starting from the time the user
     * enters the DAI stream, for which
     *                 mid-roll decisioning will be skipped. This field is
     * only applicable when an ad holiday
     *                 is requested in the stream create request. This value
     * is optional and defaults to 0.
     */
    public void setAdHolidayDuration(java.lang.Long adHolidayDuration) {
        this.adHolidayDuration = adHolidayDuration;
    }


    /**
     * Gets the enableDurationlessAdBreaks value for this LiveStreamEvent.
     * 
     * @return enableDurationlessAdBreaks   * Whether there will be durationless ad breaks in this live stream.
     * If true,
     *                 {@code defaultAdBreakDuration} should be specified.
     * This field is optional and defaults to
     *                 false;
     */
    public java.lang.Boolean getEnableDurationlessAdBreaks() {
        return enableDurationlessAdBreaks;
    }


    /**
     * Sets the enableDurationlessAdBreaks value for this LiveStreamEvent.
     * 
     * @param enableDurationlessAdBreaks   * Whether there will be durationless ad breaks in this live stream.
     * If true,
     *                 {@code defaultAdBreakDuration} should be specified.
     * This field is optional and defaults to
     *                 false;
     */
    public void setEnableDurationlessAdBreaks(java.lang.Boolean enableDurationlessAdBreaks) {
        this.enableDurationlessAdBreaks = enableDurationlessAdBreaks;
    }


    /**
     * Gets the defaultAdBreakDuration value for this LiveStreamEvent.
     * 
     * @return defaultAdBreakDuration   * The default ad pod duration (in seconds) that will be requested
     * when an ad break cue-out
     *                 does not specify a duration. This field is optional
     * and defaults to 0;
     */
    public java.lang.Long getDefaultAdBreakDuration() {
        return defaultAdBreakDuration;
    }


    /**
     * Sets the defaultAdBreakDuration value for this LiveStreamEvent.
     * 
     * @param defaultAdBreakDuration   * The default ad pod duration (in seconds) that will be requested
     * when an ad break cue-out
     *                 does not specify a duration. This field is optional
     * and defaults to 0;
     */
    public void setDefaultAdBreakDuration(java.lang.Long defaultAdBreakDuration) {
        this.defaultAdBreakDuration = defaultAdBreakDuration;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(java.lang.Object obj) {
        if (!(obj instanceof LiveStreamEvent)) return false;
        LiveStreamEvent other = (LiveStreamEvent) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.id==null && other.getId()==null) || 
             (this.id!=null &&
              this.id.equals(other.getId()))) &&
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            ((this.description==null && other.getDescription()==null) || 
             (this.description!=null &&
              this.description.equals(other.getDescription()))) &&
            ((this.status==null && other.getStatus()==null) || 
             (this.status!=null &&
              this.status.equals(other.getStatus()))) &&
            ((this.creationDateTime==null && other.getCreationDateTime()==null) || 
             (this.creationDateTime!=null &&
              this.creationDateTime.equals(other.getCreationDateTime()))) &&
            ((this.lastModifiedDateTime==null && other.getLastModifiedDateTime()==null) || 
             (this.lastModifiedDateTime!=null &&
              this.lastModifiedDateTime.equals(other.getLastModifiedDateTime()))) &&
            ((this.startDateTime==null && other.getStartDateTime()==null) || 
             (this.startDateTime!=null &&
              this.startDateTime.equals(other.getStartDateTime()))) &&
            ((this.endDateTime==null && other.getEndDateTime()==null) || 
             (this.endDateTime!=null &&
              this.endDateTime.equals(other.getEndDateTime()))) &&
            ((this.totalEstimatedConcurrentUsers==null && other.getTotalEstimatedConcurrentUsers()==null) || 
             (this.totalEstimatedConcurrentUsers!=null &&
              this.totalEstimatedConcurrentUsers.equals(other.getTotalEstimatedConcurrentUsers()))) &&
            ((this.contentUrls==null && other.getContentUrls()==null) || 
             (this.contentUrls!=null &&
              java.util.Arrays.equals(this.contentUrls, other.getContentUrls()))) &&
            ((this.adTags==null && other.getAdTags()==null) || 
             (this.adTags!=null &&
              java.util.Arrays.equals(this.adTags, other.getAdTags()))) &&
            ((this.liveStreamEventCode==null && other.getLiveStreamEventCode()==null) || 
             (this.liveStreamEventCode!=null &&
              this.liveStreamEventCode.equals(other.getLiveStreamEventCode()))) &&
            ((this.authenticationService==null && other.getAuthenticationService()==null) || 
             (this.authenticationService!=null &&
              this.authenticationService.equals(other.getAuthenticationService()))) &&
            ((this.authenticationKey==null && other.getAuthenticationKey()==null) || 
             (this.authenticationKey!=null &&
              this.authenticationKey.equals(other.getAuthenticationKey()))) &&
            ((this.tokenAuthenticationUnsigned==null && other.getTokenAuthenticationUnsigned()==null) || 
             (this.tokenAuthenticationUnsigned!=null &&
              this.tokenAuthenticationUnsigned.equals(other.getTokenAuthenticationUnsigned()))) &&
            ((this.originForwardingType==null && other.getOriginForwardingType()==null) || 
             (this.originForwardingType!=null &&
              this.originForwardingType.equals(other.getOriginForwardingType()))) &&
            ((this.originPathPrefix==null && other.getOriginPathPrefix()==null) || 
             (this.originPathPrefix!=null &&
              this.originPathPrefix.equals(other.getOriginPathPrefix()))) &&
            ((this.dvrWindowSeconds==null && other.getDvrWindowSeconds()==null) || 
             (this.dvrWindowSeconds!=null &&
              this.dvrWindowSeconds.equals(other.getDvrWindowSeconds()))) &&
            ((this.adBreakFillType==null && other.getAdBreakFillType()==null) || 
             (this.adBreakFillType!=null &&
              this.adBreakFillType.equals(other.getAdBreakFillType()))) &&
            ((this.adHolidayDuration==null && other.getAdHolidayDuration()==null) || 
             (this.adHolidayDuration!=null &&
              this.adHolidayDuration.equals(other.getAdHolidayDuration()))) &&
            ((this.enableDurationlessAdBreaks==null && other.getEnableDurationlessAdBreaks()==null) || 
             (this.enableDurationlessAdBreaks!=null &&
              this.enableDurationlessAdBreaks.equals(other.getEnableDurationlessAdBreaks()))) &&
            ((this.defaultAdBreakDuration==null && other.getDefaultAdBreakDuration()==null) || 
             (this.defaultAdBreakDuration!=null &&
              this.defaultAdBreakDuration.equals(other.getDefaultAdBreakDuration())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getId() != null) {
            _hashCode += getId().hashCode();
        }
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        if (getDescription() != null) {
            _hashCode += getDescription().hashCode();
        }
        if (getStatus() != null) {
            _hashCode += getStatus().hashCode();
        }
        if (getCreationDateTime() != null) {
            _hashCode += getCreationDateTime().hashCode();
        }
        if (getLastModifiedDateTime() != null) {
            _hashCode += getLastModifiedDateTime().hashCode();
        }
        if (getStartDateTime() != null) {
            _hashCode += getStartDateTime().hashCode();
        }
        if (getEndDateTime() != null) {
            _hashCode += getEndDateTime().hashCode();
        }
        if (getTotalEstimatedConcurrentUsers() != null) {
            _hashCode += getTotalEstimatedConcurrentUsers().hashCode();
        }
        if (getContentUrls() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getContentUrls());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getContentUrls(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAdTags() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAdTags());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getAdTags(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getLiveStreamEventCode() != null) {
            _hashCode += getLiveStreamEventCode().hashCode();
        }
        if (getAuthenticationService() != null) {
            _hashCode += getAuthenticationService().hashCode();
        }
        if (getAuthenticationKey() != null) {
            _hashCode += getAuthenticationKey().hashCode();
        }
        if (getTokenAuthenticationUnsigned() != null) {
            _hashCode += getTokenAuthenticationUnsigned().hashCode();
        }
        if (getOriginForwardingType() != null) {
            _hashCode += getOriginForwardingType().hashCode();
        }
        if (getOriginPathPrefix() != null) {
            _hashCode += getOriginPathPrefix().hashCode();
        }
        if (getDvrWindowSeconds() != null) {
            _hashCode += getDvrWindowSeconds().hashCode();
        }
        if (getAdBreakFillType() != null) {
            _hashCode += getAdBreakFillType().hashCode();
        }
        if (getAdHolidayDuration() != null) {
            _hashCode += getAdHolidayDuration().hashCode();
        }
        if (getEnableDurationlessAdBreaks() != null) {
            _hashCode += getEnableDurationlessAdBreaks().hashCode();
        }
        if (getDefaultAdBreakDuration() != null) {
            _hashCode += getDefaultAdBreakDuration().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(LiveStreamEvent.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "LiveStreamEvent"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("id");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "id"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("description");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "description"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("status");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "status"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "LiveStreamEventStatus"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("creationDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "creationDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastModifiedDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "lastModifiedDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("startDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "startDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("endDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "endDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("totalEstimatedConcurrentUsers");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "totalEstimatedConcurrentUsers"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("contentUrls");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "contentUrls"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adTags");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "adTags"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("liveStreamEventCode");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "liveStreamEventCode"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("authenticationService");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "authenticationService"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "AuthenticationService"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("authenticationKey");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "authenticationKey"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("tokenAuthenticationUnsigned");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "tokenAuthenticationUnsigned"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("originForwardingType");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "originForwardingType"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "OriginForwardingType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("originPathPrefix");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "originPathPrefix"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("dvrWindowSeconds");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "dvrWindowSeconds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adBreakFillType");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "adBreakFillType"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "AdBreakFillType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adHolidayDuration");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "adHolidayDuration"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enableDurationlessAdBreaks");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "enableDurationlessAdBreaks"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("defaultAdBreakDuration");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201708", "defaultAdBreakDuration"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
