// Copyright 2018 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * LineItemCreativeAssociationStats.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Mar 02, 2009 (07:08:06 PST) WSDL2Java emitter.
 */

package com.google.api.ads.admanager.axis.v201808;


/**
 * Contains statistics such as impressions, clicks delivered and cost
 * for {@link LineItemCreativeAssociation} objects.
 */
public class LineItemCreativeAssociationStats  implements java.io.Serializable {
    /* A {@link Stats} object that holds delivered impressions and
     * clicks
     *                 statistics. */
    private com.google.api.ads.admanager.axis.v201808.Stats stats;

    /* A map containing {@link Stats} objects for each creative belonging
     * to
     *                 a creative set, {@code null} for non creative set
     * associations. */
    private com.google.api.ads.admanager.axis.v201808.Long_StatsMapEntry[] creativeSetStats;

    /* The revenue generated thus far by the creative from its association
     * with
     *                 the particular line item in the publisher's currency. */
    private com.google.api.ads.admanager.axis.v201808.Money costInOrderCurrency;

    public LineItemCreativeAssociationStats() {
    }

    public LineItemCreativeAssociationStats(
           com.google.api.ads.admanager.axis.v201808.Stats stats,
           com.google.api.ads.admanager.axis.v201808.Long_StatsMapEntry[] creativeSetStats,
           com.google.api.ads.admanager.axis.v201808.Money costInOrderCurrency) {
           this.stats = stats;
           this.creativeSetStats = creativeSetStats;
           this.costInOrderCurrency = costInOrderCurrency;
    }

    @Override
    public String toString() {
        return com.google.common.base.MoreObjects.toStringHelper(this.getClass())
            .omitNullValues()
            .add("costInOrderCurrency", getCostInOrderCurrency())
            .add("creativeSetStats", getCreativeSetStats())
            .add("stats", getStats())
            .toString();
    }

    /**
     * Gets the stats value for this LineItemCreativeAssociationStats.
     * 
     * @return stats   * A {@link Stats} object that holds delivered impressions and
     * clicks
     *                 statistics.
     */
    public com.google.api.ads.admanager.axis.v201808.Stats getStats() {
        return stats;
    }


    /**
     * Sets the stats value for this LineItemCreativeAssociationStats.
     * 
     * @param stats   * A {@link Stats} object that holds delivered impressions and
     * clicks
     *                 statistics.
     */
    public void setStats(com.google.api.ads.admanager.axis.v201808.Stats stats) {
        this.stats = stats;
    }


    /**
     * Gets the creativeSetStats value for this LineItemCreativeAssociationStats.
     * 
     * @return creativeSetStats   * A map containing {@link Stats} objects for each creative belonging
     * to
     *                 a creative set, {@code null} for non creative set
     * associations.
     */
    public com.google.api.ads.admanager.axis.v201808.Long_StatsMapEntry[] getCreativeSetStats() {
        return creativeSetStats;
    }


    /**
     * Sets the creativeSetStats value for this LineItemCreativeAssociationStats.
     * 
     * @param creativeSetStats   * A map containing {@link Stats} objects for each creative belonging
     * to
     *                 a creative set, {@code null} for non creative set
     * associations.
     */
    public void setCreativeSetStats(com.google.api.ads.admanager.axis.v201808.Long_StatsMapEntry[] creativeSetStats) {
        this.creativeSetStats = creativeSetStats;
    }

    public com.google.api.ads.admanager.axis.v201808.Long_StatsMapEntry getCreativeSetStats(int i) {
        return this.creativeSetStats[i];
    }

    public void setCreativeSetStats(int i, com.google.api.ads.admanager.axis.v201808.Long_StatsMapEntry _value) {
        this.creativeSetStats[i] = _value;
    }


    /**
     * Gets the costInOrderCurrency value for this LineItemCreativeAssociationStats.
     * 
     * @return costInOrderCurrency   * The revenue generated thus far by the creative from its association
     * with
     *                 the particular line item in the publisher's currency.
     */
    public com.google.api.ads.admanager.axis.v201808.Money getCostInOrderCurrency() {
        return costInOrderCurrency;
    }


    /**
     * Sets the costInOrderCurrency value for this LineItemCreativeAssociationStats.
     * 
     * @param costInOrderCurrency   * The revenue generated thus far by the creative from its association
     * with
     *                 the particular line item in the publisher's currency.
     */
    public void setCostInOrderCurrency(com.google.api.ads.admanager.axis.v201808.Money costInOrderCurrency) {
        this.costInOrderCurrency = costInOrderCurrency;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(java.lang.Object obj) {
        if (!(obj instanceof LineItemCreativeAssociationStats)) return false;
        LineItemCreativeAssociationStats other = (LineItemCreativeAssociationStats) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.stats==null && other.getStats()==null) || 
             (this.stats!=null &&
              this.stats.equals(other.getStats()))) &&
            ((this.creativeSetStats==null && other.getCreativeSetStats()==null) || 
             (this.creativeSetStats!=null &&
              java.util.Arrays.equals(this.creativeSetStats, other.getCreativeSetStats()))) &&
            ((this.costInOrderCurrency==null && other.getCostInOrderCurrency()==null) || 
             (this.costInOrderCurrency!=null &&
              this.costInOrderCurrency.equals(other.getCostInOrderCurrency())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getStats() != null) {
            _hashCode += getStats().hashCode();
        }
        if (getCreativeSetStats() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getCreativeSetStats());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getCreativeSetStats(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getCostInOrderCurrency() != null) {
            _hashCode += getCostInOrderCurrency().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(LineItemCreativeAssociationStats.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201808", "LineItemCreativeAssociationStats"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("stats");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201808", "stats"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201808", "Stats"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("creativeSetStats");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201808", "creativeSetStats"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201808", "Long_StatsMapEntry"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("costInOrderCurrency");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201808", "costInOrderCurrency"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201808", "Money"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
