// Copyright 2019 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * LiveStreamEvent.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Mar 02, 2009 (07:08:06 PST) WSDL2Java emitter.
 */

package com.google.api.ads.admanager.axis.v201911;


/**
 * A {@code LiveStreamEvent} encapsulates all the information necessary
 * to enable DAI (Dynamic Ad Insertion) into a live video stream.
 *             
 *             <p>This includes information such as the start and expected
 * end time of
 *             the event, the URL of the actual content for Ad Manager
 * to pull and insert ads into,
 *             as well as the metadata necessary to generate ad requests
 * during the event.
 */
public class LiveStreamEvent  implements java.io.Serializable {
    /* The unique ID of the {@code LiveStreamEvent}. This value is
     * read-only and
     *                 is assigned by Google. */
    private java.lang.Long id;

    /* The name of the {@code LiveStreamEvent}. This value is required
     * to create
     *                 a live stream event and has a maximum length of 255
     * characters. */
    private java.lang.String name;

    /* Additional notes to annotate the event with. This attribute
     * is optional and
     *                 has a maximum length of 65,535 characters. */
    private java.lang.String description;

    /* The status of this {@code LiveStreamEvent}. This attribute
     * is read-only
     *                 and is assigned by Google. Live stream events are
     * created in the
     *                 {@link LiveStreamEventStatus#PAUSED} state. */
    private com.google.api.ads.admanager.axis.v201911.LiveStreamEventStatus status;

    /* The date and time this {@code LiveStreamEvent} was created.
     * This attribute
     *                 is read-only. */
    private com.google.api.ads.admanager.axis.v201911.DateTime creationDateTime;

    /* The date and time this {@code LiveStreamEvent} was last modified.
     * This
     *                 attribute is read-only. */
    private com.google.api.ads.admanager.axis.v201911.DateTime lastModifiedDateTime;

    /* The start date and time of this {@code LiveStreamEvent}. This
     * attribute
     *                 is required if the {@link LiveStreamEvent#startDateTimeType}
     * is
     *                 {@link StartDateTimeType#USE_START_DATE_TIME} and
     * is ignored for all other values of
     *                 {@link StartDateTimeType}. */
    private com.google.api.ads.admanager.axis.v201911.DateTime startDateTime;

    /* Specifies whether to start the {@link LiveStreamEvent} right
     * away, in an hour, etc.
     *                 This attribute is optional and defaults to {@link
     * StartDateTimeType#USE_START_DATE_TIME}. */
    private com.google.api.ads.admanager.axis.v201911.StartDateTimeType startDateTimeType;

    /* The scheduled end date and time of this {@code LiveStreamEvent}.
     * This
     *                 attribute is required if {@code unlimitedEndDateTime}
     * is false and ignored if
     *                 {@code unlimitedEndDateTime} is true. */
    private com.google.api.ads.admanager.axis.v201911.DateTime endDateTime;

    /* Whether the {@link LiveStreamEvent} has an end time. This attribute
     * is optional and defaults
     *                 to false. If this field is true, {@code endDateTime}
     * is ignored. */
    private java.lang.Boolean unlimitedEndDateTime;

    /* The total number of concurrent users expected to watch this
     * event across
     *                 all regions. This attribute is optional and default
     * value is 0. */
    private java.lang.Long totalEstimatedConcurrentUsers;

    /* The list of URLs pointing to the live stream content in
     *                 Content Delivery Network. This attribute is required. */
    private java.lang.String[] contentUrls;

    /* The list of Ad Manager ad tag URLs generated by the Ad Manager
     * trafficking workflow that are
     *                 associated with this live stream event. Currently,
     * the list includes only one element: the
     *                 master ad tag. This attribute is required. */
    private java.lang.String[] adTags;

    /* This code is used in constructing a live stream event master
     * playlist URL. This attribute is
     *                 read-only and is assigned by Google. As of V201911
     * this field is called assetKey. */
    private java.lang.String assetKey;

    /* ID corresponding to the slate for this live event. If not set,
     * network default value
     *                 will be used. */
    private java.lang.Long slateCreativeId;

    /* Length of the DVR window in seconds. This value is optional.
     * If unset
     *                 the default window as provided by the input encoder
     * will be used. */
    private java.lang.Integer dvrWindowSeconds;

    /* Whether the event's stream requests to the IMA SDK API will
     * be authenticated using the DAI
     *                 authentication keys. */
    private java.lang.Boolean enableDaiAuthenticationKeys;

    /* The type of content that should be used to fill an empty ad
     * break. This value is optional and
     *                 defaults to {@link AdBreakFillType#SLATE}. */
    private com.google.api.ads.admanager.axis.v201911.AdBreakFillType adBreakFillType;

    /* The duration (in seconds), starting from the time the user
     * enters the DAI stream, for which
     *                 mid-roll decisioning will be skipped. This field is
     * only applicable when an ad holiday
     *                 is requested in the stream create request. This value
     * is optional and defaults to 0. */
    private java.lang.Long adHolidayDuration;

    /* Whether there will be durationless ad breaks in this live stream.
     * If true,
     *                 {@code defaultAdBreakDuration} should be specified.
     * This field is optional and defaults to
     *                 false; */
    private java.lang.Boolean enableDurationlessAdBreaks;

    /* The default ad pod duration (in seconds) that will be requested
     * when an ad break cue-out
     *                 does not specify a duration. This field is optional
     * and defaults to 0; */
    private java.lang.Long defaultAdBreakDuration;

    /* The list of {@link DaiAuthenticationKey} IDs used to authenticate
     * requests for this live
     *                 stream. */
    private long[] daiAuthenticationKeyIds;

    /* The list of {@link CdnConfiguration} IDs that provide settings
     * for ingesting and delivering the
     *                 videos associated with this source. */
    private long[] sourceContentConfigurationIds;

    /* The settings that are specific to HTTPS live streaming (HLS)
     * protocol. This field is optional
     *                 and if it is not set will use the default HLS settings. */
    private com.google.api.ads.admanager.axis.v201911.HlsSettings hlsSettings;

    /* The streaming format of the {@link LiveStreamEvent} media. */
    private com.google.api.ads.admanager.axis.v201911.StreamingFormat streamingFormat;

    public LiveStreamEvent() {
    }

    public LiveStreamEvent(
           java.lang.Long id,
           java.lang.String name,
           java.lang.String description,
           com.google.api.ads.admanager.axis.v201911.LiveStreamEventStatus status,
           com.google.api.ads.admanager.axis.v201911.DateTime creationDateTime,
           com.google.api.ads.admanager.axis.v201911.DateTime lastModifiedDateTime,
           com.google.api.ads.admanager.axis.v201911.DateTime startDateTime,
           com.google.api.ads.admanager.axis.v201911.StartDateTimeType startDateTimeType,
           com.google.api.ads.admanager.axis.v201911.DateTime endDateTime,
           java.lang.Boolean unlimitedEndDateTime,
           java.lang.Long totalEstimatedConcurrentUsers,
           java.lang.String[] contentUrls,
           java.lang.String[] adTags,
           java.lang.String assetKey,
           java.lang.Long slateCreativeId,
           java.lang.Integer dvrWindowSeconds,
           java.lang.Boolean enableDaiAuthenticationKeys,
           com.google.api.ads.admanager.axis.v201911.AdBreakFillType adBreakFillType,
           java.lang.Long adHolidayDuration,
           java.lang.Boolean enableDurationlessAdBreaks,
           java.lang.Long defaultAdBreakDuration,
           long[] daiAuthenticationKeyIds,
           long[] sourceContentConfigurationIds,
           com.google.api.ads.admanager.axis.v201911.HlsSettings hlsSettings,
           com.google.api.ads.admanager.axis.v201911.StreamingFormat streamingFormat) {
           this.id = id;
           this.name = name;
           this.description = description;
           this.status = status;
           this.creationDateTime = creationDateTime;
           this.lastModifiedDateTime = lastModifiedDateTime;
           this.startDateTime = startDateTime;
           this.startDateTimeType = startDateTimeType;
           this.endDateTime = endDateTime;
           this.unlimitedEndDateTime = unlimitedEndDateTime;
           this.totalEstimatedConcurrentUsers = totalEstimatedConcurrentUsers;
           this.contentUrls = contentUrls;
           this.adTags = adTags;
           this.assetKey = assetKey;
           this.slateCreativeId = slateCreativeId;
           this.dvrWindowSeconds = dvrWindowSeconds;
           this.enableDaiAuthenticationKeys = enableDaiAuthenticationKeys;
           this.adBreakFillType = adBreakFillType;
           this.adHolidayDuration = adHolidayDuration;
           this.enableDurationlessAdBreaks = enableDurationlessAdBreaks;
           this.defaultAdBreakDuration = defaultAdBreakDuration;
           this.daiAuthenticationKeyIds = daiAuthenticationKeyIds;
           this.sourceContentConfigurationIds = sourceContentConfigurationIds;
           this.hlsSettings = hlsSettings;
           this.streamingFormat = streamingFormat;
    }

    @Override
    public String toString() {
        return com.google.common.base.MoreObjects.toStringHelper(this.getClass())
            .omitNullValues()
            .add("adBreakFillType", getAdBreakFillType())
            .add("adHolidayDuration", getAdHolidayDuration())
            .add("adTags", getAdTags())
            .add("assetKey", getAssetKey())
            .add("contentUrls", getContentUrls())
            .add("creationDateTime", getCreationDateTime())
            .add("daiAuthenticationKeyIds", getDaiAuthenticationKeyIds())
            .add("defaultAdBreakDuration", getDefaultAdBreakDuration())
            .add("description", getDescription())
            .add("dvrWindowSeconds", getDvrWindowSeconds())
            .add("enableDaiAuthenticationKeys", getEnableDaiAuthenticationKeys())
            .add("enableDurationlessAdBreaks", getEnableDurationlessAdBreaks())
            .add("endDateTime", getEndDateTime())
            .add("hlsSettings", getHlsSettings())
            .add("id", getId())
            .add("lastModifiedDateTime", getLastModifiedDateTime())
            .add("name", getName())
            .add("slateCreativeId", getSlateCreativeId())
            .add("sourceContentConfigurationIds", getSourceContentConfigurationIds())
            .add("startDateTime", getStartDateTime())
            .add("startDateTimeType", getStartDateTimeType())
            .add("status", getStatus())
            .add("streamingFormat", getStreamingFormat())
            .add("totalEstimatedConcurrentUsers", getTotalEstimatedConcurrentUsers())
            .add("unlimitedEndDateTime", getUnlimitedEndDateTime())
            .toString();
    }

    /**
     * Gets the id value for this LiveStreamEvent.
     * 
     * @return id   * The unique ID of the {@code LiveStreamEvent}. This value is
     * read-only and
     *                 is assigned by Google.
     */
    public java.lang.Long getId() {
        return id;
    }


    /**
     * Sets the id value for this LiveStreamEvent.
     * 
     * @param id   * The unique ID of the {@code LiveStreamEvent}. This value is
     * read-only and
     *                 is assigned by Google.
     */
    public void setId(java.lang.Long id) {
        this.id = id;
    }


    /**
     * Gets the name value for this LiveStreamEvent.
     * 
     * @return name   * The name of the {@code LiveStreamEvent}. This value is required
     * to create
     *                 a live stream event and has a maximum length of 255
     * characters.
     */
    public java.lang.String getName() {
        return name;
    }


    /**
     * Sets the name value for this LiveStreamEvent.
     * 
     * @param name   * The name of the {@code LiveStreamEvent}. This value is required
     * to create
     *                 a live stream event and has a maximum length of 255
     * characters.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }


    /**
     * Gets the description value for this LiveStreamEvent.
     * 
     * @return description   * Additional notes to annotate the event with. This attribute
     * is optional and
     *                 has a maximum length of 65,535 characters.
     */
    public java.lang.String getDescription() {
        return description;
    }


    /**
     * Sets the description value for this LiveStreamEvent.
     * 
     * @param description   * Additional notes to annotate the event with. This attribute
     * is optional and
     *                 has a maximum length of 65,535 characters.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }


    /**
     * Gets the status value for this LiveStreamEvent.
     * 
     * @return status   * The status of this {@code LiveStreamEvent}. This attribute
     * is read-only
     *                 and is assigned by Google. Live stream events are
     * created in the
     *                 {@link LiveStreamEventStatus#PAUSED} state.
     */
    public com.google.api.ads.admanager.axis.v201911.LiveStreamEventStatus getStatus() {
        return status;
    }


    /**
     * Sets the status value for this LiveStreamEvent.
     * 
     * @param status   * The status of this {@code LiveStreamEvent}. This attribute
     * is read-only
     *                 and is assigned by Google. Live stream events are
     * created in the
     *                 {@link LiveStreamEventStatus#PAUSED} state.
     */
    public void setStatus(com.google.api.ads.admanager.axis.v201911.LiveStreamEventStatus status) {
        this.status = status;
    }


    /**
     * Gets the creationDateTime value for this LiveStreamEvent.
     * 
     * @return creationDateTime   * The date and time this {@code LiveStreamEvent} was created.
     * This attribute
     *                 is read-only.
     */
    public com.google.api.ads.admanager.axis.v201911.DateTime getCreationDateTime() {
        return creationDateTime;
    }


    /**
     * Sets the creationDateTime value for this LiveStreamEvent.
     * 
     * @param creationDateTime   * The date and time this {@code LiveStreamEvent} was created.
     * This attribute
     *                 is read-only.
     */
    public void setCreationDateTime(com.google.api.ads.admanager.axis.v201911.DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }


    /**
     * Gets the lastModifiedDateTime value for this LiveStreamEvent.
     * 
     * @return lastModifiedDateTime   * The date and time this {@code LiveStreamEvent} was last modified.
     * This
     *                 attribute is read-only.
     */
    public com.google.api.ads.admanager.axis.v201911.DateTime getLastModifiedDateTime() {
        return lastModifiedDateTime;
    }


    /**
     * Sets the lastModifiedDateTime value for this LiveStreamEvent.
     * 
     * @param lastModifiedDateTime   * The date and time this {@code LiveStreamEvent} was last modified.
     * This
     *                 attribute is read-only.
     */
    public void setLastModifiedDateTime(com.google.api.ads.admanager.axis.v201911.DateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }


    /**
     * Gets the startDateTime value for this LiveStreamEvent.
     * 
     * @return startDateTime   * The start date and time of this {@code LiveStreamEvent}. This
     * attribute
     *                 is required if the {@link LiveStreamEvent#startDateTimeType}
     * is
     *                 {@link StartDateTimeType#USE_START_DATE_TIME} and
     * is ignored for all other values of
     *                 {@link StartDateTimeType}.
     */
    public com.google.api.ads.admanager.axis.v201911.DateTime getStartDateTime() {
        return startDateTime;
    }


    /**
     * Sets the startDateTime value for this LiveStreamEvent.
     * 
     * @param startDateTime   * The start date and time of this {@code LiveStreamEvent}. This
     * attribute
     *                 is required if the {@link LiveStreamEvent#startDateTimeType}
     * is
     *                 {@link StartDateTimeType#USE_START_DATE_TIME} and
     * is ignored for all other values of
     *                 {@link StartDateTimeType}.
     */
    public void setStartDateTime(com.google.api.ads.admanager.axis.v201911.DateTime startDateTime) {
        this.startDateTime = startDateTime;
    }


    /**
     * Gets the startDateTimeType value for this LiveStreamEvent.
     * 
     * @return startDateTimeType   * Specifies whether to start the {@link LiveStreamEvent} right
     * away, in an hour, etc.
     *                 This attribute is optional and defaults to {@link
     * StartDateTimeType#USE_START_DATE_TIME}.
     */
    public com.google.api.ads.admanager.axis.v201911.StartDateTimeType getStartDateTimeType() {
        return startDateTimeType;
    }


    /**
     * Sets the startDateTimeType value for this LiveStreamEvent.
     * 
     * @param startDateTimeType   * Specifies whether to start the {@link LiveStreamEvent} right
     * away, in an hour, etc.
     *                 This attribute is optional and defaults to {@link
     * StartDateTimeType#USE_START_DATE_TIME}.
     */
    public void setStartDateTimeType(com.google.api.ads.admanager.axis.v201911.StartDateTimeType startDateTimeType) {
        this.startDateTimeType = startDateTimeType;
    }


    /**
     * Gets the endDateTime value for this LiveStreamEvent.
     * 
     * @return endDateTime   * The scheduled end date and time of this {@code LiveStreamEvent}.
     * This
     *                 attribute is required if {@code unlimitedEndDateTime}
     * is false and ignored if
     *                 {@code unlimitedEndDateTime} is true.
     */
    public com.google.api.ads.admanager.axis.v201911.DateTime getEndDateTime() {
        return endDateTime;
    }


    /**
     * Sets the endDateTime value for this LiveStreamEvent.
     * 
     * @param endDateTime   * The scheduled end date and time of this {@code LiveStreamEvent}.
     * This
     *                 attribute is required if {@code unlimitedEndDateTime}
     * is false and ignored if
     *                 {@code unlimitedEndDateTime} is true.
     */
    public void setEndDateTime(com.google.api.ads.admanager.axis.v201911.DateTime endDateTime) {
        this.endDateTime = endDateTime;
    }


    /**
     * Gets the unlimitedEndDateTime value for this LiveStreamEvent.
     * 
     * @return unlimitedEndDateTime   * Whether the {@link LiveStreamEvent} has an end time. This attribute
     * is optional and defaults
     *                 to false. If this field is true, {@code endDateTime}
     * is ignored.
     */
    public java.lang.Boolean getUnlimitedEndDateTime() {
        return unlimitedEndDateTime;
    }


    /**
     * Sets the unlimitedEndDateTime value for this LiveStreamEvent.
     * 
     * @param unlimitedEndDateTime   * Whether the {@link LiveStreamEvent} has an end time. This attribute
     * is optional and defaults
     *                 to false. If this field is true, {@code endDateTime}
     * is ignored.
     */
    public void setUnlimitedEndDateTime(java.lang.Boolean unlimitedEndDateTime) {
        this.unlimitedEndDateTime = unlimitedEndDateTime;
    }


    /**
     * Gets the totalEstimatedConcurrentUsers value for this LiveStreamEvent.
     * 
     * @return totalEstimatedConcurrentUsers   * The total number of concurrent users expected to watch this
     * event across
     *                 all regions. This attribute is optional and default
     * value is 0.
     */
    public java.lang.Long getTotalEstimatedConcurrentUsers() {
        return totalEstimatedConcurrentUsers;
    }


    /**
     * Sets the totalEstimatedConcurrentUsers value for this LiveStreamEvent.
     * 
     * @param totalEstimatedConcurrentUsers   * The total number of concurrent users expected to watch this
     * event across
     *                 all regions. This attribute is optional and default
     * value is 0.
     */
    public void setTotalEstimatedConcurrentUsers(java.lang.Long totalEstimatedConcurrentUsers) {
        this.totalEstimatedConcurrentUsers = totalEstimatedConcurrentUsers;
    }


    /**
     * Gets the contentUrls value for this LiveStreamEvent.
     * 
     * @return contentUrls   * The list of URLs pointing to the live stream content in
     *                 Content Delivery Network. This attribute is required.
     */
    public java.lang.String[] getContentUrls() {
        return contentUrls;
    }


    /**
     * Sets the contentUrls value for this LiveStreamEvent.
     * 
     * @param contentUrls   * The list of URLs pointing to the live stream content in
     *                 Content Delivery Network. This attribute is required.
     */
    public void setContentUrls(java.lang.String[] contentUrls) {
        this.contentUrls = contentUrls;
    }

    public java.lang.String getContentUrls(int i) {
        return this.contentUrls[i];
    }

    public void setContentUrls(int i, java.lang.String _value) {
        this.contentUrls[i] = _value;
    }


    /**
     * Gets the adTags value for this LiveStreamEvent.
     * 
     * @return adTags   * The list of Ad Manager ad tag URLs generated by the Ad Manager
     * trafficking workflow that are
     *                 associated with this live stream event. Currently,
     * the list includes only one element: the
     *                 master ad tag. This attribute is required.
     */
    public java.lang.String[] getAdTags() {
        return adTags;
    }


    /**
     * Sets the adTags value for this LiveStreamEvent.
     * 
     * @param adTags   * The list of Ad Manager ad tag URLs generated by the Ad Manager
     * trafficking workflow that are
     *                 associated with this live stream event. Currently,
     * the list includes only one element: the
     *                 master ad tag. This attribute is required.
     */
    public void setAdTags(java.lang.String[] adTags) {
        this.adTags = adTags;
    }

    public java.lang.String getAdTags(int i) {
        return this.adTags[i];
    }

    public void setAdTags(int i, java.lang.String _value) {
        this.adTags[i] = _value;
    }


    /**
     * Gets the assetKey value for this LiveStreamEvent.
     * 
     * @return assetKey   * This code is used in constructing a live stream event master
     * playlist URL. This attribute is
     *                 read-only and is assigned by Google. As of V201911
     * this field is called assetKey.
     */
    public java.lang.String getAssetKey() {
        return assetKey;
    }


    /**
     * Sets the assetKey value for this LiveStreamEvent.
     * 
     * @param assetKey   * This code is used in constructing a live stream event master
     * playlist URL. This attribute is
     *                 read-only and is assigned by Google. As of V201911
     * this field is called assetKey.
     */
    public void setAssetKey(java.lang.String assetKey) {
        this.assetKey = assetKey;
    }


    /**
     * Gets the slateCreativeId value for this LiveStreamEvent.
     * 
     * @return slateCreativeId   * ID corresponding to the slate for this live event. If not set,
     * network default value
     *                 will be used.
     */
    public java.lang.Long getSlateCreativeId() {
        return slateCreativeId;
    }


    /**
     * Sets the slateCreativeId value for this LiveStreamEvent.
     * 
     * @param slateCreativeId   * ID corresponding to the slate for this live event. If not set,
     * network default value
     *                 will be used.
     */
    public void setSlateCreativeId(java.lang.Long slateCreativeId) {
        this.slateCreativeId = slateCreativeId;
    }


    /**
     * Gets the dvrWindowSeconds value for this LiveStreamEvent.
     * 
     * @return dvrWindowSeconds   * Length of the DVR window in seconds. This value is optional.
     * If unset
     *                 the default window as provided by the input encoder
     * will be used.
     */
    public java.lang.Integer getDvrWindowSeconds() {
        return dvrWindowSeconds;
    }


    /**
     * Sets the dvrWindowSeconds value for this LiveStreamEvent.
     * 
     * @param dvrWindowSeconds   * Length of the DVR window in seconds. This value is optional.
     * If unset
     *                 the default window as provided by the input encoder
     * will be used.
     */
    public void setDvrWindowSeconds(java.lang.Integer dvrWindowSeconds) {
        this.dvrWindowSeconds = dvrWindowSeconds;
    }


    /**
     * Gets the enableDaiAuthenticationKeys value for this LiveStreamEvent.
     * 
     * @return enableDaiAuthenticationKeys   * Whether the event's stream requests to the IMA SDK API will
     * be authenticated using the DAI
     *                 authentication keys.
     */
    public java.lang.Boolean getEnableDaiAuthenticationKeys() {
        return enableDaiAuthenticationKeys;
    }


    /**
     * Sets the enableDaiAuthenticationKeys value for this LiveStreamEvent.
     * 
     * @param enableDaiAuthenticationKeys   * Whether the event's stream requests to the IMA SDK API will
     * be authenticated using the DAI
     *                 authentication keys.
     */
    public void setEnableDaiAuthenticationKeys(java.lang.Boolean enableDaiAuthenticationKeys) {
        this.enableDaiAuthenticationKeys = enableDaiAuthenticationKeys;
    }


    /**
     * Gets the adBreakFillType value for this LiveStreamEvent.
     * 
     * @return adBreakFillType   * The type of content that should be used to fill an empty ad
     * break. This value is optional and
     *                 defaults to {@link AdBreakFillType#SLATE}.
     */
    public com.google.api.ads.admanager.axis.v201911.AdBreakFillType getAdBreakFillType() {
        return adBreakFillType;
    }


    /**
     * Sets the adBreakFillType value for this LiveStreamEvent.
     * 
     * @param adBreakFillType   * The type of content that should be used to fill an empty ad
     * break. This value is optional and
     *                 defaults to {@link AdBreakFillType#SLATE}.
     */
    public void setAdBreakFillType(com.google.api.ads.admanager.axis.v201911.AdBreakFillType adBreakFillType) {
        this.adBreakFillType = adBreakFillType;
    }


    /**
     * Gets the adHolidayDuration value for this LiveStreamEvent.
     * 
     * @return adHolidayDuration   * The duration (in seconds), starting from the time the user
     * enters the DAI stream, for which
     *                 mid-roll decisioning will be skipped. This field is
     * only applicable when an ad holiday
     *                 is requested in the stream create request. This value
     * is optional and defaults to 0.
     */
    public java.lang.Long getAdHolidayDuration() {
        return adHolidayDuration;
    }


    /**
     * Sets the adHolidayDuration value for this LiveStreamEvent.
     * 
     * @param adHolidayDuration   * The duration (in seconds), starting from the time the user
     * enters the DAI stream, for which
     *                 mid-roll decisioning will be skipped. This field is
     * only applicable when an ad holiday
     *                 is requested in the stream create request. This value
     * is optional and defaults to 0.
     */
    public void setAdHolidayDuration(java.lang.Long adHolidayDuration) {
        this.adHolidayDuration = adHolidayDuration;
    }


    /**
     * Gets the enableDurationlessAdBreaks value for this LiveStreamEvent.
     * 
     * @return enableDurationlessAdBreaks   * Whether there will be durationless ad breaks in this live stream.
     * If true,
     *                 {@code defaultAdBreakDuration} should be specified.
     * This field is optional and defaults to
     *                 false;
     */
    public java.lang.Boolean getEnableDurationlessAdBreaks() {
        return enableDurationlessAdBreaks;
    }


    /**
     * Sets the enableDurationlessAdBreaks value for this LiveStreamEvent.
     * 
     * @param enableDurationlessAdBreaks   * Whether there will be durationless ad breaks in this live stream.
     * If true,
     *                 {@code defaultAdBreakDuration} should be specified.
     * This field is optional and defaults to
     *                 false;
     */
    public void setEnableDurationlessAdBreaks(java.lang.Boolean enableDurationlessAdBreaks) {
        this.enableDurationlessAdBreaks = enableDurationlessAdBreaks;
    }


    /**
     * Gets the defaultAdBreakDuration value for this LiveStreamEvent.
     * 
     * @return defaultAdBreakDuration   * The default ad pod duration (in seconds) that will be requested
     * when an ad break cue-out
     *                 does not specify a duration. This field is optional
     * and defaults to 0;
     */
    public java.lang.Long getDefaultAdBreakDuration() {
        return defaultAdBreakDuration;
    }


    /**
     * Sets the defaultAdBreakDuration value for this LiveStreamEvent.
     * 
     * @param defaultAdBreakDuration   * The default ad pod duration (in seconds) that will be requested
     * when an ad break cue-out
     *                 does not specify a duration. This field is optional
     * and defaults to 0;
     */
    public void setDefaultAdBreakDuration(java.lang.Long defaultAdBreakDuration) {
        this.defaultAdBreakDuration = defaultAdBreakDuration;
    }


    /**
     * Gets the daiAuthenticationKeyIds value for this LiveStreamEvent.
     * 
     * @return daiAuthenticationKeyIds   * The list of {@link DaiAuthenticationKey} IDs used to authenticate
     * requests for this live
     *                 stream.
     */
    public long[] getDaiAuthenticationKeyIds() {
        return daiAuthenticationKeyIds;
    }


    /**
     * Sets the daiAuthenticationKeyIds value for this LiveStreamEvent.
     * 
     * @param daiAuthenticationKeyIds   * The list of {@link DaiAuthenticationKey} IDs used to authenticate
     * requests for this live
     *                 stream.
     */
    public void setDaiAuthenticationKeyIds(long[] daiAuthenticationKeyIds) {
        this.daiAuthenticationKeyIds = daiAuthenticationKeyIds;
    }

    public long getDaiAuthenticationKeyIds(int i) {
        return this.daiAuthenticationKeyIds[i];
    }

    public void setDaiAuthenticationKeyIds(int i, long _value) {
        this.daiAuthenticationKeyIds[i] = _value;
    }


    /**
     * Gets the sourceContentConfigurationIds value for this LiveStreamEvent.
     * 
     * @return sourceContentConfigurationIds   * The list of {@link CdnConfiguration} IDs that provide settings
     * for ingesting and delivering the
     *                 videos associated with this source.
     */
    public long[] getSourceContentConfigurationIds() {
        return sourceContentConfigurationIds;
    }


    /**
     * Sets the sourceContentConfigurationIds value for this LiveStreamEvent.
     * 
     * @param sourceContentConfigurationIds   * The list of {@link CdnConfiguration} IDs that provide settings
     * for ingesting and delivering the
     *                 videos associated with this source.
     */
    public void setSourceContentConfigurationIds(long[] sourceContentConfigurationIds) {
        this.sourceContentConfigurationIds = sourceContentConfigurationIds;
    }

    public long getSourceContentConfigurationIds(int i) {
        return this.sourceContentConfigurationIds[i];
    }

    public void setSourceContentConfigurationIds(int i, long _value) {
        this.sourceContentConfigurationIds[i] = _value;
    }


    /**
     * Gets the hlsSettings value for this LiveStreamEvent.
     * 
     * @return hlsSettings   * The settings that are specific to HTTPS live streaming (HLS)
     * protocol. This field is optional
     *                 and if it is not set will use the default HLS settings.
     */
    public com.google.api.ads.admanager.axis.v201911.HlsSettings getHlsSettings() {
        return hlsSettings;
    }


    /**
     * Sets the hlsSettings value for this LiveStreamEvent.
     * 
     * @param hlsSettings   * The settings that are specific to HTTPS live streaming (HLS)
     * protocol. This field is optional
     *                 and if it is not set will use the default HLS settings.
     */
    public void setHlsSettings(com.google.api.ads.admanager.axis.v201911.HlsSettings hlsSettings) {
        this.hlsSettings = hlsSettings;
    }


    /**
     * Gets the streamingFormat value for this LiveStreamEvent.
     * 
     * @return streamingFormat   * The streaming format of the {@link LiveStreamEvent} media.
     */
    public com.google.api.ads.admanager.axis.v201911.StreamingFormat getStreamingFormat() {
        return streamingFormat;
    }


    /**
     * Sets the streamingFormat value for this LiveStreamEvent.
     * 
     * @param streamingFormat   * The streaming format of the {@link LiveStreamEvent} media.
     */
    public void setStreamingFormat(com.google.api.ads.admanager.axis.v201911.StreamingFormat streamingFormat) {
        this.streamingFormat = streamingFormat;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(java.lang.Object obj) {
        if (!(obj instanceof LiveStreamEvent)) return false;
        LiveStreamEvent other = (LiveStreamEvent) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.id==null && other.getId()==null) || 
             (this.id!=null &&
              this.id.equals(other.getId()))) &&
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            ((this.description==null && other.getDescription()==null) || 
             (this.description!=null &&
              this.description.equals(other.getDescription()))) &&
            ((this.status==null && other.getStatus()==null) || 
             (this.status!=null &&
              this.status.equals(other.getStatus()))) &&
            ((this.creationDateTime==null && other.getCreationDateTime()==null) || 
             (this.creationDateTime!=null &&
              this.creationDateTime.equals(other.getCreationDateTime()))) &&
            ((this.lastModifiedDateTime==null && other.getLastModifiedDateTime()==null) || 
             (this.lastModifiedDateTime!=null &&
              this.lastModifiedDateTime.equals(other.getLastModifiedDateTime()))) &&
            ((this.startDateTime==null && other.getStartDateTime()==null) || 
             (this.startDateTime!=null &&
              this.startDateTime.equals(other.getStartDateTime()))) &&
            ((this.startDateTimeType==null && other.getStartDateTimeType()==null) || 
             (this.startDateTimeType!=null &&
              this.startDateTimeType.equals(other.getStartDateTimeType()))) &&
            ((this.endDateTime==null && other.getEndDateTime()==null) || 
             (this.endDateTime!=null &&
              this.endDateTime.equals(other.getEndDateTime()))) &&
            ((this.unlimitedEndDateTime==null && other.getUnlimitedEndDateTime()==null) || 
             (this.unlimitedEndDateTime!=null &&
              this.unlimitedEndDateTime.equals(other.getUnlimitedEndDateTime()))) &&
            ((this.totalEstimatedConcurrentUsers==null && other.getTotalEstimatedConcurrentUsers()==null) || 
             (this.totalEstimatedConcurrentUsers!=null &&
              this.totalEstimatedConcurrentUsers.equals(other.getTotalEstimatedConcurrentUsers()))) &&
            ((this.contentUrls==null && other.getContentUrls()==null) || 
             (this.contentUrls!=null &&
              java.util.Arrays.equals(this.contentUrls, other.getContentUrls()))) &&
            ((this.adTags==null && other.getAdTags()==null) || 
             (this.adTags!=null &&
              java.util.Arrays.equals(this.adTags, other.getAdTags()))) &&
            ((this.assetKey==null && other.getAssetKey()==null) || 
             (this.assetKey!=null &&
              this.assetKey.equals(other.getAssetKey()))) &&
            ((this.slateCreativeId==null && other.getSlateCreativeId()==null) || 
             (this.slateCreativeId!=null &&
              this.slateCreativeId.equals(other.getSlateCreativeId()))) &&
            ((this.dvrWindowSeconds==null && other.getDvrWindowSeconds()==null) || 
             (this.dvrWindowSeconds!=null &&
              this.dvrWindowSeconds.equals(other.getDvrWindowSeconds()))) &&
            ((this.enableDaiAuthenticationKeys==null && other.getEnableDaiAuthenticationKeys()==null) || 
             (this.enableDaiAuthenticationKeys!=null &&
              this.enableDaiAuthenticationKeys.equals(other.getEnableDaiAuthenticationKeys()))) &&
            ((this.adBreakFillType==null && other.getAdBreakFillType()==null) || 
             (this.adBreakFillType!=null &&
              this.adBreakFillType.equals(other.getAdBreakFillType()))) &&
            ((this.adHolidayDuration==null && other.getAdHolidayDuration()==null) || 
             (this.adHolidayDuration!=null &&
              this.adHolidayDuration.equals(other.getAdHolidayDuration()))) &&
            ((this.enableDurationlessAdBreaks==null && other.getEnableDurationlessAdBreaks()==null) || 
             (this.enableDurationlessAdBreaks!=null &&
              this.enableDurationlessAdBreaks.equals(other.getEnableDurationlessAdBreaks()))) &&
            ((this.defaultAdBreakDuration==null && other.getDefaultAdBreakDuration()==null) || 
             (this.defaultAdBreakDuration!=null &&
              this.defaultAdBreakDuration.equals(other.getDefaultAdBreakDuration()))) &&
            ((this.daiAuthenticationKeyIds==null && other.getDaiAuthenticationKeyIds()==null) || 
             (this.daiAuthenticationKeyIds!=null &&
              java.util.Arrays.equals(this.daiAuthenticationKeyIds, other.getDaiAuthenticationKeyIds()))) &&
            ((this.sourceContentConfigurationIds==null && other.getSourceContentConfigurationIds()==null) || 
             (this.sourceContentConfigurationIds!=null &&
              java.util.Arrays.equals(this.sourceContentConfigurationIds, other.getSourceContentConfigurationIds()))) &&
            ((this.hlsSettings==null && other.getHlsSettings()==null) || 
             (this.hlsSettings!=null &&
              this.hlsSettings.equals(other.getHlsSettings()))) &&
            ((this.streamingFormat==null && other.getStreamingFormat()==null) || 
             (this.streamingFormat!=null &&
              this.streamingFormat.equals(other.getStreamingFormat())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getId() != null) {
            _hashCode += getId().hashCode();
        }
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        if (getDescription() != null) {
            _hashCode += getDescription().hashCode();
        }
        if (getStatus() != null) {
            _hashCode += getStatus().hashCode();
        }
        if (getCreationDateTime() != null) {
            _hashCode += getCreationDateTime().hashCode();
        }
        if (getLastModifiedDateTime() != null) {
            _hashCode += getLastModifiedDateTime().hashCode();
        }
        if (getStartDateTime() != null) {
            _hashCode += getStartDateTime().hashCode();
        }
        if (getStartDateTimeType() != null) {
            _hashCode += getStartDateTimeType().hashCode();
        }
        if (getEndDateTime() != null) {
            _hashCode += getEndDateTime().hashCode();
        }
        if (getUnlimitedEndDateTime() != null) {
            _hashCode += getUnlimitedEndDateTime().hashCode();
        }
        if (getTotalEstimatedConcurrentUsers() != null) {
            _hashCode += getTotalEstimatedConcurrentUsers().hashCode();
        }
        if (getContentUrls() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getContentUrls());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getContentUrls(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAdTags() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAdTags());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getAdTags(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAssetKey() != null) {
            _hashCode += getAssetKey().hashCode();
        }
        if (getSlateCreativeId() != null) {
            _hashCode += getSlateCreativeId().hashCode();
        }
        if (getDvrWindowSeconds() != null) {
            _hashCode += getDvrWindowSeconds().hashCode();
        }
        if (getEnableDaiAuthenticationKeys() != null) {
            _hashCode += getEnableDaiAuthenticationKeys().hashCode();
        }
        if (getAdBreakFillType() != null) {
            _hashCode += getAdBreakFillType().hashCode();
        }
        if (getAdHolidayDuration() != null) {
            _hashCode += getAdHolidayDuration().hashCode();
        }
        if (getEnableDurationlessAdBreaks() != null) {
            _hashCode += getEnableDurationlessAdBreaks().hashCode();
        }
        if (getDefaultAdBreakDuration() != null) {
            _hashCode += getDefaultAdBreakDuration().hashCode();
        }
        if (getDaiAuthenticationKeyIds() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getDaiAuthenticationKeyIds());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getDaiAuthenticationKeyIds(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSourceContentConfigurationIds() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSourceContentConfigurationIds());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getSourceContentConfigurationIds(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getHlsSettings() != null) {
            _hashCode += getHlsSettings().hashCode();
        }
        if (getStreamingFormat() != null) {
            _hashCode += getStreamingFormat().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(LiveStreamEvent.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "LiveStreamEvent"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("id");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "id"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("description");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "description"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("status");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "status"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "LiveStreamEventStatus"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("creationDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "creationDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastModifiedDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "lastModifiedDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("startDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "startDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("startDateTimeType");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "startDateTimeType"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "StartDateTimeType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("endDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "endDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("unlimitedEndDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "unlimitedEndDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("totalEstimatedConcurrentUsers");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "totalEstimatedConcurrentUsers"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("contentUrls");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "contentUrls"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adTags");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "adTags"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("assetKey");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "assetKey"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("slateCreativeId");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "slateCreativeId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("dvrWindowSeconds");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "dvrWindowSeconds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enableDaiAuthenticationKeys");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "enableDaiAuthenticationKeys"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adBreakFillType");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "adBreakFillType"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "AdBreakFillType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adHolidayDuration");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "adHolidayDuration"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enableDurationlessAdBreaks");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "enableDurationlessAdBreaks"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("defaultAdBreakDuration");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "defaultAdBreakDuration"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("daiAuthenticationKeyIds");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "daiAuthenticationKeyIds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("sourceContentConfigurationIds");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "sourceContentConfigurationIds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hlsSettings");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "hlsSettings"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "HlsSettings"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("streamingFormat");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "streamingFormat"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v201911", "StreamingFormat"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
