// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * LiveStreamEvent.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Mar 02, 2009 (07:08:06 PST) WSDL2Java emitter.
 */

package com.google.api.ads.admanager.axis.v202302;


/**
 * A {@code LiveStreamEvent} encapsulates all the information necessary
 * to enable DAI (Dynamic Ad
 *             Insertion) into a live video stream.
 *             
 *             <p>This includes information such as the start and expected
 * end time of the live stream, the URL
 *             of the actual content for Ad Manager to pull and insert
 * ads into, as well as the metadata
 *             necessary to generate ad requests during the live stream.
 */
public class LiveStreamEvent  implements java.io.Serializable {
    /* The unique ID of the {@code LiveStreamEvent}. This value is
     * read-only and is assigned by
     *                 Google. */
    private java.lang.Long id;

    /* The name of the {@code LiveStreamEvent}. This value is required
     * to create a live stream event
     *                 and has a maximum length of 255 characters. */
    private java.lang.String name;

    /* The status of this {@code LiveStreamEvent}. This attribute
     * is read-only and is assigned by
     *                 Google. Live stream events are created in the {@link
     * LiveStreamEventStatus#PAUSED} state. */
    private com.google.api.ads.admanager.axis.v202302.LiveStreamEventStatus status;

    /* The date and time this {@code LiveStreamEvent} was created.
     * This attribute is read-only. */
    private com.google.api.ads.admanager.axis.v202302.DateTime creationDateTime;

    /* The date and time this {@code LiveStreamEvent} was last modified.
     * This attribute is read-only. */
    private com.google.api.ads.admanager.axis.v202302.DateTime lastModifiedDateTime;

    /* The start date and time of this {@code LiveStreamEvent}. This
     * attribute is required if the
     *                 {@link LiveStreamEvent#startDateTimeType} is {@link
     * StartDateTimeType#USE_START_DATE_TIME} and
     *                 is ignored for all other values of {@link StartDateTimeType}.
     * Modifying this attribute for an
     *                 active live stream can impact traffic. */
    private com.google.api.ads.admanager.axis.v202302.DateTime startDateTime;

    /* Specifies whether to start the {@link LiveStreamEvent} right
     * away, in an hour, etc. This
     *                 attribute is optional and defaults to {@link StartDateTimeType#USE_START_DATE_TIME}. */
    private com.google.api.ads.admanager.axis.v202302.StartDateTimeType startDateTimeType;

    /* The scheduled end date and time of this {@code LiveStreamEvent}.
     * This attribute is required if
     *                 {@code unlimitedEndDateTime} is false and ignored
     * if {@code unlimitedEndDateTime} is true.
     *                 Modifying this attribute for an active live stream
     * can impact traffic. */
    private com.google.api.ads.admanager.axis.v202302.DateTime endDateTime;

    /* Whether the {@link LiveStreamEvent} has an end time. This attribute
     * is optional and defaults to
     *                 false. If this field is true, {@code endDateTime}
     * is ignored. */
    private java.lang.Boolean unlimitedEndDateTime;

    /* The total number of concurrent users expected to watch this
     * live stream across all regions.
     *                 This attribute is optional and default value is 0. */
    private java.lang.Long totalEstimatedConcurrentUsers;

    /* The list of URLs pointing to the live stream content in Content
     * Delivery Network. This
     *                 attribute is required and can be modified when the
     * live stream is in a {@link
     *                 LiveStreamEventStatus#PAUSED} state. */
    private java.lang.String[] contentUrls;

    /* The list of Ad Manager ad tag URLs generated by the Ad Manager
     * trafficking workflow that are
     *                 associated with this live stream event. Currently,
     * the list includes only one element: the
     *                 master ad tag. This attribute is required. */
    private java.lang.String[] adTags;

    /* This code is used in constructing a live stream event master
     * playlist URL. This attribute is
     *                 read-only and is assigned by Google. {@code liveStreamEventCode}
     * was renamed {@code assetKey}
     *                 in v201911. */
    private java.lang.String assetKey;

    /* ID corresponding to the slate for this live event. If not set,
     * network default value will be
     *                 used. */
    private java.lang.Long slateCreativeId;

    /* Length of the DVR window in seconds. This value is optional.
     * If unset the default window as
     *                 provided by the input encoder will be used. Modifying
     * this value for an active live stream can
     *                 impact traffic. */
    private java.lang.Integer dvrWindowSeconds;

    /* Whether the live stream's requests to the IMA SDK API will
     * be authenticated using the DAI
     *                 authentication keys. */
    private java.lang.Boolean enableDaiAuthenticationKeys;

    /* The type of content that should be used to fill an empty ad
     * break. This value is optional and
     *                 defaults to {@link AdBreakFillType#SLATE}. */
    private com.google.api.ads.admanager.axis.v202302.AdBreakFillType adBreakFillType;

    /* The type of content that should be used to fill the time remaining
     * in the ad break when there
     *                 are not enough ads to fill the entire break. This
     * value is optional and defaults to {@link
     *                 AdBreakFillType#SLATE}. To set this field a network
     * needs to have the "Live stream ad break
     *                 underfill type" feature enabled. */
    private com.google.api.ads.admanager.axis.v202302.AdBreakFillType underfillAdBreakFillType;

    /* The duration (in seconds), starting from the time the user
     * enters the DAI stream, for which
     *                 mid-roll decisioning will be skipped. This field is
     * only applicable when an ad holiday is
     *                 requested in the stream create request. This value
     * is optional and defaults to 0. */
    private java.lang.Long adHolidayDuration;

    /* Whether there will be max filler duration in this live stream.
     * If true, {@code
     *                 maxFillerDuration} should be specified. This field
     * is optional and defaults to false. */
    private java.lang.Boolean enableMaxFillerDuration;

    /* The maximum number of seconds that can be used to fill this
     * ad pod, either with a slate or
     *                 underlying content, depending on your settings. If
     * more time needs to be filled, the ad pod
     *                 will instead be dropped and the underlying content
     * will be served. */
    private java.lang.Long maxFillerDuration;

    /* Whether there will be durationless ad breaks in this live stream.
     * If true, {@code
     *                 defaultAdBreakDuration} should be specified. This
     * field is optional and defaults to false; */
    private java.lang.Boolean enableDurationlessAdBreaks;

    /* The default ad pod duration (in seconds) that will be requested
     * when an ad break cue-out does
     *                 not specify a duration. This field is optional and
     * defaults to 0; */
    private java.lang.Long defaultAdBreakDuration;

    /* The list of {@link DaiAuthenticationKey} IDs used to authenticate
     * stream create requests for
     *                 this live stream. Modifying keys for an active live
     * stream may break the stream for some users.
     *                 Exercise caution. */
    private long[] streamCreateDaiAuthenticationKeyIds;

    /* The list of {@link CdnConfiguration} IDs that provide settings
     * for ingesting and delivering the
     *                 videos associated with this source. Modifying settings
     * for an active live stream may break the
     *                 stream for some users. Exercise caution. */
    private long[] sourceContentConfigurationIds;

    /* The settings that are specific to HTTPS live streaming (HLS)
     * protocol. This field is optional
     *                 and if it is not set will use the default HLS settings. */
    private com.google.api.ads.admanager.axis.v202302.HlsSettings hlsSettings;

    /* Whether specific allowlisted IP addresses should be used to
     * access this live stream. This field
     *                 is optional and will default to false. To set this
     * field a network needs to have the "Video
     *                 live allowlisted IPS enabled" feature enabled. Modifying
     * this field for an active live stream
     *                 can impact traffic. */
    private java.lang.Boolean enableAllowlistedIps;

    /* The method of dynamic ad insertion that is used to insert ads
     * into this live stream. This
     *                 attribute is optional and defaults to {@link DynamicAdInsertionType.LINEAR}.
     * This field cannot
     *                 be modified after live stream creation. */
    private com.google.api.ads.admanager.axis.v202302.DynamicAdInsertionType dynamicAdInsertionType;

    /* Whether the served playlists can include relative URLs. This
     * field is optional and defaults to
     *                 false. To set this field a network needs to have the
     * "Video live stream relative playlist URLs"
     *                 feature enabled. This field can be modified when the
     * live stream is in a {@link
     *                 LiveStreamEventStatus#PAUSED} state. */
    private java.lang.Boolean enableRelativePlaylistDelivery;

    /* The streaming format of the {@link LiveStreamEvent} media.
     * This field cannot be modified after
     *                 live stream creation. */
    private com.google.api.ads.admanager.axis.v202302.StreamingFormat streamingFormat;

    /* Indicates whether the option to prefetch ad requests is enabled. */
    private java.lang.Boolean prefetchEnabled;

    /* The information needed to prefetch ad requests for an ad break. */
    private com.google.api.ads.admanager.axis.v202302.PrefetchSettings prefetchSettings;

    /* Whether live stream placement opportunities without #EXT-CUE-IN
     * markers should be force closed.
     *                 This field is optional and defaults to false. To set
     * this field a network needs to have the
     *                 "Video live stream forced cue in" feature enabled. */
    private java.lang.Boolean enableForceCloseAdBreaks;

    /* Whether segments shorter than 1 second at the end of an ad
     * pod should be dropped. This field is
     *                 optional and defaults to false. To set this field
     * a network needs to have the "Video live
     *                 stream short segment dropping" feature enabled. */
    private java.lang.Boolean enableShortSegmentDropping;

    /* An additional code that can be used in constructing live stream
     * event URLs. This field is
     *                 immutable after creation and can only be set for pod
     * serving live streams. The custom asset key
     *                 may be at most 64 characters and can contain alphanumeric
     * characters and symbols other than the
     *                 following: ", ', =, !, +, #, *, ~, ;, ^, (, ), <,
     * >, [, ], the white space character. */
    private java.lang.String customAssetKey;

    /* The list of {@code DaiEncodingProfile} IDs that will be used
     * for this live stream event. This
     *                 field only applies to pod serving events. New profile
     * IDs can be added to running live streams.
     *                 Profile IDs cannot be removed from running live streams.
     * Modifying settings for an active live
     *                 stream may break the stream for some users. Exercise
     * caution. */
    private long[] daiEncodingProfileIds;

    /* The list of {@link DaiAuthenticationKey} IDs used to authenticate
     * ad segment url requests for
     *                 this live stream. This field only applies to pod serving
     * events. Modifying settings for an
     *                 active live stream may break the stream for some users.
     * Exercise caution. */
    private long[] segmentUrlAuthenticationKeyIds;

    /* The formats that will be recognized as ad break start/end markers.
     * This field is ignored if
     *                 {@code adBreakMarkupTypesEnabled} is false */
    private com.google.api.ads.admanager.axis.v202302.AdBreakMarkupType[] adBreakMarkups;

    /* Whether this {@link LiveStreamEvent} is specifying a subset
     * of supported {@code
     *                 adBreakMarkups}. If this field is false, all supported
     * formats will be treated as ad break
     *                 start/end markers. */
    private java.lang.Boolean adBreakMarkupTypesEnabled;

    /* Whether ads on this {@link LiveStreamEvent} are served by Google
     * Ad Manager DAI or Google Ad
     *                 Serving. */
    private com.google.api.ads.admanager.axis.v202302.AdServingFormat adServingFormat;

    /* The conditioning to apply to this {@link LiveStreamEvent}. */
    private com.google.api.ads.admanager.axis.v202302.LiveStreamConditioning liveStreamConditioning;

    public LiveStreamEvent() {
    }

    public LiveStreamEvent(
           java.lang.Long id,
           java.lang.String name,
           com.google.api.ads.admanager.axis.v202302.LiveStreamEventStatus status,
           com.google.api.ads.admanager.axis.v202302.DateTime creationDateTime,
           com.google.api.ads.admanager.axis.v202302.DateTime lastModifiedDateTime,
           com.google.api.ads.admanager.axis.v202302.DateTime startDateTime,
           com.google.api.ads.admanager.axis.v202302.StartDateTimeType startDateTimeType,
           com.google.api.ads.admanager.axis.v202302.DateTime endDateTime,
           java.lang.Boolean unlimitedEndDateTime,
           java.lang.Long totalEstimatedConcurrentUsers,
           java.lang.String[] contentUrls,
           java.lang.String[] adTags,
           java.lang.String assetKey,
           java.lang.Long slateCreativeId,
           java.lang.Integer dvrWindowSeconds,
           java.lang.Boolean enableDaiAuthenticationKeys,
           com.google.api.ads.admanager.axis.v202302.AdBreakFillType adBreakFillType,
           com.google.api.ads.admanager.axis.v202302.AdBreakFillType underfillAdBreakFillType,
           java.lang.Long adHolidayDuration,
           java.lang.Boolean enableMaxFillerDuration,
           java.lang.Long maxFillerDuration,
           java.lang.Boolean enableDurationlessAdBreaks,
           java.lang.Long defaultAdBreakDuration,
           long[] streamCreateDaiAuthenticationKeyIds,
           long[] sourceContentConfigurationIds,
           com.google.api.ads.admanager.axis.v202302.HlsSettings hlsSettings,
           java.lang.Boolean enableAllowlistedIps,
           com.google.api.ads.admanager.axis.v202302.DynamicAdInsertionType dynamicAdInsertionType,
           java.lang.Boolean enableRelativePlaylistDelivery,
           com.google.api.ads.admanager.axis.v202302.StreamingFormat streamingFormat,
           java.lang.Boolean prefetchEnabled,
           com.google.api.ads.admanager.axis.v202302.PrefetchSettings prefetchSettings,
           java.lang.Boolean enableForceCloseAdBreaks,
           java.lang.Boolean enableShortSegmentDropping,
           java.lang.String customAssetKey,
           long[] daiEncodingProfileIds,
           long[] segmentUrlAuthenticationKeyIds,
           com.google.api.ads.admanager.axis.v202302.AdBreakMarkupType[] adBreakMarkups,
           java.lang.Boolean adBreakMarkupTypesEnabled,
           com.google.api.ads.admanager.axis.v202302.AdServingFormat adServingFormat,
           com.google.api.ads.admanager.axis.v202302.LiveStreamConditioning liveStreamConditioning) {
           this.id = id;
           this.name = name;
           this.status = status;
           this.creationDateTime = creationDateTime;
           this.lastModifiedDateTime = lastModifiedDateTime;
           this.startDateTime = startDateTime;
           this.startDateTimeType = startDateTimeType;
           this.endDateTime = endDateTime;
           this.unlimitedEndDateTime = unlimitedEndDateTime;
           this.totalEstimatedConcurrentUsers = totalEstimatedConcurrentUsers;
           this.contentUrls = contentUrls;
           this.adTags = adTags;
           this.assetKey = assetKey;
           this.slateCreativeId = slateCreativeId;
           this.dvrWindowSeconds = dvrWindowSeconds;
           this.enableDaiAuthenticationKeys = enableDaiAuthenticationKeys;
           this.adBreakFillType = adBreakFillType;
           this.underfillAdBreakFillType = underfillAdBreakFillType;
           this.adHolidayDuration = adHolidayDuration;
           this.enableMaxFillerDuration = enableMaxFillerDuration;
           this.maxFillerDuration = maxFillerDuration;
           this.enableDurationlessAdBreaks = enableDurationlessAdBreaks;
           this.defaultAdBreakDuration = defaultAdBreakDuration;
           this.streamCreateDaiAuthenticationKeyIds = streamCreateDaiAuthenticationKeyIds;
           this.sourceContentConfigurationIds = sourceContentConfigurationIds;
           this.hlsSettings = hlsSettings;
           this.enableAllowlistedIps = enableAllowlistedIps;
           this.dynamicAdInsertionType = dynamicAdInsertionType;
           this.enableRelativePlaylistDelivery = enableRelativePlaylistDelivery;
           this.streamingFormat = streamingFormat;
           this.prefetchEnabled = prefetchEnabled;
           this.prefetchSettings = prefetchSettings;
           this.enableForceCloseAdBreaks = enableForceCloseAdBreaks;
           this.enableShortSegmentDropping = enableShortSegmentDropping;
           this.customAssetKey = customAssetKey;
           this.daiEncodingProfileIds = daiEncodingProfileIds;
           this.segmentUrlAuthenticationKeyIds = segmentUrlAuthenticationKeyIds;
           this.adBreakMarkups = adBreakMarkups;
           this.adBreakMarkupTypesEnabled = adBreakMarkupTypesEnabled;
           this.adServingFormat = adServingFormat;
           this.liveStreamConditioning = liveStreamConditioning;
    }

    @Override
    public String toString() {
        return com.google.common.base.MoreObjects.toStringHelper(this.getClass())
            .omitNullValues()
            .add("adBreakFillType", getAdBreakFillType())
            .add("adBreakMarkupTypesEnabled", getAdBreakMarkupTypesEnabled())
            .add("adBreakMarkups", getAdBreakMarkups())
            .add("adHolidayDuration", getAdHolidayDuration())
            .add("adServingFormat", getAdServingFormat())
            .add("adTags", getAdTags())
            .add("assetKey", getAssetKey())
            .add("contentUrls", getContentUrls())
            .add("creationDateTime", getCreationDateTime())
            .add("customAssetKey", getCustomAssetKey())
            .add("daiEncodingProfileIds", getDaiEncodingProfileIds())
            .add("defaultAdBreakDuration", getDefaultAdBreakDuration())
            .add("dvrWindowSeconds", getDvrWindowSeconds())
            .add("dynamicAdInsertionType", getDynamicAdInsertionType())
            .add("enableAllowlistedIps", getEnableAllowlistedIps())
            .add("enableDaiAuthenticationKeys", getEnableDaiAuthenticationKeys())
            .add("enableDurationlessAdBreaks", getEnableDurationlessAdBreaks())
            .add("enableForceCloseAdBreaks", getEnableForceCloseAdBreaks())
            .add("enableMaxFillerDuration", getEnableMaxFillerDuration())
            .add("enableRelativePlaylistDelivery", getEnableRelativePlaylistDelivery())
            .add("enableShortSegmentDropping", getEnableShortSegmentDropping())
            .add("endDateTime", getEndDateTime())
            .add("hlsSettings", getHlsSettings())
            .add("id", getId())
            .add("lastModifiedDateTime", getLastModifiedDateTime())
            .add("liveStreamConditioning", getLiveStreamConditioning())
            .add("maxFillerDuration", getMaxFillerDuration())
            .add("name", getName())
            .add("prefetchEnabled", getPrefetchEnabled())
            .add("prefetchSettings", getPrefetchSettings())
            .add("segmentUrlAuthenticationKeyIds", getSegmentUrlAuthenticationKeyIds())
            .add("slateCreativeId", getSlateCreativeId())
            .add("sourceContentConfigurationIds", getSourceContentConfigurationIds())
            .add("startDateTime", getStartDateTime())
            .add("startDateTimeType", getStartDateTimeType())
            .add("status", getStatus())
            .add("streamCreateDaiAuthenticationKeyIds", getStreamCreateDaiAuthenticationKeyIds())
            .add("streamingFormat", getStreamingFormat())
            .add("totalEstimatedConcurrentUsers", getTotalEstimatedConcurrentUsers())
            .add("underfillAdBreakFillType", getUnderfillAdBreakFillType())
            .add("unlimitedEndDateTime", getUnlimitedEndDateTime())
            .toString();
    }

    /**
     * Gets the id value for this LiveStreamEvent.
     * 
     * @return id   * The unique ID of the {@code LiveStreamEvent}. This value is
     * read-only and is assigned by
     *                 Google.
     */
    public java.lang.Long getId() {
        return id;
    }


    /**
     * Sets the id value for this LiveStreamEvent.
     * 
     * @param id   * The unique ID of the {@code LiveStreamEvent}. This value is
     * read-only and is assigned by
     *                 Google.
     */
    public void setId(java.lang.Long id) {
        this.id = id;
    }


    /**
     * Gets the name value for this LiveStreamEvent.
     * 
     * @return name   * The name of the {@code LiveStreamEvent}. This value is required
     * to create a live stream event
     *                 and has a maximum length of 255 characters.
     */
    public java.lang.String getName() {
        return name;
    }


    /**
     * Sets the name value for this LiveStreamEvent.
     * 
     * @param name   * The name of the {@code LiveStreamEvent}. This value is required
     * to create a live stream event
     *                 and has a maximum length of 255 characters.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }


    /**
     * Gets the status value for this LiveStreamEvent.
     * 
     * @return status   * The status of this {@code LiveStreamEvent}. This attribute
     * is read-only and is assigned by
     *                 Google. Live stream events are created in the {@link
     * LiveStreamEventStatus#PAUSED} state.
     */
    public com.google.api.ads.admanager.axis.v202302.LiveStreamEventStatus getStatus() {
        return status;
    }


    /**
     * Sets the status value for this LiveStreamEvent.
     * 
     * @param status   * The status of this {@code LiveStreamEvent}. This attribute
     * is read-only and is assigned by
     *                 Google. Live stream events are created in the {@link
     * LiveStreamEventStatus#PAUSED} state.
     */
    public void setStatus(com.google.api.ads.admanager.axis.v202302.LiveStreamEventStatus status) {
        this.status = status;
    }


    /**
     * Gets the creationDateTime value for this LiveStreamEvent.
     * 
     * @return creationDateTime   * The date and time this {@code LiveStreamEvent} was created.
     * This attribute is read-only.
     */
    public com.google.api.ads.admanager.axis.v202302.DateTime getCreationDateTime() {
        return creationDateTime;
    }


    /**
     * Sets the creationDateTime value for this LiveStreamEvent.
     * 
     * @param creationDateTime   * The date and time this {@code LiveStreamEvent} was created.
     * This attribute is read-only.
     */
    public void setCreationDateTime(com.google.api.ads.admanager.axis.v202302.DateTime creationDateTime) {
        this.creationDateTime = creationDateTime;
    }


    /**
     * Gets the lastModifiedDateTime value for this LiveStreamEvent.
     * 
     * @return lastModifiedDateTime   * The date and time this {@code LiveStreamEvent} was last modified.
     * This attribute is read-only.
     */
    public com.google.api.ads.admanager.axis.v202302.DateTime getLastModifiedDateTime() {
        return lastModifiedDateTime;
    }


    /**
     * Sets the lastModifiedDateTime value for this LiveStreamEvent.
     * 
     * @param lastModifiedDateTime   * The date and time this {@code LiveStreamEvent} was last modified.
     * This attribute is read-only.
     */
    public void setLastModifiedDateTime(com.google.api.ads.admanager.axis.v202302.DateTime lastModifiedDateTime) {
        this.lastModifiedDateTime = lastModifiedDateTime;
    }


    /**
     * Gets the startDateTime value for this LiveStreamEvent.
     * 
     * @return startDateTime   * The start date and time of this {@code LiveStreamEvent}. This
     * attribute is required if the
     *                 {@link LiveStreamEvent#startDateTimeType} is {@link
     * StartDateTimeType#USE_START_DATE_TIME} and
     *                 is ignored for all other values of {@link StartDateTimeType}.
     * Modifying this attribute for an
     *                 active live stream can impact traffic.
     */
    public com.google.api.ads.admanager.axis.v202302.DateTime getStartDateTime() {
        return startDateTime;
    }


    /**
     * Sets the startDateTime value for this LiveStreamEvent.
     * 
     * @param startDateTime   * The start date and time of this {@code LiveStreamEvent}. This
     * attribute is required if the
     *                 {@link LiveStreamEvent#startDateTimeType} is {@link
     * StartDateTimeType#USE_START_DATE_TIME} and
     *                 is ignored for all other values of {@link StartDateTimeType}.
     * Modifying this attribute for an
     *                 active live stream can impact traffic.
     */
    public void setStartDateTime(com.google.api.ads.admanager.axis.v202302.DateTime startDateTime) {
        this.startDateTime = startDateTime;
    }


    /**
     * Gets the startDateTimeType value for this LiveStreamEvent.
     * 
     * @return startDateTimeType   * Specifies whether to start the {@link LiveStreamEvent} right
     * away, in an hour, etc. This
     *                 attribute is optional and defaults to {@link StartDateTimeType#USE_START_DATE_TIME}.
     */
    public com.google.api.ads.admanager.axis.v202302.StartDateTimeType getStartDateTimeType() {
        return startDateTimeType;
    }


    /**
     * Sets the startDateTimeType value for this LiveStreamEvent.
     * 
     * @param startDateTimeType   * Specifies whether to start the {@link LiveStreamEvent} right
     * away, in an hour, etc. This
     *                 attribute is optional and defaults to {@link StartDateTimeType#USE_START_DATE_TIME}.
     */
    public void setStartDateTimeType(com.google.api.ads.admanager.axis.v202302.StartDateTimeType startDateTimeType) {
        this.startDateTimeType = startDateTimeType;
    }


    /**
     * Gets the endDateTime value for this LiveStreamEvent.
     * 
     * @return endDateTime   * The scheduled end date and time of this {@code LiveStreamEvent}.
     * This attribute is required if
     *                 {@code unlimitedEndDateTime} is false and ignored
     * if {@code unlimitedEndDateTime} is true.
     *                 Modifying this attribute for an active live stream
     * can impact traffic.
     */
    public com.google.api.ads.admanager.axis.v202302.DateTime getEndDateTime() {
        return endDateTime;
    }


    /**
     * Sets the endDateTime value for this LiveStreamEvent.
     * 
     * @param endDateTime   * The scheduled end date and time of this {@code LiveStreamEvent}.
     * This attribute is required if
     *                 {@code unlimitedEndDateTime} is false and ignored
     * if {@code unlimitedEndDateTime} is true.
     *                 Modifying this attribute for an active live stream
     * can impact traffic.
     */
    public void setEndDateTime(com.google.api.ads.admanager.axis.v202302.DateTime endDateTime) {
        this.endDateTime = endDateTime;
    }


    /**
     * Gets the unlimitedEndDateTime value for this LiveStreamEvent.
     * 
     * @return unlimitedEndDateTime   * Whether the {@link LiveStreamEvent} has an end time. This attribute
     * is optional and defaults to
     *                 false. If this field is true, {@code endDateTime}
     * is ignored.
     */
    public java.lang.Boolean getUnlimitedEndDateTime() {
        return unlimitedEndDateTime;
    }


    /**
     * Sets the unlimitedEndDateTime value for this LiveStreamEvent.
     * 
     * @param unlimitedEndDateTime   * Whether the {@link LiveStreamEvent} has an end time. This attribute
     * is optional and defaults to
     *                 false. If this field is true, {@code endDateTime}
     * is ignored.
     */
    public void setUnlimitedEndDateTime(java.lang.Boolean unlimitedEndDateTime) {
        this.unlimitedEndDateTime = unlimitedEndDateTime;
    }


    /**
     * Gets the totalEstimatedConcurrentUsers value for this LiveStreamEvent.
     * 
     * @return totalEstimatedConcurrentUsers   * The total number of concurrent users expected to watch this
     * live stream across all regions.
     *                 This attribute is optional and default value is 0.
     */
    public java.lang.Long getTotalEstimatedConcurrentUsers() {
        return totalEstimatedConcurrentUsers;
    }


    /**
     * Sets the totalEstimatedConcurrentUsers value for this LiveStreamEvent.
     * 
     * @param totalEstimatedConcurrentUsers   * The total number of concurrent users expected to watch this
     * live stream across all regions.
     *                 This attribute is optional and default value is 0.
     */
    public void setTotalEstimatedConcurrentUsers(java.lang.Long totalEstimatedConcurrentUsers) {
        this.totalEstimatedConcurrentUsers = totalEstimatedConcurrentUsers;
    }


    /**
     * Gets the contentUrls value for this LiveStreamEvent.
     * 
     * @return contentUrls   * The list of URLs pointing to the live stream content in Content
     * Delivery Network. This
     *                 attribute is required and can be modified when the
     * live stream is in a {@link
     *                 LiveStreamEventStatus#PAUSED} state.
     */
    public java.lang.String[] getContentUrls() {
        return contentUrls;
    }


    /**
     * Sets the contentUrls value for this LiveStreamEvent.
     * 
     * @param contentUrls   * The list of URLs pointing to the live stream content in Content
     * Delivery Network. This
     *                 attribute is required and can be modified when the
     * live stream is in a {@link
     *                 LiveStreamEventStatus#PAUSED} state.
     */
    public void setContentUrls(java.lang.String[] contentUrls) {
        this.contentUrls = contentUrls;
    }

    public java.lang.String getContentUrls(int i) {
        return this.contentUrls[i];
    }

    public void setContentUrls(int i, java.lang.String _value) {
        this.contentUrls[i] = _value;
    }


    /**
     * Gets the adTags value for this LiveStreamEvent.
     * 
     * @return adTags   * The list of Ad Manager ad tag URLs generated by the Ad Manager
     * trafficking workflow that are
     *                 associated with this live stream event. Currently,
     * the list includes only one element: the
     *                 master ad tag. This attribute is required.
     */
    public java.lang.String[] getAdTags() {
        return adTags;
    }


    /**
     * Sets the adTags value for this LiveStreamEvent.
     * 
     * @param adTags   * The list of Ad Manager ad tag URLs generated by the Ad Manager
     * trafficking workflow that are
     *                 associated with this live stream event. Currently,
     * the list includes only one element: the
     *                 master ad tag. This attribute is required.
     */
    public void setAdTags(java.lang.String[] adTags) {
        this.adTags = adTags;
    }

    public java.lang.String getAdTags(int i) {
        return this.adTags[i];
    }

    public void setAdTags(int i, java.lang.String _value) {
        this.adTags[i] = _value;
    }


    /**
     * Gets the assetKey value for this LiveStreamEvent.
     * 
     * @return assetKey   * This code is used in constructing a live stream event master
     * playlist URL. This attribute is
     *                 read-only and is assigned by Google. {@code liveStreamEventCode}
     * was renamed {@code assetKey}
     *                 in v201911.
     */
    public java.lang.String getAssetKey() {
        return assetKey;
    }


    /**
     * Sets the assetKey value for this LiveStreamEvent.
     * 
     * @param assetKey   * This code is used in constructing a live stream event master
     * playlist URL. This attribute is
     *                 read-only and is assigned by Google. {@code liveStreamEventCode}
     * was renamed {@code assetKey}
     *                 in v201911.
     */
    public void setAssetKey(java.lang.String assetKey) {
        this.assetKey = assetKey;
    }


    /**
     * Gets the slateCreativeId value for this LiveStreamEvent.
     * 
     * @return slateCreativeId   * ID corresponding to the slate for this live event. If not set,
     * network default value will be
     *                 used.
     */
    public java.lang.Long getSlateCreativeId() {
        return slateCreativeId;
    }


    /**
     * Sets the slateCreativeId value for this LiveStreamEvent.
     * 
     * @param slateCreativeId   * ID corresponding to the slate for this live event. If not set,
     * network default value will be
     *                 used.
     */
    public void setSlateCreativeId(java.lang.Long slateCreativeId) {
        this.slateCreativeId = slateCreativeId;
    }


    /**
     * Gets the dvrWindowSeconds value for this LiveStreamEvent.
     * 
     * @return dvrWindowSeconds   * Length of the DVR window in seconds. This value is optional.
     * If unset the default window as
     *                 provided by the input encoder will be used. Modifying
     * this value for an active live stream can
     *                 impact traffic.
     */
    public java.lang.Integer getDvrWindowSeconds() {
        return dvrWindowSeconds;
    }


    /**
     * Sets the dvrWindowSeconds value for this LiveStreamEvent.
     * 
     * @param dvrWindowSeconds   * Length of the DVR window in seconds. This value is optional.
     * If unset the default window as
     *                 provided by the input encoder will be used. Modifying
     * this value for an active live stream can
     *                 impact traffic.
     */
    public void setDvrWindowSeconds(java.lang.Integer dvrWindowSeconds) {
        this.dvrWindowSeconds = dvrWindowSeconds;
    }


    /**
     * Gets the enableDaiAuthenticationKeys value for this LiveStreamEvent.
     * 
     * @return enableDaiAuthenticationKeys   * Whether the live stream's requests to the IMA SDK API will
     * be authenticated using the DAI
     *                 authentication keys.
     */
    public java.lang.Boolean getEnableDaiAuthenticationKeys() {
        return enableDaiAuthenticationKeys;
    }


    /**
     * Sets the enableDaiAuthenticationKeys value for this LiveStreamEvent.
     * 
     * @param enableDaiAuthenticationKeys   * Whether the live stream's requests to the IMA SDK API will
     * be authenticated using the DAI
     *                 authentication keys.
     */
    public void setEnableDaiAuthenticationKeys(java.lang.Boolean enableDaiAuthenticationKeys) {
        this.enableDaiAuthenticationKeys = enableDaiAuthenticationKeys;
    }


    /**
     * Gets the adBreakFillType value for this LiveStreamEvent.
     * 
     * @return adBreakFillType   * The type of content that should be used to fill an empty ad
     * break. This value is optional and
     *                 defaults to {@link AdBreakFillType#SLATE}.
     */
    public com.google.api.ads.admanager.axis.v202302.AdBreakFillType getAdBreakFillType() {
        return adBreakFillType;
    }


    /**
     * Sets the adBreakFillType value for this LiveStreamEvent.
     * 
     * @param adBreakFillType   * The type of content that should be used to fill an empty ad
     * break. This value is optional and
     *                 defaults to {@link AdBreakFillType#SLATE}.
     */
    public void setAdBreakFillType(com.google.api.ads.admanager.axis.v202302.AdBreakFillType adBreakFillType) {
        this.adBreakFillType = adBreakFillType;
    }


    /**
     * Gets the underfillAdBreakFillType value for this LiveStreamEvent.
     * 
     * @return underfillAdBreakFillType   * The type of content that should be used to fill the time remaining
     * in the ad break when there
     *                 are not enough ads to fill the entire break. This
     * value is optional and defaults to {@link
     *                 AdBreakFillType#SLATE}. To set this field a network
     * needs to have the "Live stream ad break
     *                 underfill type" feature enabled.
     */
    public com.google.api.ads.admanager.axis.v202302.AdBreakFillType getUnderfillAdBreakFillType() {
        return underfillAdBreakFillType;
    }


    /**
     * Sets the underfillAdBreakFillType value for this LiveStreamEvent.
     * 
     * @param underfillAdBreakFillType   * The type of content that should be used to fill the time remaining
     * in the ad break when there
     *                 are not enough ads to fill the entire break. This
     * value is optional and defaults to {@link
     *                 AdBreakFillType#SLATE}. To set this field a network
     * needs to have the "Live stream ad break
     *                 underfill type" feature enabled.
     */
    public void setUnderfillAdBreakFillType(com.google.api.ads.admanager.axis.v202302.AdBreakFillType underfillAdBreakFillType) {
        this.underfillAdBreakFillType = underfillAdBreakFillType;
    }


    /**
     * Gets the adHolidayDuration value for this LiveStreamEvent.
     * 
     * @return adHolidayDuration   * The duration (in seconds), starting from the time the user
     * enters the DAI stream, for which
     *                 mid-roll decisioning will be skipped. This field is
     * only applicable when an ad holiday is
     *                 requested in the stream create request. This value
     * is optional and defaults to 0.
     */
    public java.lang.Long getAdHolidayDuration() {
        return adHolidayDuration;
    }


    /**
     * Sets the adHolidayDuration value for this LiveStreamEvent.
     * 
     * @param adHolidayDuration   * The duration (in seconds), starting from the time the user
     * enters the DAI stream, for which
     *                 mid-roll decisioning will be skipped. This field is
     * only applicable when an ad holiday is
     *                 requested in the stream create request. This value
     * is optional and defaults to 0.
     */
    public void setAdHolidayDuration(java.lang.Long adHolidayDuration) {
        this.adHolidayDuration = adHolidayDuration;
    }


    /**
     * Gets the enableMaxFillerDuration value for this LiveStreamEvent.
     * 
     * @return enableMaxFillerDuration   * Whether there will be max filler duration in this live stream.
     * If true, {@code
     *                 maxFillerDuration} should be specified. This field
     * is optional and defaults to false.
     */
    public java.lang.Boolean getEnableMaxFillerDuration() {
        return enableMaxFillerDuration;
    }


    /**
     * Sets the enableMaxFillerDuration value for this LiveStreamEvent.
     * 
     * @param enableMaxFillerDuration   * Whether there will be max filler duration in this live stream.
     * If true, {@code
     *                 maxFillerDuration} should be specified. This field
     * is optional and defaults to false.
     */
    public void setEnableMaxFillerDuration(java.lang.Boolean enableMaxFillerDuration) {
        this.enableMaxFillerDuration = enableMaxFillerDuration;
    }


    /**
     * Gets the maxFillerDuration value for this LiveStreamEvent.
     * 
     * @return maxFillerDuration   * The maximum number of seconds that can be used to fill this
     * ad pod, either with a slate or
     *                 underlying content, depending on your settings. If
     * more time needs to be filled, the ad pod
     *                 will instead be dropped and the underlying content
     * will be served.
     */
    public java.lang.Long getMaxFillerDuration() {
        return maxFillerDuration;
    }


    /**
     * Sets the maxFillerDuration value for this LiveStreamEvent.
     * 
     * @param maxFillerDuration   * The maximum number of seconds that can be used to fill this
     * ad pod, either with a slate or
     *                 underlying content, depending on your settings. If
     * more time needs to be filled, the ad pod
     *                 will instead be dropped and the underlying content
     * will be served.
     */
    public void setMaxFillerDuration(java.lang.Long maxFillerDuration) {
        this.maxFillerDuration = maxFillerDuration;
    }


    /**
     * Gets the enableDurationlessAdBreaks value for this LiveStreamEvent.
     * 
     * @return enableDurationlessAdBreaks   * Whether there will be durationless ad breaks in this live stream.
     * If true, {@code
     *                 defaultAdBreakDuration} should be specified. This
     * field is optional and defaults to false;
     */
    public java.lang.Boolean getEnableDurationlessAdBreaks() {
        return enableDurationlessAdBreaks;
    }


    /**
     * Sets the enableDurationlessAdBreaks value for this LiveStreamEvent.
     * 
     * @param enableDurationlessAdBreaks   * Whether there will be durationless ad breaks in this live stream.
     * If true, {@code
     *                 defaultAdBreakDuration} should be specified. This
     * field is optional and defaults to false;
     */
    public void setEnableDurationlessAdBreaks(java.lang.Boolean enableDurationlessAdBreaks) {
        this.enableDurationlessAdBreaks = enableDurationlessAdBreaks;
    }


    /**
     * Gets the defaultAdBreakDuration value for this LiveStreamEvent.
     * 
     * @return defaultAdBreakDuration   * The default ad pod duration (in seconds) that will be requested
     * when an ad break cue-out does
     *                 not specify a duration. This field is optional and
     * defaults to 0;
     */
    public java.lang.Long getDefaultAdBreakDuration() {
        return defaultAdBreakDuration;
    }


    /**
     * Sets the defaultAdBreakDuration value for this LiveStreamEvent.
     * 
     * @param defaultAdBreakDuration   * The default ad pod duration (in seconds) that will be requested
     * when an ad break cue-out does
     *                 not specify a duration. This field is optional and
     * defaults to 0;
     */
    public void setDefaultAdBreakDuration(java.lang.Long defaultAdBreakDuration) {
        this.defaultAdBreakDuration = defaultAdBreakDuration;
    }


    /**
     * Gets the streamCreateDaiAuthenticationKeyIds value for this LiveStreamEvent.
     * 
     * @return streamCreateDaiAuthenticationKeyIds   * The list of {@link DaiAuthenticationKey} IDs used to authenticate
     * stream create requests for
     *                 this live stream. Modifying keys for an active live
     * stream may break the stream for some users.
     *                 Exercise caution.
     */
    public long[] getStreamCreateDaiAuthenticationKeyIds() {
        return streamCreateDaiAuthenticationKeyIds;
    }


    /**
     * Sets the streamCreateDaiAuthenticationKeyIds value for this LiveStreamEvent.
     * 
     * @param streamCreateDaiAuthenticationKeyIds   * The list of {@link DaiAuthenticationKey} IDs used to authenticate
     * stream create requests for
     *                 this live stream. Modifying keys for an active live
     * stream may break the stream for some users.
     *                 Exercise caution.
     */
    public void setStreamCreateDaiAuthenticationKeyIds(long[] streamCreateDaiAuthenticationKeyIds) {
        this.streamCreateDaiAuthenticationKeyIds = streamCreateDaiAuthenticationKeyIds;
    }

    public long getStreamCreateDaiAuthenticationKeyIds(int i) {
        return this.streamCreateDaiAuthenticationKeyIds[i];
    }

    public void setStreamCreateDaiAuthenticationKeyIds(int i, long _value) {
        this.streamCreateDaiAuthenticationKeyIds[i] = _value;
    }


    /**
     * Gets the sourceContentConfigurationIds value for this LiveStreamEvent.
     * 
     * @return sourceContentConfigurationIds   * The list of {@link CdnConfiguration} IDs that provide settings
     * for ingesting and delivering the
     *                 videos associated with this source. Modifying settings
     * for an active live stream may break the
     *                 stream for some users. Exercise caution.
     */
    public long[] getSourceContentConfigurationIds() {
        return sourceContentConfigurationIds;
    }


    /**
     * Sets the sourceContentConfigurationIds value for this LiveStreamEvent.
     * 
     * @param sourceContentConfigurationIds   * The list of {@link CdnConfiguration} IDs that provide settings
     * for ingesting and delivering the
     *                 videos associated with this source. Modifying settings
     * for an active live stream may break the
     *                 stream for some users. Exercise caution.
     */
    public void setSourceContentConfigurationIds(long[] sourceContentConfigurationIds) {
        this.sourceContentConfigurationIds = sourceContentConfigurationIds;
    }

    public long getSourceContentConfigurationIds(int i) {
        return this.sourceContentConfigurationIds[i];
    }

    public void setSourceContentConfigurationIds(int i, long _value) {
        this.sourceContentConfigurationIds[i] = _value;
    }


    /**
     * Gets the hlsSettings value for this LiveStreamEvent.
     * 
     * @return hlsSettings   * The settings that are specific to HTTPS live streaming (HLS)
     * protocol. This field is optional
     *                 and if it is not set will use the default HLS settings.
     */
    public com.google.api.ads.admanager.axis.v202302.HlsSettings getHlsSettings() {
        return hlsSettings;
    }


    /**
     * Sets the hlsSettings value for this LiveStreamEvent.
     * 
     * @param hlsSettings   * The settings that are specific to HTTPS live streaming (HLS)
     * protocol. This field is optional
     *                 and if it is not set will use the default HLS settings.
     */
    public void setHlsSettings(com.google.api.ads.admanager.axis.v202302.HlsSettings hlsSettings) {
        this.hlsSettings = hlsSettings;
    }


    /**
     * Gets the enableAllowlistedIps value for this LiveStreamEvent.
     * 
     * @return enableAllowlistedIps   * Whether specific allowlisted IP addresses should be used to
     * access this live stream. This field
     *                 is optional and will default to false. To set this
     * field a network needs to have the "Video
     *                 live allowlisted IPS enabled" feature enabled. Modifying
     * this field for an active live stream
     *                 can impact traffic.
     */
    public java.lang.Boolean getEnableAllowlistedIps() {
        return enableAllowlistedIps;
    }


    /**
     * Sets the enableAllowlistedIps value for this LiveStreamEvent.
     * 
     * @param enableAllowlistedIps   * Whether specific allowlisted IP addresses should be used to
     * access this live stream. This field
     *                 is optional and will default to false. To set this
     * field a network needs to have the "Video
     *                 live allowlisted IPS enabled" feature enabled. Modifying
     * this field for an active live stream
     *                 can impact traffic.
     */
    public void setEnableAllowlistedIps(java.lang.Boolean enableAllowlistedIps) {
        this.enableAllowlistedIps = enableAllowlistedIps;
    }


    /**
     * Gets the dynamicAdInsertionType value for this LiveStreamEvent.
     * 
     * @return dynamicAdInsertionType   * The method of dynamic ad insertion that is used to insert ads
     * into this live stream. This
     *                 attribute is optional and defaults to {@link DynamicAdInsertionType.LINEAR}.
     * This field cannot
     *                 be modified after live stream creation.
     */
    public com.google.api.ads.admanager.axis.v202302.DynamicAdInsertionType getDynamicAdInsertionType() {
        return dynamicAdInsertionType;
    }


    /**
     * Sets the dynamicAdInsertionType value for this LiveStreamEvent.
     * 
     * @param dynamicAdInsertionType   * The method of dynamic ad insertion that is used to insert ads
     * into this live stream. This
     *                 attribute is optional and defaults to {@link DynamicAdInsertionType.LINEAR}.
     * This field cannot
     *                 be modified after live stream creation.
     */
    public void setDynamicAdInsertionType(com.google.api.ads.admanager.axis.v202302.DynamicAdInsertionType dynamicAdInsertionType) {
        this.dynamicAdInsertionType = dynamicAdInsertionType;
    }


    /**
     * Gets the enableRelativePlaylistDelivery value for this LiveStreamEvent.
     * 
     * @return enableRelativePlaylistDelivery   * Whether the served playlists can include relative URLs. This
     * field is optional and defaults to
     *                 false. To set this field a network needs to have the
     * "Video live stream relative playlist URLs"
     *                 feature enabled. This field can be modified when the
     * live stream is in a {@link
     *                 LiveStreamEventStatus#PAUSED} state.
     */
    public java.lang.Boolean getEnableRelativePlaylistDelivery() {
        return enableRelativePlaylistDelivery;
    }


    /**
     * Sets the enableRelativePlaylistDelivery value for this LiveStreamEvent.
     * 
     * @param enableRelativePlaylistDelivery   * Whether the served playlists can include relative URLs. This
     * field is optional and defaults to
     *                 false. To set this field a network needs to have the
     * "Video live stream relative playlist URLs"
     *                 feature enabled. This field can be modified when the
     * live stream is in a {@link
     *                 LiveStreamEventStatus#PAUSED} state.
     */
    public void setEnableRelativePlaylistDelivery(java.lang.Boolean enableRelativePlaylistDelivery) {
        this.enableRelativePlaylistDelivery = enableRelativePlaylistDelivery;
    }


    /**
     * Gets the streamingFormat value for this LiveStreamEvent.
     * 
     * @return streamingFormat   * The streaming format of the {@link LiveStreamEvent} media.
     * This field cannot be modified after
     *                 live stream creation.
     */
    public com.google.api.ads.admanager.axis.v202302.StreamingFormat getStreamingFormat() {
        return streamingFormat;
    }


    /**
     * Sets the streamingFormat value for this LiveStreamEvent.
     * 
     * @param streamingFormat   * The streaming format of the {@link LiveStreamEvent} media.
     * This field cannot be modified after
     *                 live stream creation.
     */
    public void setStreamingFormat(com.google.api.ads.admanager.axis.v202302.StreamingFormat streamingFormat) {
        this.streamingFormat = streamingFormat;
    }


    /**
     * Gets the prefetchEnabled value for this LiveStreamEvent.
     * 
     * @return prefetchEnabled   * Indicates whether the option to prefetch ad requests is enabled.
     */
    public java.lang.Boolean getPrefetchEnabled() {
        return prefetchEnabled;
    }


    /**
     * Sets the prefetchEnabled value for this LiveStreamEvent.
     * 
     * @param prefetchEnabled   * Indicates whether the option to prefetch ad requests is enabled.
     */
    public void setPrefetchEnabled(java.lang.Boolean prefetchEnabled) {
        this.prefetchEnabled = prefetchEnabled;
    }


    /**
     * Gets the prefetchSettings value for this LiveStreamEvent.
     * 
     * @return prefetchSettings   * The information needed to prefetch ad requests for an ad break.
     */
    public com.google.api.ads.admanager.axis.v202302.PrefetchSettings getPrefetchSettings() {
        return prefetchSettings;
    }


    /**
     * Sets the prefetchSettings value for this LiveStreamEvent.
     * 
     * @param prefetchSettings   * The information needed to prefetch ad requests for an ad break.
     */
    public void setPrefetchSettings(com.google.api.ads.admanager.axis.v202302.PrefetchSettings prefetchSettings) {
        this.prefetchSettings = prefetchSettings;
    }


    /**
     * Gets the enableForceCloseAdBreaks value for this LiveStreamEvent.
     * 
     * @return enableForceCloseAdBreaks   * Whether live stream placement opportunities without #EXT-CUE-IN
     * markers should be force closed.
     *                 This field is optional and defaults to false. To set
     * this field a network needs to have the
     *                 "Video live stream forced cue in" feature enabled.
     */
    public java.lang.Boolean getEnableForceCloseAdBreaks() {
        return enableForceCloseAdBreaks;
    }


    /**
     * Sets the enableForceCloseAdBreaks value for this LiveStreamEvent.
     * 
     * @param enableForceCloseAdBreaks   * Whether live stream placement opportunities without #EXT-CUE-IN
     * markers should be force closed.
     *                 This field is optional and defaults to false. To set
     * this field a network needs to have the
     *                 "Video live stream forced cue in" feature enabled.
     */
    public void setEnableForceCloseAdBreaks(java.lang.Boolean enableForceCloseAdBreaks) {
        this.enableForceCloseAdBreaks = enableForceCloseAdBreaks;
    }


    /**
     * Gets the enableShortSegmentDropping value for this LiveStreamEvent.
     * 
     * @return enableShortSegmentDropping   * Whether segments shorter than 1 second at the end of an ad
     * pod should be dropped. This field is
     *                 optional and defaults to false. To set this field
     * a network needs to have the "Video live
     *                 stream short segment dropping" feature enabled.
     */
    public java.lang.Boolean getEnableShortSegmentDropping() {
        return enableShortSegmentDropping;
    }


    /**
     * Sets the enableShortSegmentDropping value for this LiveStreamEvent.
     * 
     * @param enableShortSegmentDropping   * Whether segments shorter than 1 second at the end of an ad
     * pod should be dropped. This field is
     *                 optional and defaults to false. To set this field
     * a network needs to have the "Video live
     *                 stream short segment dropping" feature enabled.
     */
    public void setEnableShortSegmentDropping(java.lang.Boolean enableShortSegmentDropping) {
        this.enableShortSegmentDropping = enableShortSegmentDropping;
    }


    /**
     * Gets the customAssetKey value for this LiveStreamEvent.
     * 
     * @return customAssetKey   * An additional code that can be used in constructing live stream
     * event URLs. This field is
     *                 immutable after creation and can only be set for pod
     * serving live streams. The custom asset key
     *                 may be at most 64 characters and can contain alphanumeric
     * characters and symbols other than the
     *                 following: ", ', =, !, +, #, *, ~, ;, ^, (, ), <,
     * >, [, ], the white space character.
     */
    public java.lang.String getCustomAssetKey() {
        return customAssetKey;
    }


    /**
     * Sets the customAssetKey value for this LiveStreamEvent.
     * 
     * @param customAssetKey   * An additional code that can be used in constructing live stream
     * event URLs. This field is
     *                 immutable after creation and can only be set for pod
     * serving live streams. The custom asset key
     *                 may be at most 64 characters and can contain alphanumeric
     * characters and symbols other than the
     *                 following: ", ', =, !, +, #, *, ~, ;, ^, (, ), <,
     * >, [, ], the white space character.
     */
    public void setCustomAssetKey(java.lang.String customAssetKey) {
        this.customAssetKey = customAssetKey;
    }


    /**
     * Gets the daiEncodingProfileIds value for this LiveStreamEvent.
     * 
     * @return daiEncodingProfileIds   * The list of {@code DaiEncodingProfile} IDs that will be used
     * for this live stream event. This
     *                 field only applies to pod serving events. New profile
     * IDs can be added to running live streams.
     *                 Profile IDs cannot be removed from running live streams.
     * Modifying settings for an active live
     *                 stream may break the stream for some users. Exercise
     * caution.
     */
    public long[] getDaiEncodingProfileIds() {
        return daiEncodingProfileIds;
    }


    /**
     * Sets the daiEncodingProfileIds value for this LiveStreamEvent.
     * 
     * @param daiEncodingProfileIds   * The list of {@code DaiEncodingProfile} IDs that will be used
     * for this live stream event. This
     *                 field only applies to pod serving events. New profile
     * IDs can be added to running live streams.
     *                 Profile IDs cannot be removed from running live streams.
     * Modifying settings for an active live
     *                 stream may break the stream for some users. Exercise
     * caution.
     */
    public void setDaiEncodingProfileIds(long[] daiEncodingProfileIds) {
        this.daiEncodingProfileIds = daiEncodingProfileIds;
    }

    public long getDaiEncodingProfileIds(int i) {
        return this.daiEncodingProfileIds[i];
    }

    public void setDaiEncodingProfileIds(int i, long _value) {
        this.daiEncodingProfileIds[i] = _value;
    }


    /**
     * Gets the segmentUrlAuthenticationKeyIds value for this LiveStreamEvent.
     * 
     * @return segmentUrlAuthenticationKeyIds   * The list of {@link DaiAuthenticationKey} IDs used to authenticate
     * ad segment url requests for
     *                 this live stream. This field only applies to pod serving
     * events. Modifying settings for an
     *                 active live stream may break the stream for some users.
     * Exercise caution.
     */
    public long[] getSegmentUrlAuthenticationKeyIds() {
        return segmentUrlAuthenticationKeyIds;
    }


    /**
     * Sets the segmentUrlAuthenticationKeyIds value for this LiveStreamEvent.
     * 
     * @param segmentUrlAuthenticationKeyIds   * The list of {@link DaiAuthenticationKey} IDs used to authenticate
     * ad segment url requests for
     *                 this live stream. This field only applies to pod serving
     * events. Modifying settings for an
     *                 active live stream may break the stream for some users.
     * Exercise caution.
     */
    public void setSegmentUrlAuthenticationKeyIds(long[] segmentUrlAuthenticationKeyIds) {
        this.segmentUrlAuthenticationKeyIds = segmentUrlAuthenticationKeyIds;
    }

    public long getSegmentUrlAuthenticationKeyIds(int i) {
        return this.segmentUrlAuthenticationKeyIds[i];
    }

    public void setSegmentUrlAuthenticationKeyIds(int i, long _value) {
        this.segmentUrlAuthenticationKeyIds[i] = _value;
    }


    /**
     * Gets the adBreakMarkups value for this LiveStreamEvent.
     * 
     * @return adBreakMarkups   * The formats that will be recognized as ad break start/end markers.
     * This field is ignored if
     *                 {@code adBreakMarkupTypesEnabled} is false
     */
    public com.google.api.ads.admanager.axis.v202302.AdBreakMarkupType[] getAdBreakMarkups() {
        return adBreakMarkups;
    }


    /**
     * Sets the adBreakMarkups value for this LiveStreamEvent.
     * 
     * @param adBreakMarkups   * The formats that will be recognized as ad break start/end markers.
     * This field is ignored if
     *                 {@code adBreakMarkupTypesEnabled} is false
     */
    public void setAdBreakMarkups(com.google.api.ads.admanager.axis.v202302.AdBreakMarkupType[] adBreakMarkups) {
        this.adBreakMarkups = adBreakMarkups;
    }

    public com.google.api.ads.admanager.axis.v202302.AdBreakMarkupType getAdBreakMarkups(int i) {
        return this.adBreakMarkups[i];
    }

    public void setAdBreakMarkups(int i, com.google.api.ads.admanager.axis.v202302.AdBreakMarkupType _value) {
        this.adBreakMarkups[i] = _value;
    }


    /**
     * Gets the adBreakMarkupTypesEnabled value for this LiveStreamEvent.
     * 
     * @return adBreakMarkupTypesEnabled   * Whether this {@link LiveStreamEvent} is specifying a subset
     * of supported {@code
     *                 adBreakMarkups}. If this field is false, all supported
     * formats will be treated as ad break
     *                 start/end markers.
     */
    public java.lang.Boolean getAdBreakMarkupTypesEnabled() {
        return adBreakMarkupTypesEnabled;
    }


    /**
     * Sets the adBreakMarkupTypesEnabled value for this LiveStreamEvent.
     * 
     * @param adBreakMarkupTypesEnabled   * Whether this {@link LiveStreamEvent} is specifying a subset
     * of supported {@code
     *                 adBreakMarkups}. If this field is false, all supported
     * formats will be treated as ad break
     *                 start/end markers.
     */
    public void setAdBreakMarkupTypesEnabled(java.lang.Boolean adBreakMarkupTypesEnabled) {
        this.adBreakMarkupTypesEnabled = adBreakMarkupTypesEnabled;
    }


    /**
     * Gets the adServingFormat value for this LiveStreamEvent.
     * 
     * @return adServingFormat   * Whether ads on this {@link LiveStreamEvent} are served by Google
     * Ad Manager DAI or Google Ad
     *                 Serving.
     */
    public com.google.api.ads.admanager.axis.v202302.AdServingFormat getAdServingFormat() {
        return adServingFormat;
    }


    /**
     * Sets the adServingFormat value for this LiveStreamEvent.
     * 
     * @param adServingFormat   * Whether ads on this {@link LiveStreamEvent} are served by Google
     * Ad Manager DAI or Google Ad
     *                 Serving.
     */
    public void setAdServingFormat(com.google.api.ads.admanager.axis.v202302.AdServingFormat adServingFormat) {
        this.adServingFormat = adServingFormat;
    }


    /**
     * Gets the liveStreamConditioning value for this LiveStreamEvent.
     * 
     * @return liveStreamConditioning   * The conditioning to apply to this {@link LiveStreamEvent}.
     */
    public com.google.api.ads.admanager.axis.v202302.LiveStreamConditioning getLiveStreamConditioning() {
        return liveStreamConditioning;
    }


    /**
     * Sets the liveStreamConditioning value for this LiveStreamEvent.
     * 
     * @param liveStreamConditioning   * The conditioning to apply to this {@link LiveStreamEvent}.
     */
    public void setLiveStreamConditioning(com.google.api.ads.admanager.axis.v202302.LiveStreamConditioning liveStreamConditioning) {
        this.liveStreamConditioning = liveStreamConditioning;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(java.lang.Object obj) {
        if (!(obj instanceof LiveStreamEvent)) return false;
        LiveStreamEvent other = (LiveStreamEvent) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.id==null && other.getId()==null) || 
             (this.id!=null &&
              this.id.equals(other.getId()))) &&
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            ((this.status==null && other.getStatus()==null) || 
             (this.status!=null &&
              this.status.equals(other.getStatus()))) &&
            ((this.creationDateTime==null && other.getCreationDateTime()==null) || 
             (this.creationDateTime!=null &&
              this.creationDateTime.equals(other.getCreationDateTime()))) &&
            ((this.lastModifiedDateTime==null && other.getLastModifiedDateTime()==null) || 
             (this.lastModifiedDateTime!=null &&
              this.lastModifiedDateTime.equals(other.getLastModifiedDateTime()))) &&
            ((this.startDateTime==null && other.getStartDateTime()==null) || 
             (this.startDateTime!=null &&
              this.startDateTime.equals(other.getStartDateTime()))) &&
            ((this.startDateTimeType==null && other.getStartDateTimeType()==null) || 
             (this.startDateTimeType!=null &&
              this.startDateTimeType.equals(other.getStartDateTimeType()))) &&
            ((this.endDateTime==null && other.getEndDateTime()==null) || 
             (this.endDateTime!=null &&
              this.endDateTime.equals(other.getEndDateTime()))) &&
            ((this.unlimitedEndDateTime==null && other.getUnlimitedEndDateTime()==null) || 
             (this.unlimitedEndDateTime!=null &&
              this.unlimitedEndDateTime.equals(other.getUnlimitedEndDateTime()))) &&
            ((this.totalEstimatedConcurrentUsers==null && other.getTotalEstimatedConcurrentUsers()==null) || 
             (this.totalEstimatedConcurrentUsers!=null &&
              this.totalEstimatedConcurrentUsers.equals(other.getTotalEstimatedConcurrentUsers()))) &&
            ((this.contentUrls==null && other.getContentUrls()==null) || 
             (this.contentUrls!=null &&
              java.util.Arrays.equals(this.contentUrls, other.getContentUrls()))) &&
            ((this.adTags==null && other.getAdTags()==null) || 
             (this.adTags!=null &&
              java.util.Arrays.equals(this.adTags, other.getAdTags()))) &&
            ((this.assetKey==null && other.getAssetKey()==null) || 
             (this.assetKey!=null &&
              this.assetKey.equals(other.getAssetKey()))) &&
            ((this.slateCreativeId==null && other.getSlateCreativeId()==null) || 
             (this.slateCreativeId!=null &&
              this.slateCreativeId.equals(other.getSlateCreativeId()))) &&
            ((this.dvrWindowSeconds==null && other.getDvrWindowSeconds()==null) || 
             (this.dvrWindowSeconds!=null &&
              this.dvrWindowSeconds.equals(other.getDvrWindowSeconds()))) &&
            ((this.enableDaiAuthenticationKeys==null && other.getEnableDaiAuthenticationKeys()==null) || 
             (this.enableDaiAuthenticationKeys!=null &&
              this.enableDaiAuthenticationKeys.equals(other.getEnableDaiAuthenticationKeys()))) &&
            ((this.adBreakFillType==null && other.getAdBreakFillType()==null) || 
             (this.adBreakFillType!=null &&
              this.adBreakFillType.equals(other.getAdBreakFillType()))) &&
            ((this.underfillAdBreakFillType==null && other.getUnderfillAdBreakFillType()==null) || 
             (this.underfillAdBreakFillType!=null &&
              this.underfillAdBreakFillType.equals(other.getUnderfillAdBreakFillType()))) &&
            ((this.adHolidayDuration==null && other.getAdHolidayDuration()==null) || 
             (this.adHolidayDuration!=null &&
              this.adHolidayDuration.equals(other.getAdHolidayDuration()))) &&
            ((this.enableMaxFillerDuration==null && other.getEnableMaxFillerDuration()==null) || 
             (this.enableMaxFillerDuration!=null &&
              this.enableMaxFillerDuration.equals(other.getEnableMaxFillerDuration()))) &&
            ((this.maxFillerDuration==null && other.getMaxFillerDuration()==null) || 
             (this.maxFillerDuration!=null &&
              this.maxFillerDuration.equals(other.getMaxFillerDuration()))) &&
            ((this.enableDurationlessAdBreaks==null && other.getEnableDurationlessAdBreaks()==null) || 
             (this.enableDurationlessAdBreaks!=null &&
              this.enableDurationlessAdBreaks.equals(other.getEnableDurationlessAdBreaks()))) &&
            ((this.defaultAdBreakDuration==null && other.getDefaultAdBreakDuration()==null) || 
             (this.defaultAdBreakDuration!=null &&
              this.defaultAdBreakDuration.equals(other.getDefaultAdBreakDuration()))) &&
            ((this.streamCreateDaiAuthenticationKeyIds==null && other.getStreamCreateDaiAuthenticationKeyIds()==null) || 
             (this.streamCreateDaiAuthenticationKeyIds!=null &&
              java.util.Arrays.equals(this.streamCreateDaiAuthenticationKeyIds, other.getStreamCreateDaiAuthenticationKeyIds()))) &&
            ((this.sourceContentConfigurationIds==null && other.getSourceContentConfigurationIds()==null) || 
             (this.sourceContentConfigurationIds!=null &&
              java.util.Arrays.equals(this.sourceContentConfigurationIds, other.getSourceContentConfigurationIds()))) &&
            ((this.hlsSettings==null && other.getHlsSettings()==null) || 
             (this.hlsSettings!=null &&
              this.hlsSettings.equals(other.getHlsSettings()))) &&
            ((this.enableAllowlistedIps==null && other.getEnableAllowlistedIps()==null) || 
             (this.enableAllowlistedIps!=null &&
              this.enableAllowlistedIps.equals(other.getEnableAllowlistedIps()))) &&
            ((this.dynamicAdInsertionType==null && other.getDynamicAdInsertionType()==null) || 
             (this.dynamicAdInsertionType!=null &&
              this.dynamicAdInsertionType.equals(other.getDynamicAdInsertionType()))) &&
            ((this.enableRelativePlaylistDelivery==null && other.getEnableRelativePlaylistDelivery()==null) || 
             (this.enableRelativePlaylistDelivery!=null &&
              this.enableRelativePlaylistDelivery.equals(other.getEnableRelativePlaylistDelivery()))) &&
            ((this.streamingFormat==null && other.getStreamingFormat()==null) || 
             (this.streamingFormat!=null &&
              this.streamingFormat.equals(other.getStreamingFormat()))) &&
            ((this.prefetchEnabled==null && other.getPrefetchEnabled()==null) || 
             (this.prefetchEnabled!=null &&
              this.prefetchEnabled.equals(other.getPrefetchEnabled()))) &&
            ((this.prefetchSettings==null && other.getPrefetchSettings()==null) || 
             (this.prefetchSettings!=null &&
              this.prefetchSettings.equals(other.getPrefetchSettings()))) &&
            ((this.enableForceCloseAdBreaks==null && other.getEnableForceCloseAdBreaks()==null) || 
             (this.enableForceCloseAdBreaks!=null &&
              this.enableForceCloseAdBreaks.equals(other.getEnableForceCloseAdBreaks()))) &&
            ((this.enableShortSegmentDropping==null && other.getEnableShortSegmentDropping()==null) || 
             (this.enableShortSegmentDropping!=null &&
              this.enableShortSegmentDropping.equals(other.getEnableShortSegmentDropping()))) &&
            ((this.customAssetKey==null && other.getCustomAssetKey()==null) || 
             (this.customAssetKey!=null &&
              this.customAssetKey.equals(other.getCustomAssetKey()))) &&
            ((this.daiEncodingProfileIds==null && other.getDaiEncodingProfileIds()==null) || 
             (this.daiEncodingProfileIds!=null &&
              java.util.Arrays.equals(this.daiEncodingProfileIds, other.getDaiEncodingProfileIds()))) &&
            ((this.segmentUrlAuthenticationKeyIds==null && other.getSegmentUrlAuthenticationKeyIds()==null) || 
             (this.segmentUrlAuthenticationKeyIds!=null &&
              java.util.Arrays.equals(this.segmentUrlAuthenticationKeyIds, other.getSegmentUrlAuthenticationKeyIds()))) &&
            ((this.adBreakMarkups==null && other.getAdBreakMarkups()==null) || 
             (this.adBreakMarkups!=null &&
              java.util.Arrays.equals(this.adBreakMarkups, other.getAdBreakMarkups()))) &&
            ((this.adBreakMarkupTypesEnabled==null && other.getAdBreakMarkupTypesEnabled()==null) || 
             (this.adBreakMarkupTypesEnabled!=null &&
              this.adBreakMarkupTypesEnabled.equals(other.getAdBreakMarkupTypesEnabled()))) &&
            ((this.adServingFormat==null && other.getAdServingFormat()==null) || 
             (this.adServingFormat!=null &&
              this.adServingFormat.equals(other.getAdServingFormat()))) &&
            ((this.liveStreamConditioning==null && other.getLiveStreamConditioning()==null) || 
             (this.liveStreamConditioning!=null &&
              this.liveStreamConditioning.equals(other.getLiveStreamConditioning())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getId() != null) {
            _hashCode += getId().hashCode();
        }
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        if (getStatus() != null) {
            _hashCode += getStatus().hashCode();
        }
        if (getCreationDateTime() != null) {
            _hashCode += getCreationDateTime().hashCode();
        }
        if (getLastModifiedDateTime() != null) {
            _hashCode += getLastModifiedDateTime().hashCode();
        }
        if (getStartDateTime() != null) {
            _hashCode += getStartDateTime().hashCode();
        }
        if (getStartDateTimeType() != null) {
            _hashCode += getStartDateTimeType().hashCode();
        }
        if (getEndDateTime() != null) {
            _hashCode += getEndDateTime().hashCode();
        }
        if (getUnlimitedEndDateTime() != null) {
            _hashCode += getUnlimitedEndDateTime().hashCode();
        }
        if (getTotalEstimatedConcurrentUsers() != null) {
            _hashCode += getTotalEstimatedConcurrentUsers().hashCode();
        }
        if (getContentUrls() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getContentUrls());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getContentUrls(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAdTags() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAdTags());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getAdTags(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAssetKey() != null) {
            _hashCode += getAssetKey().hashCode();
        }
        if (getSlateCreativeId() != null) {
            _hashCode += getSlateCreativeId().hashCode();
        }
        if (getDvrWindowSeconds() != null) {
            _hashCode += getDvrWindowSeconds().hashCode();
        }
        if (getEnableDaiAuthenticationKeys() != null) {
            _hashCode += getEnableDaiAuthenticationKeys().hashCode();
        }
        if (getAdBreakFillType() != null) {
            _hashCode += getAdBreakFillType().hashCode();
        }
        if (getUnderfillAdBreakFillType() != null) {
            _hashCode += getUnderfillAdBreakFillType().hashCode();
        }
        if (getAdHolidayDuration() != null) {
            _hashCode += getAdHolidayDuration().hashCode();
        }
        if (getEnableMaxFillerDuration() != null) {
            _hashCode += getEnableMaxFillerDuration().hashCode();
        }
        if (getMaxFillerDuration() != null) {
            _hashCode += getMaxFillerDuration().hashCode();
        }
        if (getEnableDurationlessAdBreaks() != null) {
            _hashCode += getEnableDurationlessAdBreaks().hashCode();
        }
        if (getDefaultAdBreakDuration() != null) {
            _hashCode += getDefaultAdBreakDuration().hashCode();
        }
        if (getStreamCreateDaiAuthenticationKeyIds() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getStreamCreateDaiAuthenticationKeyIds());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getStreamCreateDaiAuthenticationKeyIds(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSourceContentConfigurationIds() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSourceContentConfigurationIds());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getSourceContentConfigurationIds(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getHlsSettings() != null) {
            _hashCode += getHlsSettings().hashCode();
        }
        if (getEnableAllowlistedIps() != null) {
            _hashCode += getEnableAllowlistedIps().hashCode();
        }
        if (getDynamicAdInsertionType() != null) {
            _hashCode += getDynamicAdInsertionType().hashCode();
        }
        if (getEnableRelativePlaylistDelivery() != null) {
            _hashCode += getEnableRelativePlaylistDelivery().hashCode();
        }
        if (getStreamingFormat() != null) {
            _hashCode += getStreamingFormat().hashCode();
        }
        if (getPrefetchEnabled() != null) {
            _hashCode += getPrefetchEnabled().hashCode();
        }
        if (getPrefetchSettings() != null) {
            _hashCode += getPrefetchSettings().hashCode();
        }
        if (getEnableForceCloseAdBreaks() != null) {
            _hashCode += getEnableForceCloseAdBreaks().hashCode();
        }
        if (getEnableShortSegmentDropping() != null) {
            _hashCode += getEnableShortSegmentDropping().hashCode();
        }
        if (getCustomAssetKey() != null) {
            _hashCode += getCustomAssetKey().hashCode();
        }
        if (getDaiEncodingProfileIds() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getDaiEncodingProfileIds());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getDaiEncodingProfileIds(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getSegmentUrlAuthenticationKeyIds() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getSegmentUrlAuthenticationKeyIds());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getSegmentUrlAuthenticationKeyIds(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAdBreakMarkups() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getAdBreakMarkups());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getAdBreakMarkups(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        if (getAdBreakMarkupTypesEnabled() != null) {
            _hashCode += getAdBreakMarkupTypesEnabled().hashCode();
        }
        if (getAdServingFormat() != null) {
            _hashCode += getAdServingFormat().hashCode();
        }
        if (getLiveStreamConditioning() != null) {
            _hashCode += getLiveStreamConditioning().hashCode();
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(LiveStreamEvent.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "LiveStreamEvent"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("id");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "id"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("status");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "status"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "LiveStreamEventStatus"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("creationDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "creationDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("lastModifiedDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "lastModifiedDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("startDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "startDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("startDateTimeType");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "startDateTimeType"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "StartDateTimeType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("endDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "endDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "DateTime"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("unlimitedEndDateTime");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "unlimitedEndDateTime"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("totalEstimatedConcurrentUsers");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "totalEstimatedConcurrentUsers"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("contentUrls");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "contentUrls"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adTags");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "adTags"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("assetKey");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "assetKey"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("slateCreativeId");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "slateCreativeId"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("dvrWindowSeconds");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "dvrWindowSeconds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "int"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enableDaiAuthenticationKeys");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "enableDaiAuthenticationKeys"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adBreakFillType");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "adBreakFillType"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "AdBreakFillType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("underfillAdBreakFillType");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "underfillAdBreakFillType"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "AdBreakFillType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adHolidayDuration");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "adHolidayDuration"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enableMaxFillerDuration");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "enableMaxFillerDuration"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("maxFillerDuration");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "maxFillerDuration"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enableDurationlessAdBreaks");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "enableDurationlessAdBreaks"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("defaultAdBreakDuration");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "defaultAdBreakDuration"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("streamCreateDaiAuthenticationKeyIds");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "streamCreateDaiAuthenticationKeyIds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("sourceContentConfigurationIds");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "sourceContentConfigurationIds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("hlsSettings");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "hlsSettings"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "HlsSettings"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enableAllowlistedIps");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "enableAllowlistedIps"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("dynamicAdInsertionType");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "dynamicAdInsertionType"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "DynamicAdInsertionType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enableRelativePlaylistDelivery");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "enableRelativePlaylistDelivery"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("streamingFormat");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "streamingFormat"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "StreamingFormat"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("prefetchEnabled");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "prefetchEnabled"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("prefetchSettings");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "prefetchSettings"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "PrefetchSettings"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enableForceCloseAdBreaks");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "enableForceCloseAdBreaks"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("enableShortSegmentDropping");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "enableShortSegmentDropping"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("customAssetKey");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "customAssetKey"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("daiEncodingProfileIds");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "daiEncodingProfileIds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("segmentUrlAuthenticationKeyIds");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "segmentUrlAuthenticationKeyIds"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adBreakMarkups");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "adBreakMarkups"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "AdBreakMarkupType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adBreakMarkupTypesEnabled");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "adBreakMarkupTypesEnabled"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adServingFormat");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "adServingFormat"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "AdServingFormat"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("liveStreamConditioning");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "liveStreamConditioning"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202302", "LiveStreamConditioning"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
