// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

/**
 * Label.java
 *
 * This file was auto-generated from WSDL
 * by the Apache Axis 1.4 Mar 02, 2009 (07:08:06 PST) WSDL2Java emitter.
 */

package com.google.api.ads.admanager.axis.v202305;


/**
 * A {@code Label} is additional information that can be added to
 * an entity.
 */
public class Label  implements java.io.Serializable {
    /* Unique ID of the {@code Label}. This value is readonly and
     * is assigned by Google. */
    private java.lang.Long id;

    /* Name of the {@code Label}. This is value is required to create
     * a label and has a maximum length
     *                 of 127 characters. */
    private java.lang.String name;

    /* A description of the label. This value is optional and its
     * maximum length is 255 characters. */
    private java.lang.String description;

    /* Specifies whether or not the label is active. This attribute
     * is read-only. */
    private java.lang.Boolean isActive;

    /* Indicates the Ad Category associated with the label. */
    private com.google.api.ads.admanager.axis.v202305.AdCategoryDto adCategory;

    /* The types of the {@code Label}. */
    private com.google.api.ads.admanager.axis.v202305.LabelType[] types;

    public Label() {
    }

    public Label(
           java.lang.Long id,
           java.lang.String name,
           java.lang.String description,
           java.lang.Boolean isActive,
           com.google.api.ads.admanager.axis.v202305.AdCategoryDto adCategory,
           com.google.api.ads.admanager.axis.v202305.LabelType[] types) {
           this.id = id;
           this.name = name;
           this.description = description;
           this.isActive = isActive;
           this.adCategory = adCategory;
           this.types = types;
    }

    @Override
    public String toString() {
        return com.google.common.base.MoreObjects.toStringHelper(this.getClass())
            .omitNullValues()
            .add("adCategory", getAdCategory())
            .add("description", getDescription())
            .add("id", getId())
            .add("isActive", getIsActive())
            .add("name", getName())
            .add("types", getTypes())
            .toString();
    }

    /**
     * Gets the id value for this Label.
     * 
     * @return id   * Unique ID of the {@code Label}. This value is readonly and
     * is assigned by Google.
     */
    public java.lang.Long getId() {
        return id;
    }


    /**
     * Sets the id value for this Label.
     * 
     * @param id   * Unique ID of the {@code Label}. This value is readonly and
     * is assigned by Google.
     */
    public void setId(java.lang.Long id) {
        this.id = id;
    }


    /**
     * Gets the name value for this Label.
     * 
     * @return name   * Name of the {@code Label}. This is value is required to create
     * a label and has a maximum length
     *                 of 127 characters.
     */
    public java.lang.String getName() {
        return name;
    }


    /**
     * Sets the name value for this Label.
     * 
     * @param name   * Name of the {@code Label}. This is value is required to create
     * a label and has a maximum length
     *                 of 127 characters.
     */
    public void setName(java.lang.String name) {
        this.name = name;
    }


    /**
     * Gets the description value for this Label.
     * 
     * @return description   * A description of the label. This value is optional and its
     * maximum length is 255 characters.
     */
    public java.lang.String getDescription() {
        return description;
    }


    /**
     * Sets the description value for this Label.
     * 
     * @param description   * A description of the label. This value is optional and its
     * maximum length is 255 characters.
     */
    public void setDescription(java.lang.String description) {
        this.description = description;
    }


    /**
     * Gets the isActive value for this Label.
     * 
     * @return isActive   * Specifies whether or not the label is active. This attribute
     * is read-only.
     */
    public java.lang.Boolean getIsActive() {
        return isActive;
    }


    /**
     * Sets the isActive value for this Label.
     * 
     * @param isActive   * Specifies whether or not the label is active. This attribute
     * is read-only.
     */
    public void setIsActive(java.lang.Boolean isActive) {
        this.isActive = isActive;
    }


    /**
     * Gets the adCategory value for this Label.
     * 
     * @return adCategory   * Indicates the Ad Category associated with the label.
     */
    public com.google.api.ads.admanager.axis.v202305.AdCategoryDto getAdCategory() {
        return adCategory;
    }


    /**
     * Sets the adCategory value for this Label.
     * 
     * @param adCategory   * Indicates the Ad Category associated with the label.
     */
    public void setAdCategory(com.google.api.ads.admanager.axis.v202305.AdCategoryDto adCategory) {
        this.adCategory = adCategory;
    }


    /**
     * Gets the types value for this Label.
     * 
     * @return types   * The types of the {@code Label}.
     */
    public com.google.api.ads.admanager.axis.v202305.LabelType[] getTypes() {
        return types;
    }


    /**
     * Sets the types value for this Label.
     * 
     * @param types   * The types of the {@code Label}.
     */
    public void setTypes(com.google.api.ads.admanager.axis.v202305.LabelType[] types) {
        this.types = types;
    }

    public com.google.api.ads.admanager.axis.v202305.LabelType getTypes(int i) {
        return this.types[i];
    }

    public void setTypes(int i, com.google.api.ads.admanager.axis.v202305.LabelType _value) {
        this.types[i] = _value;
    }

    private java.lang.Object __equalsCalc = null;
    public synchronized boolean equals(java.lang.Object obj) {
        if (!(obj instanceof Label)) return false;
        Label other = (Label) obj;
        if (obj == null) return false;
        if (this == obj) return true;
        if (__equalsCalc != null) {
            return (__equalsCalc == obj);
        }
        __equalsCalc = obj;
        boolean _equals;
        _equals = true && 
            ((this.id==null && other.getId()==null) || 
             (this.id!=null &&
              this.id.equals(other.getId()))) &&
            ((this.name==null && other.getName()==null) || 
             (this.name!=null &&
              this.name.equals(other.getName()))) &&
            ((this.description==null && other.getDescription()==null) || 
             (this.description!=null &&
              this.description.equals(other.getDescription()))) &&
            ((this.isActive==null && other.getIsActive()==null) || 
             (this.isActive!=null &&
              this.isActive.equals(other.getIsActive()))) &&
            ((this.adCategory==null && other.getAdCategory()==null) || 
             (this.adCategory!=null &&
              this.adCategory.equals(other.getAdCategory()))) &&
            ((this.types==null && other.getTypes()==null) || 
             (this.types!=null &&
              java.util.Arrays.equals(this.types, other.getTypes())));
        __equalsCalc = null;
        return _equals;
    }

    private boolean __hashCodeCalc = false;
    public synchronized int hashCode() {
        if (__hashCodeCalc) {
            return 0;
        }
        __hashCodeCalc = true;
        int _hashCode = 1;
        if (getId() != null) {
            _hashCode += getId().hashCode();
        }
        if (getName() != null) {
            _hashCode += getName().hashCode();
        }
        if (getDescription() != null) {
            _hashCode += getDescription().hashCode();
        }
        if (getIsActive() != null) {
            _hashCode += getIsActive().hashCode();
        }
        if (getAdCategory() != null) {
            _hashCode += getAdCategory().hashCode();
        }
        if (getTypes() != null) {
            for (int i=0;
                 i<java.lang.reflect.Array.getLength(getTypes());
                 i++) {
                java.lang.Object obj = java.lang.reflect.Array.get(getTypes(), i);
                if (obj != null &&
                    !obj.getClass().isArray()) {
                    _hashCode += obj.hashCode();
                }
            }
        }
        __hashCodeCalc = false;
        return _hashCode;
    }

    // Type metadata
    private static org.apache.axis.description.TypeDesc typeDesc =
        new org.apache.axis.description.TypeDesc(Label.class, true);

    static {
        typeDesc.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202305", "Label"));
        org.apache.axis.description.ElementDesc elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("id");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202305", "id"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "long"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("name");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202305", "name"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("description");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202305", "description"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "string"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("isActive");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202305", "isActive"));
        elemField.setXmlType(new javax.xml.namespace.QName("http://www.w3.org/2001/XMLSchema", "boolean"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("adCategory");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202305", "adCategory"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202305", "AdCategoryDto"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        typeDesc.addFieldDesc(elemField);
        elemField = new org.apache.axis.description.ElementDesc();
        elemField.setFieldName("types");
        elemField.setXmlName(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202305", "types"));
        elemField.setXmlType(new javax.xml.namespace.QName("https://www.google.com/apis/ads/publisher/v202305", "LabelType"));
        elemField.setMinOccurs(0);
        elemField.setNillable(false);
        elemField.setMaxOccursUnbounded(true);
        typeDesc.addFieldDesc(elemField);
    }

    /**
     * Return type metadata object
     */
    public static org.apache.axis.description.TypeDesc getTypeDesc() {
        return typeDesc;
    }

    /**
     * Get Custom Serializer
     */
    public static org.apache.axis.encoding.Serializer getSerializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanSerializer(
            _javaType, _xmlType, typeDesc);
    }

    /**
     * Get Custom Deserializer
     */
    public static org.apache.axis.encoding.Deserializer getDeserializer(
           java.lang.String mechType, 
           java.lang.Class _javaType,  
           javax.xml.namespace.QName _xmlType) {
        return 
          new  org.apache.axis.encoding.ser.BeanDeserializer(
            _javaType, _xmlType, typeDesc);
    }

}
