/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.annotations.impl.generators.catalog;

import com.google.ads.googleads.annotations.impl.generators.Generator;
import com.google.ads.googleads.annotations.impl.generators.Utils;
import com.google.api.gax.core.FixedCredentialsProvider;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.auth.Credentials;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.CodeBlock;
import com.squareup.javapoet.FieldSpec;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Element;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.Modifier;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.Elements;

public class GeneratedCatalogCodeGenerator
implements Generator {
    private static final ClassName VERSION_CLASS_NAME = ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)"Version", (String[])new String[0]);
    private static final ClassName IMMUTABLE_SET_CLASS_NAME = ClassName.get(ImmutableSet.class);
    private final Set<Integer> versions;
    private final int latestVersion;
    private final String catalogName;
    private final Elements elementUtils;
    private final Messager messager;
    private final Filer filer;

    public GeneratedCatalogCodeGenerator(Set<Integer> versions, int latestVersion, String catalogName, Elements elementUtils, Messager messager, Filer filer) {
        this.versions = versions;
        this.latestVersion = latestVersion;
        this.catalogName = catalogName;
        this.elementUtils = elementUtils;
        this.messager = messager;
        this.filer = filer;
    }

    @Override
    public void generate() {
        String generatedCatalogSimpleName = "GeneratedCatalog";
        if (!this.catalogName.isEmpty()) {
            generatedCatalogSimpleName = generatedCatalogSimpleName + "_" + this.catalogName;
        }
        ClassName generatedCatalogClassName = ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)generatedCatalogSimpleName, (String[])new String[0]);
        FieldSpec instance = FieldSpec.builder((TypeName)generatedCatalogClassName, (String)"instance", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).build();
        CodeBlock instanceInitializer = CodeBlock.builder().beginControlFlow("try", new Object[0]).addStatement("instance = new $T($T.getCatalog())", new Object[]{generatedCatalogClassName, ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)"VersionCatalog", (String[])new String[0])}).nextControlFlow("catch ($T e)", new Object[]{IllegalAccessException.class}).addStatement("throw new RuntimeException(e)", new Object[0]).nextControlFlow("catch ($T e)", new Object[]{InstantiationException.class}).addStatement("throw new RuntimeException(e)", new Object[0]).endControlFlow().build();
        FieldSpec supportedVersions = FieldSpec.builder((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(ImmutableSortedSet.class), (TypeName[])new TypeName[]{VERSION_CLASS_NAME}), (String)"supportedVersions", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter((TypeName)ParameterizedTypeName.get((ClassName)IMMUTABLE_SET_CLASS_NAME, (TypeName[])new TypeName[]{VERSION_CLASS_NAME}), "versions", new Modifier[0]).addStatement("supportedVersions = $T.copyOf(versions)", new Object[]{ImmutableSortedSet.class}).addJavadoc("Creates a new constant catalog from a known collection of versions.", new Object[0]).build();
        MethodSpec getDefault = MethodSpec.methodBuilder((String)"getDefault").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.STATIC}).returns((TypeName)generatedCatalogClassName).addStatement("return instance", new Object[0]).build();
        MethodSpec getSupportedVersions = MethodSpec.methodBuilder((String)"getSupportedVersions").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ParameterizedTypeName.get((ClassName)ClassName.get(SortedSet.class), (TypeName[])new TypeName[]{VERSION_CLASS_NAME})).addStatement("return supportedVersions", new Object[0]).build();
        MethodSpec getLatestVersion = MethodSpec.methodBuilder((String)"getLatestVersion").addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)VERSION_CLASS_NAME).addStatement("return getSupportedVersions().first()", new Object[0]).build();
        MethodSpec createAllVersionsClient = GeneratedCatalogCodeGenerator.createAllVersionsClient(this.versions, this.latestVersion, this.catalogName);
        TypeSpec.Builder generatedCatalogBuilder = TypeSpec.classBuilder((String)generatedCatalogSimpleName).addAnnotation(Utils.generatedAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addField(instance).addStaticBlock(instanceInitializer).addField(supportedVersions).addMethod(constructor).addMethod(getDefault).addMethod(getSupportedVersions).addMethod(getLatestVersion).addMethod(createAllVersionsClient);
        if (generatedCatalogSimpleName.equals("GeneratedCatalog")) {
            generatedCatalogBuilder.addSuperinterface((TypeName)ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)"ApiCatalog", (String[])new String[0]));
        }
        for (Integer version : this.versions) {
            generatedCatalogBuilder.addType(GeneratedCatalogCodeGenerator.createClient(version, this.elementUtils));
        }
        Utils.writeGeneratedClassToFile("com.google.ads.googleads.lib.catalog", generatedCatalogBuilder.build(), this.messager, this.filer);
    }

    private static TypeSpec createClient(int version, Elements elementUtils) {
        FieldSpec provider = FieldSpec.builder(TransportChannelProvider.class, (String)"provider", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        FieldSpec credentials = FieldSpec.builder(Credentials.class, (String)"credentials", (Modifier[])new Modifier[0]).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.FINAL}).build();
        MethodSpec constructor = MethodSpec.constructorBuilder().addModifiers(new Modifier[]{Modifier.PUBLIC}).addParameter(TransportChannelProvider.class, "provider", new Modifier[0]).addParameter(Credentials.class, "credentials", new Modifier[0]).addStatement("this.provider = provider", new Object[0]).addStatement("this.credentials = credentials", new Object[0]).build();
        TypeSpec.Builder clientBuilder = TypeSpec.classBuilder((String)("V" + version + "Client")).addModifiers(new Modifier[]{Modifier.PRIVATE, Modifier.STATIC}).addSuperinterface((TypeName)Utils.createServiceClientClassName(version, "GoogleAdsVersion")).addField(provider).addField(credentials).addMethod(constructor);
        ClassName versionClassName = Utils.createServiceClientClassName(version, "GoogleAdsVersion");
        TypeElement googleAdsVersionType = elementUtils.getTypeElement(versionClassName.reflectionName());
        for (Element element : googleAdsVersionType.getEnclosedElements()) {
            if (element.getKind() != ElementKind.METHOD) continue;
            ExecutableElement executableElement = (ExecutableElement)element;
            Name methodName = executableElement.getSimpleName();
            String serviceClient = methodName.toString().substring("create".length());
            clientBuilder.addMethod(GeneratedCatalogCodeGenerator.createServiceClient(version, serviceClient));
        }
        return clientBuilder.build();
    }

    private static MethodSpec createServiceClient(int version, String serviceClient) {
        MethodSpec.Builder serviceBuilder = MethodSpec.methodBuilder((String)("create" + serviceClient)).addModifiers(new Modifier[]{Modifier.PUBLIC}).addAnnotation(Override.class).returns((TypeName)Utils.createServiceClientClassName(version, serviceClient));
        String noClientName = serviceClient.substring(0, serviceClient.length() - "client".length());
        serviceBuilder.addCode("try {\n  $T settings =\n    $T.newBuilder()\n      .setCredentialsProvider($T.create(credentials))\n      .setTransportChannelProvider(provider)\n      .build();\n  return $T.create(settings);\n} catch ($T e) {\n  throw new RuntimeException(e);\n}\n", new Object[]{Utils.createServiceClientClassName(version, noClientName + "Settings"), Utils.createServiceClientClassName(version, noClientName + "Settings"), FixedCredentialsProvider.class, Utils.createServiceClientClassName(version, serviceClient), IOException.class});
        return serviceBuilder.build();
    }

    private static MethodSpec createAllVersionsClient(Set<Integer> versions, int latestVersion, String catalogName) {
        String googleAdsAllVersionsSimpleName = "GoogleAdsAllVersions";
        if (!catalogName.isEmpty()) {
            googleAdsAllVersionsSimpleName = googleAdsAllVersionsSimpleName + "_" + catalogName;
        }
        ClassName googleAdsAllVersionsClassName = ClassName.get((String)"com.google.ads.googleads.lib", (String)googleAdsAllVersionsSimpleName, (String[])new String[0]);
        TypeSpec.Builder allVersionsClientBuilder = TypeSpec.anonymousClassBuilder((String)"", (Object[])new Object[0]).addSuperinterface((TypeName)googleAdsAllVersionsClassName);
        for (Integer version : versions) {
            allVersionsClientBuilder.addMethod(GeneratedCatalogCodeGenerator.getVersion(version));
        }
        allVersionsClientBuilder.addMethod(MethodSpec.methodBuilder((String)"getLatestVersion").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)("com.google.ads.googleads.v" + latestVersion + ".services"), (String)"GoogleAdsVersion", (String[])new String[0])).addStatement("return getVersion$L()", new Object[]{latestVersion}).build());
        TypeSpec allVersionsClient = allVersionsClientBuilder.build();
        return MethodSpec.methodBuilder((String)"createAllVersionsClient").addModifiers(new Modifier[]{Modifier.PUBLIC}).addStatement("return $L", new Object[]{allVersionsClient}).returns((TypeName)googleAdsAllVersionsClassName).addParameter(TransportChannelProvider.class, "provider", new Modifier[0]).addParameter(Credentials.class, "credentials", new Modifier[0]).build();
    }

    private static MethodSpec getVersion(int version) {
        return MethodSpec.methodBuilder((String)("getVersion" + version)).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)Utils.createServiceClientClassName(version, "GoogleAdsVersion")).addStatement("return new V" + version + "Client(provider, credentials)", new Object[0]).build();
    }
}

