/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.annotations.impl.generators.catalog;

import com.google.ads.googleads.annotations.impl.generators.Generator;
import com.google.ads.googleads.annotations.impl.generators.Utils;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;

public class GoogleAdsAllVersionsCodeGenerator
implements Generator {
    private final Set<Integer> versions;
    private final int latestVersion;
    private final String catalogName;
    private final Messager messager;
    private final Filer filer;

    public GoogleAdsAllVersionsCodeGenerator(Set<Integer> versions, int latestVersion, String catalogName, Messager messager, Filer filer) {
        this.versions = versions;
        this.latestVersion = latestVersion;
        this.catalogName = catalogName;
        this.messager = messager;
        this.filer = filer;
    }

    @Override
    public void generate() {
        String googleAdsAllVersionsSimpleName = "GoogleAdsAllVersions";
        if (!this.catalogName.isEmpty()) {
            googleAdsAllVersionsSimpleName = googleAdsAllVersionsSimpleName + "_" + this.catalogName;
        }
        TypeSpec.Builder googleAdsAllVersionsGeneratedCodeBuilder = TypeSpec.interfaceBuilder((String)googleAdsAllVersionsSimpleName).addAnnotation(Utils.generatedAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Integer version : this.versions) {
            MethodSpec getVersionMethod = MethodSpec.methodBuilder((String)("getVersion" + version)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)Utils.createServiceClientClassName(version, "GoogleAdsVersion")).build();
            googleAdsAllVersionsGeneratedCodeBuilder.addMethod(getVersionMethod);
        }
        MethodSpec getLatestVersionMethod = MethodSpec.methodBuilder((String)"getLatestVersion").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)Utils.createServiceClientClassName(this.latestVersion, "GoogleAdsVersion")).build();
        googleAdsAllVersionsGeneratedCodeBuilder.addMethod(getLatestVersionMethod);
        TypeSpec googleAdsAllVersionsGeneratedCode = googleAdsAllVersionsGeneratedCodeBuilder.build();
        Utils.writeGeneratedClassToFile("com.google.ads.googleads.lib", googleAdsAllVersionsGeneratedCode, this.messager, this.filer);
    }
}

