/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.annotations.impl.generators.catalog;

import com.google.ads.googleads.annotations.impl.generators.Generator;
import com.google.ads.googleads.annotations.impl.generators.Utils;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;

public class VersionCatalogCodeGenerator
implements Generator {
    private static final ClassName VERSION_CLASS_NAME = ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)"Version", (String[])new String[0]);
    private static final ClassName IMMUTABLE_SET_CLASS_NAME = ClassName.get(ImmutableSet.class);
    private final Set<Integer> versions;
    private final String catalogName;
    private final Messager messager;
    private final Filer filer;

    public VersionCatalogCodeGenerator(Set<Integer> versions, String catalogName, Messager messager, Filer filer) {
        this.versions = versions;
        this.catalogName = catalogName;
        this.messager = messager;
        this.filer = filer;
    }

    @Override
    public void generate() {
        String versionCatalogSimpleName = "VersionCatalog";
        if (!this.catalogName.isEmpty()) {
            versionCatalogSimpleName = versionCatalogSimpleName + "_" + this.catalogName;
        }
        MethodSpec.Builder getCatalogBuilder = MethodSpec.methodBuilder((String)"getCatalog").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.STATIC}).addException(IllegalAccessException.class).addException(InstantiationException.class).returns((TypeName)ParameterizedTypeName.get((ClassName)IMMUTABLE_SET_CLASS_NAME, (TypeName[])new TypeName[]{VERSION_CLASS_NAME})).addStatement("$T.Builder<$T> builder = $T.builder()", new Object[]{IMMUTABLE_SET_CLASS_NAME, VERSION_CLASS_NAME, IMMUTABLE_SET_CLASS_NAME});
        for (Integer version : this.versions) {
            ClassName exceptionFactoryName = ClassName.get((String)("com.google.ads.googleads.v" + version + ".errors"), (String)"GoogleAdsException", (String[])new String[]{"Factory"});
            ClassName versionClassName = ClassName.get((String)("com.google.ads.googleads.v" + version + ".services"), (String)"GoogleAdsVersion", (String[])new String[0]);
            ClassName messageProxyProviderClassName = ClassName.get((String)"com.google.ads.googleads.lib.utils.messageproxy", (String)"DefaultMessageProxyProvider", (String[])new String[0]);
            ClassName searchStreamResponseProxyName = ClassName.get((String)("com.google.ads.googleads.lib.utils.messageproxy.generated.v" + version), (String)"SearchGoogleAdsStreamResponseMessageProxy", (String[])new String[0]);
            ClassName searchPagedResponseProxyName = ClassName.get((String)("com.google.ads.googleads.lib.utils.messageproxy.generated.v" + version), (String)"SearchGoogleAdsResponseMessageProxy", (String[])new String[0]);
            ClassName customerUserAccessProxyName = ClassName.get((String)("com.google.ads.googleads.lib.utils.messageproxy.generated.v" + version), (String)"CustomerUserAccessMessageProxy", (String[])new String[0]);
            ClassName feedMessageProxyName = ClassName.get((String)("com.google.ads.googleads.lib.utils.messageproxy.generated.v" + version), (String)"FeedMessageProxy", (String[])new String[0]);
            ClassName createCustomerClientRequestProxyName = ClassName.get((String)("com.google.ads.googleads.lib.utils.messageproxy.generated.v" + version), (String)"CreateCustomerClientRequestMessageProxy", (String[])new String[0]);
            getCatalogBuilder.addStatement("builder.add(new Version(\n  $S,\n  new $T(),\n  $T.class))", new Object[]{"v" + version, exceptionFactoryName, versionClassName});
        }
        getCatalogBuilder.addStatement("return builder.build()", new Object[0]);
        MethodSpec getCatalog = getCatalogBuilder.build();
        TypeSpec versionCatalogGeneratedCode = TypeSpec.classBuilder((String)versionCatalogSimpleName).addAnnotation(Utils.generatedAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(getCatalog).build();
        Utils.writeGeneratedClassToFile("com.google.ads.googleads.lib.catalog", versionCatalogGeneratedCode, this.messager, this.filer);
    }
}

