/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.annotations.impl;

import com.google.ads.googleads.annotations.api.VersionDescriptor;
import com.google.ads.googleads.annotations.impl.generators.Generator;
import com.google.ads.googleads.annotations.impl.generators.catalog.AbstractGoogleAdsClientCodeGenerator;
import com.google.ads.googleads.annotations.impl.generators.catalog.GeneratedCatalogCodeGenerator;
import com.google.ads.googleads.annotations.impl.generators.catalog.GoogleAdsAllVersionsCodeGenerator;
import com.google.ads.googleads.annotations.impl.generators.catalog.VersionCatalogCodeGenerator;
import com.google.auto.service.AutoService;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.SortedSetMultimap;
import com.google.common.collect.TreeMultimap;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.annotation.processing.ProcessingEnvironment;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationMirror;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.ExecutableElement;
import javax.lang.model.element.TypeElement;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.util.Elements;

@AutoService(value=Processor.class)
public class GoogleAdsCatalogAnnotationProcessor
extends AbstractProcessor {
    private Elements elementUtils;
    private Filer filer;
    private Messager messager;
    private boolean hasWrittenFiles;

    @Override
    public synchronized void init(ProcessingEnvironment processingEnv) {
        super.init(processingEnv);
        this.elementUtils = processingEnv.getElementUtils();
        this.filer = processingEnv.getFiler();
        this.messager = processingEnv.getMessager();
    }

    @Override
    public Set<String> getSupportedAnnotationTypes() {
        return Collections.singleton(VersionDescriptor.class.getCanonicalName());
    }

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latestSupported();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        try {
            return this.doProcess(roundEnv);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    private boolean doProcess(RoundEnvironment roundEnv) {
        SortedSetMultimap<String, Integer> catalogVersionsMap;
        if (!this.hasWrittenFiles && !(catalogVersionsMap = GoogleAdsCatalogAnnotationProcessor.generateVersionsFromAnnotations(roundEnv)).isEmpty()) {
            for (String catalogName : catalogVersionsMap.keySet()) {
                SortedSet versions = catalogVersionsMap.get((Object)catalogName);
                int latestVersion = GoogleAdsCatalogAnnotationProcessor.getLatestVersion(versions);
                if (versions.isEmpty()) continue;
                for (Generator generator : this.loadGenerators(catalogName, versions, latestVersion)) {
                    generator.generate();
                }
            }
            this.hasWrittenFiles = true;
        }
        return false;
    }

    private Collection<Generator> loadGenerators(String catalogName, Set<Integer> versions, int latestVersion) {
        return ImmutableList.of((Object)new GeneratedCatalogCodeGenerator(versions, latestVersion, catalogName, this.elementUtils, this.messager, this.filer), (Object)new VersionCatalogCodeGenerator(versions, catalogName, this.messager, this.filer), (Object)new AbstractGoogleAdsClientCodeGenerator(versions, latestVersion, catalogName, this.messager, this.filer), (Object)new GoogleAdsAllVersionsCodeGenerator(versions, latestVersion, catalogName, this.messager, this.filer));
    }

    private static SortedSetMultimap<String, Integer> generateVersionsFromAnnotations(RoundEnvironment roundEnv) {
        TreeMultimap versionsMap = TreeMultimap.create();
        for (Element element : roundEnv.getElementsAnnotatedWith(VersionDescriptor.class)) {
            String validExceptionFactoryType;
            TypeElement typeElement = (TypeElement)element;
            if (!GoogleAdsCatalogAnnotationProcessor.isValidExceptionFactory(typeElement, validExceptionFactoryType = "BaseGoogleAdsException.Factory")) {
                throw new IllegalArgumentException(String.format("googleAdsExceptionFactory parameters in VersionDescriptor either be of class type %s or directly extend %s.", validExceptionFactoryType, validExceptionFactoryType));
            }
            VersionDescriptor annotation = typeElement.getAnnotation(VersionDescriptor.class);
            if (annotation.versionName().charAt(0) == 'v') {
                int version = Integer.parseInt(annotation.versionName().substring(1));
                versionsMap.put((Object)annotation.catalogName(), (Object)version);
                continue;
            }
            throw new IllegalArgumentException("versionName parameters in VersionDescriptor annotations must be in the format 'vX' where X is an integer.");
        }
        return versionsMap;
    }

    private static boolean isValidExceptionFactory(TypeElement typeElement, String validExceptionFactoryType) {
        TypeElement exceptionFactoryElement = GoogleAdsCatalogAnnotationProcessor.getExceptionFactoryElement(typeElement);
        if (GoogleAdsCatalogAnnotationProcessor.isClassNameValid(exceptionFactoryElement.getQualifiedName().toString(), validExceptionFactoryType)) {
            return true;
        }
        String superClass = exceptionFactoryElement.getSuperclass().toString();
        return GoogleAdsCatalogAnnotationProcessor.isClassNameValid(superClass, validExceptionFactoryType);
    }

    private static TypeElement getExceptionFactoryElement(TypeElement typeElement) {
        for (AnnotationMirror annotationMirror : typeElement.getAnnotationMirrors()) {
            for (Map.Entry<? extends ExecutableElement, ? extends AnnotationValue> entry : annotationMirror.getElementValues().entrySet()) {
                if (!entry.getKey().getSimpleName().toString().equals("googleAdsExceptionFactory")) continue;
                DeclaredType exceptionFactoryMirror = (DeclaredType)entry.getValue().getValue();
                return (TypeElement)exceptionFactoryMirror.asElement();
            }
        }
        return null;
    }

    private static boolean isClassNameValid(String className, String validExceptionFactoryType) {
        int end = className.indexOf("<");
        if (end != -1) {
            className = className.substring(0, end);
        }
        return className.endsWith(validExceptionFactoryType);
    }

    private static int getLatestVersion(Set<Integer> versions) {
        int latestVersion = 0;
        for (int version : versions) {
            if (version == 999) continue;
            latestVersion = Math.max(latestVersion, version);
        }
        return latestVersion;
    }
}

