/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.annotations.impl.generators;

import com.squareup.javapoet.AnnotationSpec;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.TypeSpec;
import java.io.IOException;
import javax.annotation.Generated;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;

public class Utils {
    public static AnnotationSpec generatedAnnotation() {
        return AnnotationSpec.builder(Generated.class).addMember("value", "$S", new Object[]{"GoogleAdsCatalogAnnotationProcessor"}).build();
    }

    public static ClassName createServiceClientClassName(int version, String serviceClient) {
        return ClassName.get((String)new StringBuilder(46).append("com.google.ads.googleads.v").append(version).append(".services").toString(), (String)serviceClient, (String[])new String[0]);
    }

    public static void writeGeneratedClassToFile(String packageName, TypeSpec typeSpec, Messager messager, Filer filer) {
        String LICENSE = "Copyright 2020 Google LLC\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.";
        try {
            JavaFile.builder((String)packageName, (TypeSpec)typeSpec).addFileComment("Copyright 2020 Google LLC\n\nLicensed under the Apache License, Version 2.0 (the \"License\");\nyou may not use this file except in compliance with the License.\nYou may obtain a copy of the License at\n\n    http://www.apache.org/licenses/LICENSE-2.0\n\nUnless required by applicable law or agreed to in writing, software\ndistributed under the License is distributed on an \"AS IS\" BASIS,\nWITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.\nSee the License for the specific language governing permissions and\nlimitations under the License.", new Object[0]).skipJavaLangImports(true).build().writeTo(filer);
            String string = typeSpec.name;
            messager.printMessage(Diagnostic.Kind.NOTE, new StringBuilder(30 + String.valueOf(packageName).length() + String.valueOf(string).length()).append("Successfully generated class ").append(packageName).append(".").append(string).toString());
        }
        catch (IOException ioe) {
            String string = String.valueOf(ioe);
            messager.printMessage(Diagnostic.Kind.ERROR, new StringBuilder(23 + String.valueOf(string).length()).append("Failed to create file: ").append(string).toString());
            string = String.valueOf(typeSpec);
            throw new RuntimeException(new StringBuilder(43 + String.valueOf(packageName).length() + String.valueOf(string).length()).append("There was an error writing the class file ").append(packageName).append(".").append(string).toString(), ioe);
        }
    }
}

