/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.annotations.impl.generators.catalog;

import com.google.ads.googleads.annotations.impl.generators.Generator;
import com.google.ads.googleads.annotations.impl.generators.Utils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;

public class AbstractGoogleAdsClientCodeGenerator
implements Generator {
    private final Set<Integer> versions;
    private final int latestVersion;
    private final String catalogName;
    private final Messager messager;
    private final Filer filer;

    public AbstractGoogleAdsClientCodeGenerator(Set<Integer> versions, int latestVersion, String catalogName, Messager messager, Filer filer) {
        this.versions = versions;
        this.latestVersion = latestVersion;
        this.catalogName = catalogName;
        this.messager = messager;
        this.filer = filer;
    }

    @Override
    public void generate() {
        String abstractGacSimpleName = "AbstractGoogleAdsClient";
        String googleAdsAllVersionsSimpleName = "GoogleAdsAllVersions";
        if (!this.catalogName.isEmpty()) {
            String string = String.valueOf(abstractGacSimpleName);
            String string2 = this.catalogName;
            abstractGacSimpleName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("_").append(string2).toString();
            string = String.valueOf(googleAdsAllVersionsSimpleName);
            string2 = this.catalogName;
            googleAdsAllVersionsSimpleName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("_").append(string2).toString();
        }
        ClassName googleAdsAllVersionsClassName = ClassName.get((String)"com.google.ads.googleads.lib", (String)googleAdsAllVersionsSimpleName, (String[])new String[0]);
        MethodSpec getGoogleAdsAllVersions = MethodSpec.methodBuilder((String)"getGoogleAdsAllVersions").addJavadoc("Returns the accessor for service client factories, using configuration from this class.", new Object[0]).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.ABSTRACT}).returns((TypeName)googleAdsAllVersionsClassName).build();
        int n = this.latestVersion;
        MethodSpec getLatestVersion = MethodSpec.methodBuilder((String)"getLatestVersion").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)new StringBuilder(46).append("com.google.ads.googleads.v").append(n).append(".services").toString(), (String)"GoogleAdsVersion", (String[])new String[0])).addStatement("return getGoogleAdsAllVersions().getLatestVersion()", new Object[0]).build();
        TypeSpec.Builder abstractGoogleAdsClientBuilder = TypeSpec.classBuilder((String)abstractGacSimpleName).addAnnotation(Utils.generatedAnnotation()).addSuperinterface((TypeName)googleAdsAllVersionsClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addMethod(getGoogleAdsAllVersions);
        for (Integer version : this.versions) {
            abstractGoogleAdsClientBuilder.addMethod(AbstractGoogleAdsClientCodeGenerator.getVersion(version));
        }
        abstractGoogleAdsClientBuilder.addMethod(getLatestVersion);
        Utils.writeGeneratedClassToFile("com.google.ads.googleads.lib", abstractGoogleAdsClientBuilder.build(), this.messager, this.filer);
    }

    private static MethodSpec getVersion(int version) {
        return MethodSpec.methodBuilder((String)new StringBuilder(21).append("getVersion").append(version).toString()).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)Utils.createServiceClientClassName(version, "GoogleAdsVersion")).addStatement(new StringBuilder(56).append("return getGoogleAdsAllVersions().getVersion").append(version).append("()").toString(), new Object[0]).build();
    }
}

