/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.annotations.impl.generators.catalog;

import com.google.ads.googleads.annotations.impl.generators.Generator;
import com.google.ads.googleads.annotations.impl.generators.Utils;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;

public class GoogleAdsAllVersionsCodeGenerator
implements Generator {
    private final Set<Integer> versions;
    private final int latestVersion;
    private final String catalogName;
    private final Messager messager;
    private final Filer filer;

    public GoogleAdsAllVersionsCodeGenerator(Set<Integer> versions, int latestVersion, String catalogName, Messager messager, Filer filer) {
        this.versions = versions;
        this.latestVersion = latestVersion;
        this.catalogName = catalogName;
        this.messager = messager;
        this.filer = filer;
    }

    @Override
    public void generate() {
        String googleAdsAllVersionsSimpleName = "GoogleAdsAllVersions";
        if (!this.catalogName.isEmpty()) {
            String string = String.valueOf(googleAdsAllVersionsSimpleName);
            String string2 = this.catalogName;
            googleAdsAllVersionsSimpleName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("_").append(string2).toString();
        }
        TypeSpec.Builder googleAdsAllVersionsGeneratedCodeBuilder = TypeSpec.interfaceBuilder((String)googleAdsAllVersionsSimpleName).addAnnotation(Utils.generatedAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Integer version : this.versions) {
            String string = String.valueOf(version);
            MethodSpec getVersionMethod = MethodSpec.methodBuilder((String)new StringBuilder(10 + String.valueOf(string).length()).append("getVersion").append(string).toString()).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)Utils.createServiceClientClassName(version, "GoogleAdsVersion")).build();
            googleAdsAllVersionsGeneratedCodeBuilder.addMethod(getVersionMethod);
        }
        MethodSpec getLatestVersionMethod = MethodSpec.methodBuilder((String)"getLatestVersion").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)Utils.createServiceClientClassName(this.latestVersion, "GoogleAdsVersion")).build();
        googleAdsAllVersionsGeneratedCodeBuilder.addMethod(getLatestVersionMethod);
        TypeSpec googleAdsAllVersionsGeneratedCode = googleAdsAllVersionsGeneratedCodeBuilder.build();
        Utils.writeGeneratedClassToFile("com.google.ads.googleads.lib", googleAdsAllVersionsGeneratedCode, this.messager, this.filer);
    }
}

