/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.annotations.impl.generators.catalog;

import com.google.ads.googleads.annotations.impl.generators.Generator;
import com.google.ads.googleads.annotations.impl.generators.Utils;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.util.Set;
import javax.annotation.processing.Filer;
import javax.annotation.processing.Messager;
import javax.lang.model.element.Modifier;

public class VersionCatalogCodeGenerator
implements Generator {
    private static final ClassName VERSION_CLASS_NAME = ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)"Version", (String[])new String[0]);
    private static final ClassName IMMUTABLE_SET_CLASS_NAME = ClassName.get(ImmutableSet.class);
    private final Set<Integer> versions;
    private final String catalogName;
    private final Messager messager;
    private final Filer filer;

    public VersionCatalogCodeGenerator(Set<Integer> versions, String catalogName, Messager messager, Filer filer) {
        this.versions = versions;
        this.catalogName = catalogName;
        this.messager = messager;
        this.filer = filer;
    }

    @Override
    public void generate() {
        String versionCatalogSimpleName = "VersionCatalog";
        if (!this.catalogName.isEmpty()) {
            String string = String.valueOf(versionCatalogSimpleName);
            String string2 = this.catalogName;
            versionCatalogSimpleName = new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("_").append(string2).toString();
        }
        MethodSpec.Builder getCatalogBuilder = MethodSpec.methodBuilder((String)"getCatalog").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.STATIC}).addException(IllegalAccessException.class).addException(InstantiationException.class).returns((TypeName)ParameterizedTypeName.get((ClassName)IMMUTABLE_SET_CLASS_NAME, (TypeName[])new TypeName[]{VERSION_CLASS_NAME})).addStatement("$T.Builder<$T> builder = $T.builder()", new Object[]{IMMUTABLE_SET_CLASS_NAME, VERSION_CLASS_NAME, IMMUTABLE_SET_CLASS_NAME});
        for (Integer version : this.versions) {
            String string = String.valueOf(version);
            ClassName exceptionFactoryName = ClassName.get((String)new StringBuilder(33 + String.valueOf(string).length()).append("com.google.ads.googleads.v").append(string).append(".errors").toString(), (String)"GoogleAdsException", (String[])new String[]{"Factory"});
            String string3 = String.valueOf(version);
            ClassName versionClassName = ClassName.get((String)new StringBuilder(35 + String.valueOf(string3).length()).append("com.google.ads.googleads.v").append(string3).append(".services").toString(), (String)"GoogleAdsVersion", (String[])new String[0]);
            ClassName messageProxyProviderClassName = ClassName.get((String)"com.google.ads.googleads.lib.utils.messageproxy", (String)"DefaultMessageProxyProvider", (String[])new String[0]);
            String string4 = String.valueOf(version);
            ClassName searchStreamResponseProxyName = ClassName.get((String)new StringBuilder(59 + String.valueOf(string4).length()).append("com.google.ads.googleads.lib.utils.messageproxy.generated.v").append(string4).toString(), (String)"SearchGoogleAdsStreamResponseMessageProxy", (String[])new String[0]);
            String string5 = String.valueOf(version);
            ClassName searchPagedResponseProxyName = ClassName.get((String)new StringBuilder(59 + String.valueOf(string5).length()).append("com.google.ads.googleads.lib.utils.messageproxy.generated.v").append(string5).toString(), (String)"SearchGoogleAdsResponseMessageProxy", (String[])new String[0]);
            String string6 = String.valueOf(version);
            ClassName customerUserAccessProxyName = ClassName.get((String)new StringBuilder(59 + String.valueOf(string6).length()).append("com.google.ads.googleads.lib.utils.messageproxy.generated.v").append(string6).toString(), (String)"CustomerUserAccessMessageProxy", (String[])new String[0]);
            String string7 = String.valueOf(version);
            ClassName feedMessageProxyName = ClassName.get((String)new StringBuilder(59 + String.valueOf(string7).length()).append("com.google.ads.googleads.lib.utils.messageproxy.generated.v").append(string7).toString(), (String)"FeedMessageProxy", (String[])new String[0]);
            String string8 = String.valueOf(version);
            ClassName createCustomerClientRequestProxyName = ClassName.get((String)new StringBuilder(59 + String.valueOf(string8).length()).append("com.google.ads.googleads.lib.utils.messageproxy.generated.v").append(string8).toString(), (String)"CreateCustomerClientRequestMessageProxy", (String[])new String[0]);
            Object[] objectArray = new Object[3];
            string8 = String.valueOf(version);
            objectArray[0] = new StringBuilder(1 + String.valueOf(string8).length()).append("v").append(string8).toString();
            objectArray[1] = exceptionFactoryName;
            objectArray[2] = versionClassName;
            getCatalogBuilder.addStatement("builder.add(new Version(\n  $S,\n  new $T(),\n  $T.class))", objectArray);
        }
        getCatalogBuilder.addStatement("return builder.build()", new Object[0]);
        MethodSpec getCatalog = getCatalogBuilder.build();
        TypeSpec versionCatalogGeneratedCode = TypeSpec.classBuilder((String)versionCatalogSimpleName).addAnnotation(Utils.generatedAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(getCatalog).build();
        Utils.writeGeneratedClassToFile("com.google.ads.googleads.lib.catalog", versionCatalogGeneratedCode, this.messager, this.filer);
    }
}

