/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.codegen;

import com.google.ads.googleads.codegen.Generator;
import com.google.ads.googleads.codegen.Utils;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.util.Set;
import javax.lang.model.element.Modifier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AbstractGoogleAdsClientCodeGenerator
implements Generator {
    private static final Logger logger = LoggerFactory.getLogger(AbstractGoogleAdsClientCodeGenerator.class);
    private final Set<Integer> versions;
    private final int latestVersion;
    private final File targetDirectory;

    public AbstractGoogleAdsClientCodeGenerator(Set<Integer> versions, int latestVersion, File targetDirectory) {
        this.versions = versions;
        this.latestVersion = latestVersion;
        this.targetDirectory = targetDirectory;
    }

    @Override
    public JavaFile generate() {
        String abstractGacSimpleName = "AbstractGoogleAdsClient";
        String googleAdsAllVersionsSimpleName = "GoogleAdsAllVersions";
        ClassName googleAdsAllVersionsClassName = ClassName.get((String)"com.google.ads.googleads.lib", (String)googleAdsAllVersionsSimpleName, (String[])new String[0]);
        MethodSpec getGoogleAdsAllVersions = MethodSpec.methodBuilder((String)"getGoogleAdsAllVersions").addJavadoc("Returns the accessor for service client factories, using configuration from this class.", new Object[0]).addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.ABSTRACT}).returns((TypeName)googleAdsAllVersionsClassName).build();
        MethodSpec getLatestVersion = MethodSpec.methodBuilder((String)"getLatestVersion").addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)ClassName.get((String)("com.google.ads.googleads.v" + this.latestVersion + ".services"), (String)"GoogleAdsVersion", (String[])new String[0])).addStatement("return getGoogleAdsAllVersions().getLatestVersion()", new Object[0]).build();
        TypeSpec.Builder abstractGoogleAdsClientBuilder = TypeSpec.classBuilder((String)abstractGacSimpleName).addAnnotation(Utils.generatedAnnotation()).addSuperinterface((TypeName)googleAdsAllVersionsClassName).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).addMethod(getGoogleAdsAllVersions);
        for (Integer version : this.versions) {
            abstractGoogleAdsClientBuilder.addMethod(AbstractGoogleAdsClientCodeGenerator.getVersion(version));
        }
        abstractGoogleAdsClientBuilder.addMethod(getLatestVersion);
        JavaFile javaFile = Utils.createJavaFile("com.google.ads.googleads.lib", abstractGoogleAdsClientBuilder.build());
        Utils.writeGeneratedClassToFile(javaFile, this.targetDirectory);
        return javaFile;
    }

    private static MethodSpec getVersion(int version) {
        return MethodSpec.methodBuilder((String)("getVersion" + version)).addAnnotation(Override.class).addModifiers(new Modifier[]{Modifier.PUBLIC}).returns((TypeName)Utils.createServiceClientClassName(version, "GoogleAdsVersion")).addStatement("return getGoogleAdsAllVersions().getVersion" + version + "()", new Object[0]).build();
    }
}

