/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.codegen;

import com.google.ads.googleads.codegen.Generator;
import com.google.ads.googleads.codegen.Utils;
import com.google.common.collect.ImmutableSet;
import com.squareup.javapoet.ClassName;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.ParameterizedTypeName;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class VersionFactoryCodeGenerator
implements Generator {
    private static final ClassName VERSION_CLASS_NAME = ClassName.get((String)"com.google.ads.googleads.lib.catalog", (String)"Version", (String[])new String[0]);
    private static final ClassName IMMUTABLE_SET_CLASS_NAME = ClassName.get(ImmutableSet.class);
    private final Set<Integer> versions;
    private final File targetDirectory;

    public VersionFactoryCodeGenerator(Set<Integer> versions, File targetDirectory) {
        this.versions = versions;
        this.targetDirectory = targetDirectory;
    }

    @Override
    public JavaFile generate() {
        String versionCatalogSimpleName = "VersionFactory";
        MethodSpec.Builder getCatalogBuilder = MethodSpec.methodBuilder((String)"getVersions").addModifiers(new Modifier[]{Modifier.PROTECTED, Modifier.STATIC}).addException(IllegalAccessException.class).addException(InstantiationException.class).returns((TypeName)ParameterizedTypeName.get((ClassName)IMMUTABLE_SET_CLASS_NAME, (TypeName[])new TypeName[]{VERSION_CLASS_NAME})).addStatement("$T.Builder<$T> builder = $T.builder()", new Object[]{IMMUTABLE_SET_CLASS_NAME, VERSION_CLASS_NAME, IMMUTABLE_SET_CLASS_NAME});
        for (Integer version : this.versions) {
            ClassName exceptionFactoryName = ClassName.get((String)("com.google.ads.googleads.v" + version + ".errors"), (String)"GoogleAdsException", (String[])new String[]{"Factory"});
            ClassName versionClassName = ClassName.get((String)("com.google.ads.googleads.v" + version + ".services"), (String)"GoogleAdsVersion", (String[])new String[0]);
            getCatalogBuilder.addStatement("builder.add(new Version(\n  $S,\n  new $T(),\n  $T.class))", new Object[]{"v" + version, exceptionFactoryName, versionClassName});
        }
        getCatalogBuilder.addStatement("return builder.build()", new Object[0]);
        MethodSpec getCatalog = getCatalogBuilder.build();
        TypeSpec versionCatalogGeneratedCode = TypeSpec.classBuilder((String)versionCatalogSimpleName).addAnnotation(Utils.generatedAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC}).addMethod(getCatalog).build();
        JavaFile javaFile = Utils.createJavaFile("com.google.ads.googleads.lib.catalog", versionCatalogGeneratedCode);
        Utils.writeGeneratedClassToFile(javaFile, this.targetDirectory);
        return javaFile;
    }
}

