/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.codegen;

import com.google.ads.googleads.codegen.Generator;
import com.google.ads.googleads.codegen.Utils;
import com.squareup.javapoet.JavaFile;
import com.squareup.javapoet.MethodSpec;
import com.squareup.javapoet.TypeName;
import com.squareup.javapoet.TypeSpec;
import java.io.File;
import java.util.Set;
import javax.lang.model.element.Modifier;

public class GoogleAdsAllVersionsCodeGenerator
implements Generator {
    private final Set<Integer> versions;
    private final int latestVersion;
    private final File targetDirectory;

    public GoogleAdsAllVersionsCodeGenerator(Set<Integer> versions, int latestVersion, File targetDirectory) {
        this.versions = versions;
        this.latestVersion = latestVersion;
        this.targetDirectory = targetDirectory;
    }

    @Override
    public JavaFile generate() {
        String googleAdsAllVersionsSimpleName = "GoogleAdsAllVersions";
        TypeSpec.Builder googleAdsAllVersionsGeneratedCodeBuilder = TypeSpec.interfaceBuilder((String)googleAdsAllVersionsSimpleName).addAnnotation(Utils.generatedAnnotation()).addModifiers(new Modifier[]{Modifier.PUBLIC});
        for (Integer version : this.versions) {
            MethodSpec getVersionMethod = MethodSpec.methodBuilder((String)("getVersion" + version)).addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)Utils.createServiceClientClassName(version, "GoogleAdsVersion")).build();
            googleAdsAllVersionsGeneratedCodeBuilder.addMethod(getVersionMethod);
        }
        MethodSpec getLatestVersionMethod = MethodSpec.methodBuilder((String)"getLatestVersion").addModifiers(new Modifier[]{Modifier.PUBLIC, Modifier.ABSTRACT}).returns((TypeName)Utils.createServiceClientClassName(this.latestVersion, "GoogleAdsVersion")).build();
        googleAdsAllVersionsGeneratedCodeBuilder.addMethod(getLatestVersionMethod);
        JavaFile javaFile = Utils.createJavaFile("com.google.ads.googleads.lib", googleAdsAllVersionsGeneratedCodeBuilder.build());
        Utils.writeGeneratedClassToFile(javaFile, this.targetDirectory);
        return javaFile;
    }
}

