/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.codegen;

import com.google.ads.googleads.codegen.AbstractGoogleAdsClientCodeGenerator;
import com.google.ads.googleads.codegen.GeneratedCatalogCodeGenerator;
import com.google.ads.googleads.codegen.Generator;
import com.google.ads.googleads.codegen.GoogleAdsAllVersionsCodeGenerator;
import com.google.ads.googleads.codegen.VersionFactoryCodeGenerator;
import com.google.ads.googleads.lib.stubs.annotations.VersionDescriptor;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.reflect.ClassPath;
import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class RunCodeGenerators {
    private final File targetDirectory;
    private final ImmutableMap<VersionDescriptor, Class<?>> descriptors;

    public static void main(String[] args) {
        if (args.length != 1) {
            throw new RuntimeException("Specify 1 argument, the directory for the generated code");
        }
        RunCodeGenerators entryPoint = new RunCodeGenerators(new File(args[0]));
        entryPoint.runAll();
    }

    private static Set<Class<?>> loadAnnotatedClasses() {
        try {
            Set<Class<?>> annotatedClasses = ClassPath.from((ClassLoader)ClassLoader.getSystemClassLoader()).getTopLevelClassesRecursive("com.google.ads.googleads").stream().map(ClassPath.ClassInfo::load).filter(c -> c.getAnnotation(VersionDescriptor.class) != null).collect(Collectors.toSet());
            Preconditions.checkState((!annotatedClasses.isEmpty() ? 1 : 0) != 0, (String)"No types found with annotation: %s", VersionDescriptor.class);
            return annotatedClasses;
        }
        catch (IOException e) {
            throw new RuntimeException("Failed to find classes annotated with " + VersionDescriptor.class.getSimpleName(), e);
        }
    }

    private static Map<VersionDescriptor, Class<?>> extractVersionDescriptors(Set<Class<?>> versionDescriptorTypes) {
        return versionDescriptorTypes.stream().collect(Collectors.toMap(c -> c.getAnnotation(VersionDescriptor.class), c -> c));
    }

    public RunCodeGenerators(File targetDirectory) {
        this(targetDirectory, RunCodeGenerators.loadAnnotatedClasses());
    }

    public RunCodeGenerators(File targetDirectory, Set<Class<?>> annotatedClasses) {
        this(targetDirectory, RunCodeGenerators.extractVersionDescriptors(annotatedClasses));
    }

    public RunCodeGenerators(File targetDirectory, Map<VersionDescriptor, Class<?>> versionDescriptors) {
        this.targetDirectory = targetDirectory;
        this.descriptors = ImmutableMap.copyOf(versionDescriptors);
    }

    public void runAll() {
        if (!this.targetDirectory.exists()) {
            this.targetDirectory.mkdirs();
        } else if (!this.targetDirectory.isDirectory()) {
            throw new RuntimeException("Target directory exists and is not a directory: " + this.targetDirectory);
        }
        for (Generator generator : this.loadGenerators(this.targetDirectory)) {
            generator.generate();
        }
    }

    private List<Generator> loadGenerators(File targetDirectory) {
        Set<Integer> versions = this.getApiMajorVersions();
        int latestVersion = this.getLatestVersion();
        return ImmutableList.of((Object)new VersionFactoryCodeGenerator(versions, targetDirectory), (Object)new GeneratedCatalogCodeGenerator(versions, latestVersion, this.descriptors, targetDirectory), (Object)new GoogleAdsAllVersionsCodeGenerator(versions, latestVersion, targetDirectory), (Object)new AbstractGoogleAdsClientCodeGenerator(versions, latestVersion, targetDirectory));
    }

    private Set<Integer> getApiMajorVersions() {
        return this.descriptors.keySet().stream().map(d -> Integer.valueOf(d.versionName().substring(1))).collect(Collectors.toSet());
    }

    private int getLatestVersion() {
        int latestVersion = 0;
        for (int version : this.getApiMajorVersions()) {
            if (version == 999) continue;
            latestVersion = Math.max(latestVersion, version);
        }
        return latestVersion;
    }
}

