/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.utils;

import com.google.protobuf.Any;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.rpc.Status;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public abstract class AbstractErrorUtils<GoogleAdsFailureT extends Message, GoogleAdsErrorT extends Message, FieldPathElementT extends Message> {
    public List<GoogleAdsErrorT> getGoogleAdsErrors(long operationIndex, Status partialFailureStatus) throws InvalidProtocolBufferException {
        ArrayList<GoogleAdsErrorT> result = new ArrayList<GoogleAdsErrorT>();
        for (Any detail : partialFailureStatus.getDetailsList()) {
            GoogleAdsFailureT failure = this.getGoogleAdsFailure(detail);
            result.addAll(this.getGoogleAdsErrors(operationIndex, failure));
        }
        return result;
    }

    public List<GoogleAdsErrorT> getGoogleAdsErrors(long operationIndex, GoogleAdsFailureT googleAdsFailure) {
        ArrayList result = new ArrayList();
        for (ErrorPath path : this.getErrorPaths(googleAdsFailure)) {
            Object error;
            if (!path.isOperationIndex() || !path.getIndex().isPresent() || path.getIndex().get() != operationIndex || result.contains(error = path.getError())) continue;
            result.add(path.getError());
        }
        return result;
    }

    public List<Long> getFailedOperationIndices(GoogleAdsFailureT googleAdsFailureT) {
        return StreamSupport.stream(this.getErrorPaths(googleAdsFailureT).spliterator(), false).filter(ErrorPath::isOperationIndex).filter(p -> p.getIndex().isPresent()).map(p -> p.getIndex().get()).distinct().collect(Collectors.toList());
    }

    public GoogleAdsFailureT getGoogleAdsFailure(Any detail) {
        try {
            return (GoogleAdsFailureT)detail.unpack(this.getGoogleAdsFailureClass());
        }
        catch (InvalidProtocolBufferException e) {
            throw new DeserializeException(e);
        }
    }

    public GoogleAdsFailureT getGoogleAdsFailure(Status partialFailureStatus) {
        return partialFailureStatus.getDetailsCount() == 0 ? null : (GoogleAdsFailureT)this.getGoogleAdsFailure(partialFailureStatus.getDetails(0));
    }

    public boolean isPartialFailureResult(Message message) {
        return message.getSerializedSize() == 0;
    }

    protected Iterable<ErrorPath> getErrorPaths(GoogleAdsFailureT googleAdsFailure) {
        ArrayList<ErrorPath> errorPaths = new ArrayList<ErrorPath>();
        for (Message googleAdsError : this.getGoogleAdsErrors(googleAdsFailure)) {
            List<FieldPathElementT> fieldPathElement = this.getFieldPathElements(googleAdsError);
            if (fieldPathElement.isEmpty()) continue;
            errorPaths.add(this.createErrorPath(googleAdsError, (Message)fieldPathElement.get(0)));
        }
        return errorPaths;
    }

    public abstract List<FieldPathElementT> getFieldPathElements(GoogleAdsErrorT var1);

    public abstract List<GoogleAdsErrorT> getGoogleAdsErrors(GoogleAdsFailureT var1);

    public abstract Class<GoogleAdsFailureT> getGoogleAdsFailureClass();

    protected abstract ErrorPath<GoogleAdsErrorT> createErrorPath(GoogleAdsErrorT var1, FieldPathElementT var2);

    public static class DeserializeException
    extends RuntimeException {
        public DeserializeException(Throwable cause) {
            super(cause);
        }
    }

    protected static class ErrorPath<GoogleAdsErrorType extends Message> {
        private final GoogleAdsErrorType error;
        private final String fieldName;
        private final Optional<Long> index;

        public ErrorPath(GoogleAdsErrorType error, String fieldName, Optional<Long> index) {
            this.error = error;
            this.fieldName = fieldName;
            this.index = index;
        }

        public GoogleAdsErrorType getError() {
            return this.error;
        }

        public String getFieldName() {
            return this.fieldName;
        }

        public Optional<Long> getIndex() {
            return this.index;
        }

        public boolean isOperationIndex() {
            return "operations".equals(this.getFieldName()) || "mutate_operations".equals(this.getFieldName());
        }
    }
}

