/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.lib.stubs.exceptions;

import com.google.api.gax.rpc.ApiException;
import com.google.common.annotations.VisibleForTesting;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import io.grpc.Metadata;
import io.grpc.Status;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseGoogleAdsException
extends ApiException {
    private static final Logger logger = LoggerFactory.getLogger(BaseGoogleAdsException.class);
    private static final Metadata.Key<String> REQUEST_ID_HEADER_KEY = Metadata.Key.of((String)"request-id", (Metadata.AsciiMarshaller)Metadata.ASCII_STRING_MARSHALLER);
    private final Metadata metadata;
    private final Message failure;

    public <T extends Message> BaseGoogleAdsException(ApiException original, T failure, Metadata metadata) {
        super(failure.toString(), original.getCause(), original.getStatusCode(), original.isRetryable());
        this.metadata = metadata;
        this.failure = failure;
    }

    public String getRequestId() {
        return this.getHeader(REQUEST_ID_HEADER_KEY);
    }

    <T> T getHeader(Metadata.Key<T> headerKey) {
        if (this.metadata == null) {
            return null;
        }
        return (T)this.metadata.get(headerKey);
    }

    public Message getGoogleAdsFailure() {
        return this.failure;
    }

    public static abstract class Factory<T extends BaseGoogleAdsException, U extends Message> {
        protected static Metadata.Key<byte[]> createKey(String trailerKey) {
            return Metadata.Key.of((String)trailerKey, (Metadata.BinaryMarshaller)Metadata.BINARY_BYTE_MARSHALLER);
        }

        public Optional<T> createGoogleAdsException(ApiException source) {
            if (source == null) {
                return Optional.empty();
            }
            Throwable cause = source.getCause();
            if (cause == null) {
                return Optional.empty();
            }
            Metadata metadata = Status.trailersFromThrowable((Throwable)cause);
            if (metadata == null) {
                return Optional.empty();
            }
            byte[] protoData = (byte[])metadata.get(this.getTrailerKey());
            if (protoData == null) {
                return Optional.empty();
            }
            try {
                return Optional.of(this.createException(source, protoData, metadata));
            }
            catch (InvalidProtocolBufferException e) {
                logger.error("Failed to decode GoogleAdsFailure", (Throwable)e);
                return Optional.empty();
            }
        }

        protected abstract T createException(ApiException var1, byte[] var2, Metadata var3) throws InvalidProtocolBufferException;

        public abstract Metadata.Key<byte[]> getTrailerKey();

        @VisibleForTesting
        public abstract U createGoogleAdsFailure();

        public abstract U createGoogleAdsFailure(byte[] var1) throws InvalidProtocolBufferException;
    }
}

