/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetGroupListingGroupFilterName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ASSET_GROUP_ID_LISTING_GROUP_FILTER_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/assetGroupListingGroupFilters/{asset_group_id}~{listing_group_filter_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String assetGroupId;
    private final String listingGroupFilterId;

    @Deprecated
    protected AssetGroupListingGroupFilterName() {
        this.customerId = null;
        this.assetGroupId = null;
        this.listingGroupFilterId = null;
    }

    private AssetGroupListingGroupFilterName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.assetGroupId = (String)Preconditions.checkNotNull((Object)builder.getAssetGroupId());
        this.listingGroupFilterId = (String)Preconditions.checkNotNull((Object)builder.getListingGroupFilterId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAssetGroupId() {
        return this.assetGroupId;
    }

    public String getListingGroupFilterId() {
        return this.listingGroupFilterId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetGroupListingGroupFilterName of(String customerId, String assetGroupId, String listingGroupFilterId) {
        return AssetGroupListingGroupFilterName.newBuilder().setCustomerId(customerId).setAssetGroupId(assetGroupId).setListingGroupFilterId(listingGroupFilterId).build();
    }

    public static String format(String customerId, String assetGroupId, String listingGroupFilterId) {
        return AssetGroupListingGroupFilterName.newBuilder().setCustomerId(customerId).setAssetGroupId(assetGroupId).setListingGroupFilterId(listingGroupFilterId).build().toString();
    }

    public static AssetGroupListingGroupFilterName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ASSET_GROUP_ID_LISTING_GROUP_FILTER_ID.validatedMatch(formattedString, "AssetGroupListingGroupFilterName.parse: formattedString not in valid format");
        return AssetGroupListingGroupFilterName.of((String)matchMap.get("customer_id"), (String)matchMap.get("asset_group_id"), (String)matchMap.get("listing_group_filter_id"));
    }

    public static List<AssetGroupListingGroupFilterName> parseList(List<String> formattedStrings) {
        ArrayList<AssetGroupListingGroupFilterName> list = new ArrayList<AssetGroupListingGroupFilterName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetGroupListingGroupFilterName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetGroupListingGroupFilterName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetGroupListingGroupFilterName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ASSET_GROUP_ID_LISTING_GROUP_FILTER_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetGroupListingGroupFilterName assetGroupListingGroupFilterName = this;
            synchronized (assetGroupListingGroupFilterName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.assetGroupId != null) {
                        fieldMapBuilder.put((Object)"asset_group_id", (Object)this.assetGroupId);
                    }
                    if (this.listingGroupFilterId != null) {
                        fieldMapBuilder.put((Object)"listing_group_filter_id", (Object)this.listingGroupFilterId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ASSET_GROUP_ID_LISTING_GROUP_FILTER_ID.instantiate(new String[]{"customer_id", this.customerId, "asset_group_id", this.assetGroupId, "listing_group_filter_id", this.listingGroupFilterId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AssetGroupListingGroupFilterName that = (AssetGroupListingGroupFilterName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.assetGroupId, that.assetGroupId) && Objects.equals(this.listingGroupFilterId, that.listingGroupFilterId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.listingGroupFilterId);
    }

    public static class Builder {
        private String customerId;
        private String assetGroupId;
        private String listingGroupFilterId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAssetGroupId() {
            return this.assetGroupId;
        }

        public String getListingGroupFilterId() {
            return this.listingGroupFilterId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAssetGroupId(String assetGroupId) {
            this.assetGroupId = assetGroupId;
            return this;
        }

        public Builder setListingGroupFilterId(String listingGroupFilterId) {
            this.listingGroupFilterId = listingGroupFilterId;
            return this;
        }

        private Builder(AssetGroupListingGroupFilterName assetGroupListingGroupFilterName) {
            this.customerId = assetGroupListingGroupFilterName.customerId;
            this.assetGroupId = assetGroupListingGroupFilterName.assetGroupId;
            this.listingGroupFilterId = assetGroupListingGroupFilterName.listingGroupFilterId;
        }

        public AssetGroupListingGroupFilterName build() {
            return new AssetGroupListingGroupFilterName(this);
        }
    }
}

