/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.services.stub;

import com.google.ads.googleads.v10.resources.MerchantCenterLink;
import com.google.ads.googleads.v10.services.GetMerchantCenterLinkRequest;
import com.google.ads.googleads.v10.services.ListMerchantCenterLinksRequest;
import com.google.ads.googleads.v10.services.ListMerchantCenterLinksResponse;
import com.google.ads.googleads.v10.services.MutateMerchantCenterLinkRequest;
import com.google.ads.googleads.v10.services.MutateMerchantCenterLinkResponse;
import com.google.ads.googleads.v10.services.stub.GrpcMerchantCenterLinkServiceStub;
import com.google.ads.googleads.v10.services.stub.MerchantCenterLinkServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class MerchantCenterLinkServiceStubSettings
extends StubSettings<MerchantCenterLinkServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<ListMerchantCenterLinksRequest, ListMerchantCenterLinksResponse> listMerchantCenterLinksSettings;
    private final UnaryCallSettings<GetMerchantCenterLinkRequest, MerchantCenterLink> getMerchantCenterLinkSettings;
    private final UnaryCallSettings<MutateMerchantCenterLinkRequest, MutateMerchantCenterLinkResponse> mutateMerchantCenterLinkSettings;

    public UnaryCallSettings<ListMerchantCenterLinksRequest, ListMerchantCenterLinksResponse> listMerchantCenterLinksSettings() {
        return this.listMerchantCenterLinksSettings;
    }

    public UnaryCallSettings<GetMerchantCenterLinkRequest, MerchantCenterLink> getMerchantCenterLinkSettings() {
        return this.getMerchantCenterLinkSettings;
    }

    public UnaryCallSettings<MutateMerchantCenterLinkRequest, MutateMerchantCenterLinkResponse> mutateMerchantCenterLinkSettings() {
        return this.mutateMerchantCenterLinkSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public MerchantCenterLinkServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcMerchantCenterLinkServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return MerchantCenterLinkServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(MerchantCenterLinkServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected MerchantCenterLinkServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.listMerchantCenterLinksSettings = settingsBuilder.listMerchantCenterLinksSettings().build();
        this.getMerchantCenterLinkSettings = settingsBuilder.getMerchantCenterLinkSettings().build();
        this.mutateMerchantCenterLinkSettings = settingsBuilder.mutateMerchantCenterLinkSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<MerchantCenterLinkServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<ListMerchantCenterLinksRequest, ListMerchantCenterLinksResponse> listMerchantCenterLinksSettings;
        private final UnaryCallSettings.Builder<GetMerchantCenterLinkRequest, MerchantCenterLink> getMerchantCenterLinkSettings;
        private final UnaryCallSettings.Builder<MutateMerchantCenterLinkRequest, MutateMerchantCenterLinkResponse> mutateMerchantCenterLinkSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.listMerchantCenterLinksSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getMerchantCenterLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.mutateMerchantCenterLinkSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMerchantCenterLinksSettings, this.getMerchantCenterLinkSettings, this.mutateMerchantCenterLinkSettings);
            Builder.initDefaults(this);
        }

        protected Builder(MerchantCenterLinkServiceStubSettings settings) {
            super((StubSettings)settings);
            this.listMerchantCenterLinksSettings = settings.listMerchantCenterLinksSettings.toBuilder();
            this.getMerchantCenterLinkSettings = settings.getMerchantCenterLinkSettings.toBuilder();
            this.mutateMerchantCenterLinkSettings = settings.mutateMerchantCenterLinkSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.listMerchantCenterLinksSettings, this.getMerchantCenterLinkSettings, this.mutateMerchantCenterLinkSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(MerchantCenterLinkServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)MerchantCenterLinkServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)MerchantCenterLinkServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(MerchantCenterLinkServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(MerchantCenterLinkServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.listMerchantCenterLinksSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.getMerchantCenterLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.mutateMerchantCenterLinkSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<ListMerchantCenterLinksRequest, ListMerchantCenterLinksResponse> listMerchantCenterLinksSettings() {
            return this.listMerchantCenterLinksSettings;
        }

        public UnaryCallSettings.Builder<GetMerchantCenterLinkRequest, MerchantCenterLink> getMerchantCenterLinkSettings() {
            return this.getMerchantCenterLinkSettings;
        }

        public UnaryCallSettings.Builder<MutateMerchantCenterLinkRequest, MutateMerchantCenterLinkResponse> mutateMerchantCenterLinkSettings() {
            return this.mutateMerchantCenterLinkSettings;
        }

        public MerchantCenterLinkServiceStubSettings build() throws IOException {
            return new MerchantCenterLinkServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)3600000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)3600000L)).setTotalTimeout(Duration.ofMillis((long)3600000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

