/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExperimentArmName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_TRIAL_ID_TRIAL_ARM_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/experimentArms/{trial_id}~{trial_arm_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String trialId;
    private final String trialArmId;

    @Deprecated
    protected ExperimentArmName() {
        this.customerId = null;
        this.trialId = null;
        this.trialArmId = null;
    }

    private ExperimentArmName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.trialId = (String)Preconditions.checkNotNull((Object)builder.getTrialId());
        this.trialArmId = (String)Preconditions.checkNotNull((Object)builder.getTrialArmId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getTrialId() {
        return this.trialId;
    }

    public String getTrialArmId() {
        return this.trialArmId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExperimentArmName of(String customerId, String trialId, String trialArmId) {
        return ExperimentArmName.newBuilder().setCustomerId(customerId).setTrialId(trialId).setTrialArmId(trialArmId).build();
    }

    public static String format(String customerId, String trialId, String trialArmId) {
        return ExperimentArmName.newBuilder().setCustomerId(customerId).setTrialId(trialId).setTrialArmId(trialArmId).build().toString();
    }

    public static ExperimentArmName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_TRIAL_ID_TRIAL_ARM_ID.validatedMatch(formattedString, "ExperimentArmName.parse: formattedString not in valid format");
        return ExperimentArmName.of((String)matchMap.get("customer_id"), (String)matchMap.get("trial_id"), (String)matchMap.get("trial_arm_id"));
    }

    public static List<ExperimentArmName> parseList(List<String> formattedStrings) {
        ArrayList<ExperimentArmName> list = new ArrayList<ExperimentArmName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExperimentArmName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExperimentArmName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExperimentArmName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_TRIAL_ID_TRIAL_ARM_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExperimentArmName experimentArmName = this;
            synchronized (experimentArmName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.trialId != null) {
                        fieldMapBuilder.put((Object)"trial_id", (Object)this.trialId);
                    }
                    if (this.trialArmId != null) {
                        fieldMapBuilder.put((Object)"trial_arm_id", (Object)this.trialArmId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_TRIAL_ID_TRIAL_ARM_ID.instantiate(new String[]{"customer_id", this.customerId, "trial_id", this.trialId, "trial_arm_id", this.trialArmId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ExperimentArmName that = (ExperimentArmName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.trialId, that.trialId) && Objects.equals(this.trialArmId, that.trialArmId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.trialId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.trialArmId);
    }

    public static class Builder {
        private String customerId;
        private String trialId;
        private String trialArmId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getTrialId() {
            return this.trialId;
        }

        public String getTrialArmId() {
            return this.trialArmId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setTrialId(String trialId) {
            this.trialId = trialId;
            return this;
        }

        public Builder setTrialArmId(String trialArmId) {
            this.trialArmId = trialArmId;
            return this;
        }

        private Builder(ExperimentArmName experimentArmName) {
            this.customerId = experimentArmName.customerId;
            this.trialId = experimentArmName.trialId;
            this.trialArmId = experimentArmName.trialArmId;
        }

        public ExperimentArmName build() {
            return new ExperimentArmName(this);
        }
    }
}

