/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExperimentName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_TRIAL_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/experiments/{trial_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String trialId;

    @Deprecated
    protected ExperimentName() {
        this.customerId = null;
        this.trialId = null;
    }

    private ExperimentName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.trialId = (String)Preconditions.checkNotNull((Object)builder.getTrialId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getTrialId() {
        return this.trialId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExperimentName of(String customerId, String trialId) {
        return ExperimentName.newBuilder().setCustomerId(customerId).setTrialId(trialId).build();
    }

    public static String format(String customerId, String trialId) {
        return ExperimentName.newBuilder().setCustomerId(customerId).setTrialId(trialId).build().toString();
    }

    public static ExperimentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_TRIAL_ID.validatedMatch(formattedString, "ExperimentName.parse: formattedString not in valid format");
        return ExperimentName.of((String)matchMap.get("customer_id"), (String)matchMap.get("trial_id"));
    }

    public static List<ExperimentName> parseList(List<String> formattedStrings) {
        ArrayList<ExperimentName> list = new ArrayList<ExperimentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExperimentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExperimentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExperimentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_TRIAL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExperimentName experimentName = this;
            synchronized (experimentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.trialId != null) {
                        fieldMapBuilder.put((Object)"trial_id", (Object)this.trialId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_TRIAL_ID.instantiate(new String[]{"customer_id", this.customerId, "trial_id", this.trialId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ExperimentName that = (ExperimentName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.trialId, that.trialId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.trialId);
    }

    public static class Builder {
        private String customerId;
        private String trialId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getTrialId() {
            return this.trialId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setTrialId(String trialId) {
            this.trialId = trialId;
            return this;
        }

        private Builder(ExperimentName experimentName) {
            this.customerId = experimentName.customerId;
            this.trialId = experimentName.trialId;
        }

        public ExperimentName build() {
            return new ExperimentName(this);
        }
    }
}

