/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class InvoiceName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_INVOICE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/invoices/{invoice_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String invoiceId;

    @Deprecated
    protected InvoiceName() {
        this.customerId = null;
        this.invoiceId = null;
    }

    private InvoiceName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.invoiceId = (String)Preconditions.checkNotNull((Object)builder.getInvoiceId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getInvoiceId() {
        return this.invoiceId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static InvoiceName of(String customerId, String invoiceId) {
        return InvoiceName.newBuilder().setCustomerId(customerId).setInvoiceId(invoiceId).build();
    }

    public static String format(String customerId, String invoiceId) {
        return InvoiceName.newBuilder().setCustomerId(customerId).setInvoiceId(invoiceId).build().toString();
    }

    public static InvoiceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_INVOICE_ID.validatedMatch(formattedString, "InvoiceName.parse: formattedString not in valid format");
        return InvoiceName.of((String)matchMap.get("customer_id"), (String)matchMap.get("invoice_id"));
    }

    public static List<InvoiceName> parseList(List<String> formattedStrings) {
        ArrayList<InvoiceName> list = new ArrayList<InvoiceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(InvoiceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<InvoiceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (InvoiceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_INVOICE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            InvoiceName invoiceName = this;
            synchronized (invoiceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.invoiceId != null) {
                        fieldMapBuilder.put((Object)"invoice_id", (Object)this.invoiceId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_INVOICE_ID.instantiate(new String[]{"customer_id", this.customerId, "invoice_id", this.invoiceId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            InvoiceName that = (InvoiceName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.invoiceId, that.invoiceId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.invoiceId);
    }

    public static class Builder {
        private String customerId;
        private String invoiceId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getInvoiceId() {
            return this.invoiceId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setInvoiceId(String invoiceId) {
            this.invoiceId = invoiceId;
            return this;
        }

        private Builder(InvoiceName invoiceName) {
            this.customerId = invoiceName.customerId;
            this.invoiceId = invoiceName.invoiceId;
        }

        public InvoiceName build() {
            return new InvoiceName(this);
        }
    }
}

