/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.services.stub;

import com.google.ads.googleads.v10.services.CampaignExperimentServiceClient;
import com.google.ads.googleads.v10.services.CreateCampaignExperimentMetadata;
import com.google.ads.googleads.v10.services.CreateCampaignExperimentRequest;
import com.google.ads.googleads.v10.services.EndCampaignExperimentRequest;
import com.google.ads.googleads.v10.services.GraduateCampaignExperimentRequest;
import com.google.ads.googleads.v10.services.GraduateCampaignExperimentResponse;
import com.google.ads.googleads.v10.services.ListCampaignExperimentAsyncErrorsRequest;
import com.google.ads.googleads.v10.services.ListCampaignExperimentAsyncErrorsResponse;
import com.google.ads.googleads.v10.services.MutateCampaignExperimentsRequest;
import com.google.ads.googleads.v10.services.MutateCampaignExperimentsResponse;
import com.google.ads.googleads.v10.services.PromoteCampaignExperimentRequest;
import com.google.ads.googleads.v10.services.stub.CampaignExperimentServiceStub;
import com.google.ads.googleads.v10.services.stub.GrpcCampaignExperimentServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.rpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class CampaignExperimentServiceStubSettings
extends StubSettings<CampaignExperimentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<CreateCampaignExperimentRequest, Operation> createCampaignExperimentSettings;
    private final OperationCallSettings<CreateCampaignExperimentRequest, Empty, CreateCampaignExperimentMetadata> createCampaignExperimentOperationSettings;
    private final UnaryCallSettings<MutateCampaignExperimentsRequest, MutateCampaignExperimentsResponse> mutateCampaignExperimentsSettings;
    private final UnaryCallSettings<GraduateCampaignExperimentRequest, GraduateCampaignExperimentResponse> graduateCampaignExperimentSettings;
    private final UnaryCallSettings<PromoteCampaignExperimentRequest, Operation> promoteCampaignExperimentSettings;
    private final OperationCallSettings<PromoteCampaignExperimentRequest, Empty, Empty> promoteCampaignExperimentOperationSettings;
    private final UnaryCallSettings<EndCampaignExperimentRequest, Empty> endCampaignExperimentSettings;
    private final PagedCallSettings<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, CampaignExperimentServiceClient.ListCampaignExperimentAsyncErrorsPagedResponse> listCampaignExperimentAsyncErrorsSettings;
    private static final PagedListDescriptor<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, Status> LIST_CAMPAIGN_EXPERIMENT_ASYNC_ERRORS_PAGE_STR_DESC = new PagedListDescriptor<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, Status>(){

        public String emptyToken() {
            return "";
        }

        public ListCampaignExperimentAsyncErrorsRequest injectToken(ListCampaignExperimentAsyncErrorsRequest payload, String token) {
            return ListCampaignExperimentAsyncErrorsRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListCampaignExperimentAsyncErrorsRequest injectPageSize(ListCampaignExperimentAsyncErrorsRequest payload, int pageSize) {
            return ListCampaignExperimentAsyncErrorsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListCampaignExperimentAsyncErrorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListCampaignExperimentAsyncErrorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Status> extractResources(ListCampaignExperimentAsyncErrorsResponse payload) {
            return payload.getErrorsList() == null ? ImmutableList.of() : payload.getErrorsList();
        }
    };
    private static final PagedListResponseFactory<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, CampaignExperimentServiceClient.ListCampaignExperimentAsyncErrorsPagedResponse> LIST_CAMPAIGN_EXPERIMENT_ASYNC_ERRORS_PAGE_STR_FACT = new PagedListResponseFactory<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, CampaignExperimentServiceClient.ListCampaignExperimentAsyncErrorsPagedResponse>(){

        public ApiFuture<CampaignExperimentServiceClient.ListCampaignExperimentAsyncErrorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse> callable, ListCampaignExperimentAsyncErrorsRequest request, ApiCallContext context, ApiFuture<ListCampaignExperimentAsyncErrorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_CAMPAIGN_EXPERIMENT_ASYNC_ERRORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return CampaignExperimentServiceClient.ListCampaignExperimentAsyncErrorsPagedResponse.createAsync((PageContext<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, Status>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<CreateCampaignExperimentRequest, Operation> createCampaignExperimentSettings() {
        return this.createCampaignExperimentSettings;
    }

    public OperationCallSettings<CreateCampaignExperimentRequest, Empty, CreateCampaignExperimentMetadata> createCampaignExperimentOperationSettings() {
        return this.createCampaignExperimentOperationSettings;
    }

    public UnaryCallSettings<MutateCampaignExperimentsRequest, MutateCampaignExperimentsResponse> mutateCampaignExperimentsSettings() {
        return this.mutateCampaignExperimentsSettings;
    }

    public UnaryCallSettings<GraduateCampaignExperimentRequest, GraduateCampaignExperimentResponse> graduateCampaignExperimentSettings() {
        return this.graduateCampaignExperimentSettings;
    }

    public UnaryCallSettings<PromoteCampaignExperimentRequest, Operation> promoteCampaignExperimentSettings() {
        return this.promoteCampaignExperimentSettings;
    }

    public OperationCallSettings<PromoteCampaignExperimentRequest, Empty, Empty> promoteCampaignExperimentOperationSettings() {
        return this.promoteCampaignExperimentOperationSettings;
    }

    public UnaryCallSettings<EndCampaignExperimentRequest, Empty> endCampaignExperimentSettings() {
        return this.endCampaignExperimentSettings;
    }

    public PagedCallSettings<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, CampaignExperimentServiceClient.ListCampaignExperimentAsyncErrorsPagedResponse> listCampaignExperimentAsyncErrorsSettings() {
        return this.listCampaignExperimentAsyncErrorsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public CampaignExperimentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcCampaignExperimentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return CampaignExperimentServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(CampaignExperimentServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected CampaignExperimentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.createCampaignExperimentSettings = settingsBuilder.createCampaignExperimentSettings().build();
        this.createCampaignExperimentOperationSettings = settingsBuilder.createCampaignExperimentOperationSettings().build();
        this.mutateCampaignExperimentsSettings = settingsBuilder.mutateCampaignExperimentsSettings().build();
        this.graduateCampaignExperimentSettings = settingsBuilder.graduateCampaignExperimentSettings().build();
        this.promoteCampaignExperimentSettings = settingsBuilder.promoteCampaignExperimentSettings().build();
        this.promoteCampaignExperimentOperationSettings = settingsBuilder.promoteCampaignExperimentOperationSettings().build();
        this.endCampaignExperimentSettings = settingsBuilder.endCampaignExperimentSettings().build();
        this.listCampaignExperimentAsyncErrorsSettings = settingsBuilder.listCampaignExperimentAsyncErrorsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<CampaignExperimentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<CreateCampaignExperimentRequest, Operation> createCampaignExperimentSettings;
        private final OperationCallSettings.Builder<CreateCampaignExperimentRequest, Empty, CreateCampaignExperimentMetadata> createCampaignExperimentOperationSettings;
        private final UnaryCallSettings.Builder<MutateCampaignExperimentsRequest, MutateCampaignExperimentsResponse> mutateCampaignExperimentsSettings;
        private final UnaryCallSettings.Builder<GraduateCampaignExperimentRequest, GraduateCampaignExperimentResponse> graduateCampaignExperimentSettings;
        private final UnaryCallSettings.Builder<PromoteCampaignExperimentRequest, Operation> promoteCampaignExperimentSettings;
        private final OperationCallSettings.Builder<PromoteCampaignExperimentRequest, Empty, Empty> promoteCampaignExperimentOperationSettings;
        private final UnaryCallSettings.Builder<EndCampaignExperimentRequest, Empty> endCampaignExperimentSettings;
        private final PagedCallSettings.Builder<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, CampaignExperimentServiceClient.ListCampaignExperimentAsyncErrorsPagedResponse> listCampaignExperimentAsyncErrorsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.createCampaignExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.createCampaignExperimentOperationSettings = OperationCallSettings.newBuilder();
            this.mutateCampaignExperimentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.graduateCampaignExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.promoteCampaignExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.promoteCampaignExperimentOperationSettings = OperationCallSettings.newBuilder();
            this.endCampaignExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listCampaignExperimentAsyncErrorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_CAMPAIGN_EXPERIMENT_ASYNC_ERRORS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCampaignExperimentSettings, this.mutateCampaignExperimentsSettings, this.graduateCampaignExperimentSettings, this.promoteCampaignExperimentSettings, this.endCampaignExperimentSettings, this.listCampaignExperimentAsyncErrorsSettings);
            Builder.initDefaults(this);
        }

        protected Builder(CampaignExperimentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.createCampaignExperimentSettings = settings.createCampaignExperimentSettings.toBuilder();
            this.createCampaignExperimentOperationSettings = settings.createCampaignExperimentOperationSettings.toBuilder();
            this.mutateCampaignExperimentsSettings = settings.mutateCampaignExperimentsSettings.toBuilder();
            this.graduateCampaignExperimentSettings = settings.graduateCampaignExperimentSettings.toBuilder();
            this.promoteCampaignExperimentSettings = settings.promoteCampaignExperimentSettings.toBuilder();
            this.promoteCampaignExperimentOperationSettings = settings.promoteCampaignExperimentOperationSettings.toBuilder();
            this.endCampaignExperimentSettings = settings.endCampaignExperimentSettings.toBuilder();
            this.listCampaignExperimentAsyncErrorsSettings = settings.listCampaignExperimentAsyncErrorsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.createCampaignExperimentSettings, this.mutateCampaignExperimentsSettings, this.graduateCampaignExperimentSettings, this.promoteCampaignExperimentSettings, this.endCampaignExperimentSettings, this.listCampaignExperimentAsyncErrorsSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(CampaignExperimentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)CampaignExperimentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)CampaignExperimentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(CampaignExperimentServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(CampaignExperimentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.createCampaignExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.mutateCampaignExperimentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.graduateCampaignExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.promoteCampaignExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.endCampaignExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listCampaignExperimentAsyncErrorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.createCampaignExperimentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(CreateCampaignExperimentMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.promoteCampaignExperimentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(Empty.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<CreateCampaignExperimentRequest, Operation> createCampaignExperimentSettings() {
            return this.createCampaignExperimentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<CreateCampaignExperimentRequest, Empty, CreateCampaignExperimentMetadata> createCampaignExperimentOperationSettings() {
            return this.createCampaignExperimentOperationSettings;
        }

        public UnaryCallSettings.Builder<MutateCampaignExperimentsRequest, MutateCampaignExperimentsResponse> mutateCampaignExperimentsSettings() {
            return this.mutateCampaignExperimentsSettings;
        }

        public UnaryCallSettings.Builder<GraduateCampaignExperimentRequest, GraduateCampaignExperimentResponse> graduateCampaignExperimentSettings() {
            return this.graduateCampaignExperimentSettings;
        }

        public UnaryCallSettings.Builder<PromoteCampaignExperimentRequest, Operation> promoteCampaignExperimentSettings() {
            return this.promoteCampaignExperimentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<PromoteCampaignExperimentRequest, Empty, Empty> promoteCampaignExperimentOperationSettings() {
            return this.promoteCampaignExperimentOperationSettings;
        }

        public UnaryCallSettings.Builder<EndCampaignExperimentRequest, Empty> endCampaignExperimentSettings() {
            return this.endCampaignExperimentSettings;
        }

        public PagedCallSettings.Builder<ListCampaignExperimentAsyncErrorsRequest, ListCampaignExperimentAsyncErrorsResponse, CampaignExperimentServiceClient.ListCampaignExperimentAsyncErrorsPagedResponse> listCampaignExperimentAsyncErrorsSettings() {
            return this.listCampaignExperimentAsyncErrorsSettings;
        }

        public CampaignExperimentServiceStubSettings build() throws IOException {
            return new CampaignExperimentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)14400000L)).setTotalTimeout(Duration.ofMillis((long)14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

