/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssetFieldTypeViewName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_FIELD_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/assetFieldTypeViews/{field_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String fieldType;

    @Deprecated
    protected AssetFieldTypeViewName() {
        this.customerId = null;
        this.fieldType = null;
    }

    private AssetFieldTypeViewName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.fieldType = (String)Preconditions.checkNotNull((Object)builder.getFieldType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssetFieldTypeViewName of(String customerId, String fieldType) {
        return AssetFieldTypeViewName.newBuilder().setCustomerId(customerId).setFieldType(fieldType).build();
    }

    public static String format(String customerId, String fieldType) {
        return AssetFieldTypeViewName.newBuilder().setCustomerId(customerId).setFieldType(fieldType).build().toString();
    }

    public static AssetFieldTypeViewName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_FIELD_TYPE.validatedMatch(formattedString, "AssetFieldTypeViewName.parse: formattedString not in valid format");
        return AssetFieldTypeViewName.of((String)matchMap.get("customer_id"), (String)matchMap.get("field_type"));
    }

    public static List<AssetFieldTypeViewName> parseList(List<String> formattedStrings) {
        ArrayList<AssetFieldTypeViewName> list = new ArrayList<AssetFieldTypeViewName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssetFieldTypeViewName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssetFieldTypeViewName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssetFieldTypeViewName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_FIELD_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssetFieldTypeViewName assetFieldTypeViewName = this;
            synchronized (assetFieldTypeViewName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.fieldType != null) {
                        fieldMapBuilder.put((Object)"field_type", (Object)this.fieldType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_FIELD_TYPE.instantiate(new String[]{"customer_id", this.customerId, "field_type", this.fieldType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AssetFieldTypeViewName that = (AssetFieldTypeViewName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.fieldType, that.fieldType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.fieldType);
    }

    public static class Builder {
        private String customerId;
        private String fieldType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setFieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        private Builder(AssetFieldTypeViewName assetFieldTypeViewName) {
            this.customerId = assetFieldTypeViewName.customerId;
            this.fieldType = assetFieldTypeViewName.fieldType;
        }

        public AssetFieldTypeViewName build() {
            return new AssetFieldTypeViewName(this);
        }
    }
}

