/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignDraftName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_BASE_CAMPAIGN_ID_DRAFT_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignDrafts/{base_campaign_id}~{draft_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String baseCampaignId;
    private final String draftId;

    @Deprecated
    protected CampaignDraftName() {
        this.customerId = null;
        this.baseCampaignId = null;
        this.draftId = null;
    }

    private CampaignDraftName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.baseCampaignId = (String)Preconditions.checkNotNull((Object)builder.getBaseCampaignId());
        this.draftId = (String)Preconditions.checkNotNull((Object)builder.getDraftId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getBaseCampaignId() {
        return this.baseCampaignId;
    }

    public String getDraftId() {
        return this.draftId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignDraftName of(String customerId, String baseCampaignId, String draftId) {
        return CampaignDraftName.newBuilder().setCustomerId(customerId).setBaseCampaignId(baseCampaignId).setDraftId(draftId).build();
    }

    public static String format(String customerId, String baseCampaignId, String draftId) {
        return CampaignDraftName.newBuilder().setCustomerId(customerId).setBaseCampaignId(baseCampaignId).setDraftId(draftId).build().toString();
    }

    public static CampaignDraftName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_BASE_CAMPAIGN_ID_DRAFT_ID.validatedMatch(formattedString, "CampaignDraftName.parse: formattedString not in valid format");
        return CampaignDraftName.of((String)matchMap.get("customer_id"), (String)matchMap.get("base_campaign_id"), (String)matchMap.get("draft_id"));
    }

    public static List<CampaignDraftName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignDraftName> list = new ArrayList<CampaignDraftName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignDraftName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignDraftName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignDraftName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_BASE_CAMPAIGN_ID_DRAFT_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignDraftName campaignDraftName = this;
            synchronized (campaignDraftName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.baseCampaignId != null) {
                        fieldMapBuilder.put((Object)"base_campaign_id", (Object)this.baseCampaignId);
                    }
                    if (this.draftId != null) {
                        fieldMapBuilder.put((Object)"draft_id", (Object)this.draftId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_BASE_CAMPAIGN_ID_DRAFT_ID.instantiate(new String[]{"customer_id", this.customerId, "base_campaign_id", this.baseCampaignId, "draft_id", this.draftId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CampaignDraftName that = (CampaignDraftName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.baseCampaignId, that.baseCampaignId) && Objects.equals(this.draftId, that.draftId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.baseCampaignId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.draftId);
    }

    public static class Builder {
        private String customerId;
        private String baseCampaignId;
        private String draftId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getBaseCampaignId() {
            return this.baseCampaignId;
        }

        public String getDraftId() {
            return this.draftId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setBaseCampaignId(String baseCampaignId) {
            this.baseCampaignId = baseCampaignId;
            return this;
        }

        public Builder setDraftId(String draftId) {
            this.draftId = draftId;
            return this;
        }

        private Builder(CampaignDraftName campaignDraftName) {
            this.customerId = campaignDraftName.customerId;
            this.baseCampaignId = campaignDraftName.baseCampaignId;
            this.draftId = campaignDraftName.draftId;
        }

        public CampaignDraftName build() {
            return new CampaignDraftName(this);
        }
    }
}

