/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.resources;

import com.google.ads.googleads.v10.enums.AffiliateLocationFeedRelationshipTypeEnum;
import com.google.ads.googleads.v10.enums.FeedOriginEnum;
import com.google.ads.googleads.v10.enums.FeedStatusEnum;
import com.google.ads.googleads.v10.resources.FeedAttribute;
import com.google.ads.googleads.v10.resources.FeedAttributeOperation;
import com.google.ads.googleads.v10.resources.FeedAttributeOperationOrBuilder;
import com.google.ads.googleads.v10.resources.FeedAttributeOrBuilder;
import com.google.ads.googleads.v10.resources.FeedOrBuilder;
import com.google.ads.googleads.v10.resources.FeedProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.LazyStringArrayList;
import com.google.protobuf.LazyStringList;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolStringList;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.SingleFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public final class Feed
extends GeneratedMessageV3
implements FeedOrBuilder {
    private static final long serialVersionUID = 0L;
    private int bitField0_;
    private int systemFeedGenerationDataCase_ = 0;
    private Object systemFeedGenerationData_;
    public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
    private volatile Object resourceName_;
    public static final int ID_FIELD_NUMBER = 11;
    private long id_;
    public static final int NAME_FIELD_NUMBER = 12;
    private volatile Object name_;
    public static final int ATTRIBUTES_FIELD_NUMBER = 4;
    private List<FeedAttribute> attributes_;
    public static final int ATTRIBUTE_OPERATIONS_FIELD_NUMBER = 9;
    private List<FeedAttributeOperation> attributeOperations_;
    public static final int ORIGIN_FIELD_NUMBER = 5;
    private int origin_;
    public static final int STATUS_FIELD_NUMBER = 8;
    private int status_;
    public static final int PLACES_LOCATION_FEED_DATA_FIELD_NUMBER = 6;
    public static final int AFFILIATE_LOCATION_FEED_DATA_FIELD_NUMBER = 7;
    private byte memoizedIsInitialized = (byte)-1;
    private static final Feed DEFAULT_INSTANCE = new Feed();
    private static final Parser<Feed> PARSER = new AbstractParser<Feed>(){

        public Feed parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = Feed.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private Feed(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private Feed() {
        this.resourceName_ = "";
        this.name_ = "";
        this.attributes_ = Collections.emptyList();
        this.attributeOperations_ = Collections.emptyList();
        this.origin_ = 0;
        this.status_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new Feed();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_fieldAccessorTable.ensureFieldAccessorsInitialized(Feed.class, Builder.class);
    }

    @Override
    public SystemFeedGenerationDataCase getSystemFeedGenerationDataCase() {
        return SystemFeedGenerationDataCase.forNumber(this.systemFeedGenerationDataCase_);
    }

    @Override
    public String getResourceName() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.resourceName_ = s;
        return s;
    }

    @Override
    public ByteString getResourceNameBytes() {
        Object ref = this.resourceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.resourceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public boolean hasId() {
        return (this.bitField0_ & 1) != 0;
    }

    @Override
    public long getId() {
        return this.id_;
    }

    @Override
    public boolean hasName() {
        return (this.bitField0_ & 2) != 0;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public List<FeedAttribute> getAttributesList() {
        return this.attributes_;
    }

    @Override
    public List<? extends FeedAttributeOrBuilder> getAttributesOrBuilderList() {
        return this.attributes_;
    }

    @Override
    public int getAttributesCount() {
        return this.attributes_.size();
    }

    @Override
    public FeedAttribute getAttributes(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public FeedAttributeOrBuilder getAttributesOrBuilder(int index) {
        return this.attributes_.get(index);
    }

    @Override
    public List<FeedAttributeOperation> getAttributeOperationsList() {
        return this.attributeOperations_;
    }

    @Override
    public List<? extends FeedAttributeOperationOrBuilder> getAttributeOperationsOrBuilderList() {
        return this.attributeOperations_;
    }

    @Override
    public int getAttributeOperationsCount() {
        return this.attributeOperations_.size();
    }

    @Override
    public FeedAttributeOperation getAttributeOperations(int index) {
        return this.attributeOperations_.get(index);
    }

    @Override
    public FeedAttributeOperationOrBuilder getAttributeOperationsOrBuilder(int index) {
        return this.attributeOperations_.get(index);
    }

    @Override
    public int getOriginValue() {
        return this.origin_;
    }

    @Override
    public FeedOriginEnum.FeedOrigin getOrigin() {
        FeedOriginEnum.FeedOrigin result = FeedOriginEnum.FeedOrigin.valueOf(this.origin_);
        return result == null ? FeedOriginEnum.FeedOrigin.UNRECOGNIZED : result;
    }

    @Override
    public int getStatusValue() {
        return this.status_;
    }

    @Override
    public FeedStatusEnum.FeedStatus getStatus() {
        FeedStatusEnum.FeedStatus result = FeedStatusEnum.FeedStatus.valueOf(this.status_);
        return result == null ? FeedStatusEnum.FeedStatus.UNRECOGNIZED : result;
    }

    @Override
    public boolean hasPlacesLocationFeedData() {
        return this.systemFeedGenerationDataCase_ == 6;
    }

    @Override
    public PlacesLocationFeedData getPlacesLocationFeedData() {
        if (this.systemFeedGenerationDataCase_ == 6) {
            return (PlacesLocationFeedData)this.systemFeedGenerationData_;
        }
        return PlacesLocationFeedData.getDefaultInstance();
    }

    @Override
    public PlacesLocationFeedDataOrBuilder getPlacesLocationFeedDataOrBuilder() {
        if (this.systemFeedGenerationDataCase_ == 6) {
            return (PlacesLocationFeedData)this.systemFeedGenerationData_;
        }
        return PlacesLocationFeedData.getDefaultInstance();
    }

    @Override
    public boolean hasAffiliateLocationFeedData() {
        return this.systemFeedGenerationDataCase_ == 7;
    }

    @Override
    public AffiliateLocationFeedData getAffiliateLocationFeedData() {
        if (this.systemFeedGenerationDataCase_ == 7) {
            return (AffiliateLocationFeedData)this.systemFeedGenerationData_;
        }
        return AffiliateLocationFeedData.getDefaultInstance();
    }

    @Override
    public AffiliateLocationFeedDataOrBuilder getAffiliateLocationFeedDataOrBuilder() {
        if (this.systemFeedGenerationDataCase_ == 7) {
            return (AffiliateLocationFeedData)this.systemFeedGenerationData_;
        }
        return AffiliateLocationFeedData.getDefaultInstance();
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.resourceName_);
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            output.writeMessage(4, (MessageLite)this.attributes_.get(i));
        }
        if (this.origin_ != FeedOriginEnum.FeedOrigin.UNSPECIFIED.getNumber()) {
            output.writeEnum(5, this.origin_);
        }
        if (this.systemFeedGenerationDataCase_ == 6) {
            output.writeMessage(6, (MessageLite)((PlacesLocationFeedData)this.systemFeedGenerationData_));
        }
        if (this.systemFeedGenerationDataCase_ == 7) {
            output.writeMessage(7, (MessageLite)((AffiliateLocationFeedData)this.systemFeedGenerationData_));
        }
        if (this.status_ != FeedStatusEnum.FeedStatus.UNSPECIFIED.getNumber()) {
            output.writeEnum(8, this.status_);
        }
        for (i = 0; i < this.attributeOperations_.size(); ++i) {
            output.writeMessage(9, (MessageLite)this.attributeOperations_.get(i));
        }
        if ((this.bitField0_ & 1) != 0) {
            output.writeInt64(11, this.id_);
        }
        if ((this.bitField0_ & 2) != 0) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.name_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int i;
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!GeneratedMessageV3.isStringEmpty((Object)this.resourceName_)) {
            size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.resourceName_);
        }
        for (i = 0; i < this.attributes_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)4, (MessageLite)((MessageLite)this.attributes_.get(i)));
        }
        if (this.origin_ != FeedOriginEnum.FeedOrigin.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)5, (int)this.origin_);
        }
        if (this.systemFeedGenerationDataCase_ == 6) {
            size += CodedOutputStream.computeMessageSize((int)6, (MessageLite)((PlacesLocationFeedData)this.systemFeedGenerationData_));
        }
        if (this.systemFeedGenerationDataCase_ == 7) {
            size += CodedOutputStream.computeMessageSize((int)7, (MessageLite)((AffiliateLocationFeedData)this.systemFeedGenerationData_));
        }
        if (this.status_ != FeedStatusEnum.FeedStatus.UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)8, (int)this.status_);
        }
        for (i = 0; i < this.attributeOperations_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)9, (MessageLite)((MessageLite)this.attributeOperations_.get(i)));
        }
        if ((this.bitField0_ & 1) != 0) {
            size += CodedOutputStream.computeInt64Size((int)11, (long)this.id_);
        }
        if ((this.bitField0_ & 2) != 0) {
            size += GeneratedMessageV3.computeStringSize((int)12, (Object)this.name_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof Feed)) {
            return super.equals(obj);
        }
        Feed other = (Feed)obj;
        if (!this.getResourceName().equals(other.getResourceName())) {
            return false;
        }
        if (this.hasId() != other.hasId()) {
            return false;
        }
        if (this.hasId() && this.getId() != other.getId()) {
            return false;
        }
        if (this.hasName() != other.hasName()) {
            return false;
        }
        if (this.hasName() && !this.getName().equals(other.getName())) {
            return false;
        }
        if (!this.getAttributesList().equals(other.getAttributesList())) {
            return false;
        }
        if (!this.getAttributeOperationsList().equals(other.getAttributeOperationsList())) {
            return false;
        }
        if (this.origin_ != other.origin_) {
            return false;
        }
        if (this.status_ != other.status_) {
            return false;
        }
        if (!this.getSystemFeedGenerationDataCase().equals((Object)other.getSystemFeedGenerationDataCase())) {
            return false;
        }
        switch (this.systemFeedGenerationDataCase_) {
            case 6: {
                if (this.getPlacesLocationFeedData().equals(other.getPlacesLocationFeedData())) break;
                return false;
            }
            case 7: {
                if (this.getAffiliateLocationFeedData().equals(other.getAffiliateLocationFeedData())) break;
                return false;
            }
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + Feed.getDescriptor().hashCode();
        hash = 37 * hash + 1;
        hash = 53 * hash + this.getResourceName().hashCode();
        if (this.hasId()) {
            hash = 37 * hash + 11;
            hash = 53 * hash + Internal.hashLong((long)this.getId());
        }
        if (this.hasName()) {
            hash = 37 * hash + 12;
            hash = 53 * hash + this.getName().hashCode();
        }
        if (this.getAttributesCount() > 0) {
            hash = 37 * hash + 4;
            hash = 53 * hash + this.getAttributesList().hashCode();
        }
        if (this.getAttributeOperationsCount() > 0) {
            hash = 37 * hash + 9;
            hash = 53 * hash + this.getAttributeOperationsList().hashCode();
        }
        hash = 37 * hash + 5;
        hash = 53 * hash + this.origin_;
        hash = 37 * hash + 8;
        hash = 53 * hash + this.status_;
        switch (this.systemFeedGenerationDataCase_) {
            case 6: {
                hash = 37 * hash + 6;
                hash = 53 * hash + this.getPlacesLocationFeedData().hashCode();
                break;
            }
            case 7: {
                hash = 37 * hash + 7;
                hash = 53 * hash + this.getAffiliateLocationFeedData().hashCode();
                break;
            }
        }
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static Feed parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (Feed)PARSER.parseFrom(data);
    }

    public static Feed parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Feed)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Feed parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (Feed)PARSER.parseFrom(data);
    }

    public static Feed parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Feed)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Feed parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (Feed)PARSER.parseFrom(data);
    }

    public static Feed parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (Feed)PARSER.parseFrom(data, extensionRegistry);
    }

    public static Feed parseFrom(InputStream input) throws IOException {
        return (Feed)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static Feed parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Feed)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Feed parseDelimitedFrom(InputStream input) throws IOException {
        return (Feed)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static Feed parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Feed)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static Feed parseFrom(CodedInputStream input) throws IOException {
        return (Feed)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static Feed parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (Feed)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return Feed.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(Feed prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static Feed getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<Feed> parser() {
        return PARSER;
    }

    public Parser<Feed> getParserForType() {
        return PARSER;
    }

    public Feed getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements FeedOrBuilder {
        private int systemFeedGenerationDataCase_ = 0;
        private Object systemFeedGenerationData_;
        private int bitField0_;
        private Object resourceName_ = "";
        private long id_;
        private Object name_ = "";
        private List<FeedAttribute> attributes_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<FeedAttribute, FeedAttribute.Builder, FeedAttributeOrBuilder> attributesBuilder_;
        private List<FeedAttributeOperation> attributeOperations_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<FeedAttributeOperation, FeedAttributeOperation.Builder, FeedAttributeOperationOrBuilder> attributeOperationsBuilder_;
        private int origin_ = 0;
        private int status_ = 0;
        private SingleFieldBuilderV3<PlacesLocationFeedData, PlacesLocationFeedData.Builder, PlacesLocationFeedDataOrBuilder> placesLocationFeedDataBuilder_;
        private SingleFieldBuilderV3<AffiliateLocationFeedData, AffiliateLocationFeedData.Builder, AffiliateLocationFeedDataOrBuilder> affiliateLocationFeedDataBuilder_;

        public static final Descriptors.Descriptor getDescriptor() {
            return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_fieldAccessorTable.ensureFieldAccessorsInitialized(Feed.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.resourceName_ = "";
            this.id_ = 0L;
            this.bitField0_ &= 0xFFFFFFFE;
            this.name_ = "";
            this.bitField0_ &= 0xFFFFFFFD;
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
            } else {
                this.attributes_ = null;
                this.attributesBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFB;
            if (this.attributeOperationsBuilder_ == null) {
                this.attributeOperations_ = Collections.emptyList();
            } else {
                this.attributeOperations_ = null;
                this.attributeOperationsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFF7;
            this.origin_ = 0;
            this.status_ = 0;
            if (this.placesLocationFeedDataBuilder_ != null) {
                this.placesLocationFeedDataBuilder_.clear();
            }
            if (this.affiliateLocationFeedDataBuilder_ != null) {
                this.affiliateLocationFeedDataBuilder_.clear();
            }
            this.systemFeedGenerationDataCase_ = 0;
            this.systemFeedGenerationData_ = null;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_descriptor;
        }

        public Feed getDefaultInstanceForType() {
            return Feed.getDefaultInstance();
        }

        public Feed build() {
            Feed result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public Feed buildPartial() {
            Feed result = new Feed(this);
            int from_bitField0_ = this.bitField0_;
            int to_bitField0_ = 0;
            result.resourceName_ = this.resourceName_;
            if ((from_bitField0_ & 1) != 0) {
                result.id_ = this.id_;
                to_bitField0_ |= 1;
            }
            if ((from_bitField0_ & 2) != 0) {
                to_bitField0_ |= 2;
            }
            result.name_ = this.name_;
            if (this.attributesBuilder_ == null) {
                if ((this.bitField0_ & 4) != 0) {
                    this.attributes_ = Collections.unmodifiableList(this.attributes_);
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.attributes_ = this.attributes_;
            } else {
                result.attributes_ = this.attributesBuilder_.build();
            }
            if (this.attributeOperationsBuilder_ == null) {
                if ((this.bitField0_ & 8) != 0) {
                    this.attributeOperations_ = Collections.unmodifiableList(this.attributeOperations_);
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.attributeOperations_ = this.attributeOperations_;
            } else {
                result.attributeOperations_ = this.attributeOperationsBuilder_.build();
            }
            result.origin_ = this.origin_;
            result.status_ = this.status_;
            if (this.systemFeedGenerationDataCase_ == 6) {
                if (this.placesLocationFeedDataBuilder_ == null) {
                    result.systemFeedGenerationData_ = this.systemFeedGenerationData_;
                } else {
                    result.systemFeedGenerationData_ = this.placesLocationFeedDataBuilder_.build();
                }
            }
            if (this.systemFeedGenerationDataCase_ == 7) {
                if (this.affiliateLocationFeedDataBuilder_ == null) {
                    result.systemFeedGenerationData_ = this.systemFeedGenerationData_;
                } else {
                    result.systemFeedGenerationData_ = this.affiliateLocationFeedDataBuilder_.build();
                }
            }
            result.bitField0_ = to_bitField0_;
            result.systemFeedGenerationDataCase_ = this.systemFeedGenerationDataCase_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof Feed) {
                return this.mergeFrom((Feed)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(Feed other) {
            if (other == Feed.getDefaultInstance()) {
                return this;
            }
            if (!other.getResourceName().isEmpty()) {
                this.resourceName_ = other.resourceName_;
                this.onChanged();
            }
            if (other.hasId()) {
                this.setId(other.getId());
            }
            if (other.hasName()) {
                this.bitField0_ |= 2;
                this.name_ = other.name_;
                this.onChanged();
            }
            if (this.attributesBuilder_ == null) {
                if (!other.attributes_.isEmpty()) {
                    if (this.attributes_.isEmpty()) {
                        this.attributes_ = other.attributes_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureAttributesIsMutable();
                        this.attributes_.addAll(other.attributes_);
                    }
                    this.onChanged();
                }
            } else if (!other.attributes_.isEmpty()) {
                if (this.attributesBuilder_.isEmpty()) {
                    this.attributesBuilder_.dispose();
                    this.attributesBuilder_ = null;
                    this.attributes_ = other.attributes_;
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.attributesBuilder_ = alwaysUseFieldBuilders ? this.getAttributesFieldBuilder() : null;
                } else {
                    this.attributesBuilder_.addAllMessages((Iterable)other.attributes_);
                }
            }
            if (this.attributeOperationsBuilder_ == null) {
                if (!other.attributeOperations_.isEmpty()) {
                    if (this.attributeOperations_.isEmpty()) {
                        this.attributeOperations_ = other.attributeOperations_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureAttributeOperationsIsMutable();
                        this.attributeOperations_.addAll(other.attributeOperations_);
                    }
                    this.onChanged();
                }
            } else if (!other.attributeOperations_.isEmpty()) {
                if (this.attributeOperationsBuilder_.isEmpty()) {
                    this.attributeOperationsBuilder_.dispose();
                    this.attributeOperationsBuilder_ = null;
                    this.attributeOperations_ = other.attributeOperations_;
                    this.bitField0_ &= 0xFFFFFFF7;
                    this.attributeOperationsBuilder_ = alwaysUseFieldBuilders ? this.getAttributeOperationsFieldBuilder() : null;
                } else {
                    this.attributeOperationsBuilder_.addAllMessages((Iterable)other.attributeOperations_);
                }
            }
            if (other.origin_ != 0) {
                this.setOriginValue(other.getOriginValue());
            }
            if (other.status_ != 0) {
                this.setStatusValue(other.getStatusValue());
            }
            switch (other.getSystemFeedGenerationDataCase()) {
                case PLACES_LOCATION_FEED_DATA: {
                    this.mergePlacesLocationFeedData(other.getPlacesLocationFeedData());
                    break;
                }
                case AFFILIATE_LOCATION_FEED_DATA: {
                    this.mergeAffiliateLocationFeedData(other.getAffiliateLocationFeedData());
                    break;
                }
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block17: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block17;
                        }
                        case 10: {
                            this.resourceName_ = input.readStringRequireUtf8();
                            continue block17;
                        }
                        case 34: {
                            GeneratedMessageV3 m = (FeedAttribute)input.readMessage(FeedAttribute.parser(), extensionRegistry);
                            if (this.attributesBuilder_ == null) {
                                this.ensureAttributesIsMutable();
                                this.attributes_.add((FeedAttribute)m);
                                continue block17;
                            }
                            this.attributesBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 40: {
                            this.origin_ = input.readEnum();
                            continue block17;
                        }
                        case 50: {
                            input.readMessage((MessageLite.Builder)this.getPlacesLocationFeedDataFieldBuilder().getBuilder(), extensionRegistry);
                            this.systemFeedGenerationDataCase_ = 6;
                            continue block17;
                        }
                        case 58: {
                            input.readMessage((MessageLite.Builder)this.getAffiliateLocationFeedDataFieldBuilder().getBuilder(), extensionRegistry);
                            this.systemFeedGenerationDataCase_ = 7;
                            continue block17;
                        }
                        case 64: {
                            this.status_ = input.readEnum();
                            continue block17;
                        }
                        case 74: {
                            GeneratedMessageV3 m = (FeedAttributeOperation)input.readMessage(FeedAttributeOperation.parser(), extensionRegistry);
                            if (this.attributeOperationsBuilder_ == null) {
                                this.ensureAttributeOperationsIsMutable();
                                this.attributeOperations_.add((FeedAttributeOperation)m);
                                continue block17;
                            }
                            this.attributeOperationsBuilder_.addMessage((AbstractMessage)m);
                            continue block17;
                        }
                        case 88: {
                            this.id_ = input.readInt64();
                            this.bitField0_ |= 1;
                            continue block17;
                        }
                        case 98: {
                            this.name_ = input.readStringRequireUtf8();
                            this.bitField0_ |= 2;
                            continue block17;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        @Override
        public SystemFeedGenerationDataCase getSystemFeedGenerationDataCase() {
            return SystemFeedGenerationDataCase.forNumber(this.systemFeedGenerationDataCase_);
        }

        public Builder clearSystemFeedGenerationData() {
            this.systemFeedGenerationDataCase_ = 0;
            this.systemFeedGenerationData_ = null;
            this.onChanged();
            return this;
        }

        @Override
        public String getResourceName() {
            Object ref = this.resourceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.resourceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getResourceNameBytes() {
            Object ref = this.resourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.resourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setResourceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.resourceName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearResourceName() {
            this.resourceName_ = Feed.getDefaultInstance().getResourceName();
            this.onChanged();
            return this;
        }

        public Builder setResourceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Feed.checkByteStringIsUtf8((ByteString)value);
            this.resourceName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasId() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public long getId() {
            return this.id_;
        }

        public Builder setId(long value) {
            this.bitField0_ |= 1;
            this.id_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearId() {
            this.bitField0_ &= 0xFFFFFFFE;
            this.id_ = 0L;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasName() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.name_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.name_ = Feed.getDefaultInstance().getName();
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Feed.checkByteStringIsUtf8((ByteString)value);
            this.bitField0_ |= 2;
            this.name_ = value;
            this.onChanged();
            return this;
        }

        private void ensureAttributesIsMutable() {
            if ((this.bitField0_ & 4) == 0) {
                this.attributes_ = new ArrayList<FeedAttribute>(this.attributes_);
                this.bitField0_ |= 4;
            }
        }

        @Override
        public List<FeedAttribute> getAttributesList() {
            if (this.attributesBuilder_ == null) {
                return Collections.unmodifiableList(this.attributes_);
            }
            return this.attributesBuilder_.getMessageList();
        }

        @Override
        public int getAttributesCount() {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.size();
            }
            return this.attributesBuilder_.getCount();
        }

        @Override
        public FeedAttribute getAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return (FeedAttribute)this.attributesBuilder_.getMessage(index);
        }

        public Builder setAttributes(int index, FeedAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, value);
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAttributes(int index, FeedAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(FeedAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(value);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributes(int index, FeedAttribute value) {
            if (this.attributesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, value);
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributes(FeedAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributes(int index, FeedAttribute.Builder builderForValue) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAttributes(Iterable<? extends FeedAttribute> values) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.attributes_);
                this.onChanged();
            } else {
                this.attributesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAttributes() {
            if (this.attributesBuilder_ == null) {
                this.attributes_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
            } else {
                this.attributesBuilder_.clear();
            }
            return this;
        }

        public Builder removeAttributes(int index) {
            if (this.attributesBuilder_ == null) {
                this.ensureAttributesIsMutable();
                this.attributes_.remove(index);
                this.onChanged();
            } else {
                this.attributesBuilder_.remove(index);
            }
            return this;
        }

        public FeedAttribute.Builder getAttributesBuilder(int index) {
            return (FeedAttribute.Builder)this.getAttributesFieldBuilder().getBuilder(index);
        }

        @Override
        public FeedAttributeOrBuilder getAttributesOrBuilder(int index) {
            if (this.attributesBuilder_ == null) {
                return this.attributes_.get(index);
            }
            return (FeedAttributeOrBuilder)this.attributesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends FeedAttributeOrBuilder> getAttributesOrBuilderList() {
            if (this.attributesBuilder_ != null) {
                return this.attributesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.attributes_);
        }

        public FeedAttribute.Builder addAttributesBuilder() {
            return (FeedAttribute.Builder)this.getAttributesFieldBuilder().addBuilder((AbstractMessage)FeedAttribute.getDefaultInstance());
        }

        public FeedAttribute.Builder addAttributesBuilder(int index) {
            return (FeedAttribute.Builder)this.getAttributesFieldBuilder().addBuilder(index, (AbstractMessage)FeedAttribute.getDefaultInstance());
        }

        public List<FeedAttribute.Builder> getAttributesBuilderList() {
            return this.getAttributesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<FeedAttribute, FeedAttribute.Builder, FeedAttributeOrBuilder> getAttributesFieldBuilder() {
            if (this.attributesBuilder_ == null) {
                this.attributesBuilder_ = new RepeatedFieldBuilderV3(this.attributes_, (this.bitField0_ & 4) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.attributes_ = null;
            }
            return this.attributesBuilder_;
        }

        private void ensureAttributeOperationsIsMutable() {
            if ((this.bitField0_ & 8) == 0) {
                this.attributeOperations_ = new ArrayList<FeedAttributeOperation>(this.attributeOperations_);
                this.bitField0_ |= 8;
            }
        }

        @Override
        public List<FeedAttributeOperation> getAttributeOperationsList() {
            if (this.attributeOperationsBuilder_ == null) {
                return Collections.unmodifiableList(this.attributeOperations_);
            }
            return this.attributeOperationsBuilder_.getMessageList();
        }

        @Override
        public int getAttributeOperationsCount() {
            if (this.attributeOperationsBuilder_ == null) {
                return this.attributeOperations_.size();
            }
            return this.attributeOperationsBuilder_.getCount();
        }

        @Override
        public FeedAttributeOperation getAttributeOperations(int index) {
            if (this.attributeOperationsBuilder_ == null) {
                return this.attributeOperations_.get(index);
            }
            return (FeedAttributeOperation)this.attributeOperationsBuilder_.getMessage(index);
        }

        public Builder setAttributeOperations(int index, FeedAttributeOperation value) {
            if (this.attributeOperationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributeOperationsIsMutable();
                this.attributeOperations_.set(index, value);
                this.onChanged();
            } else {
                this.attributeOperationsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAttributeOperations(int index, FeedAttributeOperation.Builder builderForValue) {
            if (this.attributeOperationsBuilder_ == null) {
                this.ensureAttributeOperationsIsMutable();
                this.attributeOperations_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributeOperationsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributeOperations(FeedAttributeOperation value) {
            if (this.attributeOperationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributeOperationsIsMutable();
                this.attributeOperations_.add(value);
                this.onChanged();
            } else {
                this.attributeOperationsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributeOperations(int index, FeedAttributeOperation value) {
            if (this.attributeOperationsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributeOperationsIsMutable();
                this.attributeOperations_.add(index, value);
                this.onChanged();
            } else {
                this.attributeOperationsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributeOperations(FeedAttributeOperation.Builder builderForValue) {
            if (this.attributeOperationsBuilder_ == null) {
                this.ensureAttributeOperationsIsMutable();
                this.attributeOperations_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.attributeOperationsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributeOperations(int index, FeedAttributeOperation.Builder builderForValue) {
            if (this.attributeOperationsBuilder_ == null) {
                this.ensureAttributeOperationsIsMutable();
                this.attributeOperations_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributeOperationsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAttributeOperations(Iterable<? extends FeedAttributeOperation> values) {
            if (this.attributeOperationsBuilder_ == null) {
                this.ensureAttributeOperationsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.attributeOperations_);
                this.onChanged();
            } else {
                this.attributeOperationsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAttributeOperations() {
            if (this.attributeOperationsBuilder_ == null) {
                this.attributeOperations_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
            } else {
                this.attributeOperationsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAttributeOperations(int index) {
            if (this.attributeOperationsBuilder_ == null) {
                this.ensureAttributeOperationsIsMutable();
                this.attributeOperations_.remove(index);
                this.onChanged();
            } else {
                this.attributeOperationsBuilder_.remove(index);
            }
            return this;
        }

        public FeedAttributeOperation.Builder getAttributeOperationsBuilder(int index) {
            return (FeedAttributeOperation.Builder)this.getAttributeOperationsFieldBuilder().getBuilder(index);
        }

        @Override
        public FeedAttributeOperationOrBuilder getAttributeOperationsOrBuilder(int index) {
            if (this.attributeOperationsBuilder_ == null) {
                return this.attributeOperations_.get(index);
            }
            return (FeedAttributeOperationOrBuilder)this.attributeOperationsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends FeedAttributeOperationOrBuilder> getAttributeOperationsOrBuilderList() {
            if (this.attributeOperationsBuilder_ != null) {
                return this.attributeOperationsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.attributeOperations_);
        }

        public FeedAttributeOperation.Builder addAttributeOperationsBuilder() {
            return (FeedAttributeOperation.Builder)this.getAttributeOperationsFieldBuilder().addBuilder((AbstractMessage)FeedAttributeOperation.getDefaultInstance());
        }

        public FeedAttributeOperation.Builder addAttributeOperationsBuilder(int index) {
            return (FeedAttributeOperation.Builder)this.getAttributeOperationsFieldBuilder().addBuilder(index, (AbstractMessage)FeedAttributeOperation.getDefaultInstance());
        }

        public List<FeedAttributeOperation.Builder> getAttributeOperationsBuilderList() {
            return this.getAttributeOperationsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<FeedAttributeOperation, FeedAttributeOperation.Builder, FeedAttributeOperationOrBuilder> getAttributeOperationsFieldBuilder() {
            if (this.attributeOperationsBuilder_ == null) {
                this.attributeOperationsBuilder_ = new RepeatedFieldBuilderV3(this.attributeOperations_, (this.bitField0_ & 8) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.attributeOperations_ = null;
            }
            return this.attributeOperationsBuilder_;
        }

        @Override
        public int getOriginValue() {
            return this.origin_;
        }

        public Builder setOriginValue(int value) {
            this.origin_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public FeedOriginEnum.FeedOrigin getOrigin() {
            FeedOriginEnum.FeedOrigin result = FeedOriginEnum.FeedOrigin.valueOf(this.origin_);
            return result == null ? FeedOriginEnum.FeedOrigin.UNRECOGNIZED : result;
        }

        public Builder setOrigin(FeedOriginEnum.FeedOrigin value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.origin_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearOrigin() {
            this.origin_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public int getStatusValue() {
            return this.status_;
        }

        public Builder setStatusValue(int value) {
            this.status_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public FeedStatusEnum.FeedStatus getStatus() {
            FeedStatusEnum.FeedStatus result = FeedStatusEnum.FeedStatus.valueOf(this.status_);
            return result == null ? FeedStatusEnum.FeedStatus.UNRECOGNIZED : result;
        }

        public Builder setStatus(FeedStatusEnum.FeedStatus value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.status_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearStatus() {
            this.status_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public boolean hasPlacesLocationFeedData() {
            return this.systemFeedGenerationDataCase_ == 6;
        }

        @Override
        public PlacesLocationFeedData getPlacesLocationFeedData() {
            if (this.placesLocationFeedDataBuilder_ == null) {
                if (this.systemFeedGenerationDataCase_ == 6) {
                    return (PlacesLocationFeedData)this.systemFeedGenerationData_;
                }
                return PlacesLocationFeedData.getDefaultInstance();
            }
            if (this.systemFeedGenerationDataCase_ == 6) {
                return (PlacesLocationFeedData)this.placesLocationFeedDataBuilder_.getMessage();
            }
            return PlacesLocationFeedData.getDefaultInstance();
        }

        public Builder setPlacesLocationFeedData(PlacesLocationFeedData value) {
            if (this.placesLocationFeedDataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.systemFeedGenerationData_ = value;
                this.onChanged();
            } else {
                this.placesLocationFeedDataBuilder_.setMessage((AbstractMessage)value);
            }
            this.systemFeedGenerationDataCase_ = 6;
            return this;
        }

        public Builder setPlacesLocationFeedData(PlacesLocationFeedData.Builder builderForValue) {
            if (this.placesLocationFeedDataBuilder_ == null) {
                this.systemFeedGenerationData_ = builderForValue.build();
                this.onChanged();
            } else {
                this.placesLocationFeedDataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.systemFeedGenerationDataCase_ = 6;
            return this;
        }

        public Builder mergePlacesLocationFeedData(PlacesLocationFeedData value) {
            if (this.placesLocationFeedDataBuilder_ == null) {
                this.systemFeedGenerationData_ = this.systemFeedGenerationDataCase_ == 6 && this.systemFeedGenerationData_ != PlacesLocationFeedData.getDefaultInstance() ? PlacesLocationFeedData.newBuilder((PlacesLocationFeedData)this.systemFeedGenerationData_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.systemFeedGenerationDataCase_ == 6) {
                this.placesLocationFeedDataBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.placesLocationFeedDataBuilder_.setMessage((AbstractMessage)value);
            }
            this.systemFeedGenerationDataCase_ = 6;
            return this;
        }

        public Builder clearPlacesLocationFeedData() {
            if (this.placesLocationFeedDataBuilder_ == null) {
                if (this.systemFeedGenerationDataCase_ == 6) {
                    this.systemFeedGenerationDataCase_ = 0;
                    this.systemFeedGenerationData_ = null;
                    this.onChanged();
                }
            } else {
                if (this.systemFeedGenerationDataCase_ == 6) {
                    this.systemFeedGenerationDataCase_ = 0;
                    this.systemFeedGenerationData_ = null;
                }
                this.placesLocationFeedDataBuilder_.clear();
            }
            return this;
        }

        public PlacesLocationFeedData.Builder getPlacesLocationFeedDataBuilder() {
            return (PlacesLocationFeedData.Builder)this.getPlacesLocationFeedDataFieldBuilder().getBuilder();
        }

        @Override
        public PlacesLocationFeedDataOrBuilder getPlacesLocationFeedDataOrBuilder() {
            if (this.systemFeedGenerationDataCase_ == 6 && this.placesLocationFeedDataBuilder_ != null) {
                return (PlacesLocationFeedDataOrBuilder)this.placesLocationFeedDataBuilder_.getMessageOrBuilder();
            }
            if (this.systemFeedGenerationDataCase_ == 6) {
                return (PlacesLocationFeedData)this.systemFeedGenerationData_;
            }
            return PlacesLocationFeedData.getDefaultInstance();
        }

        private SingleFieldBuilderV3<PlacesLocationFeedData, PlacesLocationFeedData.Builder, PlacesLocationFeedDataOrBuilder> getPlacesLocationFeedDataFieldBuilder() {
            if (this.placesLocationFeedDataBuilder_ == null) {
                if (this.systemFeedGenerationDataCase_ != 6) {
                    this.systemFeedGenerationData_ = PlacesLocationFeedData.getDefaultInstance();
                }
                this.placesLocationFeedDataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((PlacesLocationFeedData)this.systemFeedGenerationData_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.systemFeedGenerationData_ = null;
            }
            this.systemFeedGenerationDataCase_ = 6;
            this.onChanged();
            return this.placesLocationFeedDataBuilder_;
        }

        @Override
        public boolean hasAffiliateLocationFeedData() {
            return this.systemFeedGenerationDataCase_ == 7;
        }

        @Override
        public AffiliateLocationFeedData getAffiliateLocationFeedData() {
            if (this.affiliateLocationFeedDataBuilder_ == null) {
                if (this.systemFeedGenerationDataCase_ == 7) {
                    return (AffiliateLocationFeedData)this.systemFeedGenerationData_;
                }
                return AffiliateLocationFeedData.getDefaultInstance();
            }
            if (this.systemFeedGenerationDataCase_ == 7) {
                return (AffiliateLocationFeedData)this.affiliateLocationFeedDataBuilder_.getMessage();
            }
            return AffiliateLocationFeedData.getDefaultInstance();
        }

        public Builder setAffiliateLocationFeedData(AffiliateLocationFeedData value) {
            if (this.affiliateLocationFeedDataBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.systemFeedGenerationData_ = value;
                this.onChanged();
            } else {
                this.affiliateLocationFeedDataBuilder_.setMessage((AbstractMessage)value);
            }
            this.systemFeedGenerationDataCase_ = 7;
            return this;
        }

        public Builder setAffiliateLocationFeedData(AffiliateLocationFeedData.Builder builderForValue) {
            if (this.affiliateLocationFeedDataBuilder_ == null) {
                this.systemFeedGenerationData_ = builderForValue.build();
                this.onChanged();
            } else {
                this.affiliateLocationFeedDataBuilder_.setMessage((AbstractMessage)builderForValue.build());
            }
            this.systemFeedGenerationDataCase_ = 7;
            return this;
        }

        public Builder mergeAffiliateLocationFeedData(AffiliateLocationFeedData value) {
            if (this.affiliateLocationFeedDataBuilder_ == null) {
                this.systemFeedGenerationData_ = this.systemFeedGenerationDataCase_ == 7 && this.systemFeedGenerationData_ != AffiliateLocationFeedData.getDefaultInstance() ? AffiliateLocationFeedData.newBuilder((AffiliateLocationFeedData)this.systemFeedGenerationData_).mergeFrom(value).buildPartial() : value;
                this.onChanged();
            } else if (this.systemFeedGenerationDataCase_ == 7) {
                this.affiliateLocationFeedDataBuilder_.mergeFrom((AbstractMessage)value);
            } else {
                this.affiliateLocationFeedDataBuilder_.setMessage((AbstractMessage)value);
            }
            this.systemFeedGenerationDataCase_ = 7;
            return this;
        }

        public Builder clearAffiliateLocationFeedData() {
            if (this.affiliateLocationFeedDataBuilder_ == null) {
                if (this.systemFeedGenerationDataCase_ == 7) {
                    this.systemFeedGenerationDataCase_ = 0;
                    this.systemFeedGenerationData_ = null;
                    this.onChanged();
                }
            } else {
                if (this.systemFeedGenerationDataCase_ == 7) {
                    this.systemFeedGenerationDataCase_ = 0;
                    this.systemFeedGenerationData_ = null;
                }
                this.affiliateLocationFeedDataBuilder_.clear();
            }
            return this;
        }

        public AffiliateLocationFeedData.Builder getAffiliateLocationFeedDataBuilder() {
            return (AffiliateLocationFeedData.Builder)this.getAffiliateLocationFeedDataFieldBuilder().getBuilder();
        }

        @Override
        public AffiliateLocationFeedDataOrBuilder getAffiliateLocationFeedDataOrBuilder() {
            if (this.systemFeedGenerationDataCase_ == 7 && this.affiliateLocationFeedDataBuilder_ != null) {
                return (AffiliateLocationFeedDataOrBuilder)this.affiliateLocationFeedDataBuilder_.getMessageOrBuilder();
            }
            if (this.systemFeedGenerationDataCase_ == 7) {
                return (AffiliateLocationFeedData)this.systemFeedGenerationData_;
            }
            return AffiliateLocationFeedData.getDefaultInstance();
        }

        private SingleFieldBuilderV3<AffiliateLocationFeedData, AffiliateLocationFeedData.Builder, AffiliateLocationFeedDataOrBuilder> getAffiliateLocationFeedDataFieldBuilder() {
            if (this.affiliateLocationFeedDataBuilder_ == null) {
                if (this.systemFeedGenerationDataCase_ != 7) {
                    this.systemFeedGenerationData_ = AffiliateLocationFeedData.getDefaultInstance();
                }
                this.affiliateLocationFeedDataBuilder_ = new SingleFieldBuilderV3((AbstractMessage)((AffiliateLocationFeedData)this.systemFeedGenerationData_), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.systemFeedGenerationData_ = null;
            }
            this.systemFeedGenerationDataCase_ = 7;
            this.onChanged();
            return this.affiliateLocationFeedDataBuilder_;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum SystemFeedGenerationDataCase implements Internal.EnumLite,
    AbstractMessageLite.InternalOneOfEnum
    {
        PLACES_LOCATION_FEED_DATA(6),
        AFFILIATE_LOCATION_FEED_DATA(7),
        SYSTEMFEEDGENERATIONDATA_NOT_SET(0);

        private final int value;

        private SystemFeedGenerationDataCase(int value) {
            this.value = value;
        }

        @Deprecated
        public static SystemFeedGenerationDataCase valueOf(int value) {
            return SystemFeedGenerationDataCase.forNumber(value);
        }

        public static SystemFeedGenerationDataCase forNumber(int value) {
            switch (value) {
                case 6: {
                    return PLACES_LOCATION_FEED_DATA;
                }
                case 7: {
                    return AFFILIATE_LOCATION_FEED_DATA;
                }
                case 0: {
                    return SYSTEMFEEDGENERATIONDATA_NOT_SET;
                }
            }
            return null;
        }

        public int getNumber() {
            return this.value;
        }
    }

    public static final class AffiliateLocationFeedData
    extends GeneratedMessageV3
    implements AffiliateLocationFeedDataOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int CHAIN_IDS_FIELD_NUMBER = 3;
        private Internal.LongList chainIds_;
        private int chainIdsMemoizedSerializedSize = -1;
        public static final int RELATIONSHIP_TYPE_FIELD_NUMBER = 2;
        private int relationshipType_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final AffiliateLocationFeedData DEFAULT_INSTANCE = new AffiliateLocationFeedData();
        private static final Parser<AffiliateLocationFeedData> PARSER = new AbstractParser<AffiliateLocationFeedData>(){

            public AffiliateLocationFeedData parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = AffiliateLocationFeedData.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private AffiliateLocationFeedData(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private AffiliateLocationFeedData() {
            this.chainIds_ = AffiliateLocationFeedData.emptyLongList();
            this.relationshipType_ = 0;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new AffiliateLocationFeedData();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_AffiliateLocationFeedData_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_AffiliateLocationFeedData_fieldAccessorTable.ensureFieldAccessorsInitialized(AffiliateLocationFeedData.class, Builder.class);
        }

        @Override
        public List<Long> getChainIdsList() {
            return this.chainIds_;
        }

        @Override
        public int getChainIdsCount() {
            return this.chainIds_.size();
        }

        @Override
        public long getChainIds(int index) {
            return this.chainIds_.getLong(index);
        }

        @Override
        public int getRelationshipTypeValue() {
            return this.relationshipType_;
        }

        @Override
        public AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType getRelationshipType() {
            AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType result = AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType.valueOf(this.relationshipType_);
            return result == null ? AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType.UNRECOGNIZED : result;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            this.getSerializedSize();
            if (this.relationshipType_ != AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType.UNSPECIFIED.getNumber()) {
                output.writeEnum(2, this.relationshipType_);
            }
            if (this.getChainIdsList().size() > 0) {
                output.writeUInt32NoTag(26);
                output.writeUInt32NoTag(this.chainIdsMemoizedSerializedSize);
            }
            for (int i = 0; i < this.chainIds_.size(); ++i) {
                output.writeInt64NoTag(this.chainIds_.getLong(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.relationshipType_ != AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType.UNSPECIFIED.getNumber()) {
                size += CodedOutputStream.computeEnumSize((int)2, (int)this.relationshipType_);
            }
            int dataSize = 0;
            for (int i = 0; i < this.chainIds_.size(); ++i) {
                dataSize += CodedOutputStream.computeInt64SizeNoTag((long)this.chainIds_.getLong(i));
            }
            size += dataSize;
            if (!this.getChainIdsList().isEmpty()) {
                ++size;
                size += CodedOutputStream.computeInt32SizeNoTag((int)dataSize);
            }
            this.chainIdsMemoizedSerializedSize = dataSize;
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AffiliateLocationFeedData)) {
                return super.equals(obj);
            }
            AffiliateLocationFeedData other = (AffiliateLocationFeedData)obj;
            if (!this.getChainIdsList().equals(other.getChainIdsList())) {
                return false;
            }
            if (this.relationshipType_ != other.relationshipType_) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + AffiliateLocationFeedData.getDescriptor().hashCode();
            if (this.getChainIdsCount() > 0) {
                hash = 37 * hash + 3;
                hash = 53 * hash + this.getChainIdsList().hashCode();
            }
            hash = 37 * hash + 2;
            hash = 53 * hash + this.relationshipType_;
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static AffiliateLocationFeedData parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (AffiliateLocationFeedData)PARSER.parseFrom(data);
        }

        public static AffiliateLocationFeedData parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AffiliateLocationFeedData)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AffiliateLocationFeedData parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (AffiliateLocationFeedData)PARSER.parseFrom(data);
        }

        public static AffiliateLocationFeedData parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AffiliateLocationFeedData)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AffiliateLocationFeedData parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (AffiliateLocationFeedData)PARSER.parseFrom(data);
        }

        public static AffiliateLocationFeedData parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AffiliateLocationFeedData)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AffiliateLocationFeedData parseFrom(InputStream input) throws IOException {
            return (AffiliateLocationFeedData)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static AffiliateLocationFeedData parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AffiliateLocationFeedData)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AffiliateLocationFeedData parseDelimitedFrom(InputStream input) throws IOException {
            return (AffiliateLocationFeedData)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static AffiliateLocationFeedData parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AffiliateLocationFeedData)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AffiliateLocationFeedData parseFrom(CodedInputStream input) throws IOException {
            return (AffiliateLocationFeedData)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static AffiliateLocationFeedData parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AffiliateLocationFeedData)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return AffiliateLocationFeedData.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(AffiliateLocationFeedData prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static AffiliateLocationFeedData getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AffiliateLocationFeedData> parser() {
            return PARSER;
        }

        public Parser<AffiliateLocationFeedData> getParserForType() {
            return PARSER;
        }

        public AffiliateLocationFeedData getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        static /* synthetic */ Internal.LongList access$3100() {
            return AffiliateLocationFeedData.emptyLongList();
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AffiliateLocationFeedDataOrBuilder {
            private int bitField0_;
            private Internal.LongList chainIds_ = AffiliateLocationFeedData.access$3100();
            private int relationshipType_ = 0;

            public static final Descriptors.Descriptor getDescriptor() {
                return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_AffiliateLocationFeedData_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_AffiliateLocationFeedData_fieldAccessorTable.ensureFieldAccessorsInitialized(AffiliateLocationFeedData.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.chainIds_ = AffiliateLocationFeedData.emptyLongList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.relationshipType_ = 0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_AffiliateLocationFeedData_descriptor;
            }

            public AffiliateLocationFeedData getDefaultInstanceForType() {
                return AffiliateLocationFeedData.getDefaultInstance();
            }

            public AffiliateLocationFeedData build() {
                AffiliateLocationFeedData result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public AffiliateLocationFeedData buildPartial() {
                AffiliateLocationFeedData result = new AffiliateLocationFeedData(this);
                int from_bitField0_ = this.bitField0_;
                if ((this.bitField0_ & 1) != 0) {
                    this.chainIds_.makeImmutable();
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.chainIds_ = this.chainIds_;
                result.relationshipType_ = this.relationshipType_;
                this.onBuilt();
                return result;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof AffiliateLocationFeedData) {
                    return this.mergeFrom((AffiliateLocationFeedData)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(AffiliateLocationFeedData other) {
                if (other == AffiliateLocationFeedData.getDefaultInstance()) {
                    return this;
                }
                if (!other.chainIds_.isEmpty()) {
                    if (this.chainIds_.isEmpty()) {
                        this.chainIds_ = other.chainIds_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureChainIdsIsMutable();
                        this.chainIds_.addAll((Collection)other.chainIds_);
                    }
                    this.onChanged();
                }
                if (other.relationshipType_ != 0) {
                    this.setRelationshipTypeValue(other.getRelationshipTypeValue());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block11: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block11;
                            }
                            case 16: {
                                this.relationshipType_ = input.readEnum();
                                continue block11;
                            }
                            case 24: {
                                long v = input.readInt64();
                                this.ensureChainIdsIsMutable();
                                this.chainIds_.addLong(v);
                                continue block11;
                            }
                            case 26: {
                                int length = input.readRawVarint32();
                                int limit = input.pushLimit(length);
                                this.ensureChainIdsIsMutable();
                                while (input.getBytesUntilLimit() > 0) {
                                    this.chainIds_.addLong(input.readInt64());
                                }
                                input.popLimit(limit);
                                continue block11;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            private void ensureChainIdsIsMutable() {
                if ((this.bitField0_ & 1) == 0) {
                    this.chainIds_ = AffiliateLocationFeedData.mutableCopy((Internal.LongList)this.chainIds_);
                    this.bitField0_ |= 1;
                }
            }

            @Override
            public List<Long> getChainIdsList() {
                return (this.bitField0_ & 1) != 0 ? Collections.unmodifiableList(this.chainIds_) : this.chainIds_;
            }

            @Override
            public int getChainIdsCount() {
                return this.chainIds_.size();
            }

            @Override
            public long getChainIds(int index) {
                return this.chainIds_.getLong(index);
            }

            public Builder setChainIds(int index, long value) {
                this.ensureChainIdsIsMutable();
                this.chainIds_.setLong(index, value);
                this.onChanged();
                return this;
            }

            public Builder addChainIds(long value) {
                this.ensureChainIdsIsMutable();
                this.chainIds_.addLong(value);
                this.onChanged();
                return this;
            }

            public Builder addAllChainIds(Iterable<? extends Long> values) {
                this.ensureChainIdsIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.chainIds_);
                this.onChanged();
                return this;
            }

            public Builder clearChainIds() {
                this.chainIds_ = AffiliateLocationFeedData.emptyLongList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            @Override
            public int getRelationshipTypeValue() {
                return this.relationshipType_;
            }

            public Builder setRelationshipTypeValue(int value) {
                this.relationshipType_ = value;
                this.onChanged();
                return this;
            }

            @Override
            public AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType getRelationshipType() {
                AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType result = AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType.valueOf(this.relationshipType_);
                return result == null ? AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType.UNRECOGNIZED : result;
            }

            public Builder setRelationshipType(AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.relationshipType_ = value.getNumber();
                this.onChanged();
                return this;
            }

            public Builder clearRelationshipType() {
                this.relationshipType_ = 0;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AffiliateLocationFeedDataOrBuilder
    extends MessageOrBuilder {
        public List<Long> getChainIdsList();

        public int getChainIdsCount();

        public long getChainIds(int var1);

        public int getRelationshipTypeValue();

        public AffiliateLocationFeedRelationshipTypeEnum.AffiliateLocationFeedRelationshipType getRelationshipType();
    }

    public static final class PlacesLocationFeedData
    extends GeneratedMessageV3
    implements PlacesLocationFeedDataOrBuilder {
        private static final long serialVersionUID = 0L;
        private int bitField0_;
        public static final int OAUTH_INFO_FIELD_NUMBER = 1;
        private OAuthInfo oauthInfo_;
        public static final int EMAIL_ADDRESS_FIELD_NUMBER = 7;
        private volatile Object emailAddress_;
        public static final int BUSINESS_ACCOUNT_ID_FIELD_NUMBER = 8;
        private volatile Object businessAccountId_;
        public static final int BUSINESS_NAME_FILTER_FIELD_NUMBER = 9;
        private volatile Object businessNameFilter_;
        public static final int CATEGORY_FILTERS_FIELD_NUMBER = 11;
        private LazyStringList categoryFilters_;
        public static final int LABEL_FILTERS_FIELD_NUMBER = 12;
        private LazyStringList labelFilters_;
        private byte memoizedIsInitialized = (byte)-1;
        private static final PlacesLocationFeedData DEFAULT_INSTANCE = new PlacesLocationFeedData();
        private static final Parser<PlacesLocationFeedData> PARSER = new AbstractParser<PlacesLocationFeedData>(){

            public PlacesLocationFeedData parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = PlacesLocationFeedData.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private PlacesLocationFeedData(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private PlacesLocationFeedData() {
            this.emailAddress_ = "";
            this.businessAccountId_ = "";
            this.businessNameFilter_ = "";
            this.categoryFilters_ = LazyStringArrayList.EMPTY;
            this.labelFilters_ = LazyStringArrayList.EMPTY;
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new PlacesLocationFeedData();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_PlacesLocationFeedData_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_PlacesLocationFeedData_fieldAccessorTable.ensureFieldAccessorsInitialized(PlacesLocationFeedData.class, Builder.class);
        }

        @Override
        public boolean hasOauthInfo() {
            return this.oauthInfo_ != null;
        }

        @Override
        public OAuthInfo getOauthInfo() {
            return this.oauthInfo_ == null ? OAuthInfo.getDefaultInstance() : this.oauthInfo_;
        }

        @Override
        public OAuthInfoOrBuilder getOauthInfoOrBuilder() {
            return this.getOauthInfo();
        }

        @Override
        public boolean hasEmailAddress() {
            return (this.bitField0_ & 1) != 0;
        }

        @Override
        public String getEmailAddress() {
            Object ref = this.emailAddress_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.emailAddress_ = s;
            return s;
        }

        @Override
        public ByteString getEmailAddressBytes() {
            Object ref = this.emailAddress_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.emailAddress_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public String getBusinessAccountId() {
            Object ref = this.businessAccountId_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.businessAccountId_ = s;
            return s;
        }

        @Override
        public ByteString getBusinessAccountIdBytes() {
            Object ref = this.businessAccountId_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.businessAccountId_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public boolean hasBusinessNameFilter() {
            return (this.bitField0_ & 2) != 0;
        }

        @Override
        public String getBusinessNameFilter() {
            Object ref = this.businessNameFilter_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.businessNameFilter_ = s;
            return s;
        }

        @Override
        public ByteString getBusinessNameFilterBytes() {
            Object ref = this.businessNameFilter_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.businessNameFilter_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public ProtocolStringList getCategoryFiltersList() {
            return this.categoryFilters_;
        }

        @Override
        public int getCategoryFiltersCount() {
            return this.categoryFilters_.size();
        }

        @Override
        public String getCategoryFilters(int index) {
            return (String)this.categoryFilters_.get(index);
        }

        @Override
        public ByteString getCategoryFiltersBytes(int index) {
            return this.categoryFilters_.getByteString(index);
        }

        public ProtocolStringList getLabelFiltersList() {
            return this.labelFilters_;
        }

        @Override
        public int getLabelFiltersCount() {
            return this.labelFilters_.size();
        }

        @Override
        public String getLabelFilters(int index) {
            return (String)this.labelFilters_.get(index);
        }

        @Override
        public ByteString getLabelFiltersBytes(int index) {
            return this.labelFilters_.getByteString(index);
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            int i;
            if (this.oauthInfo_ != null) {
                output.writeMessage(1, (MessageLite)this.getOauthInfo());
            }
            if ((this.bitField0_ & 1) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)7, (Object)this.emailAddress_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.businessAccountId_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)8, (Object)this.businessAccountId_);
            }
            if ((this.bitField0_ & 2) != 0) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)9, (Object)this.businessNameFilter_);
            }
            for (i = 0; i < this.categoryFilters_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)11, (Object)this.categoryFilters_.getRaw(i));
            }
            for (i = 0; i < this.labelFilters_.size(); ++i) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)12, (Object)this.labelFilters_.getRaw(i));
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int i;
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (this.oauthInfo_ != null) {
                size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)this.getOauthInfo());
            }
            if ((this.bitField0_ & 1) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)7, (Object)this.emailAddress_);
            }
            if (!GeneratedMessageV3.isStringEmpty((Object)this.businessAccountId_)) {
                size += GeneratedMessageV3.computeStringSize((int)8, (Object)this.businessAccountId_);
            }
            if ((this.bitField0_ & 2) != 0) {
                size += GeneratedMessageV3.computeStringSize((int)9, (Object)this.businessNameFilter_);
            }
            int dataSize = 0;
            for (i = 0; i < this.categoryFilters_.size(); ++i) {
                dataSize += PlacesLocationFeedData.computeStringSizeNoTag((Object)this.categoryFilters_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getCategoryFiltersList().size();
            dataSize = 0;
            for (i = 0; i < this.labelFilters_.size(); ++i) {
                dataSize += PlacesLocationFeedData.computeStringSizeNoTag((Object)this.labelFilters_.getRaw(i));
            }
            size += dataSize;
            size += 1 * this.getLabelFiltersList().size();
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof PlacesLocationFeedData)) {
                return super.equals(obj);
            }
            PlacesLocationFeedData other = (PlacesLocationFeedData)obj;
            if (this.hasOauthInfo() != other.hasOauthInfo()) {
                return false;
            }
            if (this.hasOauthInfo() && !this.getOauthInfo().equals(other.getOauthInfo())) {
                return false;
            }
            if (this.hasEmailAddress() != other.hasEmailAddress()) {
                return false;
            }
            if (this.hasEmailAddress() && !this.getEmailAddress().equals(other.getEmailAddress())) {
                return false;
            }
            if (!this.getBusinessAccountId().equals(other.getBusinessAccountId())) {
                return false;
            }
            if (this.hasBusinessNameFilter() != other.hasBusinessNameFilter()) {
                return false;
            }
            if (this.hasBusinessNameFilter() && !this.getBusinessNameFilter().equals(other.getBusinessNameFilter())) {
                return false;
            }
            if (!this.getCategoryFiltersList().equals(other.getCategoryFiltersList())) {
                return false;
            }
            if (!this.getLabelFiltersList().equals(other.getLabelFiltersList())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + PlacesLocationFeedData.getDescriptor().hashCode();
            if (this.hasOauthInfo()) {
                hash = 37 * hash + 1;
                hash = 53 * hash + this.getOauthInfo().hashCode();
            }
            if (this.hasEmailAddress()) {
                hash = 37 * hash + 7;
                hash = 53 * hash + this.getEmailAddress().hashCode();
            }
            hash = 37 * hash + 8;
            hash = 53 * hash + this.getBusinessAccountId().hashCode();
            if (this.hasBusinessNameFilter()) {
                hash = 37 * hash + 9;
                hash = 53 * hash + this.getBusinessNameFilter().hashCode();
            }
            if (this.getCategoryFiltersCount() > 0) {
                hash = 37 * hash + 11;
                hash = 53 * hash + this.getCategoryFiltersList().hashCode();
            }
            if (this.getLabelFiltersCount() > 0) {
                hash = 37 * hash + 12;
                hash = 53 * hash + this.getLabelFiltersList().hashCode();
            }
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static PlacesLocationFeedData parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (PlacesLocationFeedData)PARSER.parseFrom(data);
        }

        public static PlacesLocationFeedData parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PlacesLocationFeedData)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PlacesLocationFeedData parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (PlacesLocationFeedData)PARSER.parseFrom(data);
        }

        public static PlacesLocationFeedData parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PlacesLocationFeedData)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PlacesLocationFeedData parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (PlacesLocationFeedData)PARSER.parseFrom(data);
        }

        public static PlacesLocationFeedData parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (PlacesLocationFeedData)PARSER.parseFrom(data, extensionRegistry);
        }

        public static PlacesLocationFeedData parseFrom(InputStream input) throws IOException {
            return (PlacesLocationFeedData)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static PlacesLocationFeedData parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PlacesLocationFeedData)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static PlacesLocationFeedData parseDelimitedFrom(InputStream input) throws IOException {
            return (PlacesLocationFeedData)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static PlacesLocationFeedData parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PlacesLocationFeedData)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static PlacesLocationFeedData parseFrom(CodedInputStream input) throws IOException {
            return (PlacesLocationFeedData)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static PlacesLocationFeedData parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (PlacesLocationFeedData)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return PlacesLocationFeedData.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(PlacesLocationFeedData prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static PlacesLocationFeedData getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<PlacesLocationFeedData> parser() {
            return PARSER;
        }

        public Parser<PlacesLocationFeedData> getParserForType() {
            return PARSER;
        }

        public PlacesLocationFeedData getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements PlacesLocationFeedDataOrBuilder {
            private int bitField0_;
            private OAuthInfo oauthInfo_;
            private SingleFieldBuilderV3<OAuthInfo, OAuthInfo.Builder, OAuthInfoOrBuilder> oauthInfoBuilder_;
            private Object emailAddress_ = "";
            private Object businessAccountId_ = "";
            private Object businessNameFilter_ = "";
            private LazyStringList categoryFilters_ = LazyStringArrayList.EMPTY;
            private LazyStringList labelFilters_ = LazyStringArrayList.EMPTY;

            public static final Descriptors.Descriptor getDescriptor() {
                return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_PlacesLocationFeedData_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_PlacesLocationFeedData_fieldAccessorTable.ensureFieldAccessorsInitialized(PlacesLocationFeedData.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                if (this.oauthInfoBuilder_ == null) {
                    this.oauthInfo_ = null;
                } else {
                    this.oauthInfo_ = null;
                    this.oauthInfoBuilder_ = null;
                }
                this.emailAddress_ = "";
                this.bitField0_ &= 0xFFFFFFFE;
                this.businessAccountId_ = "";
                this.businessNameFilter_ = "";
                this.bitField0_ &= 0xFFFFFFFD;
                this.categoryFilters_ = LazyStringArrayList.EMPTY;
                this.bitField0_ &= 0xFFFFFFFB;
                this.labelFilters_ = LazyStringArrayList.EMPTY;
                this.bitField0_ &= 0xFFFFFFF7;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_PlacesLocationFeedData_descriptor;
            }

            public PlacesLocationFeedData getDefaultInstanceForType() {
                return PlacesLocationFeedData.getDefaultInstance();
            }

            public PlacesLocationFeedData build() {
                PlacesLocationFeedData result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public PlacesLocationFeedData buildPartial() {
                PlacesLocationFeedData result = new PlacesLocationFeedData(this);
                int from_bitField0_ = this.bitField0_;
                int to_bitField0_ = 0;
                if (this.oauthInfoBuilder_ == null) {
                    result.oauthInfo_ = this.oauthInfo_;
                } else {
                    result.oauthInfo_ = (OAuthInfo)this.oauthInfoBuilder_.build();
                }
                if ((from_bitField0_ & 1) != 0) {
                    to_bitField0_ |= 1;
                }
                result.emailAddress_ = this.emailAddress_;
                result.businessAccountId_ = this.businessAccountId_;
                if ((from_bitField0_ & 2) != 0) {
                    to_bitField0_ |= 2;
                }
                result.businessNameFilter_ = this.businessNameFilter_;
                if ((this.bitField0_ & 4) != 0) {
                    this.categoryFilters_ = this.categoryFilters_.getUnmodifiableView();
                    this.bitField0_ &= 0xFFFFFFFB;
                }
                result.categoryFilters_ = this.categoryFilters_;
                if ((this.bitField0_ & 8) != 0) {
                    this.labelFilters_ = this.labelFilters_.getUnmodifiableView();
                    this.bitField0_ &= 0xFFFFFFF7;
                }
                result.labelFilters_ = this.labelFilters_;
                result.bitField0_ = to_bitField0_;
                this.onBuilt();
                return result;
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof PlacesLocationFeedData) {
                    return this.mergeFrom((PlacesLocationFeedData)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(PlacesLocationFeedData other) {
                if (other == PlacesLocationFeedData.getDefaultInstance()) {
                    return this;
                }
                if (other.hasOauthInfo()) {
                    this.mergeOauthInfo(other.getOauthInfo());
                }
                if (other.hasEmailAddress()) {
                    this.bitField0_ |= 1;
                    this.emailAddress_ = other.emailAddress_;
                    this.onChanged();
                }
                if (!other.getBusinessAccountId().isEmpty()) {
                    this.businessAccountId_ = other.businessAccountId_;
                    this.onChanged();
                }
                if (other.hasBusinessNameFilter()) {
                    this.bitField0_ |= 2;
                    this.businessNameFilter_ = other.businessNameFilter_;
                    this.onChanged();
                }
                if (!other.categoryFilters_.isEmpty()) {
                    if (this.categoryFilters_.isEmpty()) {
                        this.categoryFilters_ = other.categoryFilters_;
                        this.bitField0_ &= 0xFFFFFFFB;
                    } else {
                        this.ensureCategoryFiltersIsMutable();
                        this.categoryFilters_.addAll((Collection)other.categoryFilters_);
                    }
                    this.onChanged();
                }
                if (!other.labelFilters_.isEmpty()) {
                    if (this.labelFilters_.isEmpty()) {
                        this.labelFilters_ = other.labelFilters_;
                        this.bitField0_ &= 0xFFFFFFF7;
                    } else {
                        this.ensureLabelFiltersIsMutable();
                        this.labelFilters_.addAll((Collection)other.labelFilters_);
                    }
                    this.onChanged();
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block14: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block14;
                            }
                            case 10: {
                                input.readMessage((MessageLite.Builder)this.getOauthInfoFieldBuilder().getBuilder(), extensionRegistry);
                                continue block14;
                            }
                            case 58: {
                                this.emailAddress_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block14;
                            }
                            case 66: {
                                this.businessAccountId_ = input.readStringRequireUtf8();
                                continue block14;
                            }
                            case 74: {
                                this.businessNameFilter_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 2;
                                continue block14;
                            }
                            case 90: {
                                String s = input.readStringRequireUtf8();
                                this.ensureCategoryFiltersIsMutable();
                                this.categoryFilters_.add((Object)s);
                                continue block14;
                            }
                            case 98: {
                                String s = input.readStringRequireUtf8();
                                this.ensureLabelFiltersIsMutable();
                                this.labelFilters_.add((Object)s);
                                continue block14;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public boolean hasOauthInfo() {
                return this.oauthInfoBuilder_ != null || this.oauthInfo_ != null;
            }

            @Override
            public OAuthInfo getOauthInfo() {
                if (this.oauthInfoBuilder_ == null) {
                    return this.oauthInfo_ == null ? OAuthInfo.getDefaultInstance() : this.oauthInfo_;
                }
                return (OAuthInfo)this.oauthInfoBuilder_.getMessage();
            }

            public Builder setOauthInfo(OAuthInfo value) {
                if (this.oauthInfoBuilder_ == null) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.oauthInfo_ = value;
                    this.onChanged();
                } else {
                    this.oauthInfoBuilder_.setMessage((AbstractMessage)value);
                }
                return this;
            }

            public Builder setOauthInfo(OAuthInfo.Builder builderForValue) {
                if (this.oauthInfoBuilder_ == null) {
                    this.oauthInfo_ = builderForValue.build();
                    this.onChanged();
                } else {
                    this.oauthInfoBuilder_.setMessage((AbstractMessage)builderForValue.build());
                }
                return this;
            }

            public Builder mergeOauthInfo(OAuthInfo value) {
                if (this.oauthInfoBuilder_ == null) {
                    this.oauthInfo_ = this.oauthInfo_ != null ? OAuthInfo.newBuilder(this.oauthInfo_).mergeFrom(value).buildPartial() : value;
                    this.onChanged();
                } else {
                    this.oauthInfoBuilder_.mergeFrom((AbstractMessage)value);
                }
                return this;
            }

            public Builder clearOauthInfo() {
                if (this.oauthInfoBuilder_ == null) {
                    this.oauthInfo_ = null;
                    this.onChanged();
                } else {
                    this.oauthInfo_ = null;
                    this.oauthInfoBuilder_ = null;
                }
                return this;
            }

            public OAuthInfo.Builder getOauthInfoBuilder() {
                this.onChanged();
                return (OAuthInfo.Builder)this.getOauthInfoFieldBuilder().getBuilder();
            }

            @Override
            public OAuthInfoOrBuilder getOauthInfoOrBuilder() {
                if (this.oauthInfoBuilder_ != null) {
                    return (OAuthInfoOrBuilder)this.oauthInfoBuilder_.getMessageOrBuilder();
                }
                return this.oauthInfo_ == null ? OAuthInfo.getDefaultInstance() : this.oauthInfo_;
            }

            private SingleFieldBuilderV3<OAuthInfo, OAuthInfo.Builder, OAuthInfoOrBuilder> getOauthInfoFieldBuilder() {
                if (this.oauthInfoBuilder_ == null) {
                    this.oauthInfoBuilder_ = new SingleFieldBuilderV3((AbstractMessage)this.getOauthInfo(), (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                    this.oauthInfo_ = null;
                }
                return this.oauthInfoBuilder_;
            }

            @Override
            public boolean hasEmailAddress() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public String getEmailAddress() {
                Object ref = this.emailAddress_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.emailAddress_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getEmailAddressBytes() {
                Object ref = this.emailAddress_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.emailAddress_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setEmailAddress(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 1;
                this.emailAddress_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearEmailAddress() {
                this.bitField0_ &= 0xFFFFFFFE;
                this.emailAddress_ = PlacesLocationFeedData.getDefaultInstance().getEmailAddress();
                this.onChanged();
                return this;
            }

            public Builder setEmailAddressBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                PlacesLocationFeedData.checkByteStringIsUtf8((ByteString)value);
                this.bitField0_ |= 1;
                this.emailAddress_ = value;
                this.onChanged();
                return this;
            }

            @Override
            public String getBusinessAccountId() {
                Object ref = this.businessAccountId_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.businessAccountId_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getBusinessAccountIdBytes() {
                Object ref = this.businessAccountId_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.businessAccountId_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setBusinessAccountId(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.businessAccountId_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearBusinessAccountId() {
                this.businessAccountId_ = PlacesLocationFeedData.getDefaultInstance().getBusinessAccountId();
                this.onChanged();
                return this;
            }

            public Builder setBusinessAccountIdBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                PlacesLocationFeedData.checkByteStringIsUtf8((ByteString)value);
                this.businessAccountId_ = value;
                this.onChanged();
                return this;
            }

            @Override
            public boolean hasBusinessNameFilter() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public String getBusinessNameFilter() {
                Object ref = this.businessNameFilter_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.businessNameFilter_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getBusinessNameFilterBytes() {
                Object ref = this.businessNameFilter_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.businessNameFilter_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setBusinessNameFilter(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.bitField0_ |= 2;
                this.businessNameFilter_ = value;
                this.onChanged();
                return this;
            }

            public Builder clearBusinessNameFilter() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.businessNameFilter_ = PlacesLocationFeedData.getDefaultInstance().getBusinessNameFilter();
                this.onChanged();
                return this;
            }

            public Builder setBusinessNameFilterBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                PlacesLocationFeedData.checkByteStringIsUtf8((ByteString)value);
                this.bitField0_ |= 2;
                this.businessNameFilter_ = value;
                this.onChanged();
                return this;
            }

            private void ensureCategoryFiltersIsMutable() {
                if ((this.bitField0_ & 4) == 0) {
                    this.categoryFilters_ = new LazyStringArrayList(this.categoryFilters_);
                    this.bitField0_ |= 4;
                }
            }

            public ProtocolStringList getCategoryFiltersList() {
                return this.categoryFilters_.getUnmodifiableView();
            }

            @Override
            public int getCategoryFiltersCount() {
                return this.categoryFilters_.size();
            }

            @Override
            public String getCategoryFilters(int index) {
                return (String)this.categoryFilters_.get(index);
            }

            @Override
            public ByteString getCategoryFiltersBytes(int index) {
                return this.categoryFilters_.getByteString(index);
            }

            public Builder setCategoryFilters(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCategoryFiltersIsMutable();
                this.categoryFilters_.set(index, (Object)value);
                this.onChanged();
                return this;
            }

            public Builder addCategoryFilters(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureCategoryFiltersIsMutable();
                this.categoryFilters_.add((Object)value);
                this.onChanged();
                return this;
            }

            public Builder addAllCategoryFilters(Iterable<String> values) {
                this.ensureCategoryFiltersIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.categoryFilters_);
                this.onChanged();
                return this;
            }

            public Builder clearCategoryFilters() {
                this.categoryFilters_ = LazyStringArrayList.EMPTY;
                this.bitField0_ &= 0xFFFFFFFB;
                this.onChanged();
                return this;
            }

            public Builder addCategoryFiltersBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                PlacesLocationFeedData.checkByteStringIsUtf8((ByteString)value);
                this.ensureCategoryFiltersIsMutable();
                this.categoryFilters_.add(value);
                this.onChanged();
                return this;
            }

            private void ensureLabelFiltersIsMutable() {
                if ((this.bitField0_ & 8) == 0) {
                    this.labelFilters_ = new LazyStringArrayList(this.labelFilters_);
                    this.bitField0_ |= 8;
                }
            }

            public ProtocolStringList getLabelFiltersList() {
                return this.labelFilters_.getUnmodifiableView();
            }

            @Override
            public int getLabelFiltersCount() {
                return this.labelFilters_.size();
            }

            @Override
            public String getLabelFilters(int index) {
                return (String)this.labelFilters_.get(index);
            }

            @Override
            public ByteString getLabelFiltersBytes(int index) {
                return this.labelFilters_.getByteString(index);
            }

            public Builder setLabelFilters(int index, String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLabelFiltersIsMutable();
                this.labelFilters_.set(index, (Object)value);
                this.onChanged();
                return this;
            }

            public Builder addLabelFilters(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureLabelFiltersIsMutable();
                this.labelFilters_.add((Object)value);
                this.onChanged();
                return this;
            }

            public Builder addAllLabelFilters(Iterable<String> values) {
                this.ensureLabelFiltersIsMutable();
                AbstractMessageLite.Builder.addAll(values, (List)this.labelFilters_);
                this.onChanged();
                return this;
            }

            public Builder clearLabelFilters() {
                this.labelFilters_ = LazyStringArrayList.EMPTY;
                this.bitField0_ &= 0xFFFFFFF7;
                this.onChanged();
                return this;
            }

            public Builder addLabelFiltersBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                PlacesLocationFeedData.checkByteStringIsUtf8((ByteString)value);
                this.ensureLabelFiltersIsMutable();
                this.labelFilters_.add(value);
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }

        public static final class OAuthInfo
        extends GeneratedMessageV3
        implements OAuthInfoOrBuilder {
            private static final long serialVersionUID = 0L;
            private int bitField0_;
            public static final int HTTP_METHOD_FIELD_NUMBER = 4;
            private volatile Object httpMethod_;
            public static final int HTTP_REQUEST_URL_FIELD_NUMBER = 5;
            private volatile Object httpRequestUrl_;
            public static final int HTTP_AUTHORIZATION_HEADER_FIELD_NUMBER = 6;
            private volatile Object httpAuthorizationHeader_;
            private byte memoizedIsInitialized = (byte)-1;
            private static final OAuthInfo DEFAULT_INSTANCE = new OAuthInfo();
            private static final Parser<OAuthInfo> PARSER = new AbstractParser<OAuthInfo>(){

                public OAuthInfo parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                    Builder builder = OAuthInfo.newBuilder();
                    try {
                        builder.mergeFrom(input, extensionRegistry);
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (UninitializedMessageException e) {
                        throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    catch (IOException e) {
                        throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                    }
                    return builder.buildPartial();
                }
            };

            private OAuthInfo(GeneratedMessageV3.Builder<?> builder) {
                super(builder);
            }

            private OAuthInfo() {
                this.httpMethod_ = "";
                this.httpRequestUrl_ = "";
                this.httpAuthorizationHeader_ = "";
            }

            protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
                return new OAuthInfo();
            }

            public final UnknownFieldSet getUnknownFields() {
                return this.unknownFields;
            }

            public static final Descriptors.Descriptor getDescriptor() {
                return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_PlacesLocationFeedData_OAuthInfo_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_PlacesLocationFeedData_OAuthInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(OAuthInfo.class, Builder.class);
            }

            @Override
            public boolean hasHttpMethod() {
                return (this.bitField0_ & 1) != 0;
            }

            @Override
            public String getHttpMethod() {
                Object ref = this.httpMethod_;
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.httpMethod_ = s;
                return s;
            }

            @Override
            public ByteString getHttpMethodBytes() {
                Object ref = this.httpMethod_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.httpMethod_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            @Override
            public boolean hasHttpRequestUrl() {
                return (this.bitField0_ & 2) != 0;
            }

            @Override
            public String getHttpRequestUrl() {
                Object ref = this.httpRequestUrl_;
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.httpRequestUrl_ = s;
                return s;
            }

            @Override
            public ByteString getHttpRequestUrlBytes() {
                Object ref = this.httpRequestUrl_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.httpRequestUrl_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            @Override
            public boolean hasHttpAuthorizationHeader() {
                return (this.bitField0_ & 4) != 0;
            }

            @Override
            public String getHttpAuthorizationHeader() {
                Object ref = this.httpAuthorizationHeader_;
                if (ref instanceof String) {
                    return (String)ref;
                }
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.httpAuthorizationHeader_ = s;
                return s;
            }

            @Override
            public ByteString getHttpAuthorizationHeaderBytes() {
                Object ref = this.httpAuthorizationHeader_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.httpAuthorizationHeader_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public final boolean isInitialized() {
                byte isInitialized = this.memoizedIsInitialized;
                if (isInitialized == 1) {
                    return true;
                }
                if (isInitialized == 0) {
                    return false;
                }
                this.memoizedIsInitialized = 1;
                return true;
            }

            public void writeTo(CodedOutputStream output) throws IOException {
                if ((this.bitField0_ & 1) != 0) {
                    GeneratedMessageV3.writeString((CodedOutputStream)output, (int)4, (Object)this.httpMethod_);
                }
                if ((this.bitField0_ & 2) != 0) {
                    GeneratedMessageV3.writeString((CodedOutputStream)output, (int)5, (Object)this.httpRequestUrl_);
                }
                if ((this.bitField0_ & 4) != 0) {
                    GeneratedMessageV3.writeString((CodedOutputStream)output, (int)6, (Object)this.httpAuthorizationHeader_);
                }
                this.getUnknownFields().writeTo(output);
            }

            public int getSerializedSize() {
                int size = this.memoizedSize;
                if (size != -1) {
                    return size;
                }
                size = 0;
                if ((this.bitField0_ & 1) != 0) {
                    size += GeneratedMessageV3.computeStringSize((int)4, (Object)this.httpMethod_);
                }
                if ((this.bitField0_ & 2) != 0) {
                    size += GeneratedMessageV3.computeStringSize((int)5, (Object)this.httpRequestUrl_);
                }
                if ((this.bitField0_ & 4) != 0) {
                    size += GeneratedMessageV3.computeStringSize((int)6, (Object)this.httpAuthorizationHeader_);
                }
                this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
                return size;
            }

            public boolean equals(Object obj) {
                if (obj == this) {
                    return true;
                }
                if (!(obj instanceof OAuthInfo)) {
                    return super.equals(obj);
                }
                OAuthInfo other = (OAuthInfo)obj;
                if (this.hasHttpMethod() != other.hasHttpMethod()) {
                    return false;
                }
                if (this.hasHttpMethod() && !this.getHttpMethod().equals(other.getHttpMethod())) {
                    return false;
                }
                if (this.hasHttpRequestUrl() != other.hasHttpRequestUrl()) {
                    return false;
                }
                if (this.hasHttpRequestUrl() && !this.getHttpRequestUrl().equals(other.getHttpRequestUrl())) {
                    return false;
                }
                if (this.hasHttpAuthorizationHeader() != other.hasHttpAuthorizationHeader()) {
                    return false;
                }
                if (this.hasHttpAuthorizationHeader() && !this.getHttpAuthorizationHeader().equals(other.getHttpAuthorizationHeader())) {
                    return false;
                }
                return this.getUnknownFields().equals((Object)other.getUnknownFields());
            }

            public int hashCode() {
                if (this.memoizedHashCode != 0) {
                    return this.memoizedHashCode;
                }
                int hash = 41;
                hash = 19 * hash + OAuthInfo.getDescriptor().hashCode();
                if (this.hasHttpMethod()) {
                    hash = 37 * hash + 4;
                    hash = 53 * hash + this.getHttpMethod().hashCode();
                }
                if (this.hasHttpRequestUrl()) {
                    hash = 37 * hash + 5;
                    hash = 53 * hash + this.getHttpRequestUrl().hashCode();
                }
                if (this.hasHttpAuthorizationHeader()) {
                    hash = 37 * hash + 6;
                    hash = 53 * hash + this.getHttpAuthorizationHeader().hashCode();
                }
                this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
                return hash;
            }

            public static OAuthInfo parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
                return (OAuthInfo)PARSER.parseFrom(data);
            }

            public static OAuthInfo parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (OAuthInfo)PARSER.parseFrom(data, extensionRegistry);
            }

            public static OAuthInfo parseFrom(ByteString data) throws InvalidProtocolBufferException {
                return (OAuthInfo)PARSER.parseFrom(data);
            }

            public static OAuthInfo parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (OAuthInfo)PARSER.parseFrom(data, extensionRegistry);
            }

            public static OAuthInfo parseFrom(byte[] data) throws InvalidProtocolBufferException {
                return (OAuthInfo)PARSER.parseFrom(data);
            }

            public static OAuthInfo parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                return (OAuthInfo)PARSER.parseFrom(data, extensionRegistry);
            }

            public static OAuthInfo parseFrom(InputStream input) throws IOException {
                return (OAuthInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
            }

            public static OAuthInfo parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (OAuthInfo)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static OAuthInfo parseDelimitedFrom(InputStream input) throws IOException {
                return (OAuthInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
            }

            public static OAuthInfo parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (OAuthInfo)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public static OAuthInfo parseFrom(CodedInputStream input) throws IOException {
                return (OAuthInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
            }

            public static OAuthInfo parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                return (OAuthInfo)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
            }

            public Builder newBuilderForType() {
                return OAuthInfo.newBuilder();
            }

            public static Builder newBuilder() {
                return DEFAULT_INSTANCE.toBuilder();
            }

            public static Builder newBuilder(OAuthInfo prototype) {
                return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
            }

            public Builder toBuilder() {
                return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
            }

            protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
                Builder builder = new Builder(parent);
                return builder;
            }

            public static OAuthInfo getDefaultInstance() {
                return DEFAULT_INSTANCE;
            }

            public static Parser<OAuthInfo> parser() {
                return PARSER;
            }

            public Parser<OAuthInfo> getParserForType() {
                return PARSER;
            }

            public OAuthInfo getDefaultInstanceForType() {
                return DEFAULT_INSTANCE;
            }

            public static final class Builder
            extends GeneratedMessageV3.Builder<Builder>
            implements OAuthInfoOrBuilder {
                private int bitField0_;
                private Object httpMethod_ = "";
                private Object httpRequestUrl_ = "";
                private Object httpAuthorizationHeader_ = "";

                public static final Descriptors.Descriptor getDescriptor() {
                    return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_PlacesLocationFeedData_OAuthInfo_descriptor;
                }

                protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                    return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_PlacesLocationFeedData_OAuthInfo_fieldAccessorTable.ensureFieldAccessorsInitialized(OAuthInfo.class, Builder.class);
                }

                private Builder() {
                }

                private Builder(GeneratedMessageV3.BuilderParent parent) {
                    super(parent);
                }

                public Builder clear() {
                    super.clear();
                    this.httpMethod_ = "";
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.httpRequestUrl_ = "";
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.httpAuthorizationHeader_ = "";
                    this.bitField0_ &= 0xFFFFFFFB;
                    return this;
                }

                public Descriptors.Descriptor getDescriptorForType() {
                    return FeedProto.internal_static_google_ads_googleads_v10_resources_Feed_PlacesLocationFeedData_OAuthInfo_descriptor;
                }

                public OAuthInfo getDefaultInstanceForType() {
                    return OAuthInfo.getDefaultInstance();
                }

                public OAuthInfo build() {
                    OAuthInfo result = this.buildPartial();
                    if (!result.isInitialized()) {
                        throw Builder.newUninitializedMessageException((Message)result);
                    }
                    return result;
                }

                public OAuthInfo buildPartial() {
                    OAuthInfo result = new OAuthInfo(this);
                    int from_bitField0_ = this.bitField0_;
                    int to_bitField0_ = 0;
                    if ((from_bitField0_ & 1) != 0) {
                        to_bitField0_ |= 1;
                    }
                    result.httpMethod_ = this.httpMethod_;
                    if ((from_bitField0_ & 2) != 0) {
                        to_bitField0_ |= 2;
                    }
                    result.httpRequestUrl_ = this.httpRequestUrl_;
                    if ((from_bitField0_ & 4) != 0) {
                        to_bitField0_ |= 4;
                    }
                    result.httpAuthorizationHeader_ = this.httpAuthorizationHeader_;
                    result.bitField0_ = to_bitField0_;
                    this.onBuilt();
                    return result;
                }

                public Builder clone() {
                    return (Builder)super.clone();
                }

                public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.setField(field, value);
                }

                public Builder clearField(Descriptors.FieldDescriptor field) {
                    return (Builder)super.clearField(field);
                }

                public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                    return (Builder)super.clearOneof(oneof);
                }

                public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                    return (Builder)super.setRepeatedField(field, index, value);
                }

                public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                    return (Builder)super.addRepeatedField(field, value);
                }

                public Builder mergeFrom(Message other) {
                    if (other instanceof OAuthInfo) {
                        return this.mergeFrom((OAuthInfo)other);
                    }
                    super.mergeFrom(other);
                    return this;
                }

                public Builder mergeFrom(OAuthInfo other) {
                    if (other == OAuthInfo.getDefaultInstance()) {
                        return this;
                    }
                    if (other.hasHttpMethod()) {
                        this.bitField0_ |= 1;
                        this.httpMethod_ = other.httpMethod_;
                        this.onChanged();
                    }
                    if (other.hasHttpRequestUrl()) {
                        this.bitField0_ |= 2;
                        this.httpRequestUrl_ = other.httpRequestUrl_;
                        this.onChanged();
                    }
                    if (other.hasHttpAuthorizationHeader()) {
                        this.bitField0_ |= 4;
                        this.httpAuthorizationHeader_ = other.httpAuthorizationHeader_;
                        this.onChanged();
                    }
                    this.mergeUnknownFields(other.getUnknownFields());
                    this.onChanged();
                    return this;
                }

                public final boolean isInitialized() {
                    return true;
                }

                public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                    if (extensionRegistry == null) {
                        throw new NullPointerException();
                    }
                    try {
                        boolean done = false;
                        block11: while (!done) {
                            int tag = input.readTag();
                            switch (tag) {
                                case 0: {
                                    done = true;
                                    continue block11;
                                }
                                case 34: {
                                    this.httpMethod_ = input.readStringRequireUtf8();
                                    this.bitField0_ |= 1;
                                    continue block11;
                                }
                                case 42: {
                                    this.httpRequestUrl_ = input.readStringRequireUtf8();
                                    this.bitField0_ |= 2;
                                    continue block11;
                                }
                                case 50: {
                                    this.httpAuthorizationHeader_ = input.readStringRequireUtf8();
                                    this.bitField0_ |= 4;
                                    continue block11;
                                }
                            }
                            if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                            done = true;
                        }
                    }
                    catch (InvalidProtocolBufferException e) {
                        throw e.unwrapIOException();
                    }
                    finally {
                        this.onChanged();
                    }
                    return this;
                }

                @Override
                public boolean hasHttpMethod() {
                    return (this.bitField0_ & 1) != 0;
                }

                @Override
                public String getHttpMethod() {
                    Object ref = this.httpMethod_;
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s = bs.toStringUtf8();
                        this.httpMethod_ = s;
                        return s;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getHttpMethodBytes() {
                    Object ref = this.httpMethod_;
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                        this.httpMethod_ = b;
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setHttpMethod(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.bitField0_ |= 1;
                    this.httpMethod_ = value;
                    this.onChanged();
                    return this;
                }

                public Builder clearHttpMethod() {
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.httpMethod_ = OAuthInfo.getDefaultInstance().getHttpMethod();
                    this.onChanged();
                    return this;
                }

                public Builder setHttpMethodBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    OAuthInfo.checkByteStringIsUtf8((ByteString)value);
                    this.bitField0_ |= 1;
                    this.httpMethod_ = value;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasHttpRequestUrl() {
                    return (this.bitField0_ & 2) != 0;
                }

                @Override
                public String getHttpRequestUrl() {
                    Object ref = this.httpRequestUrl_;
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s = bs.toStringUtf8();
                        this.httpRequestUrl_ = s;
                        return s;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getHttpRequestUrlBytes() {
                    Object ref = this.httpRequestUrl_;
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                        this.httpRequestUrl_ = b;
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setHttpRequestUrl(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.bitField0_ |= 2;
                    this.httpRequestUrl_ = value;
                    this.onChanged();
                    return this;
                }

                public Builder clearHttpRequestUrl() {
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.httpRequestUrl_ = OAuthInfo.getDefaultInstance().getHttpRequestUrl();
                    this.onChanged();
                    return this;
                }

                public Builder setHttpRequestUrlBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    OAuthInfo.checkByteStringIsUtf8((ByteString)value);
                    this.bitField0_ |= 2;
                    this.httpRequestUrl_ = value;
                    this.onChanged();
                    return this;
                }

                @Override
                public boolean hasHttpAuthorizationHeader() {
                    return (this.bitField0_ & 4) != 0;
                }

                @Override
                public String getHttpAuthorizationHeader() {
                    Object ref = this.httpAuthorizationHeader_;
                    if (!(ref instanceof String)) {
                        ByteString bs = (ByteString)ref;
                        String s = bs.toStringUtf8();
                        this.httpAuthorizationHeader_ = s;
                        return s;
                    }
                    return (String)ref;
                }

                @Override
                public ByteString getHttpAuthorizationHeaderBytes() {
                    Object ref = this.httpAuthorizationHeader_;
                    if (ref instanceof String) {
                        ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                        this.httpAuthorizationHeader_ = b;
                        return b;
                    }
                    return (ByteString)ref;
                }

                public Builder setHttpAuthorizationHeader(String value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    this.bitField0_ |= 4;
                    this.httpAuthorizationHeader_ = value;
                    this.onChanged();
                    return this;
                }

                public Builder clearHttpAuthorizationHeader() {
                    this.bitField0_ &= 0xFFFFFFFB;
                    this.httpAuthorizationHeader_ = OAuthInfo.getDefaultInstance().getHttpAuthorizationHeader();
                    this.onChanged();
                    return this;
                }

                public Builder setHttpAuthorizationHeaderBytes(ByteString value) {
                    if (value == null) {
                        throw new NullPointerException();
                    }
                    OAuthInfo.checkByteStringIsUtf8((ByteString)value);
                    this.bitField0_ |= 4;
                    this.httpAuthorizationHeader_ = value;
                    this.onChanged();
                    return this;
                }

                public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.setUnknownFields(unknownFields);
                }

                public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                    return (Builder)super.mergeUnknownFields(unknownFields);
                }
            }
        }

        public static interface OAuthInfoOrBuilder
        extends MessageOrBuilder {
            public boolean hasHttpMethod();

            public String getHttpMethod();

            public ByteString getHttpMethodBytes();

            public boolean hasHttpRequestUrl();

            public String getHttpRequestUrl();

            public ByteString getHttpRequestUrlBytes();

            public boolean hasHttpAuthorizationHeader();

            public String getHttpAuthorizationHeader();

            public ByteString getHttpAuthorizationHeaderBytes();
        }
    }

    public static interface PlacesLocationFeedDataOrBuilder
    extends MessageOrBuilder {
        public boolean hasOauthInfo();

        public PlacesLocationFeedData.OAuthInfo getOauthInfo();

        public PlacesLocationFeedData.OAuthInfoOrBuilder getOauthInfoOrBuilder();

        public boolean hasEmailAddress();

        public String getEmailAddress();

        public ByteString getEmailAddressBytes();

        public String getBusinessAccountId();

        public ByteString getBusinessAccountIdBytes();

        public boolean hasBusinessNameFilter();

        public String getBusinessNameFilter();

        public ByteString getBusinessNameFilterBytes();

        public List<String> getCategoryFiltersList();

        public int getCategoryFiltersCount();

        public String getCategoryFilters(int var1);

        public ByteString getCategoryFiltersBytes(int var1);

        public List<String> getLabelFiltersList();

        public int getLabelFiltersCount();

        public String getLabelFilters(int var1);

        public ByteString getLabelFiltersBytes(int var1);
    }
}

