/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class OfflineUserDataJobName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_OFFLINE_USER_DATA_UPDATE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/offlineUserDataJobs/{offline_user_data_update_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String offlineUserDataUpdateId;

    @Deprecated
    protected OfflineUserDataJobName() {
        this.customerId = null;
        this.offlineUserDataUpdateId = null;
    }

    private OfflineUserDataJobName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.offlineUserDataUpdateId = (String)Preconditions.checkNotNull((Object)builder.getOfflineUserDataUpdateId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getOfflineUserDataUpdateId() {
        return this.offlineUserDataUpdateId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static OfflineUserDataJobName of(String customerId, String offlineUserDataUpdateId) {
        return OfflineUserDataJobName.newBuilder().setCustomerId(customerId).setOfflineUserDataUpdateId(offlineUserDataUpdateId).build();
    }

    public static String format(String customerId, String offlineUserDataUpdateId) {
        return OfflineUserDataJobName.newBuilder().setCustomerId(customerId).setOfflineUserDataUpdateId(offlineUserDataUpdateId).build().toString();
    }

    public static OfflineUserDataJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_OFFLINE_USER_DATA_UPDATE_ID.validatedMatch(formattedString, "OfflineUserDataJobName.parse: formattedString not in valid format");
        return OfflineUserDataJobName.of((String)matchMap.get("customer_id"), (String)matchMap.get("offline_user_data_update_id"));
    }

    public static List<OfflineUserDataJobName> parseList(List<String> formattedStrings) {
        ArrayList<OfflineUserDataJobName> list = new ArrayList<OfflineUserDataJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(OfflineUserDataJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<OfflineUserDataJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (OfflineUserDataJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_OFFLINE_USER_DATA_UPDATE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            OfflineUserDataJobName offlineUserDataJobName = this;
            synchronized (offlineUserDataJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.offlineUserDataUpdateId != null) {
                        fieldMapBuilder.put((Object)"offline_user_data_update_id", (Object)this.offlineUserDataUpdateId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_OFFLINE_USER_DATA_UPDATE_ID.instantiate(new String[]{"customer_id", this.customerId, "offline_user_data_update_id", this.offlineUserDataUpdateId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            OfflineUserDataJobName that = (OfflineUserDataJobName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.offlineUserDataUpdateId, that.offlineUserDataUpdateId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.offlineUserDataUpdateId);
    }

    public static class Builder {
        private String customerId;
        private String offlineUserDataUpdateId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getOfflineUserDataUpdateId() {
            return this.offlineUserDataUpdateId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setOfflineUserDataUpdateId(String offlineUserDataUpdateId) {
            this.offlineUserDataUpdateId = offlineUserDataUpdateId;
            return this;
        }

        private Builder(OfflineUserDataJobName offlineUserDataJobName) {
            this.customerId = offlineUserDataJobName.customerId;
            this.offlineUserDataUpdateId = offlineUserDataJobName.offlineUserDataUpdateId;
        }

        public OfflineUserDataJobName build() {
            return new OfflineUserDataJobName(this);
        }
    }
}

