/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.services;

import com.google.ads.googleads.v10.services.AdGroupAdLabelOperation;
import com.google.ads.googleads.v10.services.AdGroupAdLabelServiceSettings;
import com.google.ads.googleads.v10.services.MutateAdGroupAdLabelsRequest;
import com.google.ads.googleads.v10.services.MutateAdGroupAdLabelsResponse;
import com.google.ads.googleads.v10.services.stub.AdGroupAdLabelServiceStub;
import com.google.ads.googleads.v10.services.stub.AdGroupAdLabelServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupAdLabelServiceClient
implements BackgroundResource {
    private final AdGroupAdLabelServiceSettings settings;
    private final AdGroupAdLabelServiceStub stub;

    public static final AdGroupAdLabelServiceClient create() throws IOException {
        return AdGroupAdLabelServiceClient.create(AdGroupAdLabelServiceSettings.newBuilder().build());
    }

    public static final AdGroupAdLabelServiceClient create(AdGroupAdLabelServiceSettings settings) throws IOException {
        return new AdGroupAdLabelServiceClient(settings);
    }

    public static final AdGroupAdLabelServiceClient create(AdGroupAdLabelServiceStub stub) {
        return new AdGroupAdLabelServiceClient(stub);
    }

    protected AdGroupAdLabelServiceClient(AdGroupAdLabelServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupAdLabelServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdGroupAdLabelServiceClient(AdGroupAdLabelServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupAdLabelServiceSettings getSettings() {
        return this.settings;
    }

    public AdGroupAdLabelServiceStub getStub() {
        return this.stub;
    }

    public final MutateAdGroupAdLabelsResponse mutateAdGroupAdLabels(String customerId, List<AdGroupAdLabelOperation> operations) {
        MutateAdGroupAdLabelsRequest request = MutateAdGroupAdLabelsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupAdLabels(request);
    }

    public final MutateAdGroupAdLabelsResponse mutateAdGroupAdLabels(MutateAdGroupAdLabelsRequest request) {
        return (MutateAdGroupAdLabelsResponse)this.mutateAdGroupAdLabelsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupAdLabelsRequest, MutateAdGroupAdLabelsResponse> mutateAdGroupAdLabelsCallable() {
        return this.stub.mutateAdGroupAdLabelsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

