/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.services;

import com.google.ads.googleads.v10.services.AdGroupExtensionSettingOperation;
import com.google.ads.googleads.v10.services.AdGroupExtensionSettingServiceSettings;
import com.google.ads.googleads.v10.services.MutateAdGroupExtensionSettingsRequest;
import com.google.ads.googleads.v10.services.MutateAdGroupExtensionSettingsResponse;
import com.google.ads.googleads.v10.services.stub.AdGroupExtensionSettingServiceStub;
import com.google.ads.googleads.v10.services.stub.AdGroupExtensionSettingServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupExtensionSettingServiceClient
implements BackgroundResource {
    private final AdGroupExtensionSettingServiceSettings settings;
    private final AdGroupExtensionSettingServiceStub stub;

    public static final AdGroupExtensionSettingServiceClient create() throws IOException {
        return AdGroupExtensionSettingServiceClient.create(AdGroupExtensionSettingServiceSettings.newBuilder().build());
    }

    public static final AdGroupExtensionSettingServiceClient create(AdGroupExtensionSettingServiceSettings settings) throws IOException {
        return new AdGroupExtensionSettingServiceClient(settings);
    }

    public static final AdGroupExtensionSettingServiceClient create(AdGroupExtensionSettingServiceStub stub) {
        return new AdGroupExtensionSettingServiceClient(stub);
    }

    protected AdGroupExtensionSettingServiceClient(AdGroupExtensionSettingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupExtensionSettingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdGroupExtensionSettingServiceClient(AdGroupExtensionSettingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupExtensionSettingServiceSettings getSettings() {
        return this.settings;
    }

    public AdGroupExtensionSettingServiceStub getStub() {
        return this.stub;
    }

    public final MutateAdGroupExtensionSettingsResponse mutateAdGroupExtensionSettings(String customerId, List<AdGroupExtensionSettingOperation> operations) {
        MutateAdGroupExtensionSettingsRequest request = MutateAdGroupExtensionSettingsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroupExtensionSettings(request);
    }

    public final MutateAdGroupExtensionSettingsResponse mutateAdGroupExtensionSettings(MutateAdGroupExtensionSettingsRequest request) {
        return (MutateAdGroupExtensionSettingsResponse)this.mutateAdGroupExtensionSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupExtensionSettingsRequest, MutateAdGroupExtensionSettingsResponse> mutateAdGroupExtensionSettingsCallable() {
        return this.stub.mutateAdGroupExtensionSettingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

