/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.services;

import com.google.ads.googleads.v10.services.AdGroupOperation;
import com.google.ads.googleads.v10.services.AdGroupServiceSettings;
import com.google.ads.googleads.v10.services.MutateAdGroupsRequest;
import com.google.ads.googleads.v10.services.MutateAdGroupsResponse;
import com.google.ads.googleads.v10.services.stub.AdGroupServiceStub;
import com.google.ads.googleads.v10.services.stub.AdGroupServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdGroupServiceClient
implements BackgroundResource {
    private final AdGroupServiceSettings settings;
    private final AdGroupServiceStub stub;

    public static final AdGroupServiceClient create() throws IOException {
        return AdGroupServiceClient.create(AdGroupServiceSettings.newBuilder().build());
    }

    public static final AdGroupServiceClient create(AdGroupServiceSettings settings) throws IOException {
        return new AdGroupServiceClient(settings);
    }

    public static final AdGroupServiceClient create(AdGroupServiceStub stub) {
        return new AdGroupServiceClient(stub);
    }

    protected AdGroupServiceClient(AdGroupServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdGroupServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdGroupServiceClient(AdGroupServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdGroupServiceSettings getSettings() {
        return this.settings;
    }

    public AdGroupServiceStub getStub() {
        return this.stub;
    }

    public final MutateAdGroupsResponse mutateAdGroups(String customerId, List<AdGroupOperation> operations) {
        MutateAdGroupsRequest request = MutateAdGroupsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAdGroups(request);
    }

    public final MutateAdGroupsResponse mutateAdGroups(MutateAdGroupsRequest request) {
        return (MutateAdGroupsResponse)this.mutateAdGroupsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdGroupsRequest, MutateAdGroupsResponse> mutateAdGroupsCallable() {
        return this.stub.mutateAdGroupsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

