/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.services;

import com.google.ads.googleads.v10.resources.Ad;
import com.google.ads.googleads.v10.resources.AdName;
import com.google.ads.googleads.v10.services.AdOperation;
import com.google.ads.googleads.v10.services.AdServiceSettings;
import com.google.ads.googleads.v10.services.GetAdRequest;
import com.google.ads.googleads.v10.services.MutateAdsRequest;
import com.google.ads.googleads.v10.services.MutateAdsResponse;
import com.google.ads.googleads.v10.services.stub.AdServiceStub;
import com.google.ads.googleads.v10.services.stub.AdServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class AdServiceClient
implements BackgroundResource {
    private final AdServiceSettings settings;
    private final AdServiceStub stub;

    public static final AdServiceClient create() throws IOException {
        return AdServiceClient.create(AdServiceSettings.newBuilder().build());
    }

    public static final AdServiceClient create(AdServiceSettings settings) throws IOException {
        return new AdServiceClient(settings);
    }

    public static final AdServiceClient create(AdServiceStub stub) {
        return new AdServiceClient(stub);
    }

    protected AdServiceClient(AdServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((AdServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected AdServiceClient(AdServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final AdServiceSettings getSettings() {
        return this.settings;
    }

    public AdServiceStub getStub() {
        return this.stub;
    }

    public final Ad getAd(AdName resourceName) {
        GetAdRequest request = GetAdRequest.newBuilder().setResourceName(resourceName == null ? null : resourceName.toString()).build();
        return this.getAd(request);
    }

    public final Ad getAd(String resourceName) {
        GetAdRequest request = GetAdRequest.newBuilder().setResourceName(resourceName).build();
        return this.getAd(request);
    }

    public final Ad getAd(GetAdRequest request) {
        return (Ad)this.getAdCallable().call((Object)request);
    }

    public final UnaryCallable<GetAdRequest, Ad> getAdCallable() {
        return this.stub.getAdCallable();
    }

    public final MutateAdsResponse mutateAds(String customerId, List<AdOperation> operations) {
        MutateAdsRequest request = MutateAdsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateAds(request);
    }

    public final MutateAdsResponse mutateAds(MutateAdsRequest request) {
        return (MutateAdsResponse)this.mutateAdsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateAdsRequest, MutateAdsResponse> mutateAdsCallable() {
        return this.stub.mutateAdsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

