/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.services;

import com.google.ads.googleads.v10.services.CustomerExtensionSettingOperation;
import com.google.ads.googleads.v10.services.CustomerExtensionSettingServiceSettings;
import com.google.ads.googleads.v10.services.MutateCustomerExtensionSettingsRequest;
import com.google.ads.googleads.v10.services.MutateCustomerExtensionSettingsResponse;
import com.google.ads.googleads.v10.services.stub.CustomerExtensionSettingServiceStub;
import com.google.ads.googleads.v10.services.stub.CustomerExtensionSettingServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CustomerExtensionSettingServiceClient
implements BackgroundResource {
    private final CustomerExtensionSettingServiceSettings settings;
    private final CustomerExtensionSettingServiceStub stub;

    public static final CustomerExtensionSettingServiceClient create() throws IOException {
        return CustomerExtensionSettingServiceClient.create(CustomerExtensionSettingServiceSettings.newBuilder().build());
    }

    public static final CustomerExtensionSettingServiceClient create(CustomerExtensionSettingServiceSettings settings) throws IOException {
        return new CustomerExtensionSettingServiceClient(settings);
    }

    public static final CustomerExtensionSettingServiceClient create(CustomerExtensionSettingServiceStub stub) {
        return new CustomerExtensionSettingServiceClient(stub);
    }

    protected CustomerExtensionSettingServiceClient(CustomerExtensionSettingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((CustomerExtensionSettingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected CustomerExtensionSettingServiceClient(CustomerExtensionSettingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final CustomerExtensionSettingServiceSettings getSettings() {
        return this.settings;
    }

    public CustomerExtensionSettingServiceStub getStub() {
        return this.stub;
    }

    public final MutateCustomerExtensionSettingsResponse mutateCustomerExtensionSettings(String customerId, List<CustomerExtensionSettingOperation> operations) {
        MutateCustomerExtensionSettingsRequest request = MutateCustomerExtensionSettingsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateCustomerExtensionSettings(request);
    }

    public final MutateCustomerExtensionSettingsResponse mutateCustomerExtensionSettings(MutateCustomerExtensionSettingsRequest request) {
        return (MutateCustomerExtensionSettingsResponse)this.mutateCustomerExtensionSettingsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateCustomerExtensionSettingsRequest, MutateCustomerExtensionSettingsResponse> mutateCustomerExtensionSettingsCallable() {
        return this.stub.mutateCustomerExtensionSettingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

