/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.services;

import com.google.ads.googleads.v10.services.FeedMappingOperation;
import com.google.ads.googleads.v10.services.FeedMappingServiceSettings;
import com.google.ads.googleads.v10.services.MutateFeedMappingsRequest;
import com.google.ads.googleads.v10.services.MutateFeedMappingsResponse;
import com.google.ads.googleads.v10.services.stub.FeedMappingServiceStub;
import com.google.ads.googleads.v10.services.stub.FeedMappingServiceStubSettings;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.rpc.UnaryCallable;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class FeedMappingServiceClient
implements BackgroundResource {
    private final FeedMappingServiceSettings settings;
    private final FeedMappingServiceStub stub;

    public static final FeedMappingServiceClient create() throws IOException {
        return FeedMappingServiceClient.create(FeedMappingServiceSettings.newBuilder().build());
    }

    public static final FeedMappingServiceClient create(FeedMappingServiceSettings settings) throws IOException {
        return new FeedMappingServiceClient(settings);
    }

    public static final FeedMappingServiceClient create(FeedMappingServiceStub stub) {
        return new FeedMappingServiceClient(stub);
    }

    protected FeedMappingServiceClient(FeedMappingServiceSettings settings) throws IOException {
        this.settings = settings;
        this.stub = ((FeedMappingServiceStubSettings)settings.getStubSettings()).createStub();
    }

    protected FeedMappingServiceClient(FeedMappingServiceStub stub) {
        this.settings = null;
        this.stub = stub;
    }

    public final FeedMappingServiceSettings getSettings() {
        return this.settings;
    }

    public FeedMappingServiceStub getStub() {
        return this.stub;
    }

    public final MutateFeedMappingsResponse mutateFeedMappings(String customerId, List<FeedMappingOperation> operations) {
        MutateFeedMappingsRequest request = MutateFeedMappingsRequest.newBuilder().setCustomerId(customerId).addAllOperations(operations).build();
        return this.mutateFeedMappings(request);
    }

    public final MutateFeedMappingsResponse mutateFeedMappings(MutateFeedMappingsRequest request) {
        return (MutateFeedMappingsResponse)this.mutateFeedMappingsCallable().call((Object)request);
    }

    public final UnaryCallable<MutateFeedMappingsRequest, MutateFeedMappingsResponse> mutateFeedMappingsCallable() {
        return this.stub.mutateFeedMappingsCallable();
    }

    public final void close() {
        this.stub.close();
    }

    public void shutdown() {
        this.stub.shutdown();
    }

    public boolean isShutdown() {
        return this.stub.isShutdown();
    }

    public boolean isTerminated() {
        return this.stub.isTerminated();
    }

    public void shutdownNow() {
        this.stub.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.stub.awaitTermination(duration, unit);
    }
}

