/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v10.services.stub;

import com.google.ads.googleads.v10.services.EndExperimentRequest;
import com.google.ads.googleads.v10.services.ExperimentServiceClient;
import com.google.ads.googleads.v10.services.GraduateExperimentRequest;
import com.google.ads.googleads.v10.services.ListExperimentAsyncErrorsRequest;
import com.google.ads.googleads.v10.services.ListExperimentAsyncErrorsResponse;
import com.google.ads.googleads.v10.services.MutateExperimentsRequest;
import com.google.ads.googleads.v10.services.MutateExperimentsResponse;
import com.google.ads.googleads.v10.services.PromoteExperimentMetadata;
import com.google.ads.googleads.v10.services.PromoteExperimentRequest;
import com.google.ads.googleads.v10.services.ScheduleExperimentMetadata;
import com.google.ads.googleads.v10.services.ScheduleExperimentRequest;
import com.google.ads.googleads.v10.services.stub.ExperimentServiceStub;
import com.google.ads.googleads.v10.services.stub.GrpcExperimentServiceStub;
import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.grpc.GaxGrpcProperties;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.grpc.InstantiatingGrpcChannelProvider;
import com.google.api.gax.grpc.ProtoOperationTransformers;
import com.google.api.gax.longrunning.OperationTimedPollAlgorithm;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.retrying.TimedRetryAlgorithm;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.OperationCallSettings;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import com.google.longrunning.Operation;
import com.google.protobuf.Empty;
import com.google.rpc.Status;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

public class ExperimentServiceStubSettings
extends StubSettings<ExperimentServiceStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/adwords").build();
    private final UnaryCallSettings<MutateExperimentsRequest, MutateExperimentsResponse> mutateExperimentsSettings;
    private final UnaryCallSettings<EndExperimentRequest, Empty> endExperimentSettings;
    private final PagedCallSettings<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, ExperimentServiceClient.ListExperimentAsyncErrorsPagedResponse> listExperimentAsyncErrorsSettings;
    private final UnaryCallSettings<GraduateExperimentRequest, Empty> graduateExperimentSettings;
    private final UnaryCallSettings<ScheduleExperimentRequest, Operation> scheduleExperimentSettings;
    private final OperationCallSettings<ScheduleExperimentRequest, Empty, ScheduleExperimentMetadata> scheduleExperimentOperationSettings;
    private final UnaryCallSettings<PromoteExperimentRequest, Operation> promoteExperimentSettings;
    private final OperationCallSettings<PromoteExperimentRequest, Empty, PromoteExperimentMetadata> promoteExperimentOperationSettings;
    private static final PagedListDescriptor<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, Status> LIST_EXPERIMENT_ASYNC_ERRORS_PAGE_STR_DESC = new PagedListDescriptor<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, Status>(){

        public String emptyToken() {
            return "";
        }

        public ListExperimentAsyncErrorsRequest injectToken(ListExperimentAsyncErrorsRequest payload, String token) {
            return ListExperimentAsyncErrorsRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListExperimentAsyncErrorsRequest injectPageSize(ListExperimentAsyncErrorsRequest payload, int pageSize) {
            return ListExperimentAsyncErrorsRequest.newBuilder(payload).setPageSize(pageSize).build();
        }

        public Integer extractPageSize(ListExperimentAsyncErrorsRequest payload) {
            return payload.getPageSize();
        }

        public String extractNextToken(ListExperimentAsyncErrorsResponse payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Status> extractResources(ListExperimentAsyncErrorsResponse payload) {
            return payload.getErrorsList() == null ? ImmutableList.of() : payload.getErrorsList();
        }
    };
    private static final PagedListResponseFactory<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, ExperimentServiceClient.ListExperimentAsyncErrorsPagedResponse> LIST_EXPERIMENT_ASYNC_ERRORS_PAGE_STR_FACT = new PagedListResponseFactory<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, ExperimentServiceClient.ListExperimentAsyncErrorsPagedResponse>(){

        public ApiFuture<ExperimentServiceClient.ListExperimentAsyncErrorsPagedResponse> getFuturePagedResponse(UnaryCallable<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse> callable, ListExperimentAsyncErrorsRequest request, ApiCallContext context, ApiFuture<ListExperimentAsyncErrorsResponse> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_EXPERIMENT_ASYNC_ERRORS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return ExperimentServiceClient.ListExperimentAsyncErrorsPagedResponse.createAsync((PageContext<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, Status>)pageContext, futureResponse);
        }
    };

    public UnaryCallSettings<MutateExperimentsRequest, MutateExperimentsResponse> mutateExperimentsSettings() {
        return this.mutateExperimentsSettings;
    }

    public UnaryCallSettings<EndExperimentRequest, Empty> endExperimentSettings() {
        return this.endExperimentSettings;
    }

    public PagedCallSettings<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, ExperimentServiceClient.ListExperimentAsyncErrorsPagedResponse> listExperimentAsyncErrorsSettings() {
        return this.listExperimentAsyncErrorsSettings;
    }

    public UnaryCallSettings<GraduateExperimentRequest, Empty> graduateExperimentSettings() {
        return this.graduateExperimentSettings;
    }

    public UnaryCallSettings<ScheduleExperimentRequest, Operation> scheduleExperimentSettings() {
        return this.scheduleExperimentSettings;
    }

    public OperationCallSettings<ScheduleExperimentRequest, Empty, ScheduleExperimentMetadata> scheduleExperimentOperationSettings() {
        return this.scheduleExperimentOperationSettings;
    }

    public UnaryCallSettings<PromoteExperimentRequest, Operation> promoteExperimentSettings() {
        return this.promoteExperimentSettings;
    }

    public OperationCallSettings<PromoteExperimentRequest, Empty, PromoteExperimentMetadata> promoteExperimentOperationSettings() {
        return this.promoteExperimentOperationSettings;
    }

    public ExperimentServiceStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(GrpcTransportChannel.getGrpcTransportName())) {
            return GrpcExperimentServiceStub.create(this);
        }
        throw new UnsupportedOperationException(String.format("Transport not supported: %s", this.getTransportChannelProvider().getTransportName()));
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "googleads.googleapis.com:443";
    }

    public static String getDefaultMtlsEndpoint() {
        return "googleads.mtls.googleapis.com:443";
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES).setUseJwtAccessWithScope(true);
    }

    public static InstantiatingGrpcChannelProvider.Builder defaultGrpcTransportProviderBuilder() {
        return InstantiatingGrpcChannelProvider.newBuilder().setMaxInboundMessageSize(Integer.valueOf(Integer.MAX_VALUE));
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return ExperimentServiceStubSettings.defaultGrpcTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(ExperimentServiceStubSettings.class)).setTransportToken(GaxGrpcProperties.getGrpcTokenName(), GaxGrpcProperties.getGrpcVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected ExperimentServiceStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.mutateExperimentsSettings = settingsBuilder.mutateExperimentsSettings().build();
        this.endExperimentSettings = settingsBuilder.endExperimentSettings().build();
        this.listExperimentAsyncErrorsSettings = settingsBuilder.listExperimentAsyncErrorsSettings().build();
        this.graduateExperimentSettings = settingsBuilder.graduateExperimentSettings().build();
        this.scheduleExperimentSettings = settingsBuilder.scheduleExperimentSettings().build();
        this.scheduleExperimentOperationSettings = settingsBuilder.scheduleExperimentOperationSettings().build();
        this.promoteExperimentSettings = settingsBuilder.promoteExperimentSettings().build();
        this.promoteExperimentOperationSettings = settingsBuilder.promoteExperimentOperationSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<ExperimentServiceStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final UnaryCallSettings.Builder<MutateExperimentsRequest, MutateExperimentsResponse> mutateExperimentsSettings;
        private final UnaryCallSettings.Builder<EndExperimentRequest, Empty> endExperimentSettings;
        private final PagedCallSettings.Builder<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, ExperimentServiceClient.ListExperimentAsyncErrorsPagedResponse> listExperimentAsyncErrorsSettings;
        private final UnaryCallSettings.Builder<GraduateExperimentRequest, Empty> graduateExperimentSettings;
        private final UnaryCallSettings.Builder<ScheduleExperimentRequest, Operation> scheduleExperimentSettings;
        private final OperationCallSettings.Builder<ScheduleExperimentRequest, Empty, ScheduleExperimentMetadata> scheduleExperimentOperationSettings;
        private final UnaryCallSettings.Builder<PromoteExperimentRequest, Operation> promoteExperimentSettings;
        private final OperationCallSettings.Builder<PromoteExperimentRequest, Empty, PromoteExperimentMetadata> promoteExperimentOperationSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.mutateExperimentsSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.endExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listExperimentAsyncErrorsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_EXPERIMENT_ASYNC_ERRORS_PAGE_STR_FACT);
            this.graduateExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.scheduleExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.scheduleExperimentOperationSettings = OperationCallSettings.newBuilder();
            this.promoteExperimentSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.promoteExperimentOperationSettings = OperationCallSettings.newBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.mutateExperimentsSettings, this.endExperimentSettings, this.listExperimentAsyncErrorsSettings, this.graduateExperimentSettings, this.scheduleExperimentSettings, this.promoteExperimentSettings);
            Builder.initDefaults(this);
        }

        protected Builder(ExperimentServiceStubSettings settings) {
            super((StubSettings)settings);
            this.mutateExperimentsSettings = settings.mutateExperimentsSettings.toBuilder();
            this.endExperimentSettings = settings.endExperimentSettings.toBuilder();
            this.listExperimentAsyncErrorsSettings = settings.listExperimentAsyncErrorsSettings.toBuilder();
            this.graduateExperimentSettings = settings.graduateExperimentSettings.toBuilder();
            this.scheduleExperimentSettings = settings.scheduleExperimentSettings.toBuilder();
            this.scheduleExperimentOperationSettings = settings.scheduleExperimentOperationSettings.toBuilder();
            this.promoteExperimentSettings = settings.promoteExperimentSettings.toBuilder();
            this.promoteExperimentOperationSettings = settings.promoteExperimentOperationSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.mutateExperimentsSettings, this.endExperimentSettings, this.listExperimentAsyncErrorsSettings, this.graduateExperimentSettings, this.scheduleExperimentSettings, this.promoteExperimentSettings);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(ExperimentServiceStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)ExperimentServiceStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)ExperimentServiceStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(ExperimentServiceStubSettings.getDefaultEndpoint());
            builder.setMtlsEndpoint(ExperimentServiceStubSettings.getDefaultMtlsEndpoint());
            builder.setSwitchToMtlsEndpointAllowed(true);
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.mutateExperimentsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.endExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.listExperimentAsyncErrorsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.graduateExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.scheduleExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.promoteExperimentSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params"));
            builder.scheduleExperimentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(ScheduleExperimentMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            builder.promoteExperimentOperationSettings().setInitialCallSettings(UnaryCallSettings.newUnaryCallSettingsBuilder().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"retry_policy_0_codes")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"retry_policy_0_params")).build()).setResponseTransformer((ApiFunction)ProtoOperationTransformers.ResponseTransformer.create(Empty.class)).setMetadataTransformer((ApiFunction)ProtoOperationTransformers.MetadataTransformer.create(PromoteExperimentMetadata.class)).setPollingAlgorithm((TimedRetryAlgorithm)OperationTimedPollAlgorithm.create((RetrySettings)RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.5).setMaxRetryDelay(Duration.ofMillis((long)45000L)).setInitialRpcTimeout(Duration.ZERO).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ZERO).setTotalTimeout(Duration.ofMillis((long)300000L)).build()));
            return builder;
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public UnaryCallSettings.Builder<MutateExperimentsRequest, MutateExperimentsResponse> mutateExperimentsSettings() {
            return this.mutateExperimentsSettings;
        }

        public UnaryCallSettings.Builder<EndExperimentRequest, Empty> endExperimentSettings() {
            return this.endExperimentSettings;
        }

        public PagedCallSettings.Builder<ListExperimentAsyncErrorsRequest, ListExperimentAsyncErrorsResponse, ExperimentServiceClient.ListExperimentAsyncErrorsPagedResponse> listExperimentAsyncErrorsSettings() {
            return this.listExperimentAsyncErrorsSettings;
        }

        public UnaryCallSettings.Builder<GraduateExperimentRequest, Empty> graduateExperimentSettings() {
            return this.graduateExperimentSettings;
        }

        public UnaryCallSettings.Builder<ScheduleExperimentRequest, Operation> scheduleExperimentSettings() {
            return this.scheduleExperimentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<ScheduleExperimentRequest, Empty, ScheduleExperimentMetadata> scheduleExperimentOperationSettings() {
            return this.scheduleExperimentOperationSettings;
        }

        public UnaryCallSettings.Builder<PromoteExperimentRequest, Operation> promoteExperimentSettings() {
            return this.promoteExperimentSettings;
        }

        @BetaApi(value="The surface for use by generated code is not stable yet and may change in the future.")
        public OperationCallSettings.Builder<PromoteExperimentRequest, Empty, PromoteExperimentMetadata> promoteExperimentOperationSettings() {
            return this.promoteExperimentOperationSettings;
        }

        public ExperimentServiceStubSettings build() throws IOException {
            return new ExperimentServiceStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"retry_policy_0_codes", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.UNAVAILABLE, StatusCode.Code.DEADLINE_EXCEEDED})));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)5000L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)14400000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)14400000L)).setTotalTimeout(Duration.ofMillis((long)14400000L)).build();
            definitions.put((Object)"retry_policy_0_params", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

