// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v13/resources/ad_group_ad.proto

package com.google.ads.googleads.v13.resources;

/**
 * <pre>
 * An ad group ad.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v13.resources.AdGroupAd}
 */
public final class AdGroupAd extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v13.resources.AdGroupAd)
    AdGroupAdOrBuilder {
private static final long serialVersionUID = 0L;
  // Use AdGroupAd.newBuilder() to construct.
  private AdGroupAd(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private AdGroupAd() {
    resourceName_ = "";
    status_ = 0;
    adGroup_ = "";
    adStrength_ = 0;
    actionItems_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    labels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new AdGroupAd();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v13.resources.AdGroupAdProto.internal_static_google_ads_googleads_v13_resources_AdGroupAd_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v13.resources.AdGroupAdProto.internal_static_google_ads_googleads_v13_resources_AdGroupAd_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v13.resources.AdGroupAd.class, com.google.ads.googleads.v13.resources.AdGroupAd.Builder.class);
  }

  private int bitField0_;
  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Immutable. The resource name of the ad.
   * Ad group ad resource names have the form:
   *
   * `customers/{customer_id}/adGroupAds/{ad_group_id}~{ad_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The resource name of the ad.
   * Ad group ad resource names have the form:
   *
   * `customers/{customer_id}/adGroupAds/{ad_group_id}~{ad_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 3;
  private int status_ = 0;
  /**
   * <pre>
   * The status of the ad.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus status = 3;</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * The status of the ad.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus status = 3;</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus getStatus() {
    com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus result = com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus.UNRECOGNIZED : result;
  }

  public static final int AD_GROUP_FIELD_NUMBER = 9;
  @SuppressWarnings("serial")
  private volatile java.lang.Object adGroup_ = "";
  /**
   * <pre>
   * Immutable. The ad group to which the ad belongs.
   * </pre>
   *
   * <code>optional string ad_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the adGroup field is set.
   */
  @java.lang.Override
  public boolean hasAdGroup() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Immutable. The ad group to which the ad belongs.
   * </pre>
   *
   * <code>optional string ad_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The adGroup.
   */
  @java.lang.Override
  public java.lang.String getAdGroup() {
    java.lang.Object ref = adGroup_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      adGroup_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Immutable. The ad group to which the ad belongs.
   * </pre>
   *
   * <code>optional string ad_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for adGroup.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getAdGroupBytes() {
    java.lang.Object ref = adGroup_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      adGroup_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int AD_FIELD_NUMBER = 5;
  private com.google.ads.googleads.v13.resources.Ad ad_;
  /**
   * <pre>
   * Immutable. The ad.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return Whether the ad field is set.
   */
  @java.lang.Override
  public boolean hasAd() {
    return ad_ != null;
  }
  /**
   * <pre>
   * Immutable. The ad.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   * @return The ad.
   */
  @java.lang.Override
  public com.google.ads.googleads.v13.resources.Ad getAd() {
    return ad_ == null ? com.google.ads.googleads.v13.resources.Ad.getDefaultInstance() : ad_;
  }
  /**
   * <pre>
   * Immutable. The ad.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v13.resources.AdOrBuilder getAdOrBuilder() {
    return ad_ == null ? com.google.ads.googleads.v13.resources.Ad.getDefaultInstance() : ad_;
  }

  public static final int POLICY_SUMMARY_FIELD_NUMBER = 6;
  private com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policySummary_;
  /**
   * <pre>
   * Output only. Policy information for the ad.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the policySummary field is set.
   */
  @java.lang.Override
  public boolean hasPolicySummary() {
    return policySummary_ != null;
  }
  /**
   * <pre>
   * Output only. Policy information for the ad.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The policySummary.
   */
  @java.lang.Override
  public com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary getPolicySummary() {
    return policySummary_ == null ? com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary.getDefaultInstance() : policySummary_;
  }
  /**
   * <pre>
   * Output only. Policy information for the ad.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   */
  @java.lang.Override
  public com.google.ads.googleads.v13.resources.AdGroupAdPolicySummaryOrBuilder getPolicySummaryOrBuilder() {
    return policySummary_ == null ? com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary.getDefaultInstance() : policySummary_;
  }

  public static final int AD_STRENGTH_FIELD_NUMBER = 7;
  private int adStrength_ = 0;
  /**
   * <pre>
   * Output only. Overall ad strength for this ad group ad.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength ad_strength = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for adStrength.
   */
  @java.lang.Override public int getAdStrengthValue() {
    return adStrength_;
  }
  /**
   * <pre>
   * Output only. Overall ad strength for this ad group ad.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength ad_strength = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The adStrength.
   */
  @java.lang.Override public com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength getAdStrength() {
    com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength result = com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength.forNumber(adStrength_);
    return result == null ? com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength.UNRECOGNIZED : result;
  }

  public static final int ACTION_ITEMS_FIELD_NUMBER = 13;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList actionItems_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Output only. A list of recommendations to improve the ad strength. For
   * example, a recommendation could be "Your headlines are a little too
   * similar. Try adding more distinct headlines.".
   * </pre>
   *
   * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return A list containing the actionItems.
   */
  public com.google.protobuf.ProtocolStringList
      getActionItemsList() {
    return actionItems_;
  }
  /**
   * <pre>
   * Output only. A list of recommendations to improve the ad strength. For
   * example, a recommendation could be "Your headlines are a little too
   * similar. Try adding more distinct headlines.".
   * </pre>
   *
   * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The count of actionItems.
   */
  public int getActionItemsCount() {
    return actionItems_.size();
  }
  /**
   * <pre>
   * Output only. A list of recommendations to improve the ad strength. For
   * example, a recommendation could be "Your headlines are a little too
   * similar. Try adding more distinct headlines.".
   * </pre>
   *
   * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @param index The index of the element to return.
   * @return The actionItems at the given index.
   */
  public java.lang.String getActionItems(int index) {
    return actionItems_.get(index);
  }
  /**
   * <pre>
   * Output only. A list of recommendations to improve the ad strength. For
   * example, a recommendation could be "Your headlines are a little too
   * similar. Try adding more distinct headlines.".
   * </pre>
   *
   * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @param index The index of the value to return.
   * @return The bytes of the actionItems at the given index.
   */
  public com.google.protobuf.ByteString
      getActionItemsBytes(int index) {
    return actionItems_.getByteString(index);
  }

  public static final int LABELS_FIELD_NUMBER = 10;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList labels_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Output only. The resource names of labels attached to this ad group ad.
   * </pre>
   *
   * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return A list containing the labels.
   */
  public com.google.protobuf.ProtocolStringList
      getLabelsList() {
    return labels_;
  }
  /**
   * <pre>
   * Output only. The resource names of labels attached to this ad group ad.
   * </pre>
   *
   * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The count of labels.
   */
  public int getLabelsCount() {
    return labels_.size();
  }
  /**
   * <pre>
   * Output only. The resource names of labels attached to this ad group ad.
   * </pre>
   *
   * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @param index The index of the element to return.
   * @return The labels at the given index.
   */
  public java.lang.String getLabels(int index) {
    return labels_.get(index);
  }
  /**
   * <pre>
   * Output only. The resource names of labels attached to this ad group ad.
   * </pre>
   *
   * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @param index The index of the value to return.
   * @return The bytes of the labels at the given index.
   */
  public com.google.protobuf.ByteString
      getLabelsBytes(int index) {
    return labels_.getByteString(index);
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (status_ != com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(3, status_);
    }
    if (ad_ != null) {
      output.writeMessage(5, getAd());
    }
    if (policySummary_ != null) {
      output.writeMessage(6, getPolicySummary());
    }
    if (adStrength_ != com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength.UNSPECIFIED.getNumber()) {
      output.writeEnum(7, adStrength_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 9, adGroup_);
    }
    for (int i = 0; i < labels_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, labels_.getRaw(i));
    }
    for (int i = 0; i < actionItems_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, actionItems_.getRaw(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (status_ != com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(3, status_);
    }
    if (ad_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(5, getAd());
    }
    if (policySummary_ != null) {
      size += com.google.protobuf.CodedOutputStream
        .computeMessageSize(6, getPolicySummary());
    }
    if (adStrength_ != com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(7, adStrength_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(9, adGroup_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < labels_.size(); i++) {
        dataSize += computeStringSizeNoTag(labels_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getLabelsList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < actionItems_.size(); i++) {
        dataSize += computeStringSizeNoTag(actionItems_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getActionItemsList().size();
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v13.resources.AdGroupAd)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v13.resources.AdGroupAd other = (com.google.ads.googleads.v13.resources.AdGroupAd) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (status_ != other.status_) return false;
    if (hasAdGroup() != other.hasAdGroup()) return false;
    if (hasAdGroup()) {
      if (!getAdGroup()
          .equals(other.getAdGroup())) return false;
    }
    if (hasAd() != other.hasAd()) return false;
    if (hasAd()) {
      if (!getAd()
          .equals(other.getAd())) return false;
    }
    if (hasPolicySummary() != other.hasPolicySummary()) return false;
    if (hasPolicySummary()) {
      if (!getPolicySummary()
          .equals(other.getPolicySummary())) return false;
    }
    if (adStrength_ != other.adStrength_) return false;
    if (!getActionItemsList()
        .equals(other.getActionItemsList())) return false;
    if (!getLabelsList()
        .equals(other.getLabelsList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    if (hasAdGroup()) {
      hash = (37 * hash) + AD_GROUP_FIELD_NUMBER;
      hash = (53 * hash) + getAdGroup().hashCode();
    }
    if (hasAd()) {
      hash = (37 * hash) + AD_FIELD_NUMBER;
      hash = (53 * hash) + getAd().hashCode();
    }
    if (hasPolicySummary()) {
      hash = (37 * hash) + POLICY_SUMMARY_FIELD_NUMBER;
      hash = (53 * hash) + getPolicySummary().hashCode();
    }
    hash = (37 * hash) + AD_STRENGTH_FIELD_NUMBER;
    hash = (53 * hash) + adStrength_;
    if (getActionItemsCount() > 0) {
      hash = (37 * hash) + ACTION_ITEMS_FIELD_NUMBER;
      hash = (53 * hash) + getActionItemsList().hashCode();
    }
    if (getLabelsCount() > 0) {
      hash = (37 * hash) + LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getLabelsList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v13.resources.AdGroupAd parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v13.resources.AdGroupAd parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v13.resources.AdGroupAd parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v13.resources.AdGroupAd parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v13.resources.AdGroupAd parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v13.resources.AdGroupAd parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v13.resources.AdGroupAd parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v13.resources.AdGroupAd parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v13.resources.AdGroupAd parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v13.resources.AdGroupAd parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v13.resources.AdGroupAd parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v13.resources.AdGroupAd parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v13.resources.AdGroupAd prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * An ad group ad.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v13.resources.AdGroupAd}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v13.resources.AdGroupAd)
      com.google.ads.googleads.v13.resources.AdGroupAdOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v13.resources.AdGroupAdProto.internal_static_google_ads_googleads_v13_resources_AdGroupAd_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v13.resources.AdGroupAdProto.internal_static_google_ads_googleads_v13_resources_AdGroupAd_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v13.resources.AdGroupAd.class, com.google.ads.googleads.v13.resources.AdGroupAd.Builder.class);
    }

    // Construct using com.google.ads.googleads.v13.resources.AdGroupAd.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      status_ = 0;
      adGroup_ = "";
      ad_ = null;
      if (adBuilder_ != null) {
        adBuilder_.dispose();
        adBuilder_ = null;
      }
      policySummary_ = null;
      if (policySummaryBuilder_ != null) {
        policySummaryBuilder_.dispose();
        policySummaryBuilder_ = null;
      }
      adStrength_ = 0;
      actionItems_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      labels_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v13.resources.AdGroupAdProto.internal_static_google_ads_googleads_v13_resources_AdGroupAd_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v13.resources.AdGroupAd getDefaultInstanceForType() {
      return com.google.ads.googleads.v13.resources.AdGroupAd.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v13.resources.AdGroupAd build() {
      com.google.ads.googleads.v13.resources.AdGroupAd result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v13.resources.AdGroupAd buildPartial() {
      com.google.ads.googleads.v13.resources.AdGroupAd result = new com.google.ads.googleads.v13.resources.AdGroupAd(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v13.resources.AdGroupAd result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.status_ = status_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.adGroup_ = adGroup_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.ad_ = adBuilder_ == null
            ? ad_
            : adBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.policySummary_ = policySummaryBuilder_ == null
            ? policySummary_
            : policySummaryBuilder_.build();
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.adStrength_ = adStrength_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        actionItems_.makeImmutable();
        result.actionItems_ = actionItems_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        labels_.makeImmutable();
        result.labels_ = labels_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v13.resources.AdGroupAd) {
        return mergeFrom((com.google.ads.googleads.v13.resources.AdGroupAd)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v13.resources.AdGroupAd other) {
      if (other == com.google.ads.googleads.v13.resources.AdGroupAd.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      if (other.hasAdGroup()) {
        adGroup_ = other.adGroup_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasAd()) {
        mergeAd(other.getAd());
      }
      if (other.hasPolicySummary()) {
        mergePolicySummary(other.getPolicySummary());
      }
      if (other.adStrength_ != 0) {
        setAdStrengthValue(other.getAdStrengthValue());
      }
      if (!other.actionItems_.isEmpty()) {
        if (actionItems_.isEmpty()) {
          actionItems_ = other.actionItems_;
          bitField0_ |= 0x00000040;
        } else {
          ensureActionItemsIsMutable();
          actionItems_.addAll(other.actionItems_);
        }
        onChanged();
      }
      if (!other.labels_.isEmpty()) {
        if (labels_.isEmpty()) {
          labels_ = other.labels_;
          bitField0_ |= 0x00000080;
        } else {
          ensureLabelsIsMutable();
          labels_.addAll(other.labels_);
        }
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 24: {
              status_ = input.readEnum();
              bitField0_ |= 0x00000002;
              break;
            } // case 24
            case 42: {
              input.readMessage(
                  getAdFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000008;
              break;
            } // case 42
            case 50: {
              input.readMessage(
                  getPolicySummaryFieldBuilder().getBuilder(),
                  extensionRegistry);
              bitField0_ |= 0x00000010;
              break;
            } // case 50
            case 56: {
              adStrength_ = input.readEnum();
              bitField0_ |= 0x00000020;
              break;
            } // case 56
            case 74: {
              adGroup_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000004;
              break;
            } // case 74
            case 82: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureLabelsIsMutable();
              labels_.add(s);
              break;
            } // case 82
            case 106: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureActionItemsIsMutable();
              actionItems_.add(s);
              break;
            } // case 106
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Immutable. The resource name of the ad.
     * Ad group ad resource names have the form:
     *
     * `customers/{customer_id}/adGroupAds/{ad_group_id}~{ad_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the ad.
     * Ad group ad resource names have the form:
     *
     * `customers/{customer_id}/adGroupAds/{ad_group_id}~{ad_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The resource name of the ad.
     * Ad group ad resource names have the form:
     *
     * `customers/{customer_id}/adGroupAds/{ad_group_id}~{ad_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the ad.
     * Ad group ad resource names have the form:
     *
     * `customers/{customer_id}/adGroupAds/{ad_group_id}~{ad_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The resource name of the ad.
     * Ad group ad resource names have the form:
     *
     * `customers/{customer_id}/adGroupAds/{ad_group_id}~{ad_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * The status of the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus status = 3;</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * The status of the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus status = 3;</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The status of the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus status = 3;</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus getStatus() {
      com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus result = com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * The status of the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus status = 3;</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * The status of the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.AdGroupAdStatusEnum.AdGroupAdStatus status = 3;</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000002);
      status_ = 0;
      onChanged();
      return this;
    }

    private java.lang.Object adGroup_ = "";
    /**
     * <pre>
     * Immutable. The ad group to which the ad belongs.
     * </pre>
     *
     * <code>optional string ad_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the adGroup field is set.
     */
    public boolean hasAdGroup() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Immutable. The ad group to which the ad belongs.
     * </pre>
     *
     * <code>optional string ad_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The adGroup.
     */
    public java.lang.String getAdGroup() {
      java.lang.Object ref = adGroup_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        adGroup_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The ad group to which the ad belongs.
     * </pre>
     *
     * <code>optional string ad_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for adGroup.
     */
    public com.google.protobuf.ByteString
        getAdGroupBytes() {
      java.lang.Object ref = adGroup_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        adGroup_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Immutable. The ad group to which the ad belongs.
     * </pre>
     *
     * <code>optional string ad_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The adGroup to set.
     * @return This builder for chaining.
     */
    public Builder setAdGroup(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      adGroup_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The ad group to which the ad belongs.
     * </pre>
     *
     * <code>optional string ad_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearAdGroup() {
      adGroup_ = getDefaultInstance().getAdGroup();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The ad group to which the ad belongs.
     * </pre>
     *
     * <code>optional string ad_group = 9 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for adGroup to set.
     * @return This builder for chaining.
     */
    public Builder setAdGroupBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      adGroup_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private com.google.ads.googleads.v13.resources.Ad ad_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v13.resources.Ad, com.google.ads.googleads.v13.resources.Ad.Builder, com.google.ads.googleads.v13.resources.AdOrBuilder> adBuilder_;
    /**
     * <pre>
     * Immutable. The ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return Whether the ad field is set.
     */
    public boolean hasAd() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Immutable. The ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return The ad.
     */
    public com.google.ads.googleads.v13.resources.Ad getAd() {
      if (adBuilder_ == null) {
        return ad_ == null ? com.google.ads.googleads.v13.resources.Ad.getDefaultInstance() : ad_;
      } else {
        return adBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Immutable. The ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setAd(com.google.ads.googleads.v13.resources.Ad value) {
      if (adBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ad_ = value;
      } else {
        adBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder setAd(
        com.google.ads.googleads.v13.resources.Ad.Builder builderForValue) {
      if (adBuilder_ == null) {
        ad_ = builderForValue.build();
      } else {
        adBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder mergeAd(com.google.ads.googleads.v13.resources.Ad value) {
      if (adBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0) &&
          ad_ != null &&
          ad_ != com.google.ads.googleads.v13.resources.Ad.getDefaultInstance()) {
          getAdBuilder().mergeFrom(value);
        } else {
          ad_ = value;
        }
      } else {
        adBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public Builder clearAd() {
      bitField0_ = (bitField0_ & ~0x00000008);
      ad_ = null;
      if (adBuilder_ != null) {
        adBuilder_.dispose();
        adBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Immutable. The ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.ads.googleads.v13.resources.Ad.Builder getAdBuilder() {
      bitField0_ |= 0x00000008;
      onChanged();
      return getAdFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Immutable. The ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    public com.google.ads.googleads.v13.resources.AdOrBuilder getAdOrBuilder() {
      if (adBuilder_ != null) {
        return adBuilder_.getMessageOrBuilder();
      } else {
        return ad_ == null ?
            com.google.ads.googleads.v13.resources.Ad.getDefaultInstance() : ad_;
      }
    }
    /**
     * <pre>
     * Immutable. The ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.Ad ad = 5 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v13.resources.Ad, com.google.ads.googleads.v13.resources.Ad.Builder, com.google.ads.googleads.v13.resources.AdOrBuilder> 
        getAdFieldBuilder() {
      if (adBuilder_ == null) {
        adBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v13.resources.Ad, com.google.ads.googleads.v13.resources.Ad.Builder, com.google.ads.googleads.v13.resources.AdOrBuilder>(
                getAd(),
                getParentForChildren(),
                isClean());
        ad_ = null;
      }
      return adBuilder_;
    }

    private com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policySummary_;
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary, com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary.Builder, com.google.ads.googleads.v13.resources.AdGroupAdPolicySummaryOrBuilder> policySummaryBuilder_;
    /**
     * <pre>
     * Output only. Policy information for the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the policySummary field is set.
     */
    public boolean hasPolicySummary() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Output only. Policy information for the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The policySummary.
     */
    public com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary getPolicySummary() {
      if (policySummaryBuilder_ == null) {
        return policySummary_ == null ? com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary.getDefaultInstance() : policySummary_;
      } else {
        return policySummaryBuilder_.getMessage();
      }
    }
    /**
     * <pre>
     * Output only. Policy information for the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setPolicySummary(com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary value) {
      if (policySummaryBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        policySummary_ = value;
      } else {
        policySummaryBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Policy information for the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder setPolicySummary(
        com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary.Builder builderForValue) {
      if (policySummaryBuilder_ == null) {
        policySummary_ = builderForValue.build();
      } else {
        policySummaryBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Policy information for the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder mergePolicySummary(com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary value) {
      if (policySummaryBuilder_ == null) {
        if (((bitField0_ & 0x00000010) != 0) &&
          policySummary_ != null &&
          policySummary_ != com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary.getDefaultInstance()) {
          getPolicySummaryBuilder().mergeFrom(value);
        } else {
          policySummary_ = value;
        }
      } else {
        policySummaryBuilder_.mergeFrom(value);
      }
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Policy information for the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public Builder clearPolicySummary() {
      bitField0_ = (bitField0_ & ~0x00000010);
      policySummary_ = null;
      if (policySummaryBuilder_ != null) {
        policySummaryBuilder_.dispose();
        policySummaryBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Policy information for the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary.Builder getPolicySummaryBuilder() {
      bitField0_ |= 0x00000010;
      onChanged();
      return getPolicySummaryFieldBuilder().getBuilder();
    }
    /**
     * <pre>
     * Output only. Policy information for the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    public com.google.ads.googleads.v13.resources.AdGroupAdPolicySummaryOrBuilder getPolicySummaryOrBuilder() {
      if (policySummaryBuilder_ != null) {
        return policySummaryBuilder_.getMessageOrBuilder();
      } else {
        return policySummary_ == null ?
            com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary.getDefaultInstance() : policySummary_;
      }
    }
    /**
     * <pre>
     * Output only. Policy information for the ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.resources.AdGroupAdPolicySummary policy_summary = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
        com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary, com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary.Builder, com.google.ads.googleads.v13.resources.AdGroupAdPolicySummaryOrBuilder> 
        getPolicySummaryFieldBuilder() {
      if (policySummaryBuilder_ == null) {
        policySummaryBuilder_ = new com.google.protobuf.SingleFieldBuilderV3<
            com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary, com.google.ads.googleads.v13.resources.AdGroupAdPolicySummary.Builder, com.google.ads.googleads.v13.resources.AdGroupAdPolicySummaryOrBuilder>(
                getPolicySummary(),
                getParentForChildren(),
                isClean());
        policySummary_ = null;
      }
      return policySummaryBuilder_;
    }

    private int adStrength_ = 0;
    /**
     * <pre>
     * Output only. Overall ad strength for this ad group ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength ad_strength = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for adStrength.
     */
    @java.lang.Override public int getAdStrengthValue() {
      return adStrength_;
    }
    /**
     * <pre>
     * Output only. Overall ad strength for this ad group ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength ad_strength = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for adStrength to set.
     * @return This builder for chaining.
     */
    public Builder setAdStrengthValue(int value) {
      adStrength_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Overall ad strength for this ad group ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength ad_strength = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The adStrength.
     */
    @java.lang.Override
    public com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength getAdStrength() {
      com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength result = com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength.forNumber(adStrength_);
      return result == null ? com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. Overall ad strength for this ad group ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength ad_strength = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The adStrength to set.
     * @return This builder for chaining.
     */
    public Builder setAdStrength(com.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000020;
      adStrength_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Overall ad strength for this ad group ad.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.AdStrengthEnum.AdStrength ad_strength = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearAdStrength() {
      bitField0_ = (bitField0_ & ~0x00000020);
      adStrength_ = 0;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList actionItems_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureActionItemsIsMutable() {
      if (!actionItems_.isModifiable()) {
        actionItems_ = new com.google.protobuf.LazyStringArrayList(actionItems_);
      }
      bitField0_ |= 0x00000040;
    }
    /**
     * <pre>
     * Output only. A list of recommendations to improve the ad strength. For
     * example, a recommendation could be "Your headlines are a little too
     * similar. Try adding more distinct headlines.".
     * </pre>
     *
     * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return A list containing the actionItems.
     */
    public com.google.protobuf.ProtocolStringList
        getActionItemsList() {
      actionItems_.makeImmutable();
      return actionItems_;
    }
    /**
     * <pre>
     * Output only. A list of recommendations to improve the ad strength. For
     * example, a recommendation could be "Your headlines are a little too
     * similar. Try adding more distinct headlines.".
     * </pre>
     *
     * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The count of actionItems.
     */
    public int getActionItemsCount() {
      return actionItems_.size();
    }
    /**
     * <pre>
     * Output only. A list of recommendations to improve the ad strength. For
     * example, a recommendation could be "Your headlines are a little too
     * similar. Try adding more distinct headlines.".
     * </pre>
     *
     * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the element to return.
     * @return The actionItems at the given index.
     */
    public java.lang.String getActionItems(int index) {
      return actionItems_.get(index);
    }
    /**
     * <pre>
     * Output only. A list of recommendations to improve the ad strength. For
     * example, a recommendation could be "Your headlines are a little too
     * similar. Try adding more distinct headlines.".
     * </pre>
     *
     * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index of the value to return.
     * @return The bytes of the actionItems at the given index.
     */
    public com.google.protobuf.ByteString
        getActionItemsBytes(int index) {
      return actionItems_.getByteString(index);
    }
    /**
     * <pre>
     * Output only. A list of recommendations to improve the ad strength. For
     * example, a recommendation could be "Your headlines are a little too
     * similar. Try adding more distinct headlines.".
     * </pre>
     *
     * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param index The index to set the value at.
     * @param value The actionItems to set.
     * @return This builder for chaining.
     */
    public Builder setActionItems(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureActionItemsIsMutable();
      actionItems_.set(index, value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. A list of recommendations to improve the ad strength. For
     * example, a recommendation could be "Your headlines are a little too
     * similar. Try adding more distinct headlines.".
     * </pre>
     *
     * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The actionItems to add.
     * @return This builder for chaining.
     */
    public Builder addActionItems(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureActionItemsIsMutable();
      actionItems_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. A list of recommendations to improve the ad strength. For
     * example, a recommendation could be "Your headlines are a little too
     * similar. Try adding more distinct headlines.".
     * </pre>
     *
     * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param values The actionItems to add.
     * @return This builder for chaining.
     */
    public Builder addAllActionItems(
        java.lang.Iterable<java.lang.String> values) {
      ensureActionItemsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, actionItems_);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. A list of recommendations to improve the ad strength. For
     * example, a recommendation could be "Your headlines are a little too
     * similar. Try adding more distinct headlines.".
     * </pre>
     *
     * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearActionItems() {
      actionItems_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000040);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. A list of recommendations to improve the ad strength. For
     * example, a recommendation could be "Your headlines are a little too
     * similar. Try adding more distinct headlines.".
     * </pre>
     *
     * <code>repeated string action_items = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes of the actionItems to add.
     * @return This builder for chaining.
     */
    public Builder addActionItemsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureActionItemsIsMutable();
      actionItems_.add(value);
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList labels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureLabelsIsMutable() {
      if (!labels_.isModifiable()) {
        labels_ = new com.google.protobuf.LazyStringArrayList(labels_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     * <pre>
     * Output only. The resource names of labels attached to this ad group ad.
     * </pre>
     *
     * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return A list containing the labels.
     */
    public com.google.protobuf.ProtocolStringList
        getLabelsList() {
      labels_.makeImmutable();
      return labels_;
    }
    /**
     * <pre>
     * Output only. The resource names of labels attached to this ad group ad.
     * </pre>
     *
     * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The count of labels.
     */
    public int getLabelsCount() {
      return labels_.size();
    }
    /**
     * <pre>
     * Output only. The resource names of labels attached to this ad group ad.
     * </pre>
     *
     * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param index The index of the element to return.
     * @return The labels at the given index.
     */
    public java.lang.String getLabels(int index) {
      return labels_.get(index);
    }
    /**
     * <pre>
     * Output only. The resource names of labels attached to this ad group ad.
     * </pre>
     *
     * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param index The index of the value to return.
     * @return The bytes of the labels at the given index.
     */
    public com.google.protobuf.ByteString
        getLabelsBytes(int index) {
      return labels_.getByteString(index);
    }
    /**
     * <pre>
     * Output only. The resource names of labels attached to this ad group ad.
     * </pre>
     *
     * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param index The index to set the value at.
     * @param value The labels to set.
     * @return This builder for chaining.
     */
    public Builder setLabels(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureLabelsIsMutable();
      labels_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource names of labels attached to this ad group ad.
     * </pre>
     *
     * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The labels to add.
     * @return This builder for chaining.
     */
    public Builder addLabels(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureLabelsIsMutable();
      labels_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource names of labels attached to this ad group ad.
     * </pre>
     *
     * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param values The labels to add.
     * @return This builder for chaining.
     */
    public Builder addAllLabels(
        java.lang.Iterable<java.lang.String> values) {
      ensureLabelsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, labels_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource names of labels attached to this ad group ad.
     * </pre>
     *
     * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearLabels() {
      labels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource names of labels attached to this ad group ad.
     * </pre>
     *
     * <code>repeated string labels = 10 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes of the labels to add.
     * @return This builder for chaining.
     */
    public Builder addLabelsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureLabelsIsMutable();
      labels_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v13.resources.AdGroupAd)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v13.resources.AdGroupAd)
  private static final com.google.ads.googleads.v13.resources.AdGroupAd DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v13.resources.AdGroupAd();
  }

  public static com.google.ads.googleads.v13.resources.AdGroupAd getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<AdGroupAd>
      PARSER = new com.google.protobuf.AbstractParser<AdGroupAd>() {
    @java.lang.Override
    public AdGroupAd parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<AdGroupAd> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<AdGroupAd> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v13.resources.AdGroupAd getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

