// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/ads/googleads/v13/resources/customer_client.proto

package com.google.ads.googleads.v13.resources;

/**
 * <pre>
 * A link between the given customer and a client customer. CustomerClients only
 * exist for manager customers. All direct and indirect client customers are
 * included, as well as the manager itself.
 * </pre>
 *
 * Protobuf type {@code google.ads.googleads.v13.resources.CustomerClient}
 */
public final class CustomerClient extends
    com.google.protobuf.GeneratedMessageV3 implements
    // @@protoc_insertion_point(message_implements:google.ads.googleads.v13.resources.CustomerClient)
    CustomerClientOrBuilder {
private static final long serialVersionUID = 0L;
  // Use CustomerClient.newBuilder() to construct.
  private CustomerClient(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }
  private CustomerClient() {
    resourceName_ = "";
    clientCustomer_ = "";
    timeZone_ = "";
    descriptiveName_ = "";
    currencyCode_ = "";
    appliedLabels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    status_ = 0;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(
      UnusedPrivateParameter unused) {
    return new CustomerClient();
  }

  public static final com.google.protobuf.Descriptors.Descriptor
      getDescriptor() {
    return com.google.ads.googleads.v13.resources.CustomerClientProto.internal_static_google_ads_googleads_v13_resources_CustomerClient_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.ads.googleads.v13.resources.CustomerClientProto.internal_static_google_ads_googleads_v13_resources_CustomerClient_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.ads.googleads.v13.resources.CustomerClient.class, com.google.ads.googleads.v13.resources.CustomerClient.Builder.class);
  }

  private int bitField0_;
  public static final int RESOURCE_NAME_FIELD_NUMBER = 1;
  @SuppressWarnings("serial")
  private volatile java.lang.Object resourceName_ = "";
  /**
   * <pre>
   * Output only. The resource name of the customer client.
   * CustomerClient resource names have the form:
   * `customers/{customer_id}/customerClients/{client_customer_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The resourceName.
   */
  @java.lang.Override
  public java.lang.String getResourceName() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      resourceName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the customer client.
   * CustomerClient resource names have the form:
   * `customers/{customer_id}/customerClients/{client_customer_id}`
   * </pre>
   *
   * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for resourceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getResourceNameBytes() {
    java.lang.Object ref = resourceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      resourceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CLIENT_CUSTOMER_FIELD_NUMBER = 12;
  @SuppressWarnings("serial")
  private volatile java.lang.Object clientCustomer_ = "";
  /**
   * <pre>
   * Output only. The resource name of the client-customer which is linked to
   * the given customer. Read only.
   * </pre>
   *
   * <code>optional string client_customer = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return Whether the clientCustomer field is set.
   */
  @java.lang.Override
  public boolean hasClientCustomer() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   * <pre>
   * Output only. The resource name of the client-customer which is linked to
   * the given customer. Read only.
   * </pre>
   *
   * <code>optional string client_customer = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The clientCustomer.
   */
  @java.lang.Override
  public java.lang.String getClientCustomer() {
    java.lang.Object ref = clientCustomer_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      clientCustomer_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. The resource name of the client-customer which is linked to
   * the given customer. Read only.
   * </pre>
   *
   * <code>optional string client_customer = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The bytes for clientCustomer.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getClientCustomerBytes() {
    java.lang.Object ref = clientCustomer_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      clientCustomer_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int HIDDEN_FIELD_NUMBER = 13;
  private boolean hidden_ = false;
  /**
   * <pre>
   * Output only. Specifies whether this is a
   * [hidden account](https://support.google.com/google-ads/answer/7519830).
   * Read only.
   * </pre>
   *
   * <code>optional bool hidden = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the hidden field is set.
   */
  @java.lang.Override
  public boolean hasHidden() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   * <pre>
   * Output only. Specifies whether this is a
   * [hidden account](https://support.google.com/google-ads/answer/7519830).
   * Read only.
   * </pre>
   *
   * <code>optional bool hidden = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The hidden.
   */
  @java.lang.Override
  public boolean getHidden() {
    return hidden_;
  }

  public static final int LEVEL_FIELD_NUMBER = 14;
  private long level_ = 0L;
  /**
   * <pre>
   * Output only. Distance between given customer and client. For self link, the
   * level value will be 0. Read only.
   * </pre>
   *
   * <code>optional int64 level = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the level field is set.
   */
  @java.lang.Override
  public boolean hasLevel() {
    return ((bitField0_ & 0x00000004) != 0);
  }
  /**
   * <pre>
   * Output only. Distance between given customer and client. For self link, the
   * level value will be 0. Read only.
   * </pre>
   *
   * <code>optional int64 level = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The level.
   */
  @java.lang.Override
  public long getLevel() {
    return level_;
  }

  public static final int TIME_ZONE_FIELD_NUMBER = 15;
  @SuppressWarnings("serial")
  private volatile java.lang.Object timeZone_ = "";
  /**
   * <pre>
   * Output only. Common Locale Data Repository (CLDR) string representation of
   * the time zone of the client, for example, America/Los_Angeles. Read only.
   * </pre>
   *
   * <code>optional string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the timeZone field is set.
   */
  @java.lang.Override
  public boolean hasTimeZone() {
    return ((bitField0_ & 0x00000008) != 0);
  }
  /**
   * <pre>
   * Output only. Common Locale Data Repository (CLDR) string representation of
   * the time zone of the client, for example, America/Los_Angeles. Read only.
   * </pre>
   *
   * <code>optional string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The timeZone.
   */
  @java.lang.Override
  public java.lang.String getTimeZone() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      timeZone_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Common Locale Data Repository (CLDR) string representation of
   * the time zone of the client, for example, America/Los_Angeles. Read only.
   * </pre>
   *
   * <code>optional string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for timeZone.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getTimeZoneBytes() {
    java.lang.Object ref = timeZone_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      timeZone_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TEST_ACCOUNT_FIELD_NUMBER = 16;
  private boolean testAccount_ = false;
  /**
   * <pre>
   * Output only. Identifies if the client is a test account. Read only.
   * </pre>
   *
   * <code>optional bool test_account = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the testAccount field is set.
   */
  @java.lang.Override
  public boolean hasTestAccount() {
    return ((bitField0_ & 0x00000010) != 0);
  }
  /**
   * <pre>
   * Output only. Identifies if the client is a test account. Read only.
   * </pre>
   *
   * <code>optional bool test_account = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The testAccount.
   */
  @java.lang.Override
  public boolean getTestAccount() {
    return testAccount_;
  }

  public static final int MANAGER_FIELD_NUMBER = 17;
  private boolean manager_ = false;
  /**
   * <pre>
   * Output only. Identifies if the client is a manager. Read only.
   * </pre>
   *
   * <code>optional bool manager = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the manager field is set.
   */
  @java.lang.Override
  public boolean hasManager() {
    return ((bitField0_ & 0x00000020) != 0);
  }
  /**
   * <pre>
   * Output only. Identifies if the client is a manager. Read only.
   * </pre>
   *
   * <code>optional bool manager = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The manager.
   */
  @java.lang.Override
  public boolean getManager() {
    return manager_;
  }

  public static final int DESCRIPTIVE_NAME_FIELD_NUMBER = 18;
  @SuppressWarnings("serial")
  private volatile java.lang.Object descriptiveName_ = "";
  /**
   * <pre>
   * Output only. Descriptive name for the client. Read only.
   * </pre>
   *
   * <code>optional string descriptive_name = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the descriptiveName field is set.
   */
  @java.lang.Override
  public boolean hasDescriptiveName() {
    return ((bitField0_ & 0x00000040) != 0);
  }
  /**
   * <pre>
   * Output only. Descriptive name for the client. Read only.
   * </pre>
   *
   * <code>optional string descriptive_name = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The descriptiveName.
   */
  @java.lang.Override
  public java.lang.String getDescriptiveName() {
    java.lang.Object ref = descriptiveName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      descriptiveName_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Descriptive name for the client. Read only.
   * </pre>
   *
   * <code>optional string descriptive_name = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for descriptiveName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getDescriptiveNameBytes() {
    java.lang.Object ref = descriptiveName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      descriptiveName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int CURRENCY_CODE_FIELD_NUMBER = 19;
  @SuppressWarnings("serial")
  private volatile java.lang.Object currencyCode_ = "";
  /**
   * <pre>
   * Output only. Currency code (for example, 'USD', 'EUR') for the client. Read
   * only.
   * </pre>
   *
   * <code>optional string currency_code = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the currencyCode field is set.
   */
  @java.lang.Override
  public boolean hasCurrencyCode() {
    return ((bitField0_ & 0x00000080) != 0);
  }
  /**
   * <pre>
   * Output only. Currency code (for example, 'USD', 'EUR') for the client. Read
   * only.
   * </pre>
   *
   * <code>optional string currency_code = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The currencyCode.
   */
  @java.lang.Override
  public java.lang.String getCurrencyCode() {
    java.lang.Object ref = currencyCode_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = 
          (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      currencyCode_ = s;
      return s;
    }
  }
  /**
   * <pre>
   * Output only. Currency code (for example, 'USD', 'EUR') for the client. Read
   * only.
   * </pre>
   *
   * <code>optional string currency_code = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The bytes for currencyCode.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString
      getCurrencyCodeBytes() {
    java.lang.Object ref = currencyCode_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b = 
          com.google.protobuf.ByteString.copyFromUtf8(
              (java.lang.String) ref);
      currencyCode_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 20;
  private long id_ = 0L;
  /**
   * <pre>
   * Output only. The ID of the client customer. Read only.
   * </pre>
   *
   * <code>optional int64 id = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000100) != 0);
  }
  /**
   * <pre>
   * Output only. The ID of the client customer. Read only.
   * </pre>
   *
   * <code>optional int64 id = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int APPLIED_LABELS_FIELD_NUMBER = 21;
  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList appliedLabels_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   * <pre>
   * Output only. The resource names of the labels owned by the requesting
   * customer that are applied to the client customer. Label resource names have
   * the form:
   *
   * `customers/{customer_id}/labels/{label_id}`
   * </pre>
   *
   * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return A list containing the appliedLabels.
   */
  public com.google.protobuf.ProtocolStringList
      getAppliedLabelsList() {
    return appliedLabels_;
  }
  /**
   * <pre>
   * Output only. The resource names of the labels owned by the requesting
   * customer that are applied to the client customer. Label resource names have
   * the form:
   *
   * `customers/{customer_id}/labels/{label_id}`
   * </pre>
   *
   * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @return The count of appliedLabels.
   */
  public int getAppliedLabelsCount() {
    return appliedLabels_.size();
  }
  /**
   * <pre>
   * Output only. The resource names of the labels owned by the requesting
   * customer that are applied to the client customer. Label resource names have
   * the form:
   *
   * `customers/{customer_id}/labels/{label_id}`
   * </pre>
   *
   * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @param index The index of the element to return.
   * @return The appliedLabels at the given index.
   */
  public java.lang.String getAppliedLabels(int index) {
    return appliedLabels_.get(index);
  }
  /**
   * <pre>
   * Output only. The resource names of the labels owned by the requesting
   * customer that are applied to the client customer. Label resource names have
   * the form:
   *
   * `customers/{customer_id}/labels/{label_id}`
   * </pre>
   *
   * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
   * @param index The index of the value to return.
   * @return The bytes of the appliedLabels at the given index.
   */
  public com.google.protobuf.ByteString
      getAppliedLabelsBytes(int index) {
    return appliedLabels_.getByteString(index);
  }

  public static final int STATUS_FIELD_NUMBER = 22;
  private int status_ = 0;
  /**
   * <pre>
   * Output only. The status of the client customer. Read only.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus status = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The enum numeric value on the wire for status.
   */
  @java.lang.Override public int getStatusValue() {
    return status_;
  }
  /**
   * <pre>
   * Output only. The status of the client customer. Read only.
   * </pre>
   *
   * <code>.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus status = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
   * @return The status.
   */
  @java.lang.Override public com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus getStatus() {
    com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus result = com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus.forNumber(status_);
    return result == null ? com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus.UNRECOGNIZED : result;
  }

  private byte memoizedIsInitialized = -1;
  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output)
                      throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, resourceName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, clientCustomer_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeBool(13, hidden_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      output.writeInt64(14, level_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 15, timeZone_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeBool(16, testAccount_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeBool(17, manager_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 18, descriptiveName_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 19, currencyCode_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeInt64(20, id_);
    }
    for (int i = 0; i < appliedLabels_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 21, appliedLabels_.getRaw(i));
    }
    if (status_ != com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus.UNSPECIFIED.getNumber()) {
      output.writeEnum(22, status_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(resourceName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, resourceName_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, clientCustomer_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(13, hidden_);
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(14, level_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(15, timeZone_);
    }
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(16, testAccount_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeBoolSize(17, manager_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(18, descriptiveName_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(19, currencyCode_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size += com.google.protobuf.CodedOutputStream
        .computeInt64Size(20, id_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < appliedLabels_.size(); i++) {
        dataSize += computeStringSizeNoTag(appliedLabels_.getRaw(i));
      }
      size += dataSize;
      size += 2 * getAppliedLabelsList().size();
    }
    if (status_ != com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus.UNSPECIFIED.getNumber()) {
      size += com.google.protobuf.CodedOutputStream
        .computeEnumSize(22, status_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
     return true;
    }
    if (!(obj instanceof com.google.ads.googleads.v13.resources.CustomerClient)) {
      return super.equals(obj);
    }
    com.google.ads.googleads.v13.resources.CustomerClient other = (com.google.ads.googleads.v13.resources.CustomerClient) obj;

    if (!getResourceName()
        .equals(other.getResourceName())) return false;
    if (hasClientCustomer() != other.hasClientCustomer()) return false;
    if (hasClientCustomer()) {
      if (!getClientCustomer()
          .equals(other.getClientCustomer())) return false;
    }
    if (hasHidden() != other.hasHidden()) return false;
    if (hasHidden()) {
      if (getHidden()
          != other.getHidden()) return false;
    }
    if (hasLevel() != other.hasLevel()) return false;
    if (hasLevel()) {
      if (getLevel()
          != other.getLevel()) return false;
    }
    if (hasTimeZone() != other.hasTimeZone()) return false;
    if (hasTimeZone()) {
      if (!getTimeZone()
          .equals(other.getTimeZone())) return false;
    }
    if (hasTestAccount() != other.hasTestAccount()) return false;
    if (hasTestAccount()) {
      if (getTestAccount()
          != other.getTestAccount()) return false;
    }
    if (hasManager() != other.hasManager()) return false;
    if (hasManager()) {
      if (getManager()
          != other.getManager()) return false;
    }
    if (hasDescriptiveName() != other.hasDescriptiveName()) return false;
    if (hasDescriptiveName()) {
      if (!getDescriptiveName()
          .equals(other.getDescriptiveName())) return false;
    }
    if (hasCurrencyCode() != other.hasCurrencyCode()) return false;
    if (hasCurrencyCode()) {
      if (!getCurrencyCode()
          .equals(other.getCurrencyCode())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId()
          != other.getId()) return false;
    }
    if (!getAppliedLabelsList()
        .equals(other.getAppliedLabelsList())) return false;
    if (status_ != other.status_) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + RESOURCE_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getResourceName().hashCode();
    if (hasClientCustomer()) {
      hash = (37 * hash) + CLIENT_CUSTOMER_FIELD_NUMBER;
      hash = (53 * hash) + getClientCustomer().hashCode();
    }
    if (hasHidden()) {
      hash = (37 * hash) + HIDDEN_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getHidden());
    }
    if (hasLevel()) {
      hash = (37 * hash) + LEVEL_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getLevel());
    }
    if (hasTimeZone()) {
      hash = (37 * hash) + TIME_ZONE_FIELD_NUMBER;
      hash = (53 * hash) + getTimeZone().hashCode();
    }
    if (hasTestAccount()) {
      hash = (37 * hash) + TEST_ACCOUNT_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getTestAccount());
    }
    if (hasManager()) {
      hash = (37 * hash) + MANAGER_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(
          getManager());
    }
    if (hasDescriptiveName()) {
      hash = (37 * hash) + DESCRIPTIVE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDescriptiveName().hashCode();
    }
    if (hasCurrencyCode()) {
      hash = (37 * hash) + CURRENCY_CODE_FIELD_NUMBER;
      hash = (53 * hash) + getCurrencyCode().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(
          getId());
    }
    if (getAppliedLabelsCount() > 0) {
      hash = (37 * hash) + APPLIED_LABELS_FIELD_NUMBER;
      hash = (53 * hash) + getAppliedLabelsList().hashCode();
    }
    hash = (37 * hash) + STATUS_FIELD_NUMBER;
    hash = (53 * hash) + status_;
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.ads.googleads.v13.resources.CustomerClient parseFrom(
      java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v13.resources.CustomerClient parseFrom(
      java.nio.ByteBuffer data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v13.resources.CustomerClient parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v13.resources.CustomerClient parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v13.resources.CustomerClient parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }
  public static com.google.ads.googleads.v13.resources.CustomerClient parseFrom(
      byte[] data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }
  public static com.google.ads.googleads.v13.resources.CustomerClient parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v13.resources.CustomerClient parseFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  public static com.google.ads.googleads.v13.resources.CustomerClient parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.ads.googleads.v13.resources.CustomerClient parseDelimitedFrom(
      java.io.InputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseDelimitedWithIOException(PARSER, input, extensionRegistry);
  }
  public static com.google.ads.googleads.v13.resources.CustomerClient parseFrom(
      com.google.protobuf.CodedInputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input);
  }
  public static com.google.ads.googleads.v13.resources.CustomerClient parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3
        .parseWithIOException(PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() { return newBuilder(); }
  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }
  public static Builder newBuilder(com.google.ads.googleads.v13.resources.CustomerClient prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }
  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE
        ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(
      com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   * <pre>
   * A link between the given customer and a client customer. CustomerClients only
   * exist for manager customers. All direct and indirect client customers are
   * included, as well as the manager itself.
   * </pre>
   *
   * Protobuf type {@code google.ads.googleads.v13.resources.CustomerClient}
   */
  public static final class Builder extends
      com.google.protobuf.GeneratedMessageV3.Builder<Builder> implements
      // @@protoc_insertion_point(builder_implements:google.ads.googleads.v13.resources.CustomerClient)
      com.google.ads.googleads.v13.resources.CustomerClientOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor
        getDescriptor() {
      return com.google.ads.googleads.v13.resources.CustomerClientProto.internal_static_google_ads_googleads_v13_resources_CustomerClient_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.ads.googleads.v13.resources.CustomerClientProto.internal_static_google_ads_googleads_v13_resources_CustomerClient_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.ads.googleads.v13.resources.CustomerClient.class, com.google.ads.googleads.v13.resources.CustomerClient.Builder.class);
    }

    // Construct using com.google.ads.googleads.v13.resources.CustomerClient.newBuilder()
    private Builder() {

    }

    private Builder(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);

    }
    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      resourceName_ = "";
      clientCustomer_ = "";
      hidden_ = false;
      level_ = 0L;
      timeZone_ = "";
      testAccount_ = false;
      manager_ = false;
      descriptiveName_ = "";
      currencyCode_ = "";
      id_ = 0L;
      appliedLabels_ =
          com.google.protobuf.LazyStringArrayList.emptyList();
      status_ = 0;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor
        getDescriptorForType() {
      return com.google.ads.googleads.v13.resources.CustomerClientProto.internal_static_google_ads_googleads_v13_resources_CustomerClient_descriptor;
    }

    @java.lang.Override
    public com.google.ads.googleads.v13.resources.CustomerClient getDefaultInstanceForType() {
      return com.google.ads.googleads.v13.resources.CustomerClient.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.ads.googleads.v13.resources.CustomerClient build() {
      com.google.ads.googleads.v13.resources.CustomerClient result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.ads.googleads.v13.resources.CustomerClient buildPartial() {
      com.google.ads.googleads.v13.resources.CustomerClient result = new com.google.ads.googleads.v13.resources.CustomerClient(this);
      if (bitField0_ != 0) { buildPartial0(result); }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.ads.googleads.v13.resources.CustomerClient result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.resourceName_ = resourceName_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.clientCustomer_ = clientCustomer_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.hidden_ = hidden_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.level_ = level_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.timeZone_ = timeZone_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.testAccount_ = testAccount_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.manager_ = manager_;
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.descriptiveName_ = descriptiveName_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.currencyCode_ = currencyCode_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        appliedLabels_.makeImmutable();
        result.appliedLabels_ = appliedLabels_;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.status_ = status_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }
    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.setField(field, value);
    }
    @java.lang.Override
    public Builder clearField(
        com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }
    @java.lang.Override
    public Builder clearOneof(
        com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }
    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }
    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field,
        java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }
    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.ads.googleads.v13.resources.CustomerClient) {
        return mergeFrom((com.google.ads.googleads.v13.resources.CustomerClient)other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.ads.googleads.v13.resources.CustomerClient other) {
      if (other == com.google.ads.googleads.v13.resources.CustomerClient.getDefaultInstance()) return this;
      if (!other.getResourceName().isEmpty()) {
        resourceName_ = other.resourceName_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.hasClientCustomer()) {
        clientCustomer_ = other.clientCustomer_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasHidden()) {
        setHidden(other.getHidden());
      }
      if (other.hasLevel()) {
        setLevel(other.getLevel());
      }
      if (other.hasTimeZone()) {
        timeZone_ = other.timeZone_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.hasTestAccount()) {
        setTestAccount(other.getTestAccount());
      }
      if (other.hasManager()) {
        setManager(other.getManager());
      }
      if (other.hasDescriptiveName()) {
        descriptiveName_ = other.descriptiveName_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasCurrencyCode()) {
        currencyCode_ = other.currencyCode_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (!other.appliedLabels_.isEmpty()) {
        if (appliedLabels_.isEmpty()) {
          appliedLabels_ = other.appliedLabels_;
          bitField0_ |= 0x00000400;
        } else {
          ensureAppliedLabelsIsMutable();
          appliedLabels_.addAll(other.appliedLabels_);
        }
        onChanged();
      }
      if (other.status_ != 0) {
        setStatusValue(other.getStatusValue());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10: {
              resourceName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000001;
              break;
            } // case 10
            case 98: {
              clientCustomer_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000002;
              break;
            } // case 98
            case 104: {
              hidden_ = input.readBool();
              bitField0_ |= 0x00000004;
              break;
            } // case 104
            case 112: {
              level_ = input.readInt64();
              bitField0_ |= 0x00000008;
              break;
            } // case 112
            case 122: {
              timeZone_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000010;
              break;
            } // case 122
            case 128: {
              testAccount_ = input.readBool();
              bitField0_ |= 0x00000020;
              break;
            } // case 128
            case 136: {
              manager_ = input.readBool();
              bitField0_ |= 0x00000040;
              break;
            } // case 136
            case 146: {
              descriptiveName_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000080;
              break;
            } // case 146
            case 154: {
              currencyCode_ = input.readStringRequireUtf8();
              bitField0_ |= 0x00000100;
              break;
            } // case 154
            case 160: {
              id_ = input.readInt64();
              bitField0_ |= 0x00000200;
              break;
            } // case 160
            case 170: {
              java.lang.String s = input.readStringRequireUtf8();
              ensureAppliedLabelsIsMutable();
              appliedLabels_.add(s);
              break;
            } // case 170
            case 176: {
              status_ = input.readEnum();
              bitField0_ |= 0x00000800;
              break;
            } // case 176
            default: {
              if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                done = true; // was an endgroup tag
              }
              break;
            } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }
    private int bitField0_;

    private java.lang.Object resourceName_ = "";
    /**
     * <pre>
     * Output only. The resource name of the customer client.
     * CustomerClient resource names have the form:
     * `customers/{customer_id}/customerClients/{client_customer_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The resourceName.
     */
    public java.lang.String getResourceName() {
      java.lang.Object ref = resourceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        resourceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the customer client.
     * CustomerClient resource names have the form:
     * `customers/{customer_id}/customerClients/{client_customer_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for resourceName.
     */
    public com.google.protobuf.ByteString
        getResourceNameBytes() {
      java.lang.Object ref = resourceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        resourceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the customer client.
     * CustomerClient resource names have the form:
     * `customers/{customer_id}/customerClients/{client_customer_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the customer client.
     * CustomerClient resource names have the form:
     * `customers/{customer_id}/customerClients/{client_customer_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearResourceName() {
      resourceName_ = getDefaultInstance().getResourceName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the customer client.
     * CustomerClient resource names have the form:
     * `customers/{customer_id}/customerClients/{client_customer_id}`
     * </pre>
     *
     * <code>string resource_name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for resourceName to set.
     * @return This builder for chaining.
     */
    public Builder setResourceNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      resourceName_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object clientCustomer_ = "";
    /**
     * <pre>
     * Output only. The resource name of the client-customer which is linked to
     * the given customer. Read only.
     * </pre>
     *
     * <code>optional string client_customer = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return Whether the clientCustomer field is set.
     */
    public boolean hasClientCustomer() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     * <pre>
     * Output only. The resource name of the client-customer which is linked to
     * the given customer. Read only.
     * </pre>
     *
     * <code>optional string client_customer = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The clientCustomer.
     */
    public java.lang.String getClientCustomer() {
      java.lang.Object ref = clientCustomer_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        clientCustomer_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the client-customer which is linked to
     * the given customer. Read only.
     * </pre>
     *
     * <code>optional string client_customer = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The bytes for clientCustomer.
     */
    public com.google.protobuf.ByteString
        getClientCustomerBytes() {
      java.lang.Object ref = clientCustomer_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        clientCustomer_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. The resource name of the client-customer which is linked to
     * the given customer. Read only.
     * </pre>
     *
     * <code>optional string client_customer = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The clientCustomer to set.
     * @return This builder for chaining.
     */
    public Builder setClientCustomer(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      clientCustomer_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the client-customer which is linked to
     * the given customer. Read only.
     * </pre>
     *
     * <code>optional string client_customer = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearClientCustomer() {
      clientCustomer_ = getDefaultInstance().getClientCustomer();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource name of the client-customer which is linked to
     * the given customer. Read only.
     * </pre>
     *
     * <code>optional string client_customer = 12 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes for clientCustomer to set.
     * @return This builder for chaining.
     */
    public Builder setClientCustomerBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      clientCustomer_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private boolean hidden_ ;
    /**
     * <pre>
     * Output only. Specifies whether this is a
     * [hidden account](https://support.google.com/google-ads/answer/7519830).
     * Read only.
     * </pre>
     *
     * <code>optional bool hidden = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the hidden field is set.
     */
    @java.lang.Override
    public boolean hasHidden() {
      return ((bitField0_ & 0x00000004) != 0);
    }
    /**
     * <pre>
     * Output only. Specifies whether this is a
     * [hidden account](https://support.google.com/google-ads/answer/7519830).
     * Read only.
     * </pre>
     *
     * <code>optional bool hidden = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The hidden.
     */
    @java.lang.Override
    public boolean getHidden() {
      return hidden_;
    }
    /**
     * <pre>
     * Output only. Specifies whether this is a
     * [hidden account](https://support.google.com/google-ads/answer/7519830).
     * Read only.
     * </pre>
     *
     * <code>optional bool hidden = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The hidden to set.
     * @return This builder for chaining.
     */
    public Builder setHidden(boolean value) {

      hidden_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Specifies whether this is a
     * [hidden account](https://support.google.com/google-ads/answer/7519830).
     * Read only.
     * </pre>
     *
     * <code>optional bool hidden = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearHidden() {
      bitField0_ = (bitField0_ & ~0x00000004);
      hidden_ = false;
      onChanged();
      return this;
    }

    private long level_ ;
    /**
     * <pre>
     * Output only. Distance between given customer and client. For self link, the
     * level value will be 0. Read only.
     * </pre>
     *
     * <code>optional int64 level = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the level field is set.
     */
    @java.lang.Override
    public boolean hasLevel() {
      return ((bitField0_ & 0x00000008) != 0);
    }
    /**
     * <pre>
     * Output only. Distance between given customer and client. For self link, the
     * level value will be 0. Read only.
     * </pre>
     *
     * <code>optional int64 level = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The level.
     */
    @java.lang.Override
    public long getLevel() {
      return level_;
    }
    /**
     * <pre>
     * Output only. Distance between given customer and client. For self link, the
     * level value will be 0. Read only.
     * </pre>
     *
     * <code>optional int64 level = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The level to set.
     * @return This builder for chaining.
     */
    public Builder setLevel(long value) {

      level_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Distance between given customer and client. For self link, the
     * level value will be 0. Read only.
     * </pre>
     *
     * <code>optional int64 level = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearLevel() {
      bitField0_ = (bitField0_ & ~0x00000008);
      level_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object timeZone_ = "";
    /**
     * <pre>
     * Output only. Common Locale Data Repository (CLDR) string representation of
     * the time zone of the client, for example, America/Los_Angeles. Read only.
     * </pre>
     *
     * <code>optional string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the timeZone field is set.
     */
    public boolean hasTimeZone() {
      return ((bitField0_ & 0x00000010) != 0);
    }
    /**
     * <pre>
     * Output only. Common Locale Data Repository (CLDR) string representation of
     * the time zone of the client, for example, America/Los_Angeles. Read only.
     * </pre>
     *
     * <code>optional string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The timeZone.
     */
    public java.lang.String getTimeZone() {
      java.lang.Object ref = timeZone_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        timeZone_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Common Locale Data Repository (CLDR) string representation of
     * the time zone of the client, for example, America/Los_Angeles. Read only.
     * </pre>
     *
     * <code>optional string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for timeZone.
     */
    public com.google.protobuf.ByteString
        getTimeZoneBytes() {
      java.lang.Object ref = timeZone_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        timeZone_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Common Locale Data Repository (CLDR) string representation of
     * the time zone of the client, for example, America/Los_Angeles. Read only.
     * </pre>
     *
     * <code>optional string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZone(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      timeZone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Common Locale Data Repository (CLDR) string representation of
     * the time zone of the client, for example, America/Los_Angeles. Read only.
     * </pre>
     *
     * <code>optional string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearTimeZone() {
      timeZone_ = getDefaultInstance().getTimeZone();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Common Locale Data Repository (CLDR) string representation of
     * the time zone of the client, for example, America/Los_Angeles. Read only.
     * </pre>
     *
     * <code>optional string time_zone = 15 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for timeZone to set.
     * @return This builder for chaining.
     */
    public Builder setTimeZoneBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      timeZone_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private boolean testAccount_ ;
    /**
     * <pre>
     * Output only. Identifies if the client is a test account. Read only.
     * </pre>
     *
     * <code>optional bool test_account = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the testAccount field is set.
     */
    @java.lang.Override
    public boolean hasTestAccount() {
      return ((bitField0_ & 0x00000020) != 0);
    }
    /**
     * <pre>
     * Output only. Identifies if the client is a test account. Read only.
     * </pre>
     *
     * <code>optional bool test_account = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The testAccount.
     */
    @java.lang.Override
    public boolean getTestAccount() {
      return testAccount_;
    }
    /**
     * <pre>
     * Output only. Identifies if the client is a test account. Read only.
     * </pre>
     *
     * <code>optional bool test_account = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The testAccount to set.
     * @return This builder for chaining.
     */
    public Builder setTestAccount(boolean value) {

      testAccount_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Identifies if the client is a test account. Read only.
     * </pre>
     *
     * <code>optional bool test_account = 16 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearTestAccount() {
      bitField0_ = (bitField0_ & ~0x00000020);
      testAccount_ = false;
      onChanged();
      return this;
    }

    private boolean manager_ ;
    /**
     * <pre>
     * Output only. Identifies if the client is a manager. Read only.
     * </pre>
     *
     * <code>optional bool manager = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the manager field is set.
     */
    @java.lang.Override
    public boolean hasManager() {
      return ((bitField0_ & 0x00000040) != 0);
    }
    /**
     * <pre>
     * Output only. Identifies if the client is a manager. Read only.
     * </pre>
     *
     * <code>optional bool manager = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The manager.
     */
    @java.lang.Override
    public boolean getManager() {
      return manager_;
    }
    /**
     * <pre>
     * Output only. Identifies if the client is a manager. Read only.
     * </pre>
     *
     * <code>optional bool manager = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The manager to set.
     * @return This builder for chaining.
     */
    public Builder setManager(boolean value) {

      manager_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Identifies if the client is a manager. Read only.
     * </pre>
     *
     * <code>optional bool manager = 17 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearManager() {
      bitField0_ = (bitField0_ & ~0x00000040);
      manager_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object descriptiveName_ = "";
    /**
     * <pre>
     * Output only. Descriptive name for the client. Read only.
     * </pre>
     *
     * <code>optional string descriptive_name = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the descriptiveName field is set.
     */
    public boolean hasDescriptiveName() {
      return ((bitField0_ & 0x00000080) != 0);
    }
    /**
     * <pre>
     * Output only. Descriptive name for the client. Read only.
     * </pre>
     *
     * <code>optional string descriptive_name = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The descriptiveName.
     */
    public java.lang.String getDescriptiveName() {
      java.lang.Object ref = descriptiveName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        descriptiveName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Descriptive name for the client. Read only.
     * </pre>
     *
     * <code>optional string descriptive_name = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for descriptiveName.
     */
    public com.google.protobuf.ByteString
        getDescriptiveNameBytes() {
      java.lang.Object ref = descriptiveName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        descriptiveName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Descriptive name for the client. Read only.
     * </pre>
     *
     * <code>optional string descriptive_name = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The descriptiveName to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptiveName(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      descriptiveName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Descriptive name for the client. Read only.
     * </pre>
     *
     * <code>optional string descriptive_name = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearDescriptiveName() {
      descriptiveName_ = getDefaultInstance().getDescriptiveName();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Descriptive name for the client. Read only.
     * </pre>
     *
     * <code>optional string descriptive_name = 18 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for descriptiveName to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptiveNameBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      descriptiveName_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object currencyCode_ = "";
    /**
     * <pre>
     * Output only. Currency code (for example, 'USD', 'EUR') for the client. Read
     * only.
     * </pre>
     *
     * <code>optional string currency_code = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the currencyCode field is set.
     */
    public boolean hasCurrencyCode() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     * <pre>
     * Output only. Currency code (for example, 'USD', 'EUR') for the client. Read
     * only.
     * </pre>
     *
     * <code>optional string currency_code = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The currencyCode.
     */
    public java.lang.String getCurrencyCode() {
      java.lang.Object ref = currencyCode_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs =
            (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        currencyCode_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     * <pre>
     * Output only. Currency code (for example, 'USD', 'EUR') for the client. Read
     * only.
     * </pre>
     *
     * <code>optional string currency_code = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The bytes for currencyCode.
     */
    public com.google.protobuf.ByteString
        getCurrencyCodeBytes() {
      java.lang.Object ref = currencyCode_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b = 
            com.google.protobuf.ByteString.copyFromUtf8(
                (java.lang.String) ref);
        currencyCode_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     * <pre>
     * Output only. Currency code (for example, 'USD', 'EUR') for the client. Read
     * only.
     * </pre>
     *
     * <code>optional string currency_code = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The currencyCode to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyCode(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      currencyCode_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Currency code (for example, 'USD', 'EUR') for the client. Read
     * only.
     * </pre>
     *
     * <code>optional string currency_code = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearCurrencyCode() {
      currencyCode_ = getDefaultInstance().getCurrencyCode();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. Currency code (for example, 'USD', 'EUR') for the client. Read
     * only.
     * </pre>
     *
     * <code>optional string currency_code = 19 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The bytes for currencyCode to set.
     * @return This builder for chaining.
     */
    public Builder setCurrencyCodeBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      currencyCode_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private long id_ ;
    /**
     * <pre>
     * Output only. The ID of the client customer. Read only.
     * </pre>
     *
     * <code>optional int64 id = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     * <pre>
     * Output only. The ID of the client customer. Read only.
     * </pre>
     *
     * <code>optional int64 id = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }
    /**
     * <pre>
     * Output only. The ID of the client customer. Read only.
     * </pre>
     *
     * <code>optional int64 id = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The ID of the client customer. Read only.
     * </pre>
     *
     * <code>optional int64 id = 20 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000200);
      id_ = 0L;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList appliedLabels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
    private void ensureAppliedLabelsIsMutable() {
      if (!appliedLabels_.isModifiable()) {
        appliedLabels_ = new com.google.protobuf.LazyStringArrayList(appliedLabels_);
      }
      bitField0_ |= 0x00000400;
    }
    /**
     * <pre>
     * Output only. The resource names of the labels owned by the requesting
     * customer that are applied to the client customer. Label resource names have
     * the form:
     *
     * `customers/{customer_id}/labels/{label_id}`
     * </pre>
     *
     * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return A list containing the appliedLabels.
     */
    public com.google.protobuf.ProtocolStringList
        getAppliedLabelsList() {
      appliedLabels_.makeImmutable();
      return appliedLabels_;
    }
    /**
     * <pre>
     * Output only. The resource names of the labels owned by the requesting
     * customer that are applied to the client customer. Label resource names have
     * the form:
     *
     * `customers/{customer_id}/labels/{label_id}`
     * </pre>
     *
     * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return The count of appliedLabels.
     */
    public int getAppliedLabelsCount() {
      return appliedLabels_.size();
    }
    /**
     * <pre>
     * Output only. The resource names of the labels owned by the requesting
     * customer that are applied to the client customer. Label resource names have
     * the form:
     *
     * `customers/{customer_id}/labels/{label_id}`
     * </pre>
     *
     * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param index The index of the element to return.
     * @return The appliedLabels at the given index.
     */
    public java.lang.String getAppliedLabels(int index) {
      return appliedLabels_.get(index);
    }
    /**
     * <pre>
     * Output only. The resource names of the labels owned by the requesting
     * customer that are applied to the client customer. Label resource names have
     * the form:
     *
     * `customers/{customer_id}/labels/{label_id}`
     * </pre>
     *
     * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param index The index of the value to return.
     * @return The bytes of the appliedLabels at the given index.
     */
    public com.google.protobuf.ByteString
        getAppliedLabelsBytes(int index) {
      return appliedLabels_.getByteString(index);
    }
    /**
     * <pre>
     * Output only. The resource names of the labels owned by the requesting
     * customer that are applied to the client customer. Label resource names have
     * the form:
     *
     * `customers/{customer_id}/labels/{label_id}`
     * </pre>
     *
     * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param index The index to set the value at.
     * @param value The appliedLabels to set.
     * @return This builder for chaining.
     */
    public Builder setAppliedLabels(
        int index, java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureAppliedLabelsIsMutable();
      appliedLabels_.set(index, value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource names of the labels owned by the requesting
     * customer that are applied to the client customer. Label resource names have
     * the form:
     *
     * `customers/{customer_id}/labels/{label_id}`
     * </pre>
     *
     * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The appliedLabels to add.
     * @return This builder for chaining.
     */
    public Builder addAppliedLabels(
        java.lang.String value) {
      if (value == null) { throw new NullPointerException(); }
      ensureAppliedLabelsIsMutable();
      appliedLabels_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource names of the labels owned by the requesting
     * customer that are applied to the client customer. Label resource names have
     * the form:
     *
     * `customers/{customer_id}/labels/{label_id}`
     * </pre>
     *
     * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param values The appliedLabels to add.
     * @return This builder for chaining.
     */
    public Builder addAllAppliedLabels(
        java.lang.Iterable<java.lang.String> values) {
      ensureAppliedLabelsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(
          values, appliedLabels_);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource names of the labels owned by the requesting
     * customer that are applied to the client customer. Label resource names have
     * the form:
     *
     * `customers/{customer_id}/labels/{label_id}`
     * </pre>
     *
     * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @return This builder for chaining.
     */
    public Builder clearAppliedLabels() {
      appliedLabels_ =
        com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000400);;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The resource names of the labels owned by the requesting
     * customer that are applied to the client customer. Label resource names have
     * the form:
     *
     * `customers/{customer_id}/labels/{label_id}`
     * </pre>
     *
     * <code>repeated string applied_labels = 21 [(.google.api.field_behavior) = OUTPUT_ONLY, (.google.api.resource_reference) = { ... }</code>
     * @param value The bytes of the appliedLabels to add.
     * @return This builder for chaining.
     */
    public Builder addAppliedLabelsBytes(
        com.google.protobuf.ByteString value) {
      if (value == null) { throw new NullPointerException(); }
      checkByteStringIsUtf8(value);
      ensureAppliedLabelsIsMutable();
      appliedLabels_.add(value);
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    private int status_ = 0;
    /**
     * <pre>
     * Output only. The status of the client customer. Read only.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus status = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The enum numeric value on the wire for status.
     */
    @java.lang.Override public int getStatusValue() {
      return status_;
    }
    /**
     * <pre>
     * Output only. The status of the client customer. Read only.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus status = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The enum numeric value on the wire for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusValue(int value) {
      status_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The status of the client customer. Read only.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus status = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return The status.
     */
    @java.lang.Override
    public com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus getStatus() {
      com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus result = com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus.forNumber(status_);
      return result == null ? com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus.UNRECOGNIZED : result;
    }
    /**
     * <pre>
     * Output only. The status of the client customer. Read only.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus status = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(com.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000800;
      status_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     * <pre>
     * Output only. The status of the client customer. Read only.
     * </pre>
     *
     * <code>.google.ads.googleads.v13.enums.CustomerStatusEnum.CustomerStatus status = 22 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      bitField0_ = (bitField0_ & ~0x00000800);
      status_ = 0;
      onChanged();
      return this;
    }
    @java.lang.Override
    public final Builder setUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }


    // @@protoc_insertion_point(builder_scope:google.ads.googleads.v13.resources.CustomerClient)
  }

  // @@protoc_insertion_point(class_scope:google.ads.googleads.v13.resources.CustomerClient)
  private static final com.google.ads.googleads.v13.resources.CustomerClient DEFAULT_INSTANCE;
  static {
    DEFAULT_INSTANCE = new com.google.ads.googleads.v13.resources.CustomerClient();
  }

  public static com.google.ads.googleads.v13.resources.CustomerClient getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<CustomerClient>
      PARSER = new com.google.protobuf.AbstractParser<CustomerClient>() {
    @java.lang.Override
    public CustomerClient parsePartialFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      Builder builder = newBuilder();
      try {
        builder.mergeFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(builder.buildPartial());
      } catch (com.google.protobuf.UninitializedMessageException e) {
        throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e)
            .setUnfinishedMessage(builder.buildPartial());
      }
      return builder.buildPartial();
    }
  };

  public static com.google.protobuf.Parser<CustomerClient> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<CustomerClient> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.ads.googleads.v13.resources.CustomerClient getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }

}

