/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupAssetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_ASSET_ID_FIELD_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupAssets/{ad_group_id}~{asset_id}~{field_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String assetId;
    private final String fieldType;

    @Deprecated
    protected AdGroupAssetName() {
        this.customerId = null;
        this.adGroupId = null;
        this.assetId = null;
        this.fieldType = null;
    }

    private AdGroupAssetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.assetId = (String)Preconditions.checkNotNull((Object)builder.getAssetId());
        this.fieldType = (String)Preconditions.checkNotNull((Object)builder.getFieldType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupAssetName of(String customerId, String adGroupId, String assetId, String fieldType) {
        return AdGroupAssetName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAssetId(assetId).setFieldType(fieldType).build();
    }

    public static String format(String customerId, String adGroupId, String assetId, String fieldType) {
        return AdGroupAssetName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setAssetId(assetId).setFieldType(fieldType).build().toString();
    }

    public static AdGroupAssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_ASSET_ID_FIELD_TYPE.validatedMatch(formattedString, "AdGroupAssetName.parse: formattedString not in valid format");
        return AdGroupAssetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("asset_id"), (String)matchMap.get("field_type"));
    }

    public static List<AdGroupAssetName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupAssetName> list = new ArrayList<AdGroupAssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupAssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupAssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupAssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_ASSET_ID_FIELD_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupAssetName adGroupAssetName = this;
            synchronized (adGroupAssetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.assetId != null) {
                        fieldMapBuilder.put((Object)"asset_id", (Object)this.assetId);
                    }
                    if (this.fieldType != null) {
                        fieldMapBuilder.put((Object)"field_type", (Object)this.fieldType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_ASSET_ID_FIELD_TYPE.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "asset_id", this.assetId, "field_type", this.fieldType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AdGroupAssetName that = (AdGroupAssetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.assetId, that.assetId) && Objects.equals(this.fieldType, that.fieldType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.fieldType);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String assetId;
        private String fieldType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setAssetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder setFieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        private Builder(AdGroupAssetName adGroupAssetName) {
            this.customerId = adGroupAssetName.customerId;
            this.adGroupId = adGroupAssetName.adGroupId;
            this.assetId = adGroupAssetName.assetId;
            this.fieldType = adGroupAssetName.fieldType;
        }

        public AdGroupAssetName build() {
            return new AdGroupAssetName(this);
        }
    }
}

