/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupFeedName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID_FEED_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroupFeeds/{ad_group_id}~{feed_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;
    private final String feedId;

    @Deprecated
    protected AdGroupFeedName() {
        this.customerId = null;
        this.adGroupId = null;
        this.feedId = null;
    }

    private AdGroupFeedName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
        this.feedId = (String)Preconditions.checkNotNull((Object)builder.getFeedId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public String getFeedId() {
        return this.feedId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupFeedName of(String customerId, String adGroupId, String feedId) {
        return AdGroupFeedName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setFeedId(feedId).build();
    }

    public static String format(String customerId, String adGroupId, String feedId) {
        return AdGroupFeedName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).setFeedId(feedId).build().toString();
    }

    public static AdGroupFeedName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID_FEED_ID.validatedMatch(formattedString, "AdGroupFeedName.parse: formattedString not in valid format");
        return AdGroupFeedName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"), (String)matchMap.get("feed_id"));
    }

    public static List<AdGroupFeedName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupFeedName> list = new ArrayList<AdGroupFeedName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupFeedName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupFeedName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupFeedName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID_FEED_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupFeedName adGroupFeedName = this;
            synchronized (adGroupFeedName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    if (this.feedId != null) {
                        fieldMapBuilder.put((Object)"feed_id", (Object)this.feedId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID_FEED_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId, "feed_id", this.feedId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AdGroupFeedName that = (AdGroupFeedName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId) && Objects.equals(this.feedId, that.feedId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.adGroupId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.feedId);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;
        private String feedId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public String getFeedId() {
            return this.feedId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        public Builder setFeedId(String feedId) {
            this.feedId = feedId;
            return this;
        }

        private Builder(AdGroupFeedName adGroupFeedName) {
            this.customerId = adGroupFeedName.customerId;
            this.adGroupId = adGroupFeedName.adGroupId;
            this.feedId = adGroupFeedName.feedId;
        }

        public AdGroupFeedName build() {
            return new AdGroupFeedName(this);
        }
    }
}

