/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AdGroupName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AD_GROUP_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/adGroups/{ad_group_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String adGroupId;

    @Deprecated
    protected AdGroupName() {
        this.customerId = null;
        this.adGroupId = null;
    }

    private AdGroupName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.adGroupId = (String)Preconditions.checkNotNull((Object)builder.getAdGroupId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAdGroupId() {
        return this.adGroupId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AdGroupName of(String customerId, String adGroupId) {
        return AdGroupName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).build();
    }

    public static String format(String customerId, String adGroupId) {
        return AdGroupName.newBuilder().setCustomerId(customerId).setAdGroupId(adGroupId).build().toString();
    }

    public static AdGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AD_GROUP_ID.validatedMatch(formattedString, "AdGroupName.parse: formattedString not in valid format");
        return AdGroupName.of((String)matchMap.get("customer_id"), (String)matchMap.get("ad_group_id"));
    }

    public static List<AdGroupName> parseList(List<String> formattedStrings) {
        ArrayList<AdGroupName> list = new ArrayList<AdGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AdGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AdGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AdGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AD_GROUP_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AdGroupName adGroupName = this;
            synchronized (adGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.adGroupId != null) {
                        fieldMapBuilder.put((Object)"ad_group_id", (Object)this.adGroupId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AD_GROUP_ID.instantiate(new String[]{"customer_id", this.customerId, "ad_group_id", this.adGroupId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AdGroupName that = (AdGroupName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.adGroupId, that.adGroupId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.adGroupId);
    }

    public static class Builder {
        private String customerId;
        private String adGroupId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAdGroupId() {
            return this.adGroupId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAdGroupId(String adGroupId) {
            this.adGroupId = adGroupId;
            return this;
        }

        private Builder(AdGroupName adGroupName) {
            this.customerId = adGroupName.customerId;
            this.adGroupId = adGroupName.adGroupId;
        }

        public AdGroupName build() {
            return new AdGroupName(this);
        }
    }
}

