/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AudienceName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_AUDIENCE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/audiences/{audience_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String audienceId;

    @Deprecated
    protected AudienceName() {
        this.customerId = null;
        this.audienceId = null;
    }

    private AudienceName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.audienceId = (String)Preconditions.checkNotNull((Object)builder.getAudienceId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAudienceId() {
        return this.audienceId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AudienceName of(String customerId, String audienceId) {
        return AudienceName.newBuilder().setCustomerId(customerId).setAudienceId(audienceId).build();
    }

    public static String format(String customerId, String audienceId) {
        return AudienceName.newBuilder().setCustomerId(customerId).setAudienceId(audienceId).build().toString();
    }

    public static AudienceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_AUDIENCE_ID.validatedMatch(formattedString, "AudienceName.parse: formattedString not in valid format");
        return AudienceName.of((String)matchMap.get("customer_id"), (String)matchMap.get("audience_id"));
    }

    public static List<AudienceName> parseList(List<String> formattedStrings) {
        ArrayList<AudienceName> list = new ArrayList<AudienceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AudienceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AudienceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AudienceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_AUDIENCE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AudienceName audienceName = this;
            synchronized (audienceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.audienceId != null) {
                        fieldMapBuilder.put((Object)"audience_id", (Object)this.audienceId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_AUDIENCE_ID.instantiate(new String[]{"customer_id", this.customerId, "audience_id", this.audienceId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AudienceName that = (AudienceName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.audienceId, that.audienceId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.audienceId);
    }

    public static class Builder {
        private String customerId;
        private String audienceId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAudienceId() {
            return this.audienceId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAudienceId(String audienceId) {
            this.audienceId = audienceId;
            return this;
        }

        private Builder(AudienceName audienceName) {
            this.customerId = audienceName.customerId;
            this.audienceId = audienceName.audienceId;
        }

        public AudienceName build() {
            return new AudienceName(this);
        }
    }
}

