/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BatchJobName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_BATCH_JOB_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/batchJobs/{batch_job_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String batchJobId;

    @Deprecated
    protected BatchJobName() {
        this.customerId = null;
        this.batchJobId = null;
    }

    private BatchJobName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.batchJobId = (String)Preconditions.checkNotNull((Object)builder.getBatchJobId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getBatchJobId() {
        return this.batchJobId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BatchJobName of(String customerId, String batchJobId) {
        return BatchJobName.newBuilder().setCustomerId(customerId).setBatchJobId(batchJobId).build();
    }

    public static String format(String customerId, String batchJobId) {
        return BatchJobName.newBuilder().setCustomerId(customerId).setBatchJobId(batchJobId).build().toString();
    }

    public static BatchJobName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_BATCH_JOB_ID.validatedMatch(formattedString, "BatchJobName.parse: formattedString not in valid format");
        return BatchJobName.of((String)matchMap.get("customer_id"), (String)matchMap.get("batch_job_id"));
    }

    public static List<BatchJobName> parseList(List<String> formattedStrings) {
        ArrayList<BatchJobName> list = new ArrayList<BatchJobName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BatchJobName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BatchJobName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BatchJobName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_BATCH_JOB_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BatchJobName batchJobName = this;
            synchronized (batchJobName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.batchJobId != null) {
                        fieldMapBuilder.put((Object)"batch_job_id", (Object)this.batchJobId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_BATCH_JOB_ID.instantiate(new String[]{"customer_id", this.customerId, "batch_job_id", this.batchJobId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            BatchJobName that = (BatchJobName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.batchJobId, that.batchJobId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.batchJobId);
    }

    public static class Builder {
        private String customerId;
        private String batchJobId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getBatchJobId() {
            return this.batchJobId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setBatchJobId(String batchJobId) {
            this.batchJobId = batchJobId;
            return this;
        }

        private Builder(BatchJobName batchJobName) {
            this.customerId = batchJobName.customerId;
            this.batchJobId = batchJobName.batchJobId;
        }

        public BatchJobName build() {
            return new BatchJobName(this);
        }
    }
}

