/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CampaignAssetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_FIELD_TYPE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/campaignAssets/{campaign_id}~{asset_id}~{field_type}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String campaignId;
    private final String assetId;
    private final String fieldType;

    @Deprecated
    protected CampaignAssetName() {
        this.customerId = null;
        this.campaignId = null;
        this.assetId = null;
        this.fieldType = null;
    }

    private CampaignAssetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.campaignId = (String)Preconditions.checkNotNull((Object)builder.getCampaignId());
        this.assetId = (String)Preconditions.checkNotNull((Object)builder.getAssetId());
        this.fieldType = (String)Preconditions.checkNotNull((Object)builder.getFieldType());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCampaignId() {
        return this.campaignId;
    }

    public String getAssetId() {
        return this.assetId;
    }

    public String getFieldType() {
        return this.fieldType;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CampaignAssetName of(String customerId, String campaignId, String assetId, String fieldType) {
        return CampaignAssetName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAssetId(assetId).setFieldType(fieldType).build();
    }

    public static String format(String customerId, String campaignId, String assetId, String fieldType) {
        return CampaignAssetName.newBuilder().setCustomerId(customerId).setCampaignId(campaignId).setAssetId(assetId).setFieldType(fieldType).build().toString();
    }

    public static CampaignAssetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_FIELD_TYPE.validatedMatch(formattedString, "CampaignAssetName.parse: formattedString not in valid format");
        return CampaignAssetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("campaign_id"), (String)matchMap.get("asset_id"), (String)matchMap.get("field_type"));
    }

    public static List<CampaignAssetName> parseList(List<String> formattedStrings) {
        ArrayList<CampaignAssetName> list = new ArrayList<CampaignAssetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CampaignAssetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CampaignAssetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CampaignAssetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_FIELD_TYPE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CampaignAssetName campaignAssetName = this;
            synchronized (campaignAssetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.campaignId != null) {
                        fieldMapBuilder.put((Object)"campaign_id", (Object)this.campaignId);
                    }
                    if (this.assetId != null) {
                        fieldMapBuilder.put((Object)"asset_id", (Object)this.assetId);
                    }
                    if (this.fieldType != null) {
                        fieldMapBuilder.put((Object)"field_type", (Object)this.fieldType);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CAMPAIGN_ID_ASSET_ID_FIELD_TYPE.instantiate(new String[]{"customer_id", this.customerId, "campaign_id", this.campaignId, "asset_id", this.assetId, "field_type", this.fieldType});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CampaignAssetName that = (CampaignAssetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.campaignId, that.campaignId) && Objects.equals(this.assetId, that.assetId) && Objects.equals(this.fieldType, that.fieldType);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.campaignId);
        h *= 1000003;
        h ^= Objects.hashCode(this.assetId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.fieldType);
    }

    public static class Builder {
        private String customerId;
        private String campaignId;
        private String assetId;
        private String fieldType;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCampaignId() {
            return this.campaignId;
        }

        public String getAssetId() {
            return this.assetId;
        }

        public String getFieldType() {
            return this.fieldType;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCampaignId(String campaignId) {
            this.campaignId = campaignId;
            return this;
        }

        public Builder setAssetId(String assetId) {
            this.assetId = assetId;
            return this;
        }

        public Builder setFieldType(String fieldType) {
            this.fieldType = fieldType;
            return this;
        }

        private Builder(CampaignAssetName campaignAssetName) {
            this.customerId = campaignAssetName.customerId;
            this.campaignId = campaignAssetName.campaignId;
            this.assetId = campaignAssetName.assetId;
            this.fieldType = campaignAssetName.fieldType;
        }

        public CampaignAssetName build() {
            return new CampaignAssetName(this);
        }
    }
}

