/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ConversionCustomVariableName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CONVERSION_CUSTOM_VARIABLE_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/conversionCustomVariables/{conversion_custom_variable_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String conversionCustomVariableId;

    @Deprecated
    protected ConversionCustomVariableName() {
        this.customerId = null;
        this.conversionCustomVariableId = null;
    }

    private ConversionCustomVariableName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.conversionCustomVariableId = (String)Preconditions.checkNotNull((Object)builder.getConversionCustomVariableId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getConversionCustomVariableId() {
        return this.conversionCustomVariableId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ConversionCustomVariableName of(String customerId, String conversionCustomVariableId) {
        return ConversionCustomVariableName.newBuilder().setCustomerId(customerId).setConversionCustomVariableId(conversionCustomVariableId).build();
    }

    public static String format(String customerId, String conversionCustomVariableId) {
        return ConversionCustomVariableName.newBuilder().setCustomerId(customerId).setConversionCustomVariableId(conversionCustomVariableId).build().toString();
    }

    public static ConversionCustomVariableName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CONVERSION_CUSTOM_VARIABLE_ID.validatedMatch(formattedString, "ConversionCustomVariableName.parse: formattedString not in valid format");
        return ConversionCustomVariableName.of((String)matchMap.get("customer_id"), (String)matchMap.get("conversion_custom_variable_id"));
    }

    public static List<ConversionCustomVariableName> parseList(List<String> formattedStrings) {
        ArrayList<ConversionCustomVariableName> list = new ArrayList<ConversionCustomVariableName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ConversionCustomVariableName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ConversionCustomVariableName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ConversionCustomVariableName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CONVERSION_CUSTOM_VARIABLE_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ConversionCustomVariableName conversionCustomVariableName = this;
            synchronized (conversionCustomVariableName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.conversionCustomVariableId != null) {
                        fieldMapBuilder.put((Object)"conversion_custom_variable_id", (Object)this.conversionCustomVariableId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CONVERSION_CUSTOM_VARIABLE_ID.instantiate(new String[]{"customer_id", this.customerId, "conversion_custom_variable_id", this.conversionCustomVariableId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ConversionCustomVariableName that = (ConversionCustomVariableName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.conversionCustomVariableId, that.conversionCustomVariableId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.conversionCustomVariableId);
    }

    public static class Builder {
        private String customerId;
        private String conversionCustomVariableId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getConversionCustomVariableId() {
            return this.conversionCustomVariableId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setConversionCustomVariableId(String conversionCustomVariableId) {
            this.conversionCustomVariableId = conversionCustomVariableId;
            return this;
        }

        private Builder(ConversionCustomVariableName conversionCustomVariableName) {
            this.customerId = conversionCustomVariableName.customerId;
            this.conversionCustomVariableId = conversionCustomVariableName.conversionCustomVariableId;
        }

        public ConversionCustomVariableName build() {
            return new ConversionCustomVariableName(this);
        }
    }
}

