/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerAssetSetName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_ASSET_SET_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerAssetSets/{asset_set_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String assetSetId;

    @Deprecated
    protected CustomerAssetSetName() {
        this.customerId = null;
        this.assetSetId = null;
    }

    private CustomerAssetSetName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.assetSetId = (String)Preconditions.checkNotNull((Object)builder.getAssetSetId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getAssetSetId() {
        return this.assetSetId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerAssetSetName of(String customerId, String assetSetId) {
        return CustomerAssetSetName.newBuilder().setCustomerId(customerId).setAssetSetId(assetSetId).build();
    }

    public static String format(String customerId, String assetSetId) {
        return CustomerAssetSetName.newBuilder().setCustomerId(customerId).setAssetSetId(assetSetId).build().toString();
    }

    public static CustomerAssetSetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_ASSET_SET_ID.validatedMatch(formattedString, "CustomerAssetSetName.parse: formattedString not in valid format");
        return CustomerAssetSetName.of((String)matchMap.get("customer_id"), (String)matchMap.get("asset_set_id"));
    }

    public static List<CustomerAssetSetName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerAssetSetName> list = new ArrayList<CustomerAssetSetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerAssetSetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerAssetSetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerAssetSetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_ASSET_SET_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerAssetSetName customerAssetSetName = this;
            synchronized (customerAssetSetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.assetSetId != null) {
                        fieldMapBuilder.put((Object)"asset_set_id", (Object)this.assetSetId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_ASSET_SET_ID.instantiate(new String[]{"customer_id", this.customerId, "asset_set_id", this.assetSetId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomerAssetSetName that = (CustomerAssetSetName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.assetSetId, that.assetSetId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assetSetId);
    }

    public static class Builder {
        private String customerId;
        private String assetSetId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getAssetSetId() {
            return this.assetSetId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setAssetSetId(String assetSetId) {
            this.assetSetId = assetSetId;
            return this;
        }

        private Builder(CustomerAssetSetName customerAssetSetName) {
            this.customerId = customerAssetSetName.customerId;
            this.assetSetId = customerAssetSetName.assetSetId;
        }

        public CustomerAssetSetName build() {
            return new CustomerAssetSetName(this);
        }
    }
}

