/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerConversionGoalName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_CATEGORY_SOURCE = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerConversionGoals/{category}~{source}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String category;
    private final String source;

    @Deprecated
    protected CustomerConversionGoalName() {
        this.customerId = null;
        this.category = null;
        this.source = null;
    }

    private CustomerConversionGoalName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.category = (String)Preconditions.checkNotNull((Object)builder.getCategory());
        this.source = (String)Preconditions.checkNotNull((Object)builder.getSource());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getCategory() {
        return this.category;
    }

    public String getSource() {
        return this.source;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerConversionGoalName of(String customerId, String category, String source) {
        return CustomerConversionGoalName.newBuilder().setCustomerId(customerId).setCategory(category).setSource(source).build();
    }

    public static String format(String customerId, String category, String source) {
        return CustomerConversionGoalName.newBuilder().setCustomerId(customerId).setCategory(category).setSource(source).build().toString();
    }

    public static CustomerConversionGoalName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_CATEGORY_SOURCE.validatedMatch(formattedString, "CustomerConversionGoalName.parse: formattedString not in valid format");
        return CustomerConversionGoalName.of((String)matchMap.get("customer_id"), (String)matchMap.get("category"), (String)matchMap.get("source"));
    }

    public static List<CustomerConversionGoalName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerConversionGoalName> list = new ArrayList<CustomerConversionGoalName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerConversionGoalName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerConversionGoalName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerConversionGoalName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_CATEGORY_SOURCE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerConversionGoalName customerConversionGoalName = this;
            synchronized (customerConversionGoalName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.category != null) {
                        fieldMapBuilder.put((Object)"category", (Object)this.category);
                    }
                    if (this.source != null) {
                        fieldMapBuilder.put((Object)"source", (Object)this.source);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_CATEGORY_SOURCE.instantiate(new String[]{"customer_id", this.customerId, "category", this.category, "source", this.source});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomerConversionGoalName that = (CustomerConversionGoalName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.category, that.category) && Objects.equals(this.source, that.source);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        h ^= Objects.hashCode(this.category);
        h *= 1000003;
        return h ^= Objects.hashCode(this.source);
    }

    public static class Builder {
        private String customerId;
        private String category;
        private String source;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSource() {
            return this.source;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setCategory(String category) {
            this.category = category;
            return this;
        }

        public Builder setSource(String source) {
            this.source = source;
            return this;
        }

        private Builder(CustomerConversionGoalName customerConversionGoalName) {
            this.customerId = customerConversionGoalName.customerId;
            this.category = customerConversionGoalName.category;
            this.source = customerConversionGoalName.source;
        }

        public CustomerConversionGoalName build() {
            return new CustomerConversionGoalName(this);
        }
    }
}

