/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CustomerLabelName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_LABEL_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/customerLabels/{label_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String labelId;

    @Deprecated
    protected CustomerLabelName() {
        this.customerId = null;
        this.labelId = null;
    }

    private CustomerLabelName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.labelId = (String)Preconditions.checkNotNull((Object)builder.getLabelId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getLabelId() {
        return this.labelId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CustomerLabelName of(String customerId, String labelId) {
        return CustomerLabelName.newBuilder().setCustomerId(customerId).setLabelId(labelId).build();
    }

    public static String format(String customerId, String labelId) {
        return CustomerLabelName.newBuilder().setCustomerId(customerId).setLabelId(labelId).build().toString();
    }

    public static CustomerLabelName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_LABEL_ID.validatedMatch(formattedString, "CustomerLabelName.parse: formattedString not in valid format");
        return CustomerLabelName.of((String)matchMap.get("customer_id"), (String)matchMap.get("label_id"));
    }

    public static List<CustomerLabelName> parseList(List<String> formattedStrings) {
        ArrayList<CustomerLabelName> list = new ArrayList<CustomerLabelName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CustomerLabelName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CustomerLabelName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CustomerLabelName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_LABEL_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CustomerLabelName customerLabelName = this;
            synchronized (customerLabelName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.labelId != null) {
                        fieldMapBuilder.put((Object)"label_id", (Object)this.labelId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_LABEL_ID.instantiate(new String[]{"customer_id", this.customerId, "label_id", this.labelId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CustomerLabelName that = (CustomerLabelName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.labelId, that.labelId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.labelId);
    }

    public static class Builder {
        private String customerId;
        private String labelId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getLabelId() {
            return this.labelId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setLabelId(String labelId) {
            this.labelId = labelId;
            return this;
        }

        private Builder(CustomerLabelName customerLabelName) {
            this.customerId = customerLabelName.customerId;
            this.labelId = customerLabelName.labelId;
        }

        public CustomerLabelName build() {
            return new CustomerLabelName(this);
        }
    }
}

