/*
 * Decompiled with CFR 0.152.
 */
package com.google.ads.googleads.v13.resources;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ExtensionFeedItemName
implements ResourceName {
    private static final PathTemplate CUSTOMER_ID_FEED_ITEM_ID = PathTemplate.createWithoutUrlEncoding((String)"customers/{customer_id}/extensionFeedItems/{feed_item_id}");
    private volatile Map<String, String> fieldValuesMap;
    private final String customerId;
    private final String feedItemId;

    @Deprecated
    protected ExtensionFeedItemName() {
        this.customerId = null;
        this.feedItemId = null;
    }

    private ExtensionFeedItemName(Builder builder) {
        this.customerId = (String)Preconditions.checkNotNull((Object)builder.getCustomerId());
        this.feedItemId = (String)Preconditions.checkNotNull((Object)builder.getFeedItemId());
    }

    public String getCustomerId() {
        return this.customerId;
    }

    public String getFeedItemId() {
        return this.feedItemId;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ExtensionFeedItemName of(String customerId, String feedItemId) {
        return ExtensionFeedItemName.newBuilder().setCustomerId(customerId).setFeedItemId(feedItemId).build();
    }

    public static String format(String customerId, String feedItemId) {
        return ExtensionFeedItemName.newBuilder().setCustomerId(customerId).setFeedItemId(feedItemId).build().toString();
    }

    public static ExtensionFeedItemName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = CUSTOMER_ID_FEED_ITEM_ID.validatedMatch(formattedString, "ExtensionFeedItemName.parse: formattedString not in valid format");
        return ExtensionFeedItemName.of((String)matchMap.get("customer_id"), (String)matchMap.get("feed_item_id"));
    }

    public static List<ExtensionFeedItemName> parseList(List<String> formattedStrings) {
        ArrayList<ExtensionFeedItemName> list = new ArrayList<ExtensionFeedItemName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ExtensionFeedItemName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ExtensionFeedItemName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ExtensionFeedItemName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return CUSTOMER_ID_FEED_ITEM_ID.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ExtensionFeedItemName extensionFeedItemName = this;
            synchronized (extensionFeedItemName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.customerId != null) {
                        fieldMapBuilder.put((Object)"customer_id", (Object)this.customerId);
                    }
                    if (this.feedItemId != null) {
                        fieldMapBuilder.put((Object)"feed_item_id", (Object)this.feedItemId);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return CUSTOMER_ID_FEED_ITEM_ID.instantiate(new String[]{"customer_id", this.customerId, "feed_item_id", this.feedItemId});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ExtensionFeedItemName that = (ExtensionFeedItemName)o;
            return Objects.equals(this.customerId, that.customerId) && Objects.equals(this.feedItemId, that.feedItemId);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.customerId);
        h *= 1000003;
        return h ^= Objects.hashCode(this.feedItemId);
    }

    public static class Builder {
        private String customerId;
        private String feedItemId;

        protected Builder() {
        }

        public String getCustomerId() {
            return this.customerId;
        }

        public String getFeedItemId() {
            return this.feedItemId;
        }

        public Builder setCustomerId(String customerId) {
            this.customerId = customerId;
            return this;
        }

        public Builder setFeedItemId(String feedItemId) {
            this.feedItemId = feedItemId;
            return this;
        }

        private Builder(ExtensionFeedItemName extensionFeedItemName) {
            this.customerId = extensionFeedItemName.customerId;
            this.feedItemId = extensionFeedItemName.feedItemId;
        }

        public ExtensionFeedItemName build() {
            return new ExtensionFeedItemName(this);
        }
    }
}

